/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.github.promeg.pinyinhelper.Pinyin;
import com.github.promeg.pinyinhelper.PinyinDict;
import com.github.promeg.pinyinhelper.PinyinMapDict;
import com.github.promeg.tinypinyin.lexicons.java.cncity.CnCityDict;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinUtil {
    private static final Logger logger = LoggerFactory.getLogger(PinyinUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileDict(Map<String, String[]> map) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream fileStream = PinyinUtil.class.getClassLoader().getResourceAsStream("cncity_fulllist.txt");
            reader = new BufferedReader(new InputStreamReader(fileStream));
            while ((line = reader.readLine()) != null) {
                String[] keyAndValue = line.split("\\s+");
                if (keyAndValue.length != 2) continue;
                String[] pinyinArray = keyAndValue[0].split("'");
                map.putIfAbsent(keyAndValue[1], pinyinArray);
            }
        }
        catch (Exception e) {
            try {
                logger.error("\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25", (Throwable)e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(reader);
                throw throwable;
            }
            ObjectCloseUtil.close(reader);
        }
        ObjectCloseUtil.close(reader);
    }

    public static String convertToPinYin(String str) {
        if (StringUtil.isEmptyOrWhiteSpace(str)) {
            return str;
        }
        return Pinyin.toPinyin((String)str, (String)"");
    }

    static {
        Pinyin.init((Pinyin.Config)Pinyin.newConfig().with((PinyinDict)CnCityDict.getInstance()));
        Pinyin.add((PinyinDict)new PinyinMapDict(){

            public Map<String, String[]> mapping() {
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                PinyinUtil.addFileDict(map);
                return map;
            }
        });
    }
}

