/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.config;

import com.geoway.adf.dms.common.util.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadPathConfig {
    private static final Logger log = LoggerFactory.getLogger(UploadPathConfig.class);
    private static final String PATH_PREFIX = "../";
    private static String uploadStoragePath = "upload";

    public static void setUploadPath(String uploadPath) {
        uploadStoragePath = uploadPath;
    }

    public static boolean isUploadPath(String path) {
        return path.startsWith(PATH_PREFIX);
    }

    public static Path getUploadPath() {
        Path uploadPath = Paths.get(uploadStoragePath, new String[0]).toAbsolutePath();
        try {
            File file = uploadPath.toFile();
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u76ee\u5f55\u521b\u5efa\u5931\u8d25", (Throwable)e);
        }
        return uploadPath;
    }

    public static Path getFullPath(String path) {
        Path fileFullPath = path.startsWith(PATH_PREFIX) ? Paths.get(UploadPathConfig.getUploadPath().toString(), path.substring(PATH_PREFIX.length())) : Paths.get(path, new String[0]);
        return fileFullPath.toAbsolutePath();
    }

    public static String getFileFullPath(String path) {
        if (path.startsWith(PATH_PREFIX)) {
            return Paths.get(UploadPathConfig.getUploadPath().toString(), path.substring(PATH_PREFIX.length())).toAbsolutePath().toString();
        }
        return path;
    }

    public static String getUploadRelativePath(String uploadFullPath) {
        Path uploadPath = UploadPathConfig.getUploadPath();
        String resultPath = uploadFullPath.substring(uploadPath.toString().length());
        resultPath = PATH_PREFIX + StringUtil.trim(resultPath.replace("\\", "/"), "/");
        return resultPath;
    }
}

