/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.sql;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.sql.SQLQueryWhereClause;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.gis.geodb.field.FieldType;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLQueryExpressionParser {
    public static SQLQueryWhereClause parse(String expression) {
        return SQLQueryExpressionParser.parse(expression, "_", "=", null);
    }

    public static SQLQueryWhereClause parse(String expression, String connectSeparator, String valueSeparator, List<FieldDTO> fields) {
        SQLQueryWhereClause queryWhereClause = new SQLQueryWhereClause();
        if (StringUtil.isEmptyOrWhiteSpace(expression)) {
            return queryWhereClause;
        }
        String[] exps = expression.split(";");
        String where = "";
        ArrayList<Object> objs = new ArrayList<Object>();
        for (String exp : exps) {
            SQLQueryWhereClause res;
            if (StringUtil.isEmptyOrWhiteSpace(exp) || (res = SQLQueryExpressionParser.parseExpression(exp, connectSeparator, valueSeparator, fields)) == null) continue;
            where = where + res.getWhere();
            objs.addAll(res.getValues());
        }
        if (where.startsWith(" and ")) {
            where = where.substring(" and ".length());
        } else if (where.startsWith(" or ")) {
            where = where.substring(" or ".length());
        }
        queryWhereClause.setWhere(where);
        queryWhereClause.setValues(objs);
        return queryWhereClause;
    }

    private static SQLQueryWhereClause parseExpression(String expression, String connectSeparator, String valueSeparator, List<FieldDTO> fields) {
        String[] operator_value;
        String where = "";
        String frontBracket = "";
        String backBracket = "";
        while (expression.startsWith("(")) {
            frontBracket = frontBracket + "(";
            expression = expression.substring(1);
        }
        while (expression.startsWith(")")) {
            backBracket = backBracket + ")";
            expression = expression.substring(1);
        }
        where = where + backBracket;
        SQLQueryWhereClause queryWhereClause = new SQLQueryWhereClause();
        if (expression.length() == 0) {
            queryWhereClause.setWhere(where);
            return queryWhereClause;
        }
        String[] splits = expression.split(connectSeparator = connectSeparator.replaceAll("([\\\\$&+,:;=?@#|'<>.^*()%!-])", "\\\\$1"), 4);
        if (splits.length != 4) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e\uff1a" + expression);
        }
        String connect = splits[0];
        String fieldName = splits[1];
        String fieldType = splits[2];
        if (fields != null) {
            boolean exist = false;
            for (FieldDTO fld : fields) {
                if (fieldName.equalsIgnoreCase(fld.getName())) {
                    exist = true;
                    fieldType = SQLQueryExpressionParser.getFieldTypeStr(FieldType.getByValue((Integer)fld.getFieldType()), fieldType);
                    break;
                }
                if (!fieldName.equals(fld.getAliasName())) continue;
                exist = true;
                fieldName = fld.getName();
                fieldType = SQLQueryExpressionParser.getFieldTypeStr(FieldType.getByValue((Integer)fld.getFieldType()), fieldType);
                break;
            }
            if (!exist) {
                System.out.println(String.format("\u8fc7\u6ee4\u6761\u4ef6[%s]\u5b57\u6bb5[%s]\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7", expression, fieldName));
                return null;
            }
        }
        if ((operator_value = splits[3].split(valueSeparator = valueSeparator.replaceAll("([\\\\$&+,:;=?@#|'<>.^*()%!-])", "\\\\$1"), 2)).length != 2) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e\uff1a" + expression);
        }
        String operator = operator_value[0];
        String val = operator_value[1];
        if ("Q".equals(connect) || "QA".equals(connect)) {
            where = " and ";
        } else if ("QOR".equals(connect)) {
            where = " or ";
        }
        where = where + frontBracket;
        where = where + fieldName;
        if (operator.equalsIgnoreCase("EQ")) {
            where = where + " = ? ";
        } else if (operator.equalsIgnoreCase("NE")) {
            where = where + " != ? ";
        } else if (operator.equalsIgnoreCase("LK")) {
            where = where + " like ? ";
        } else if (operator.equalsIgnoreCase("LFK")) {
            where = where + " like ? ";
        } else if (operator.equalsIgnoreCase("RHK")) {
            where = where + " like ? ";
        } else if (operator.equalsIgnoreCase("LT")) {
            where = where + " < ? ";
        } else if (operator.equalsIgnoreCase("GT")) {
            where = where + " > ? ";
        } else if (operator.equalsIgnoreCase("LE")) {
            where = where + " <= ? ";
        } else if (operator.equalsIgnoreCase("GE")) {
            where = where + " >= ? ";
        } else if (operator.equalsIgnoreCase("IN")) {
            String inStr = SQLQueryExpressionParser.getInStr(val.split(",").length);
            where = where + " in (" + inStr + ") ";
        } else if (operator.equalsIgnoreCase("NOTIN")) {
            String index = SQLQueryExpressionParser.getInStr(val.split(",").length);
            where = where + " not in (" + index + ") ";
        } else {
            throw new RuntimeException("\u5f53\u524d\u4e0d\u652f\u6301\u64cd\u4f5c\u7b26\u3010" + operator + "\u3011");
        }
        List<Object> vals = SQLQueryExpressionParser.getVal(val, fieldType, operator);
        queryWhereClause.setWhere(where);
        queryWhereClause.setValues(vals);
        return queryWhereClause;
    }

    private static List<Object> getVal(String val, String fieldType, String operator) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (fieldType.equals("S")) {
            if ("LK".equals(operator)) {
                list.add("%" + val + "%");
            } else if ("LFK".equals(operator)) {
                list.add(val + "%");
            } else if ("RHK".equals(operator)) {
                list.add("%" + val);
            } else if ("IN".equals(operator) || "NOTIN".equals(operator)) {
                List<String> asList = Arrays.asList(val.split(","));
                list.addAll(asList);
            } else {
                list.add(val);
            }
        } else if (fieldType.equals("D")) {
            Date date = SQLQueryExpressionParser.getDate(val, "yyyy-MM-dd");
            list.add(date);
        } else if (fieldType.equals("DT")) {
            Timestamp date = SQLQueryExpressionParser.getTimestamp(val, "yyyy-MM-dd HH:mm:ss");
            list.add(date);
        } else if (fieldType.equals("N")) {
            list.add(Double.valueOf(val));
        }
        return list;
    }

    private static String getInStr(int index) {
        String res = "?";
        while (index > 1) {
            res = res + ",?";
            --index;
        }
        return res;
    }

    private static Date getDate(String val, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date parse = null;
        try {
            parse = new Date(sdf.parse(val).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse;
    }

    private static Timestamp getTimestamp(String val, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Timestamp parse = null;
        try {
            parse = new Timestamp(sdf.parse(val).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return parse;
    }

    private static String getFieldTypeStr(FieldType fieldType, String filterType) {
        switch (fieldType) {
            case DateTime: {
                if (filterType.equals("D")) {
                    return "D";
                }
                return "DT";
            }
            case Decimal: 
            case Double: 
            case Short: 
            case Int: 
            case Long: 
            case Float: {
                return "N";
            }
            case Boolean: 
            case Byte: 
            case String: 
            case Blob: 
            case Text: {
                return "S";
            }
            case Shape: {
                break;
            }
            case OID: {
                return "N";
            }
            default: {
                return "S";
            }
        }
        return "S";
    }
}

