/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.typehandler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class BlobToStringTypeHandler
extends BaseTypeHandler<String> {
    private static final String DEFAULT_CHARSET = "utf-8";

    public void setNonNullParameter(PreparedStatement ps, int i, String parameter, JdbcType paramJdbcType) throws SQLException {
        try {
            byte[] data = parameter.getBytes(DEFAULT_CHARSET);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ps.setBinaryStream(i, (InputStream)bis, data.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        byte[] returnValue = rs.getBytes(columnName);
        String result = null;
        try {
            if (returnValue != null) {
                result = new String(returnValue, DEFAULT_CHARSET);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        byte[] returnValue = rs.getBytes(columnIndex);
        String result = null;
        try {
            if (returnValue != null) {
                result = new String(returnValue, DEFAULT_CHARSET);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        byte[] returnValue = cs.getBytes(columnIndex);
        String result = null;
        try {
            if (returnValue != null) {
                result = new String(returnValue, DEFAULT_CHARSET);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

