/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import cn.hutool.core.convert.Convert;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final CharSequence[] SPECIAL_SUFFIX = new CharSequence[]{"tar.bz2", "tar.Z", "tar.gz", "tar.xz"};
    private static final Charset[] DEFAULT_CHARSETS;

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        int secondToLastIndex = fileName.substring(0, index).lastIndexOf(".");
        String substr = fileName.substring(secondToLastIndex == -1 ? index : secondToLastIndex);
        if (StringUtil.containsAny((CharSequence)substr, SPECIAL_SUFFIX)) {
            return substr;
        }
        String ext = fileName.substring(index);
        return StringUtil.containsAny((CharSequence)ext, '/', '\\') ? "" : ext;
    }

    public static String getFileName(String fileFullName) {
        File file = new File(fileFullName);
        return file.getName();
    }

    public static String getFileNameWithoutExtension(String fileFullName) {
        if (fileFullName == null || fileFullName.length() == 0) {
            return fileFullName;
        }
        String fileName = FileUtil.getFileName(fileFullName);
        int len = fileName.length();
        for (CharSequence specialSuffix : SPECIAL_SUFFIX) {
            if (!fileName.endsWith("." + specialSuffix)) continue;
            return fileName.substring(0, len - specialSuffix.length() - 1);
        }
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getDirectoryName(String fileFullName) {
        File file = new File(fileFullName);
        return file.getParent();
    }

    public static String changeExtension(String fileName, String extension) {
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            return fileName.substring(0, index) + "." + extension;
        }
        return fileName + "." + extension;
    }

    public static Boolean isDirExsit(String path) {
        File folder = new File(path);
        if (folder.exists() && folder.isDirectory()) {
            return true;
        }
        return false;
    }

    public static Boolean isFileExsit(String path) {
        File file = new File(path);
        if (file.exists() && file.isFile()) {
            return true;
        }
        return false;
    }

    public static File mkdirs(String path) {
        File file = new File(path);
        if (file.mkdirs()) {
            return file;
        }
        return null;
    }

    public static void deleteDir(String path) {
        File[] list;
        File file = new File(path);
        for (File f : list = file.listFiles()) {
            if (f.isDirectory()) {
                FileUtil.deleteDir(f.getPath());
                continue;
            }
            f.delete();
        }
        boolean deleted = file.delete();
    }

    public static void copyFile(String filePath, String targetPath) {
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                int hasRead;
                fis = new FileInputStream(file);
                fos = new FileOutputStream(targetPath);
                byte[] buffer = new byte[2048];
                while ((hasRead = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, hasRead);
                }
            }
            catch (Exception e) {
                try {
                    log.error("[{}]\u590d\u5236\u5230[{}]\u5931\u8d25", (Object)filePath, (Object)targetPath);
                    throw new RuntimeException("\u590d\u5236\u6587\u4ef6\u51fa\u9519", e);
                }
                catch (Throwable throwable) {
                    ObjectCloseUtil.close(fis, fos);
                    throw throwable;
                }
            }
            ObjectCloseUtil.close(fis, fos);
        }
    }

    public static void copyFile(InputStream srcStream, String targetPath) {
        FileOutputStream fos = null;
        try {
            int hasRead;
            fos = new FileOutputStream(targetPath);
            byte[] buffer = new byte[2048];
            while ((hasRead = srcStream.read(buffer)) != -1) {
                fos.write(buffer, 0, hasRead);
            }
        }
        catch (Exception e) {
            try {
                log.error("\u590d\u5236\u5230[{}]\u5931\u8d25", (Object)targetPath);
                throw new RuntimeException("\u590d\u5236\u6587\u4ef6\u51fa\u9519", e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(srcStream, fos);
                throw throwable;
            }
        }
        ObjectCloseUtil.close(srcStream, fos);
    }

    public static void copy(String sourcePath, String targetPath) {
        File[] files;
        File sourceFile = new File(sourcePath);
        Assert.state((boolean)sourceFile.exists(), (String)("\u6587\u4ef6\u4e0d\u5b58\u5728:" + sourcePath));
        if (sourceFile.isFile()) {
            FileUtil.copyFile(sourcePath, targetPath);
            return;
        }
        File targetFile = new File(targetPath);
        if (!targetFile.exists() && !targetFile.isFile()) {
            targetFile.mkdirs();
        }
        if ((files = sourceFile.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileUtil.mkdirs(targetPath + File.separator + file.getName());
                FileUtil.copy(sourcePath + File.separator + file.getName(), targetPath + File.separator + file.getName());
                continue;
            }
            String filePath = targetPath + File.separator + file.getName();
            FileUtil.copyFile(file.getAbsolutePath(), filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileLines(String fileName) {
        ArrayList<String> arrayList;
        ArrayList<String> list = new ArrayList<String>();
        File file = new File(fileName);
        BufferedReader reader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            String charset = FileUtil.getFileCharset(file);
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, charset));
            String tempString = null;
            int line = 1;
            while ((tempString = reader.readLine()) != null) {
                list.add(tempString);
                ++line;
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            ObjectCloseUtil.close(inputStream, reader);
            throw throwable;
        }
        ObjectCloseUtil.close(inputStream, reader);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileCharset(File sourceFile) {
        try (FileInputStream fis = new FileInputStream(sourceFile);){
            byte[] dataBytes;
            int bytesLength = 128;
            byte[] firstBytes = new byte[bytesLength];
            int bytesRead = fis.read(firstBytes, 0, bytesLength);
            if (bytesRead < bytesLength) {
                dataBytes = new byte[bytesRead];
                System.arraycopy(firstBytes, 0, dataBytes, 0, bytesRead);
            } else {
                dataBytes = firstBytes;
            }
            String string = FileUtil.getFileCharset(dataBytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "UTF-8";
        }
    }

    public static String getFileCharset(byte[] bytes) {
        try {
            byte[] bom = Arrays.copyOf(bytes, 4);
            if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                return "UTF-8";
            }
            if (bom[0] == -2 && bom[1] == -1) {
                return "UTF-16BE";
            }
            if (bom[0] == -1 && bom[1] == -2) {
                return "UTF-16LE";
            }
            if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                return "UTF-32BE";
            }
            if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                return "UTF-32LE";
            }
            for (Charset charset : DEFAULT_CHARSETS) {
                CharsetDecoder decoder = charset.newDecoder();
                if (!FileUtil.identify(bytes, decoder)) continue;
                return charset.name();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "UTF-8";
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    public static File createTempDir(String dirName) {
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        File newDir = new File(tmpdir, dirName);
        newDir.mkdirs();
        return newDir;
    }

    static {
        String[] names = new String[]{"UTF-8", "GB2312", "GBK", "GB18030", "BIG5", "US-ASCII"};
        DEFAULT_CHARSETS = (Charset[])Convert.convert(Charset[].class, (Object)names);
    }
}

