/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StringUtil {
    public static String MD5(String str) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(str.getBytes());
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String base64Encode(String str) {
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] textByte = str.getBytes("UTF-8");
        return encoder.encodeToString(textByte);
    }

    public static String base64Decode(String str) {
        Base64.Decoder decoder = Base64.getDecoder();
        return new String(decoder.decode(str), "UTF-8");
    }

    public static String safeUrlBase64Encode(String str) {
        String encodeBase64 = StringUtil.base64Encode(str);
        String safeBase64Str = encodeBase64.replace('+', '-').replace('/', '_').replaceAll("=", "");
        return safeBase64Str;
    }

    public static String safeUrlBase64Decode(String safeBase64Str) {
        String base64Str = safeBase64Str.replace('-', '+');
        int mod4 = (base64Str = base64Str.replace('_', '/')).length() % 4;
        if (mod4 > 0) {
            base64Str = base64Str + "====".substring(mod4);
        }
        return StringUtil.base64Decode(base64Str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmptyOrWhiteSpace(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static int compare(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null && str2 != null) {
            return -1;
        }
        if (str1 != null && str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    public static String join(String separator, Object[] elements) {
        return StringUtil.join(separator, Arrays.stream(elements).iterator());
    }

    public static String join(String separator, Iterable<?> elements) {
        if (null != elements) {
            return StringUtil.join(separator, elements.iterator());
        }
        return null;
    }

    public static String join(String separator, Iterator<?> iterator) {
        if (null != iterator) {
            StringBuilder stringBuilder = new StringBuilder();
            if (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString());
                while (iterator.hasNext()) {
                    stringBuilder.append(separator);
                    stringBuilder.append(iterator.next().toString());
                }
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static <T> List<T> split(String str, String separator, Function<String, ? extends T> mapper) {
        return Arrays.stream(str.split(separator)).map(t -> mapper.apply((String)t)).collect(Collectors.toList());
    }

    public static String trim(String str, String trimStr) {
        String newStr = str;
        if (str.startsWith(trimStr)) {
            newStr = str.substring(trimStr.length());
        }
        if (newStr.endsWith(trimStr)) {
            newStr = newStr.substring(0, newStr.length() - trimStr.length());
        }
        return newStr;
    }

    public static String trimStart(String str, String trimStr) {
        String newStr = str;
        while (newStr.startsWith(trimStr)) {
            newStr = newStr.substring(trimStr.length());
        }
        return newStr;
    }

    public static String trimEnd(String str, String trimStr) {
        String newStr = str;
        while (newStr.endsWith(trimStr)) {
            newStr = newStr.substring(0, newStr.length() - trimStr.length());
        }
        return newStr;
    }

    public static boolean containsAny(CharSequence str, char ... testChars) {
        if (str != null && str.length() > 0) {
            for (int i = 0; i < str.length(); ++i) {
                if (StringUtil.indexOf(testChars, str.charAt(i)) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence str, CharSequence ... testStrs) {
        return null != StringUtil.getContainsStr(str, testStrs);
    }

    public static String getContainsStr(CharSequence str, CharSequence ... testStrs) {
        if (str != null && str.length() > 0 && testStrs != null && testStrs.length > 0) {
            for (CharSequence checkStr : testStrs) {
                if (!str.toString().contains(checkStr)) continue;
                return checkStr.toString();
            }
        }
        return null;
    }

    public static int indexOf(char[] array, char value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i]) continue;
                return i;
            }
        }
        return -1;
    }
}

