/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.web;

import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class EnvironmentConfig
implements EnvironmentAware {
    private static Environment environment;

    public void setEnvironment(Environment env) {
        environment = env;
    }

    public static String getProperty(String key) {
        return environment == null ? null : environment.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return environment == null ? defaultValue : environment.getProperty(key, defaultValue);
    }

    public static Integer getInteger(String key, Integer defaultValue) {
        if (environment == null) {
            return defaultValue;
        }
        String val = environment.getProperty(key);
        try {
            return Integer.valueOf(val);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        if (environment == null) {
            return defaultValue;
        }
        String val = environment.getProperty(key);
        try {
            return Boolean.valueOf(val);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Float getFloat(String key, Float defaultValue) {
        if (environment == null) {
            return defaultValue;
        }
        String val = environment.getProperty(key);
        try {
            return Float.valueOf(val);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Double getDouble(String key, Double defaultValue) {
        if (environment == null) {
            return defaultValue;
        }
        String val = environment.getProperty(key);
        try {
            return Double.valueOf(val);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }
}

