/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.web;

import com.geoway.adf.dms.common.exception.FileUploadIllegalException;
import com.geoway.adf.dms.common.web.Response;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={SQLException.class})
    @ResponseBody
    public Response exceptionHandler(SQLException e) {
        log.error("SQL\u5f02\u5e38:", (Throwable)e);
        return Response.error(e.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseBody
    public Response exceptionHandler(NullPointerException e) {
        log.error("\u7a7a\u6307\u9488\u5f02\u5e38:", (Throwable)e);
        return Response.error("NullPointer");
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseBody
    public ResponseEntity<Response> exceptionHandler(MaxUploadSizeExceededException e) throws IOException {
        log.error("\u4e0a\u4f20\u6587\u4ef6\u8d85\u8fc7\u6700\u5927\u6587\u4ef6\u5927\u5c0f\u9650\u5236", (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.PAYLOAD_TOO_LARGE).body(Response.error(HttpStatus.PAYLOAD_TOO_LARGE.value(), e.getMessage()));
    }

    @ExceptionHandler(value={FileUploadIllegalException.class})
    @ResponseBody
    public ResponseEntity<Response> exceptionHandler(FileUploadIllegalException e) {
        log.error(e.getFileName() == null ? "" : e.getFileName() + "\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e0a\u4f20", (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(Response.error(HttpStatus.FORBIDDEN.value(), String.format("[%s]%s", e.getFileName(), e.getMessage())));
    }

    @ExceptionHandler(value={HttpStatusCodeException.class})
    @ResponseBody
    public ResponseEntity<Response> exceptionHandler(HttpStatusCodeException e) {
        log.error("\u5f02\u5e38:", (Throwable)e);
        return ResponseEntity.status((HttpStatus)e.getStatusCode()).body(Response.error(e.getStatusCode().value(), e.getStatusText()));
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Response exceptionHandler(Exception e) {
        if (e.getCause() instanceof SQLException) {
            log.error("SQL\u5f02\u5e38:", (Throwable)e);
            SQLException sqlException = (SQLException)e.getCause();
            return Response.error(sqlException.getMessage());
        }
        if (e instanceof UndeclaredThrowableException) {
            UndeclaredThrowableException undeclaredThrowableException = (UndeclaredThrowableException)e;
            log.error("\u5f02\u5e38:", (Throwable)undeclaredThrowableException);
            return Response.error(undeclaredThrowableException.getUndeclaredThrowable().getMessage());
        }
        log.error("\u5f02\u5e38:", (Throwable)e);
        return Response.error(e.getMessage());
    }
}

