/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ZipAndRarUtil {
    private static final Logger logger = LoggerFactory.getLogger(ZipAndRarUtil.class);

    public static void zipFiles(List<File> srcFile, File zipFile) {
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile), Charset.forName("GBK"));
            for (File file : srcFile) {
                int len;
                in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(in, out);
                throw throwable;
            }
        }
        ObjectCloseUtil.close(in, out);
    }

    public static void zipFiles(List<File> srcFile, File zipFile, String rootDir) {
        ZipAndRarUtil.zipFiles(srcFile, rootDir, new FileOutputStream(zipFile));
    }

    public static void zipFiles(List<File> srcFile, String srcRootDir, OutputStream outputStream) {
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(outputStream, Charset.forName("GBK"));
            for (File file : srcFile) {
                String inZipPath = file.getName();
                if (StringUtil.isNotEmpty(srcRootDir) && file.getPath().contains(srcRootDir)) {
                    inZipPath = file.getPath().substring(srcRootDir.length());
                    inZipPath = file.isDirectory() ? inZipPath + "/" : inZipPath;
                    inZipPath = StringUtil.trimStart(inZipPath.replace("\\", "/"), "/");
                }
                out.putNextEntry(new ZipEntry(inZipPath));
                if (file.isFile()) {
                    int len;
                    in = new FileInputStream(file);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                } else {
                    ZipAndRarUtil.compress(file, out, file.getName(), true);
                }
                out.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(in, out);
                throw throwable;
            }
        }
        ObjectCloseUtil.close(in, out);
    }

    public static void onlyZipSrcFileList(List<File> srcFile, File zipFile, String rootDir) {
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile), Charset.forName("GBK"));
            for (File file : srcFile) {
                String inZipPath = file.getName();
                if (file.getPath().contains(rootDir)) {
                    inZipPath = file.getPath().substring(rootDir.length());
                    inZipPath = file.isDirectory() ? inZipPath + "/" : inZipPath;
                    inZipPath = StringUtil.trimStart(inZipPath.replace("\\", "/"), "/");
                }
                out.putNextEntry(new ZipEntry(inZipPath));
                if (file.isFile()) {
                    int len;
                    in = new FileInputStream(file);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                out.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u538b\u7f29\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(in, out);
                throw throwable;
            }
        }
        ObjectCloseUtil.close(in, out);
    }

    public static void toZip(String srcDir, String destFilePath, boolean keepDirStructure) {
        Assert.state((!destFilePath.toLowerCase().contains(srcDir.toLowerCase() + File.separator) ? 1 : 0) != 0, (String)("\u76ee\u6807\u8def\u5f84\u6709\u8bef : " + srcDir));
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFilePath);
            zos = new ZipOutputStream(fos);
            File sourceFile = new File(srcDir);
            ZipAndRarUtil.compress(sourceFile, zos, sourceFile.getName(), keepDirStructure);
            long end = System.currentTimeMillis();
            logger.info("\u538b\u7f29\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("zip error from ZipUtils", e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(zos, fos);
                throw throwable;
            }
        }
        ObjectCloseUtil.close(zos, fos);
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        ZipAndRarUtil.compress(file, zos, name + "/" + file.getName(), true);
                        continue;
                    }
                    ZipAndRarUtil.compress(file, zos, file.getName(), false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFiles(File zipFile, String descDir) {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            ZipFile zf = new ZipFile(zipFile, Charset.forName("GBK"));
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String zipEntryName = entry.getName();
                in = zf.getInputStream(entry);
                File file = new File(descDir + zipEntryName);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (file.isDirectory()) {
                    file.mkdirs();
                }
                out = new FileOutputStream(descDir + zipEntryName);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            }
            zf.close();
        }
        catch (Exception e) {
            try {
                ObjectCloseUtil.close(in, out);
                try {
                    ZipAndRarUtil.unZipFilesByZipArchiveInputStream(zipFile, descDir);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(in, out);
                throw throwable;
            }
            ObjectCloseUtil.close(in, out);
        }
        ObjectCloseUtil.close(in, out);
    }

    private static void unZipFilesByZipArchiveInputStream(File zipFile, String descDir) {
        FileInputStream in = null;
        FileOutputStream out = null;
        ZipArchiveInputStream zipIn = null;
        try {
            in = new FileInputStream(zipFile);
            zipIn = new ZipArchiveInputStream((InputStream)in, "GBK", true);
            ArchiveEntry archiveEntry = zipIn.getNextEntry();
            while (archiveEntry != null) {
                String entryFileName = archiveEntry.getName();
                if (!archiveEntry.isDirectory()) {
                    int len;
                    File entryFile;
                    String entryFilePath = Paths.get(descDir, entryFileName).toString();
                    File file = new File(entryFilePath);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    if (!(entryFile = new File(entryFilePath)).getParentFile().exists()) {
                        entryFile.getParentFile().mkdirs();
                    }
                    out = new FileOutputStream(entryFile);
                    byte[] buf1 = new byte[1024];
                    while ((len = zipIn.read(buf1)) > 0) {
                        ((OutputStream)out).write(buf1, 0, len);
                    }
                }
                archiveEntry = zipIn.getNextEntry();
            }
            zipIn.close();
            ((InputStream)in).close();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close(new AutoCloseable[]{zipIn, in, out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close(new AutoCloseable[]{zipIn, in, out});
    }
}

