/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.SysLogDao;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.entity.SysLog;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysLogServiceImpl
implements SysLogService {
    private static final Logger log = LoggerFactory.getLogger(SysLogServiceImpl.class);
    @Resource
    private SysLogDao sysLogDao;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public PageInfo<SysLog> list(int page, int rows, Integer eventId, Date startTime, Date endTime, Boolean orderDesc, String keyword) {
        PageHelper.startPage((int)(page + 1), (int)rows);
        return new PageInfo(this.sysLogDao.select(eventId, startTime, endTime, orderDesc, keyword));
    }

    @Override
    public List<Map<String, String>> getEvents() {
        return this.sysLogDao.selectEvents();
    }

    @Override
    public void addLog(int eventId, String logContent) {
        try {
            SysLog sysLog = new SysLog();
            sysLog.setEventId(eventId);
            sysLog.setContent(logContent);
            sysLog.setTime(new Date());
            String userName = "admin";
            String userAgentStr = null;
            LoginUserInfo userInfo = null;
            try {
                userInfo = ThreadLocalUtil.getCurrentUser();
                if (userInfo != null) {
                    userName = userInfo.getUserName();
                    userAgentStr = userInfo.getRequestUserAgent();
                    sysLog.setIp(userInfo.getRequestRemoteAddr());
                }
            }
            catch (IllegalStateException e) {
                log.error("\u83b7\u53d6\u7528\u6237\u540d\u548cip\u5f02\u5e38", (Throwable)e);
            }
            if (userInfo == null) {
                try {
                    ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
                    HttpServletRequest request = servletRequestAttributes.getRequest();
                    userInfo = this.loginUserService.getUserInfo(request);
                    if (userInfo != null && StringUtil.isNotEmpty((String)userInfo.getUserName())) {
                        userName = userInfo.getUserName();
                        userAgentStr = userInfo.getRequestUserAgent();
                    }
                    sysLog.setIp(request.getRemoteAddr());
                    if (StringUtil.isEmptyOrWhiteSpace((String)userAgentStr)) {
                        userAgentStr = request.getHeader("User-Agent");
                    }
                }
                catch (IllegalStateException e) {
                    log.error("\u83b7\u53d6\u7528\u6237\u540d\u548cip\u5f02\u5e38", (Throwable)e);
                }
            }
            sysLog.setUserName(userName);
            if (!StringUtil.isEmptyOrWhiteSpace((String)userAgentStr)) {
                UserAgent userAgent = UserAgentUtil.parse((String)userAgentStr);
                sysLog.setClientOS(userAgent.getOs().getName());
                sysLog.setClientPlatform(userAgent.getPlatform().getName());
                sysLog.setBrowserType(userAgent.getBrowser().getName() + " " + userAgent.getVersion());
            }
            this.sysLogDao.insertSelective(sysLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public void downloadLog(Integer eventId, Date startTime, Date endTime, Boolean orderDesc, String keyword, HttpServletResponse response) {
        PageHelper.startPage((int)1, (int)10000);
        List sysLogs = new PageInfo(this.sysLogDao.select(eventId, startTime, endTime, orderDesc, keyword)).getList();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u64cd\u4f5c\u65e5\u5fd7", "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        ExcelUtil.registerConverter();
        try (ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream()).registerWriteHandler((WriteHandler)new SimpleColumnWidthStyleStrategy(Integer.valueOf(25)))).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet((String)"\u64cd\u4f5c\u65e5\u5fd7").build();
            ArrayList<List<Object>> dataList = new ArrayList<List<Object>>();
            List<Object> titles = Arrays.asList("\u65f6\u95f4", "\u4e8b\u4ef6", "\u65e5\u5fd7\u5185\u5bb9", "\u7528\u6237", "IP");
            dataList.add(titles);
            for (SysLog sysLog : sysLogs) {
                ArrayList<Object> item = new ArrayList<Object>();
                item.add(sysLog.getTime());
                item.add(sysLog.getEventName());
                item.add(sysLog.getContent());
                item.add(sysLog.getUserName());
                item.add(sysLog.getIp());
                dataList.add(item);
            }
            excelWriter.write(dataList, writeSheet);
        }
    }

    @Override
    public int deleteLog(Integer beforeDays) {
        if (beforeDays < 30) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u5220\u966430\u5929\u5185\u7684\u65e5\u5fd7");
        }
        DateTime beforeDate = DateUtil.offsetDay((Date)new Date(), (int)(-beforeDays.intValue()));
        int count = this.sysLogDao.deleteByDate((Date)beforeDate);
        this.addLog(1, String.format("\u5220\u9664\u7cfb\u7edf\u64cd\u4f5c\u65e5\u5fd7\uff1a[%d]\u5929\u524d[%d]\u6761", beforeDays, count));
        return count;
    }
}

