/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.util;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpMapUtil {
    private static final Logger log = LoggerFactory.getLogger(IpMapUtil.class);
    public static final String DIC_IPMap = "IPMap";
    private static final SysParamsService sysParamsService = (SysParamsService)SpringContextUtil.getBean(SysParamsService.class);

    public static Map<String, String> getIpMap() {
        HashMap<String, String> ipMap = new HashMap<String, String>(0);
        try {
            SysParamGroupDTO sysParams = sysParamsService.getGroupDetail(DIC_IPMap);
            if (sysParams != null && sysParams.getParams() != null) {
                for (SysParamDTO param : sysParams.getParams()) {
                    ipMap.put(param.getKey(), param.getValue());
                }
            }
        }
        catch (Exception e) {
            log.debug("IP\u6620\u5c04\u914d\u7f6e\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
        }
        return ipMap;
    }

    public static String getIpAfterMap(Map<String, String> ipMap, String url) {
        if (StringUtil.isEmptyOrWhiteSpace((String)url)) {
            return url;
        }
        for (String ipBeforeMap : ipMap.keySet()) {
            String ipAfterMap = ipMap.get(ipBeforeMap);
            if (!url.contains(ipBeforeMap)) continue;
            url = url.replace(ipBeforeMap, ipAfterMap);
            break;
        }
        return url;
    }

    public static String getIpBeforMap(Map<String, String> ipMap, String url) {
        if (StringUtil.isEmptyOrWhiteSpace((String)url)) {
            return url;
        }
        for (String ipBeforeMap : ipMap.keySet()) {
            String ipAfterMap = ipMap.get(ipBeforeMap);
            if (!url.contains(ipAfterMap)) continue;
            url = url.replace(ipAfterMap, ipBeforeMap);
            break;
        }
        return url;
    }
}

