/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.ImageUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.component.MaterialCacheManager;
import com.geoway.adf.dms.config.dao.CmMaterialDao;
import com.geoway.adf.dms.config.dto.material.MaterialDTO;
import com.geoway.adf.dms.config.dto.material.MaterialGroupDTO;
import com.geoway.adf.dms.config.dto.material.MaterialImportStrategy;
import com.geoway.adf.dms.config.entity.CmMaterial;
import com.geoway.adf.dms.config.service.MaterialService;
import com.geoway.adf.gis.basic.PageList;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(rollbackFor={Exception.class})
public class MaterialServiceImpl
implements MaterialService {
    private static final Logger log = LoggerFactory.getLogger(MaterialServiceImpl.class);
    @Resource
    private CmMaterialDao cmMaterialDao;
    @Resource
    private MaterialCacheManager materialCacheManager;

    @Override
    public List<MaterialGroupDTO> listTypes() {
        List<CmMaterial> cmMaterials = this.cmMaterialDao.selectRoot();
        cmMaterials.sort(Comparator.comparing(CmMaterial::getCreateTime));
        ArrayList<MaterialGroupDTO> groupDTOS = new ArrayList<MaterialGroupDTO>();
        cmMaterials.forEach(m -> {
            MaterialGroupDTO groupDTO = new MaterialGroupDTO();
            BeanUtils.copyProperties((Object)m, (Object)groupDTO);
            groupDTOS.add(groupDTO);
        });
        return groupDTOS;
    }

    @Override
    public List<MaterialGroupDTO> listGroups(String typeId, Boolean withChildren, Integer childrenCount) {
        List<CmMaterial> cmMaterials = this.cmMaterialDao.selectByGroupId(typeId, null);
        ArrayList<MaterialGroupDTO> groupDTOS = new ArrayList<MaterialGroupDTO>();
        cmMaterials.forEach(m -> {
            MaterialGroupDTO groupDTO = new MaterialGroupDTO();
            BeanUtils.copyProperties((Object)m, (Object)groupDTO);
            groupDTOS.add(groupDTO);
            if (Boolean.TRUE.equals(withChildren)) {
                PageHelper.startPage((int)1, (int)childrenCount);
                PageInfo children = new PageInfo(this.cmMaterialDao.selectByGroupId(groupDTO.getId(), null));
                groupDTO.setMaterials(ListUtil.convertAll((List)children.getList(), this::convert));
            }
        });
        return groupDTOS;
    }

    @Override
    public PageList<MaterialDTO> listMaterials(String groupId, String keyword, Integer pageIndex, Integer rows) {
        PageHelper.startPage((int)(pageIndex + 1), (int)rows);
        PageInfo cmMaterialPageInfo = new PageInfo(this.cmMaterialDao.selectByGroupId(groupId, keyword));
        List materialDTOS = ListUtil.convertAll((List)cmMaterialPageInfo.getList(), this::convert);
        return new PageList(materialDTOS, Long.valueOf(cmMaterialPageInfo.getTotal()));
    }

    @Override
    public String saveGroup(MaterialGroupDTO group) {
        if (StringUtil.isEmptyOrWhiteSpace((String)group.getGroupId())) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u6240\u5c5e\u7c7b\u578b");
        }
        CmMaterial rootMaterial = this.cmMaterialDao.selectByPrimaryKey(group.getGroupId());
        if (rootMaterial == null) {
            throw new RuntimeException(group.getGroupId() + "\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (StringUtil.isEmpty((String)group.getId())) {
            Assert.isTrue((this.cmMaterialDao.selectIdByName(group.getGroupId(), group.getName()).size() == 0 ? 1 : 0) != 0, (String)("\u5206\u7ec4\u540d\u79f0[" + group.getName() + "]\u5df2\u5b58\u5728"));
            CmMaterial cmMaterial = new CmMaterial();
            cmMaterial.setId(IdUtil.getSnowflakeNextIdStr());
            cmMaterial.setName(group.getName());
            cmMaterial.setDesc(group.getDesc());
            cmMaterial.setGroupId(group.getGroupId());
            cmMaterial.setCreateTime(new Date());
            this.cmMaterialDao.insert(cmMaterial);
            return cmMaterial.getId();
        }
        CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(group.getId());
        if (cmMaterial == null) {
            log.error(group.getId());
            throw new RuntimeException("\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        List<String> existIds = this.cmMaterialDao.selectIdByName(group.getGroupId(), group.getName());
        if (!existIds.contains(group.getId())) {
            throw new RuntimeException("\u5206\u7ec4\u540d\u79f0[" + group.getName() + "]\u5df2\u5b58\u5728");
        }
        cmMaterial = new CmMaterial();
        cmMaterial.setId(group.getId());
        cmMaterial.setName(group.getName());
        cmMaterial.setDesc(group.getDesc());
        this.cmMaterialDao.updateByPrimaryKeySelective(cmMaterial);
        return cmMaterial.getId();
    }

    @Override
    public void deleteGroup(String id) {
        this.cmMaterialDao.deleteByGroupId(id);
        this.cmMaterialDao.deleteByPrimaryKey(id);
        this.materialCacheManager.deleteGroup(id);
    }

    @Override
    public List<String> uploadMaterial(String groupId, MultipartFile[] files) {
        CmMaterial groupMaterial = this.cmMaterialDao.selectByPrimaryKey(groupId);
        if (groupMaterial == null) {
            log.error(groupId);
            throw new RuntimeException("\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (MultipartFile file : files) {
            String ogrFileName = file.getOriginalFilename();
            String uid = UUID.randomUUID().toString().replace("-", "");
            String name = FileUtil.getFileNameWithoutExtension((String)ogrFileName);
            name = this.getNewName(name, groupId);
            String srcName = name + uid + FileUtil.getExtension((String)ogrFileName);
            CmMaterial cmMaterial = new CmMaterial();
            cmMaterial.setId(uid);
            cmMaterial.setName(name);
            cmMaterial.setSourceName(srcName);
            cmMaterial.setGroupId(groupId);
            cmMaterial.setType(StringUtil.trimStart((String)FileUtil.getExtension((String)srcName), (String)".").toLowerCase());
            cmMaterial.setCreateTime(new Date());
            cmMaterial.setContent(file.getBytes());
            this.cmMaterialDao.insert(cmMaterial);
            this.materialCacheManager.saveMaterial(groupId, srcName, file);
            ids.add(cmMaterial.getId());
        }
        return ids;
    }

    @Override
    public void renameMaterial(String id, String name) {
        CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(id);
        if (cmMaterial == null) {
            log.error(id);
            throw new RuntimeException("\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        List<String> existIds = this.cmMaterialDao.selectIdByName(cmMaterial.getGroupId(), name);
        if (!existIds.contains(cmMaterial.getId())) {
            throw new RuntimeException("\u540d\u79f0[" + name + "]\u5df2\u5b58\u5728");
        }
        cmMaterial = new CmMaterial();
        cmMaterial.setId(id);
        cmMaterial.setName(name);
        this.cmMaterialDao.updateByPrimaryKeySelective(cmMaterial);
    }

    @Override
    public void deleteMaterial(String[] ids) {
        for (String id : ids) {
            CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(id);
            if (cmMaterial == null) continue;
            this.cmMaterialDao.deleteByPrimaryKey(id);
            this.materialCacheManager.deleteMaterial(cmMaterial);
        }
    }

    @Override
    public void move2Group(String[] ids, String newGroupId) {
        CmMaterial newGroupMaterial = this.cmMaterialDao.selectByPrimaryKey(newGroupId);
        if (newGroupMaterial == null) {
            log.error(newGroupId);
            throw new RuntimeException("\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        for (String id : ids) {
            CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(id);
            if (cmMaterial == null) continue;
            String newName = this.getNewName(cmMaterial.getName(), newGroupId);
            String newSourceName = newName + cmMaterial.getId() + FileUtil.getExtension((String)cmMaterial.getSourceName());
            CmMaterial newMaterial = new CmMaterial();
            newMaterial.setId(id);
            newMaterial.setName(newName);
            newMaterial.setSourceName(newSourceName);
            newMaterial.setGroupId(newGroupId);
            this.cmMaterialDao.updateByPrimaryKeySelective(newMaterial);
            this.materialCacheManager.move2Group(newMaterial, cmMaterial.getGroupId(), cmMaterial.getSourceName());
        }
    }

    @Override
    public MaterialDTO getMaterialDetail(String id) {
        CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(id);
        if (cmMaterial == null) {
            log.error(id);
            throw new RuntimeException("\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        return this.convert(cmMaterial);
    }

    @Override
    public void viewMaterial(String id, String sourceName, HttpServletRequest request, HttpServletResponse response) {
        block19: {
            CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(id);
            Assert.notNull((Object)cmMaterial, (String)"\u7d20\u6750\u4e0d\u5b58\u5728");
            if (cmMaterial.getSourceName() == null) {
                String groupId = id;
                boolean success = this.materialCacheManager.viewMaterial(groupId, sourceName, request, response);
                if (!success) {
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                }
                break block19;
            }
            String groupId = cmMaterial.getGroupId();
            boolean success = this.materialCacheManager.viewMaterial(groupId, sourceName = cmMaterial.getSourceName(), request, response);
            if (success) break block19;
            try {
                byte[] content = (byte[])this.cmMaterialDao.selectContent(cmMaterial.getId());
                if (content == null) {
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return;
                }
                this.materialCacheManager.saveMaterial(groupId, sourceName, content);
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(content);){
                    FileViewerUtil.viewFileStream((InputStream)inputStream, (String)sourceName, (long)content.length, (HttpServletRequest)request, (HttpServletResponse)response);
                }
            }
            catch (Exception e) {
                log.error(id + "/" + sourceName, (Throwable)e);
                response.setStatus(HttpStatus.NOT_FOUND.value());
            }
        }
    }

    @Override
    public void download(String groupId, String ids, HttpServletRequest request, HttpServletResponse response) {
        CmMaterial groupMaterial = this.cmMaterialDao.selectByPrimaryKey(groupId);
        Assert.notNull((Object)groupMaterial, (String)"\u7d20\u6750\u5206\u7ec4\u4e0d\u5b58\u5728");
        List<CmMaterial> cmMaterials = this.cmMaterialDao.selectByIds(groupId, StringUtil.isEmpty((String)ids) ? null : ids.split(","));
        if (cmMaterials.size() == 0) {
            log.error(ids);
            throw new RuntimeException("\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        ZipOutputStream out = null;
        try {
            DownloadUtil.setDownloadFileName((String)(groupMaterial.getName() + ".zip"), (HttpServletRequest)request, (HttpServletResponse)response);
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            ServletOutputStream outputStream = response.getOutputStream();
            out = new ZipOutputStream((OutputStream)outputStream, Charset.forName("GBK"));
            ArrayList<String> zipPathList = new ArrayList<String>();
            for (CmMaterial cmMaterial : cmMaterials) {
                String inZipPath = cmMaterial.getName() + FileUtil.getExtension((String)cmMaterial.getSourceName());
                if (zipPathList.contains(inZipPath)) {
                    inZipPath = cmMaterial.getName() + "_1" + FileUtil.getExtension((String)cmMaterial.getSourceName());
                }
                out.putNextEntry(new ZipEntry(inZipPath));
                zipPathList.add(inZipPath);
                byte[] content = (byte[])this.cmMaterialDao.selectContent(cmMaterial.getId());
                if (content == null) {
                    try (InputStream inputStream = this.materialCacheManager.getMaterialInputStream(groupId, cmMaterial.getSourceName());){
                        if (inputStream != null) {
                            content = FileCopyUtils.copyToByteArray((InputStream)inputStream);
                        }
                    }
                    catch (Exception e) {
                        log.error(cmMaterial.getSourceName(), (Throwable)e);
                    }
                }
                if (content != null) {
                    out.write(content);
                }
                out.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u7d20\u6750\u4e0b\u8f7d\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
    }

    @Override
    public void exportGroup(String groupId, HttpServletRequest request, HttpServletResponse response) {
        CmMaterial groupMaterial = this.cmMaterialDao.selectByPrimaryKey(groupId);
        Assert.notNull((Object)groupMaterial, (String)"\u7d20\u6750\u5206\u7ec4\u4e0d\u5b58\u5728");
        List<CmMaterial> cmMaterials = this.cmMaterialDao.selectByGroupId(groupId, null);
        if (cmMaterials.size() == 0) {
            throw new RuntimeException("\u5206\u7ec4\u5185\u4e0d\u5b58\u5728\u5f85\u5bfc\u51fa\u7d20\u6750");
        }
        ZipOutputStream out = null;
        try {
            DownloadUtil.setDownloadFileName((String)(groupMaterial.getName() + ".gmt"), (HttpServletRequest)request, (HttpServletResponse)response);
            response.setContentType("application/x-download");
            response.setCharacterEncoding("UTF-8");
            ServletOutputStream outputStream = response.getOutputStream();
            out = new ZipOutputStream((OutputStream)outputStream, Charset.forName("GBK"));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"group", (Object)groupMaterial);
            jsonObject.put((Object)"list", cmMaterials);
            byte[] metadata = jsonObject.toJSONString(new JSONWriter.Feature[0]).getBytes("UTF-8");
            out.putNextEntry(new ZipEntry("metadata.json"));
            out.write(metadata);
            ArrayList<String> zipPathList = new ArrayList<String>();
            for (CmMaterial cmMaterial : cmMaterials) {
                String inZipPath = cmMaterial.getName() + FileUtil.getExtension((String)cmMaterial.getSourceName());
                if (zipPathList.contains(inZipPath)) {
                    inZipPath = cmMaterial.getName() + "_1" + FileUtil.getExtension((String)cmMaterial.getSourceName());
                }
                out.putNextEntry(new ZipEntry(inZipPath));
                zipPathList.add(inZipPath);
                byte[] content = (byte[])this.cmMaterialDao.selectContent(cmMaterial.getId());
                if (content == null) {
                    try (InputStream inputStream = this.materialCacheManager.getMaterialInputStream(groupId, cmMaterial.getSourceName());){
                        if (inputStream != null) {
                            content = FileCopyUtils.copyToByteArray((InputStream)inputStream);
                        }
                    }
                    catch (Exception e) {
                        log.error(cmMaterial.getSourceName(), (Throwable)e);
                    }
                }
                if (content != null) {
                    out.write(content);
                }
                out.closeEntry();
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u7d20\u6750\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{out});
    }

    @Override
    public String importGroup(String typeId, Integer importStrategy, MultipartFile file) {
        CmMaterial typeMaterial = this.cmMaterialDao.selectByPrimaryKey(typeId);
        Assert.notNull((Object)typeMaterial, (String)(typeId + "\u5206\u7c7b\u4e0d\u5b58\u5728"));
        try {
            File tempDir = FileUtil.createTempDir((String)UUID.randomUUID().toString());
            File localFile = new File(tempDir, file.getOriginalFilename());
            file.transferTo(localFile);
            ZipAndRarUtil.unZipFiles((File)localFile, (String)(tempDir + File.separator));
            File metadataFile = new File(tempDir, "metadata.json");
            if (!metadataFile.exists()) {
                throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            byte[] data = Files.readAllBytes(metadataFile.toPath());
            JSONObject jsonObject = (JSONObject)JSON.parseObject((byte[])data, JSONObject.class);
            CmMaterial group = (CmMaterial)jsonObject.getObject("group", CmMaterial.class, new JSONReader.Feature[0]);
            List materialList = JSON.parseArray((String)jsonObject.getString("list"), CmMaterial.class);
            if (materialList == null || materialList.size() == 0) {
                throw new RuntimeException("\u7d20\u6750\u5217\u8868\u4e3a\u7a7a");
            }
            String groupId = group.getId();
            CmMaterial groupMaterial = this.cmMaterialDao.selectByPrimaryKey(groupId);
            if (groupMaterial == null) {
                groupMaterial = new CmMaterial();
                groupMaterial.setId(groupId);
                groupMaterial.setName(group.getName());
                groupMaterial.setDesc(group.getDesc());
                groupMaterial.setGroupId(typeId);
                groupMaterial.setCreateTime(new Date());
                this.cmMaterialDao.insert(groupMaterial);
            }
            MaterialImportStrategy strategy = MaterialImportStrategy.getByValue(importStrategy);
            for (CmMaterial material : materialList) {
                String materialId = material.getId();
                String name = material.getName();
                String srcFileName = name + FileUtil.getExtension((String)material.getSourceName());
                String materialSrcName = material.getSourceName();
                File srcFile = new File(tempDir, srcFileName);
                if (!srcFile.exists()) {
                    log.error(srcFileName + "\u6587\u4ef6\u4e0d\u5b58\u5728");
                    continue;
                }
                CmMaterial cmMaterial = this.cmMaterialDao.selectByPrimaryKey(materialId);
                if (cmMaterial != null) {
                    if (strategy == MaterialImportStrategy.Skip) continue;
                    if (strategy == MaterialImportStrategy.Overwrite) {
                        byte[] fileContent = Files.readAllBytes(srcFile.toPath());
                        this.cmMaterialDao.updateContent(materialId, fileContent);
                        this.materialCacheManager.saveMaterial(groupId, materialSrcName, file);
                        continue;
                    }
                    if (strategy != MaterialImportStrategy.Append) continue;
                    materialId = UUID.randomUUID().toString().replace("-", "");
                }
                name = this.getNewName(name, groupId);
                materialSrcName = name + materialId + FileUtil.getExtension((String)srcFileName);
                cmMaterial = new CmMaterial();
                cmMaterial.setId(materialId);
                cmMaterial.setName(name);
                cmMaterial.setSourceName(materialSrcName);
                cmMaterial.setGroupId(groupId);
                cmMaterial.setType(StringUtil.trimStart((String)FileUtil.getExtension((String)srcFileName), (String)".").toLowerCase());
                cmMaterial.setCreateTime(new Date());
                cmMaterial.setContent(Files.readAllBytes(srcFile.toPath()));
                this.cmMaterialDao.insert(cmMaterial);
                this.materialCacheManager.saveMaterial(groupId, materialSrcName, file);
            }
            return groupMaterial.getName();
        }
        catch (Exception e) {
            log.error(file.getOriginalFilename() + "\u7d20\u6750\u5305\u5bfc\u5165\u5931\u8d25");
            throw new RuntimeException(e);
        }
    }

    private MaterialDTO convert(CmMaterial cmMaterial) {
        MaterialDTO materialDTO = new MaterialDTO();
        BeanUtils.copyProperties((Object)cmMaterial, (Object)materialDTO);
        String name = cmMaterial.getName() + FileUtil.getExtension((String)cmMaterial.getSourceName());
        materialDTO.setUrl(String.format("/material/%s/%s", cmMaterial.getId(), name));
        if (cmMaterial.getThumbnail() != null) {
            String base64Str = ImageUtil.toBase64DataUri((byte[])((byte[])cmMaterial.getThumbnail()), null);
            materialDTO.setThumbnail(base64Str);
        }
        return materialDTO;
    }

    private String getNewName(String name, String groupId) {
        String newName = name;
        int i = 1;
        while (this.cmMaterialDao.selectIdByName(groupId, newName).size() > 0) {
            newName = name + "_" + i;
            ++i;
        }
        return newName;
    }
}

