/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.component;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class MyBatisSchemaInterceptor
implements Interceptor {
    private final Map<String, String[]> mapperTableNames = new ConcurrentSkipListMap<String, String[]>();

    public void addMapper(String mapperName, String ... tableNames) {
        this.mapperTableNames.put(mapperName, tableNames);
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement;
        if (!(invocation.getTarget() instanceof StatementHandler)) {
            return invocation.proceed();
        }
        StatementHandler handler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = SystemMetaObject.forObject((Object)handler);
        if (metaObject.hasGetter("delegate.mappedStatement")) {
            mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        } else if (metaObject.hasGetter("parameterHandler.mappedStatement")) {
            mappedStatement = (MappedStatement)metaObject.getValue("parameterHandler.mappedStatement");
        } else {
            return invocation.proceed();
        }
        String mapperNamespace = mappedStatement.getId();
        String mapperName = mapperNamespace.substring(0, mapperNamespace.lastIndexOf("."));
        if (this.mapperTableNames.containsKey(mapperName)) {
            String originalSql;
            LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
            if (userInfo == null) {
                throw new HttpClientErrorException(HttpStatus.UNAUTHORIZED, "\u7cfb\u7edf\u672a\u767b\u5f55");
            }
            String schemaName = userInfo.getTenantId();
            if (schemaName == null) {
                return invocation.proceed();
            }
            BoundSql boundSql = handler.getBoundSql();
            String newSql = originalSql = boundSql.getSql();
            for (String tableName : this.mapperTableNames.get(mapperName)) {
                newSql = newSql.replaceAll("\\b" + tableName + "\\b", " " + schemaName + "." + tableName + " ");
            }
            Field sqlField = boundSql.getClass().getDeclaredField("sql");
            sqlField.setAccessible(true);
            sqlField.set(boundSql, newSql);
        }
        return invocation.proceed();
    }

    private void printMetaObjectStructure(MetaObject metaObject) {
        for (String name : metaObject.getGetterNames()) {
            Object value = metaObject.getValue(name);
            System.out.println("\u5c5e\u6027: " + name + ", \u503c\u7c7b\u578b: " + (value != null ? value.getClass() : "null"));
            if (value == null || metaObject.hasGetter(name)) continue;
            this.printMetaObjectStructure(SystemMetaObject.forObject((Object)value));
        }
    }
}

