/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.SysParamDao;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.entity.SysParam;
import com.geoway.adf.dms.config.service.SysParamsService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysParamsServiceImpl
implements SysParamsService {
    private static final Logger log = LoggerFactory.getLogger(SysParamsServiceImpl.class);
    @Resource
    private SysParamDao sysParamDao;

    @Override
    public List<SysParamGroupDTO> listGroupParams(String keyword) {
        List<SysParam> allSysParams = this.sysParamDao.selectAll();
        SysParamGroupDTO defaultGroup = null;
        LinkedHashMap<Long, SysParamGroupDTO> groupIdMap = new LinkedHashMap<Long, SysParamGroupDTO>();
        for (SysParam param : allSysParams) {
            switch (param.getType()) {
                case 0: {
                    SysParamGroupDTO groupDTO = (SysParamGroupDTO)groupIdMap.get(param.getGroupId());
                    if (groupDTO == null) break;
                    SysParamDTO paramDTO = this.convertToDTO(param, groupDTO.getKey());
                    groupDTO.getParams().add(paramDTO);
                    break;
                }
                case 1: {
                    SysParamGroupDTO group = this.convertToGroupDTO(param);
                    groupIdMap.put(group.getId(), group);
                    if (!StringUtil.isEmpty((String)param.getKey())) break;
                    defaultGroup = group;
                    break;
                }
            }
        }
        ArrayList<SysParamGroupDTO> groupList = new ArrayList<SysParamGroupDTO>(groupIdMap.values());
        if (defaultGroup == null) {
            defaultGroup = this.convertToGroupDTO(this.addDefaultGroup());
            groupList.add(0, defaultGroup);
        } else {
            groupList.remove(defaultGroup);
            groupList.add(0, defaultGroup);
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)keyword)) {
            return groupList;
        }
        String keywordLower = keyword.toLowerCase();
        ArrayList<SysParamGroupDTO> targetParams = new ArrayList<SysParamGroupDTO>();
        for (SysParamGroupDTO groupDTO : groupList) {
            if (groupDTO.getKey().toLowerCase().contains(keywordLower) || groupDTO.getName().toLowerCase().contains(keywordLower)) {
                targetParams.add(groupDTO);
                continue;
            }
            List children = ListUtil.findAll(groupDTO.getParams(), p -> p.getKey().toLowerCase().contains(keywordLower));
            if (children.size() <= 0) continue;
            groupDTO.setParams(children);
            targetParams.add(groupDTO);
        }
        return targetParams;
    }

    @Override
    @Cacheable(value={"SystemParamCache"}, keyGenerator="customKeyGenerator")
    public SysParamDTO getDetail(String groupKey, String key) {
        SysParam group = !StringUtil.isEmptyOrWhiteSpace((String)groupKey) ? this.sysParamDao.selectGroup(groupKey) : this.getDefaultGroup();
        if (group == null) {
            log.error(String.format("\u7cfb\u7edf\u53c2\u6570\u5206\u7ec4[%s]\u4e0d\u5b58\u5728", groupKey));
            return null;
        }
        SysParam target = this.sysParamDao.selectByKeyGroupId(key, group.getId());
        if (target == null) {
            if (StringUtil.isEmpty((String)groupKey)) {
                log.error(String.format("\u7cfb\u7edf\u53c2\u6570[%s]\u4e0d\u5b58\u5728", key));
            } else {
                log.error(String.format("\u7cfb\u7edf\u53c2\u6570[%s]->[%s]\u4e0d\u5b58\u5728", groupKey, key));
            }
            return null;
        }
        return this.convertToDTO(target, group.getKey());
    }

    @Override
    @Cacheable(value={"SystemParamCache"}, keyGenerator="customKeyGenerator")
    public SysParamGroupDTO getGroupDetail(String groupKey) {
        SysParam group = !StringUtil.isEmptyOrWhiteSpace((String)groupKey) ? this.sysParamDao.selectGroup(groupKey) : this.getDefaultGroup();
        if (group == null) {
            log.error(String.format("\u7cfb\u7edf\u53c2\u6570\u5206\u7ec4[%s]\u4e0d\u5b58\u5728", groupKey));
            return null;
        }
        List<SysParam> children = this.sysParamDao.selectByGroupId(group.getId());
        SysParamGroupDTO groupDTO = this.convertToGroupDTO(group);
        if (children != null && children.size() > 0) {
            groupDTO.setParams(ListUtil.convertAll(children, f -> this.convertToDTO((SysParam)f, groupDTO.getKey())));
        }
        return groupDTO;
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public Long addParamGroup(SysParamGroupDTO paramGroup) {
        if (StringUtil.isEmptyOrWhiteSpace((String)paramGroup.getKey())) {
            throw new RuntimeException("\u5206\u7ec4\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)paramGroup.getName())) {
            throw new RuntimeException("\u5206\u7ec4\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        SysParam sameKeyGroup = this.sysParamDao.selectGroup(paramGroup.getKey());
        if (sameKeyGroup != null) {
            throw new RuntimeException("\u5df2\u5b58\u5728\u540c\u6807\u8bc6\u7684\u5206\u7ec4\uff01");
        }
        SysParam group = new SysParam();
        group.setType(1);
        group.setName(paramGroup.getName());
        group.setKey(paramGroup.getKey());
        group.setUserKey("");
        group.setDesc(paramGroup.getDesc());
        this.sysParamDao.insert(group);
        return group.getId();
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public void updateParamGroup(SysParamGroupDTO paramGroup) {
        if (paramGroup.getId() == null) {
            throw new RuntimeException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SysParam group = this.sysParamDao.selectByPrimaryKey(paramGroup.getId());
        Assert.notNull((Object)group, (String)"\u672a\u627e\u5230\u6b64\u53c2\u6570\u5206\u7ec4\uff01");
        if (!StringUtil.isEmptyOrWhiteSpace((String)paramGroup.getKey()) && !group.getKey().equals(paramGroup.getKey())) {
            SysParam sameKeyGroup = this.sysParamDao.selectGroup(paramGroup.getKey());
            if (sameKeyGroup != null) {
                throw new RuntimeException("\u5df2\u5b58\u5728\u540c\u6807\u8bc6\u7684\u5206\u7ec4\uff01");
            }
            group.setKey(paramGroup.getKey());
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)paramGroup.getName())) {
            group.setName(paramGroup.getName());
        }
        if (paramGroup.getDesc() != null) {
            group.setDesc(paramGroup.getDesc());
        }
        this.sysParamDao.updateByPrimaryKey(group);
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public Long addSysParam(SysParamDTO sysParam) {
        if (StringUtil.isEmptyOrWhiteSpace((String)sysParam.getKey())) {
            throw new RuntimeException("\u53c2\u6570\u6807\u8bc6\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (sysParam.getGroupId() == null) {
            throw new RuntimeException("groupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysParam param = new SysParam();
        param.setType(0);
        param.setKey(sysParam.getKey());
        param.setDesc(sysParam.getDesc());
        param.setValue(sysParam.getValue());
        param.setUserKey("");
        param.setGroupId(sysParam.getGroupId());
        SysParam group = this.sysParamDao.selectByPrimaryKey(sysParam.getGroupId());
        Assert.notNull((Object)group, (String)"\u672a\u627e\u5230\u76ee\u6807\u5206\u7ec4\uff01");
        SysParam sameParam = this.sysParamDao.selectByKeyGroupId(sysParam.getKey(), group.getId());
        if (sameParam != null) {
            throw new RuntimeException("\u6b64\u7ec4\u4e0b\u5df2\u5b58\u5728\u540c\u6807\u8bc6\u7684\u7cfb\u7edf\u53c2\u6570\uff01");
        }
        this.sysParamDao.insert(param);
        return param.getId();
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public void updateSysParam(SysParamDTO sysParam) {
        if (sysParam.getId() == null) {
            throw new RuntimeException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SysParam param = this.sysParamDao.selectByPrimaryKey(sysParam.getId());
        Assert.notNull((Object)param, (String)"\u672a\u627e\u5230\u6b64\u7cfb\u7edf\u53c2\u6570\uff01");
        SysParam group = this.sysParamDao.selectByPrimaryKey(param.getGroupId());
        Assert.notNull((Object)group, (String)"\u672a\u627e\u5230\u76ee\u6807\u5206\u7ec4\uff01");
        if (!StringUtil.isEmptyOrWhiteSpace((String)sysParam.getKey()) && !param.getKey().equals(sysParam.getKey())) {
            SysParam sameParam = this.sysParamDao.selectByKeyGroupId(sysParam.getKey(), param.getGroupId());
            if (sameParam != null) {
                throw new RuntimeException("\u6b64\u7ec4\u4e0b\u5df2\u5b58\u5728\u540c\u6807\u8bc6\u7684\u7cfb\u7edf\u53c2\u6570\uff01");
            }
            param.setKey(sysParam.getKey());
        }
        if (sysParam.getValue() != null) {
            param.setValue(sysParam.getValue());
        }
        if (sysParam.getDesc() != null) {
            param.setDesc(sysParam.getDesc());
        }
        if (sysParam.getGroupId() != null) {
            param.setGroupId(sysParam.getGroupId());
        }
        this.sysParamDao.updateByPrimaryKey(param);
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public void deleteSysParam(String groupKey, String key) {
        if (StringUtil.isEmptyOrWhiteSpace((String)groupKey) && StringUtil.isEmptyOrWhiteSpace((String)key)) {
            return;
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)groupKey)) {
            SysParam defaultGroup = this.getDefaultGroup();
            this.sysParamDao.deleteByKeyGroupId(key, defaultGroup.getId());
            return;
        }
        SysParam group = this.sysParamDao.selectGroup(groupKey);
        if (group == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u7cfb\u7edf\u53c2\u6570\u5206\u7ec4\uff1a" + groupKey);
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)key)) {
            this.sysParamDao.deleteByGroupId(group.getId());
            return;
        }
        this.sysParamDao.deleteByKeyGroupId(key, group.getId());
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public void deleteSysParam(Long id) {
        this.sysParamDao.deleteByGroupId(id);
    }

    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public void batchDeleteSysParam(String ids) {
        List idList;
        Object[] idArray = ids.split(",");
        try {
            idList = ListUtil.convertAll((Object[])idArray, Long::parseLong);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("id\u53c2\u6570\u5f02\u5e38\uff01");
        }
        if (idList != null && idList.size() > 0) {
            this.sysParamDao.batchDelete(idList);
        }
    }

    @Override
    public void exportGroupParam(String groupKey) {
        SysParamGroupDTO sysParamGroupDTO = this.getGroupDetail(groupKey);
        if (sysParamGroupDTO == null) {
            throw new RuntimeException(String.format("\u7cfb\u7edf\u53c2\u6570\u5206\u7ec4[%s]\u4e0d\u5b58\u5728", groupKey));
        }
        String contents = JSONObject.toJSONString((Object)sysParamGroupDTO);
        String name = sysParamGroupDTO.getKey().replaceAll("[\\s\\\\/:\\*\\?\\\"<>\\|]", "");
        if (StringUtil.isEmptyOrWhiteSpace((String)name)) {
            name = sysParamGroupDTO.getName();
        }
        DownloadUtil.downloadToFile((String)(name + ".json"), (String)contents);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @CacheEvict(value={"SystemParamCache"}, allEntries=true)
    public Boolean importGroupParam(MultipartFile file) {
        if (file == null || !Objects.requireNonNull(file.getOriginalFilename()).endsWith(".json")) {
            throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuffer = new StringBuilder();
        SysParamGroupDTO sysParamGroupDTO = null;
        try {
            streamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            bufferedReader.close();
            streamReader.close();
            sysParamGroupDTO = (SysParamGroupDTO)JSONObject.parseObject((String)stringBuffer.toString(), SysParamGroupDTO.class);
        }
        catch (Exception e) {
            try {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff01" + e.getMessage());
            }
            catch (Throwable throwable) {
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
                throw throwable;
            }
        }
        ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{streamReader, bufferedReader});
        if (sysParamGroupDTO == null) {
            throw new RuntimeException("\u672a\u89e3\u6790\u5230\u7cfb\u7edf\u53c2\u6570\uff01");
        }
        Long groupId = null;
        if (!StringUtil.isEmptyOrWhiteSpace((String)sysParamGroupDTO.getKey())) {
            SysParam group = this.sysParamDao.selectGroup(sysParamGroupDTO.getKey());
            if (group != null) throw new RuntimeException(sysParamGroupDTO.getKey() + "\u53c2\u6570\u5206\u7ec4\u5df2\u5b58\u5728\uff01");
            groupId = this.addParamGroup(sysParamGroupDTO);
        } else {
            SysParam defaultGroup = this.getDefaultGroup();
            groupId = defaultGroup.getId();
        }
        for (SysParamDTO paramDTO : sysParamGroupDTO.getParams()) {
            SysParam sameParam = this.sysParamDao.selectByKeyGroupId(paramDTO.getKey(), groupId);
            if (sameParam != null) continue;
            paramDTO.setGroupId(groupId);
            this.addSysParam(paramDTO);
        }
        return true;
    }

    private SysParam getDefaultGroup() {
        SysParam defaultGroup = this.sysParamDao.selectGroup("");
        if (defaultGroup == null) {
            defaultGroup = this.addDefaultGroup();
        }
        return defaultGroup;
    }

    private synchronized SysParam addDefaultGroup() {
        SysParam defaultGroup = this.sysParamDao.selectGroup("");
        if (defaultGroup == null) {
            defaultGroup = new SysParam();
            defaultGroup.setKey("");
            defaultGroup.setName("\u9ed8\u8ba4\u5206\u7ec4");
            defaultGroup.setUserKey("");
            defaultGroup.setType(1);
            defaultGroup.setId(-1L);
            this.sysParamDao.insert(defaultGroup);
        }
        return defaultGroup;
    }

    private SysParamGroupDTO convertToGroupDTO(SysParam param) {
        SysParamGroupDTO dto = new SysParamGroupDTO();
        if (param == null) {
            return dto;
        }
        dto.setId(param.getId());
        dto.setName(param.getName());
        dto.setKey(param.getKey());
        dto.setDesc(param.getDesc());
        dto.setParams(new ArrayList<SysParamDTO>());
        return dto;
    }

    private SysParamDTO convertToDTO(SysParam param, String groupKey) {
        SysParamDTO dto = new SysParamDTO();
        if (param == null) {
            return dto;
        }
        dto.setId(param.getId());
        dto.setKey(param.getKey());
        dto.setDesc(param.getDesc());
        dto.setValue(param.getValue());
        dto.setGroupKey(groupKey);
        dto.setGroupId(param.getGroupId());
        return dto;
    }
}

