/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONObject;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.CmAttachmentDao;
import com.geoway.adf.dms.config.dto.attachment.AttachmentDTO;
import com.geoway.adf.dms.config.entity.CmAttachment;
import com.geoway.adf.dms.config.service.AttachmentService;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AttachmentServiceImpl
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(AttachmentServiceImpl.class);
    @Resource
    private CmAttachmentDao attachmentDao;
    @Value(value="${project.attachment-path:#{null}}")
    private String attachment_path;

    @Override
    public List<AttachmentDTO> list(String relatedType, String relatedId) {
        List<CmAttachment> attachmentList = this.attachmentDao.selectByRelated(relatedType, relatedId);
        ArrayList<AttachmentDTO> attachmentDTOList = new ArrayList<AttachmentDTO>();
        attachmentList.forEach(a -> attachmentDTOList.add(this.convert((CmAttachment)a)));
        return attachmentDTOList;
    }

    @Override
    public List<AttachmentDTO> getAttachments(String ids) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)ids), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> idList = Arrays.asList(ids.split(","));
        List<CmAttachment> attachmentList = this.attachmentDao.selectByIds(idList);
        ArrayList<AttachmentDTO> attachmentDTOList = new ArrayList<AttachmentDTO>();
        attachmentList.forEach(a -> attachmentDTOList.add(this.convert((CmAttachment)a)));
        return attachmentDTOList;
    }

    @Override
    public List<AttachmentDTO> upload(String relatedType, String relatedId, MultipartFile[] files) {
        File relatedPath = this.getAttachmentPath(relatedType, relatedId);
        ArrayList<AttachmentDTO> attachmentDTOList = new ArrayList<AttachmentDTO>();
        for (MultipartFile file : files) {
            File localFile = new File(relatedPath, file.getOriginalFilename());
            file.transferTo(localFile);
            CmAttachment attachment = new CmAttachment();
            attachment.setId(IdUtil.getSnowflakeNextIdStr());
            attachment.setRelatedType(relatedType);
            attachment.setRelatedId(relatedId);
            attachment.setFileName(file.getOriginalFilename());
            attachment.setCreateTime(new Date());
            String ext = FileUtil.getExtension((String)localFile.getName()).toLowerCase();
            if (ext.equals(".mp4")) {
                try (IsoFile isoFile = new IsoFile(localFile.getAbsolutePath());){
                    JSONObject jsonObject = new JSONObject();
                    MovieBox movieBox = isoFile.getMovieBox();
                    MovieHeaderBox movieBoxMovieHeaderBox = movieBox.getMovieHeaderBox();
                    jsonObject.put("duration", (Object)(movieBoxMovieHeaderBox.getDuration() / movieBoxMovieHeaderBox.getTimescale()));
                    Iterator iterator = movieBox.getBoxes(TrackBox.class).iterator();
                    if (iterator.hasNext()) {
                        TrackBox trackBox = (TrackBox)iterator.next();
                        TrackHeaderBox trackHeaderBox = trackBox.getTrackHeaderBox();
                        jsonObject.put("width", (Object)((int)trackHeaderBox.getWidth()));
                        jsonObject.put("height", (Object)((int)trackHeaderBox.getHeight()));
                    }
                    attachment.setTag(jsonObject.toJSONString());
                }
                catch (Exception e) {
                    log.error(localFile + " \u8bfb\u53d6mp4\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                }
            }
            this.attachmentDao.insert(attachment);
            attachmentDTOList.add(this.convert(attachment));
        }
        return attachmentDTOList;
    }

    @Override
    public void delete(String id) {
        String[] idList;
        for (String attId : idList = id.split(",")) {
            CmAttachment attachment = this.attachmentDao.selectByPrimaryKey(attId);
            if (attachment == null) continue;
            this.deleteFile(attachment.getRelatedType(), attachment.getRelatedId(), attachment.getFileName());
            this.attachmentDao.deleteByPrimaryKey(attId);
        }
    }

    @Override
    public void delete(String relatedType, String relatedId) {
        File relatedPath = this.getRelatedTypePath(relatedType);
        if (relatedPath != null) {
            try {
                if (StringUtil.isNotEmpty((String)relatedId)) {
                    relatedPath = new File(relatedPath, relatedId);
                }
                if (relatedPath.exists()) {
                    FileUtil.deleteDir((String)relatedPath.getAbsolutePath());
                }
            }
            catch (Exception e) {
                log.error(relatedPath.getAbsolutePath() + " \u9644\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
            }
        }
        this.attachmentDao.deleteByRelated(relatedType, relatedId);
    }

    @Override
    public void view(String relatedType, String relatedId, String fileName, HttpServletRequest request, HttpServletResponse response) {
        File schemePath = this.getAttachmentPath(relatedType, relatedId);
        File file = new File(schemePath, fileName);
        FileViewerUtil.viewFile((File)file, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Override
    public void view(String id, HttpServletRequest request, HttpServletResponse response) {
        CmAttachment attachment = this.attachmentDao.selectByPrimaryKey(id);
        Assert.notNull((Object)attachment, (String)"\u9644\u4ef6\u4e0d\u5b58\u5728");
        File schemePath = this.getAttachmentPath(attachment.getRelatedType(), attachment.getRelatedId());
        File file = new File(schemePath, attachment.getFileName());
        FileViewerUtil.viewFile((File)file, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Override
    public void download(String id, HttpServletRequest request, HttpServletResponse response) {
        CmAttachment attachment = this.attachmentDao.selectByPrimaryKey(id);
        Assert.notNull((Object)attachment, (String)"\u9644\u4ef6\u4e0d\u5b58\u5728");
        File schemePath = this.getAttachmentPath(attachment.getRelatedType(), attachment.getRelatedId());
        File file = new File(schemePath, attachment.getFileName());
        if (file.exists()) {
            DownloadUtil.downloadFile((String)file.getAbsolutePath());
        } else {
            log.error(file.getAbsolutePath() + " \u9644\u4ef6\u5df2\u4e0d\u5b58\u5728");
        }
    }

    private void deleteFile(String relatedType, String relatedId, String fileName) {
        try {
            File schemePath = this.getRelatedTypePath(relatedType);
            if (schemePath == null) {
                return;
            }
            File file = Paths.get(schemePath.getAbsolutePath(), relatedId, fileName).toFile();
            if (file.exists()) {
                file.delete();
            } else {
                log.error(file.getAbsolutePath() + " \u9644\u4ef6\u5df2\u4e0d\u5b58\u5728");
            }
        }
        catch (Exception e) {
            log.error(fileName + " \u9644\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
        }
    }

    private File getRelatedTypePath(String relatedType) {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.attachment_path)) {
            return null;
        }
        File rootPath = new File(this.attachment_path);
        return new File(rootPath, relatedType);
    }

    private File getAttachmentPath(String relatedType, String relatedId) {
        if (StringUtil.isEmptyOrWhiteSpace((String)this.attachment_path)) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u9644\u4ef6\u5b58\u50a8\u4f4d\u7f6e\uff01");
        }
        if (!FileUtil.isDirExsit((String)this.attachment_path).booleanValue()) {
            throw new RuntimeException("\u9644\u4ef6\u5b58\u50a8\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        File relatedPath = new File(this.getRelatedTypePath(relatedType), relatedId);
        if (!relatedPath.isDirectory() || !relatedPath.exists()) {
            relatedPath.mkdirs();
        }
        return relatedPath;
    }

    private AttachmentDTO convert(CmAttachment cmAttachment) {
        AttachmentDTO attachmentDTO = new AttachmentDTO();
        BeanUtils.copyProperties((Object)cmAttachment, (Object)attachmentDTO);
        attachmentDTO.setUrl(String.format("/attachment/view/%s/%s/%s", cmAttachment.getRelatedType(), cmAttachment.getRelatedId(), cmAttachment.getFileName()));
        return attachmentDTO;
    }
}

