/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.cache;

import com.geoway.adf.dms.config.cache.CustomKeyGenerator;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;

@EnableCaching
@AutoConfiguration
@ConditionalOnExpression(value="'${spring.cache.type:caffeine}'.equalsIgnoreCase('caffeine')")
@ConditionalOnClass(value={Caffeine.class, CaffeineCacheManager.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@EnableConfigurationProperties(value={CaffeineCacheProperties.class})
public class CaffeineCacheAutoConfig {
    @Bean(value={"customKeyGenerator"})
    @ConditionalOnMissingBean(value={CustomKeyGenerator.class})
    public CustomKeyGenerator customKeyGenerator() {
        return new CustomKeyGenerator();
    }

    @Bean(value={"caffeineCacheManager"})
    public CacheManager cacheManager(CaffeineCacheProperties caffeineCacheProperties) {
        CaffeineCacheManager cacheManager = new CaffeineCacheManager();
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(caffeineCacheProperties.getInitCacheCapacity().intValue()).maximumSize(caffeineCacheProperties.getMaxCacheCapacity().longValue());
        if (caffeineCacheProperties.getExpireHour() > 0) {
            caffeine.expireAfterWrite((long)caffeineCacheProperties.getExpireHour().intValue(), TimeUnit.HOURS);
        }
        cacheManager.setCaffeine(caffeine);
        return cacheManager;
    }

    @ConfigurationProperties(prefix="spring.cache.caffeine")
    public static class CaffeineCacheProperties {
        private Integer initCacheCapacity = 256;
        private Long maxCacheCapacity = 10000L;
        private Integer expireHour = -1;

        public Integer getInitCacheCapacity() {
            return this.initCacheCapacity;
        }

        public Long getMaxCacheCapacity() {
            return this.maxCacheCapacity;
        }

        public Integer getExpireHour() {
            return this.expireHour;
        }

        public void setInitCacheCapacity(Integer initCacheCapacity) {
            this.initCacheCapacity = initCacheCapacity;
        }

        public void setMaxCacheCapacity(Long maxCacheCapacity) {
            this.maxCacheCapacity = maxCacheCapacity;
        }

        public void setExpireHour(Integer expireHour) {
            this.expireHour = expireHour;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CaffeineCacheProperties)) {
                return false;
            }
            CaffeineCacheProperties other = (CaffeineCacheProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$initCacheCapacity = this.getInitCacheCapacity();
            Integer other$initCacheCapacity = other.getInitCacheCapacity();
            if (this$initCacheCapacity == null ? other$initCacheCapacity != null : !((Object)this$initCacheCapacity).equals(other$initCacheCapacity)) {
                return false;
            }
            Long this$maxCacheCapacity = this.getMaxCacheCapacity();
            Long other$maxCacheCapacity = other.getMaxCacheCapacity();
            if (this$maxCacheCapacity == null ? other$maxCacheCapacity != null : !((Object)this$maxCacheCapacity).equals(other$maxCacheCapacity)) {
                return false;
            }
            Integer this$expireHour = this.getExpireHour();
            Integer other$expireHour = other.getExpireHour();
            return !(this$expireHour == null ? other$expireHour != null : !((Object)this$expireHour).equals(other$expireHour));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CaffeineCacheProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $initCacheCapacity = this.getInitCacheCapacity();
            result = result * 59 + ($initCacheCapacity == null ? 43 : ((Object)$initCacheCapacity).hashCode());
            Long $maxCacheCapacity = this.getMaxCacheCapacity();
            result = result * 59 + ($maxCacheCapacity == null ? 43 : ((Object)$maxCacheCapacity).hashCode());
            Integer $expireHour = this.getExpireHour();
            result = result * 59 + ($expireHour == null ? 43 : ((Object)$expireHour).hashCode());
            return result;
        }

        public String toString() {
            return "CaffeineCacheAutoConfig.CaffeineCacheProperties(initCacheCapacity=" + this.getInitCacheCapacity() + ", maxCacheCapacity=" + this.getMaxCacheCapacity() + ", expireHour=" + this.getExpireHour() + ")";
        }
    }
}

