/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.filemodel;

import com.geoway.adf.dms.config.filemodel.DataCompactPackage;
import com.geoway.adf.dms.config.filemodel.DataFile;
import com.geoway.adf.dms.config.filemodel.DataFolder;
import com.geoway.adf.dms.config.filemodel.DataPackage;
import com.geoway.adf.dms.config.filemodel.DatumModelDataObject;
import com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum;
import java.util.ArrayList;
import java.util.List;

public class ScanModelParam {
    private DataPackage model;
    private FileModelNodeTypeEnum keyObjType;
    private DataFile keyFile;
    private DataFolder keyFolder;
    private DataCompactPackage keyCompactPackage;
    private DataPackage keyPackage;
    private DatumModelDataObject keyObj;
    private List<DataFolder> parentFoldersOfKeyObj;
    private Boolean enableNecessary;
    private Boolean needScanInvalid;

    public ScanModelParam(DataPackage model) {
        this.model = model;
        this.model.setDepth(0);
        this.setChildObjDepth(this.model);
        this.keyObj = this.model.getDataKeyObject();
        if (this.keyObj == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u4e3b\u6570\u636e\u6807\u8bc6");
        }
        this.keyObjType = FileModelNodeTypeEnum.getByValue(this.keyObj.getNodeType());
        switch (this.keyObjType) {
            case DataFile: {
                this.keyFile = (DataFile)this.keyObj;
                break;
            }
            case CompactPackage: {
                this.keyCompactPackage = (DataCompactPackage)this.keyObj;
                break;
            }
            case DataFolder: {
                this.keyFolder = (DataFolder)this.keyObj;
                break;
            }
            case DataPackage: {
                this.keyPackage = (DataPackage)this.keyObj;
                break;
            }
        }
        this.parentFoldersOfKeyObj = new ArrayList<DataFolder>();
        this.enableNecessary = true;
        this.needScanInvalid = false;
        DatumModelDataObject tempObj = this.keyObj;
        while (tempObj.getParentObject() != null && tempObj.getParentObject().getNodeType() == 1) {
            tempObj = tempObj.getParentObject();
            this.parentFoldersOfKeyObj.add((DataFolder)tempObj);
        }
    }

    private void setChildObjDepth(DatumModelDataObject obj) {
        for (DatumModelDataObject item : obj.getChildren()) {
            item.setDepth(obj.getDepth() + 1);
            if (item.getChildren().size() <= 0) continue;
            this.setChildObjDepth(item);
        }
    }

    public DataPackage getModel() {
        return this.model;
    }

    public FileModelNodeTypeEnum getKeyObjType() {
        return this.keyObjType;
    }

    public DataFile getKeyFile() {
        return this.keyFile;
    }

    public DataFolder getKeyFolder() {
        return this.keyFolder;
    }

    public DataCompactPackage getKeyCompactPackage() {
        return this.keyCompactPackage;
    }

    public DataPackage getKeyPackage() {
        return this.keyPackage;
    }

    public DatumModelDataObject getKeyObj() {
        return this.keyObj;
    }

    public List<DataFolder> getParentFoldersOfKeyObj() {
        return this.parentFoldersOfKeyObj;
    }

    public Boolean getEnableNecessary() {
        return this.enableNecessary;
    }

    public Boolean getNeedScanInvalid() {
        return this.needScanInvalid;
    }

    public void setModel(DataPackage model) {
        this.model = model;
    }

    public void setKeyObjType(FileModelNodeTypeEnum keyObjType) {
        this.keyObjType = keyObjType;
    }

    public void setKeyFile(DataFile keyFile) {
        this.keyFile = keyFile;
    }

    public void setKeyFolder(DataFolder keyFolder) {
        this.keyFolder = keyFolder;
    }

    public void setKeyCompactPackage(DataCompactPackage keyCompactPackage) {
        this.keyCompactPackage = keyCompactPackage;
    }

    public void setKeyPackage(DataPackage keyPackage) {
        this.keyPackage = keyPackage;
    }

    public void setKeyObj(DatumModelDataObject keyObj) {
        this.keyObj = keyObj;
    }

    public void setParentFoldersOfKeyObj(List<DataFolder> parentFoldersOfKeyObj) {
        this.parentFoldersOfKeyObj = parentFoldersOfKeyObj;
    }

    public void setEnableNecessary(Boolean enableNecessary) {
        this.enableNecessary = enableNecessary;
    }

    public void setNeedScanInvalid(Boolean needScanInvalid) {
        this.needScanInvalid = needScanInvalid;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScanModelParam)) {
            return false;
        }
        ScanModelParam other = (ScanModelParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableNecessary = this.getEnableNecessary();
        Boolean other$enableNecessary = other.getEnableNecessary();
        if (this$enableNecessary == null ? other$enableNecessary != null : !((Object)this$enableNecessary).equals(other$enableNecessary)) {
            return false;
        }
        Boolean this$needScanInvalid = this.getNeedScanInvalid();
        Boolean other$needScanInvalid = other.getNeedScanInvalid();
        if (this$needScanInvalid == null ? other$needScanInvalid != null : !((Object)this$needScanInvalid).equals(other$needScanInvalid)) {
            return false;
        }
        DataPackage this$model = this.getModel();
        DataPackage other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
            return false;
        }
        FileModelNodeTypeEnum this$keyObjType = this.getKeyObjType();
        FileModelNodeTypeEnum other$keyObjType = other.getKeyObjType();
        if (this$keyObjType == null ? other$keyObjType != null : !((Object)((Object)this$keyObjType)).equals((Object)other$keyObjType)) {
            return false;
        }
        DataFile this$keyFile = this.getKeyFile();
        DataFile other$keyFile = other.getKeyFile();
        if (this$keyFile == null ? other$keyFile != null : !((Object)this$keyFile).equals(other$keyFile)) {
            return false;
        }
        DataFolder this$keyFolder = this.getKeyFolder();
        DataFolder other$keyFolder = other.getKeyFolder();
        if (this$keyFolder == null ? other$keyFolder != null : !((Object)this$keyFolder).equals(other$keyFolder)) {
            return false;
        }
        DataCompactPackage this$keyCompactPackage = this.getKeyCompactPackage();
        DataCompactPackage other$keyCompactPackage = other.getKeyCompactPackage();
        if (this$keyCompactPackage == null ? other$keyCompactPackage != null : !((Object)this$keyCompactPackage).equals(other$keyCompactPackage)) {
            return false;
        }
        DataPackage this$keyPackage = this.getKeyPackage();
        DataPackage other$keyPackage = other.getKeyPackage();
        if (this$keyPackage == null ? other$keyPackage != null : !((Object)this$keyPackage).equals(other$keyPackage)) {
            return false;
        }
        DatumModelDataObject this$keyObj = this.getKeyObj();
        DatumModelDataObject other$keyObj = other.getKeyObj();
        if (this$keyObj == null ? other$keyObj != null : !((Object)this$keyObj).equals(other$keyObj)) {
            return false;
        }
        List<DataFolder> this$parentFoldersOfKeyObj = this.getParentFoldersOfKeyObj();
        List<DataFolder> other$parentFoldersOfKeyObj = other.getParentFoldersOfKeyObj();
        return !(this$parentFoldersOfKeyObj == null ? other$parentFoldersOfKeyObj != null : !((Object)this$parentFoldersOfKeyObj).equals(other$parentFoldersOfKeyObj));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScanModelParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableNecessary = this.getEnableNecessary();
        result = result * 59 + ($enableNecessary == null ? 43 : ((Object)$enableNecessary).hashCode());
        Boolean $needScanInvalid = this.getNeedScanInvalid();
        result = result * 59 + ($needScanInvalid == null ? 43 : ((Object)$needScanInvalid).hashCode());
        DataPackage $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        FileModelNodeTypeEnum $keyObjType = this.getKeyObjType();
        result = result * 59 + ($keyObjType == null ? 43 : ((Object)((Object)$keyObjType)).hashCode());
        DataFile $keyFile = this.getKeyFile();
        result = result * 59 + ($keyFile == null ? 43 : ((Object)$keyFile).hashCode());
        DataFolder $keyFolder = this.getKeyFolder();
        result = result * 59 + ($keyFolder == null ? 43 : ((Object)$keyFolder).hashCode());
        DataCompactPackage $keyCompactPackage = this.getKeyCompactPackage();
        result = result * 59 + ($keyCompactPackage == null ? 43 : ((Object)$keyCompactPackage).hashCode());
        DataPackage $keyPackage = this.getKeyPackage();
        result = result * 59 + ($keyPackage == null ? 43 : ((Object)$keyPackage).hashCode());
        DatumModelDataObject $keyObj = this.getKeyObj();
        result = result * 59 + ($keyObj == null ? 43 : ((Object)$keyObj).hashCode());
        List<DataFolder> $parentFoldersOfKeyObj = this.getParentFoldersOfKeyObj();
        result = result * 59 + ($parentFoldersOfKeyObj == null ? 43 : ((Object)$parentFoldersOfKeyObj).hashCode());
        return result;
    }

    public String toString() {
        return "ScanModelParam(model=" + this.getModel() + ", keyObjType=" + (Object)((Object)this.getKeyObjType()) + ", keyFile=" + this.getKeyFile() + ", keyFolder=" + this.getKeyFolder() + ", keyCompactPackage=" + this.getKeyCompactPackage() + ", keyPackage=" + this.getKeyPackage() + ", keyObj=" + this.getKeyObj() + ", parentFoldersOfKeyObj=" + this.getParentFoldersOfKeyObj() + ", enableNecessary=" + this.getEnableNecessary() + ", needScanInvalid=" + this.getNeedScanInvalid() + ")";
    }
}

