/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.component;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class LoginUserHelper {
    @Resource
    private UserRightProperties userRightProperties;
    @Resource
    private LoginUserService loginUserService;

    public LoginUserInfo getCurrentUser(HttpServletRequest request) {
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        if (userInfo == null) {
            userInfo = this.loginUserService.getUserInfo(request);
        }
        return userInfo;
    }

    public boolean isAdmin(LoginUserInfo userInfo) {
        if (Boolean.TRUE.equals(this.userRightProperties.getTenantEnabled())) {
            return Boolean.TRUE.equals(userInfo.getTenantAdmin());
        }
        return this.isSystemAdmin(userInfo);
    }

    public boolean isSystemAdmin(LoginUserInfo userInfo) {
        if (userInfo.getRoleId() == null) {
            return false;
        }
        List<String> roleIdList = Arrays.asList(userInfo.getRoleId().split(","));
        if (this.userRightProperties.getAdminRoleId() != null) {
            String[] adminRoleIdList;
            for (String adminRoleId : adminRoleIdList = this.userRightProperties.getAdminRoleId().split(",")) {
                if (!roleIdList.contains(adminRoleId)) continue;
                return true;
            }
        }
        return false;
    }
}

