/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.config.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dao.DmGeoTemplateDao;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDatasetDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateFieldDTO;
import com.geoway.adf.dms.config.entity.DmGeoTemplate;
import com.geoway.adf.dms.config.service.GeoTemplateService;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IFields;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GeoTemplateServiceImpl
implements GeoTemplateService {
    private static final Logger log = LoggerFactory.getLogger(GeoTemplateServiceImpl.class);
    @Resource
    private DmGeoTemplateDao dmGeoTemplateDao;

    @Override
    public List<GeoTemplateDTO> listTemplate(String keyword) {
        return this.listTemplate(keyword, null);
    }

    @Override
    public List<GeoTemplateDTO> listTemplate(String keyword, String category) {
        List<DmGeoTemplate> list = this.dmGeoTemplateDao.selectAll(null, category);
        ArrayList<GeoTemplateDTO> templateDTOS = new ArrayList<GeoTemplateDTO>();
        for (DmGeoTemplate t : list) {
            GeoTemplateDTO templateDTO = this.convert(t);
            if (StringUtil.isEmptyOrWhiteSpace((String)keyword)) {
                templateDTOS.add(templateDTO);
                continue;
            }
            if (templateDTO.getName().contains(keyword)) {
                templateDTOS.add(templateDTO);
                continue;
            }
            List datasetList = ListUtil.findAll(templateDTO.getDatasets(), f -> {
                if (f.getName() != null && f.getName().contains(keyword)) {
                    return true;
                }
                return f.getAliasName() != null && f.getAliasName().contains(keyword);
            });
            if (datasetList == null || datasetList.size() <= 0) continue;
            templateDTO.setDatasets(datasetList);
            templateDTOS.add(templateDTO);
        }
        return templateDTOS;
    }

    @Override
    public GeoTemplateDTO getGeoTemplate(String id, String code) {
        DmGeoTemplate dmGeoTemplate = StringUtil.isNotEmpty((String)id) ? this.dmGeoTemplateDao.selectByPrimaryKey(id) : this.dmGeoTemplateDao.selectByCode(code);
        Assert.notNull((Object)dmGeoTemplate, (String)"\u6570\u636e\u6a21\u677f\u4e0d\u5b58\u5728");
        GeoTemplateDTO templateDTO = this.convert(dmGeoTemplate);
        return templateDTO;
    }

    @Override
    public String saveGeoTemplate(GeoTemplateDTO template) {
        if (StringUtil.isEmpty((String)template.getName())) {
            throw new RuntimeException("\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (template.getId() == null || template.getId().length() == 0) {
            if (this.dmGeoTemplateDao.selectByName(template.getName()) != null) {
                throw new RuntimeException("\u6a21\u677f\u540d\u79f0[" + template.getName() + "]\u5df2\u5b58\u5728");
            }
            if (this.dmGeoTemplateDao.selectByCode(template.getCode()) != null) {
                throw new RuntimeException("\u6a21\u677f\u7f16\u7801[" + template.getCode() + "]\u5df2\u5b58\u5728");
            }
            DmGeoTemplate dmGeoTemplate = new DmGeoTemplate();
            dmGeoTemplate.setId(UUID.randomUUID().toString());
            dmGeoTemplate.setCode(template.getCode());
            dmGeoTemplate.setName(template.getName());
            dmGeoTemplate.setCategory(template.getCategory());
            if (template.getDatasets() != null) {
                template.getDatasets().forEach(d -> d.setTemplateId(dmGeoTemplate.getId()));
                dmGeoTemplate.setDatasets(JSONArray.toJSONString(template.getDatasets()));
            }
            this.dmGeoTemplateDao.insertSelective(dmGeoTemplate);
            return dmGeoTemplate.getId();
        }
        DmGeoTemplate temp1 = this.dmGeoTemplateDao.selectByName(template.getName());
        if (temp1 != null && !temp1.getId().equals(template.getId())) {
            throw new RuntimeException("\u6a21\u677f\u540d\u79f0[" + template.getName() + "]\u5df2\u5b58\u5728");
        }
        DmGeoTemplate temp2 = this.dmGeoTemplateDao.selectByCode(template.getCode());
        if (temp2 != null && !temp2.getId().equals(template.getId())) {
            throw new RuntimeException("\u6a21\u677f\u7f16\u7801[" + template.getCode() + "]\u5df2\u5b58\u5728");
        }
        DmGeoTemplate dmGeoTemplate = new DmGeoTemplate();
        dmGeoTemplate.setId(template.getId());
        dmGeoTemplate.setCode(template.getCode());
        dmGeoTemplate.setName(template.getName());
        if (template.getDatasets() != null) {
            template.getDatasets().forEach(d -> d.setTemplateId(dmGeoTemplate.getId()));
            dmGeoTemplate.setDatasets(JSONArray.toJSONString(template.getDatasets()));
        }
        this.dmGeoTemplateDao.updateByPrimaryKeySelective(dmGeoTemplate);
        return dmGeoTemplate.getId();
    }

    @Override
    public void deleteGeoTemplate(String id) {
        this.dmGeoTemplateDao.deleteByPrimaryKey(id);
    }

    @Override
    public void saveDataset(GeoTemplateDatasetDTO templateDataset) {
        GeoTemplateDTO templateDTO = this.getGeoTemplate(templateDataset.getTemplateId(), null);
        if (StringUtil.isEmptyOrWhiteSpace((String)templateDataset.getId())) {
            templateDataset.setId(templateDTO.getCode() + "_" + templateDataset.getName());
            if (templateDTO.getDatasets() == null) {
                ArrayList<GeoTemplateDatasetDTO> datasetDTOS = new ArrayList<GeoTemplateDatasetDTO>();
                datasetDTOS.add(templateDataset);
                templateDTO.setDatasets(datasetDTOS);
            } else {
                if (ListUtil.exist(templateDTO.getDatasets(), d -> d.getName().equalsIgnoreCase(templateDataset.getName()))) {
                    throw new RuntimeException(templateDataset.getName() + "\u56fe\u5c42\u5df2\u5b58\u5728");
                }
                templateDTO.getDatasets().add(templateDataset);
            }
        } else {
            if (templateDTO.getDatasets() == null) {
                throw new RuntimeException(templateDataset.getName() + "\u56fe\u5c42\u4e0d\u5b58\u5728");
            }
            GeoTemplateDatasetDTO oldDataset = (GeoTemplateDatasetDTO)ListUtil.find(templateDTO.getDatasets(), d -> templateDataset.getId().equals(d.getId()));
            if (oldDataset != null) {
                BeanUtils.copyProperties((Object)templateDataset, (Object)oldDataset);
            } else {
                throw new RuntimeException(templateDataset.getName() + "\u56fe\u5c42\u4e0d\u5b58\u5728");
            }
        }
        this.saveGeoTemplate(templateDTO);
    }

    @Override
    public void deleteDataset(String templateId, String datasetName) {
        GeoTemplateDTO templateDTO = this.getGeoTemplate(templateId, null);
        GeoTemplateDatasetDTO dataset = (GeoTemplateDatasetDTO)ListUtil.find(templateDTO.getDatasets(), d -> d.getName().equals(datasetName));
        if (dataset == null) {
            throw new RuntimeException(datasetName + "\u56fe\u5c42\u4e0d\u5b58\u5728");
        }
        templateDTO.getDatasets().remove(dataset);
        this.saveGeoTemplate(templateDTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportGeoTemplate(String id) {
        GeoTemplateDTO templateDTO = this.getGeoTemplate(id, null);
        File outputPath = Paths.get(OutputPathConfig.getOutputPath().toString(), "geoTemplate-" + UUID.randomUUID()).toFile();
        outputPath.mkdirs();
        File filegdb = new File(outputPath, templateDTO.getName() + ".gdb");
        try (IFeatureWorkspace workspace = WorkspaceUtil.createLocalFileGeodatabase((String)filegdb.getAbsolutePath());){
            for (GeoTemplateDatasetDTO templateDatasetDTO : templateDTO.getDatasets()) {
                ArrayList<Object> fields = new ArrayList<Object>();
                Field oidFld = new Field();
                oidFld.setName("objectid");
                oidFld.setAliasName("objectid");
                oidFld.setFieldType(FieldType.OID);
                fields.add(oidFld);
                FeatureType featureType = FeatureType.getByValue((Integer)templateDatasetDTO.getType());
                GeometryType geometryType = GeometryType.Unknown;
                switch (featureType) {
                    case Point: {
                        geometryType = GeometryType.Point;
                        break;
                    }
                    case Polyline: {
                        geometryType = GeometryType.Polyline;
                        break;
                    }
                    case Polygon: {
                        geometryType = GeometryType.MultiPolygon;
                        break;
                    }
                }
                GeometryField geoField = null;
                if (featureType != FeatureType.Unknown) {
                    geoField = new GeometryField();
                    geoField.setSpatialReferenceSystem(SpatialReferenceSystemFunc.createSpatialReference((int)4490));
                    geoField.setName("Shape");
                    geoField.setAliasName("Shape");
                    geoField.setFieldType(FieldType.Shape);
                    geoField.setGeometryType(geometryType);
                    fields.add(geoField);
                }
                for (GeoTemplateFieldDTO templateFieldDTO : templateDatasetDTO.getFields()) {
                    Field sFld = new Field();
                    sFld.setName(templateFieldDTO.getName().trim());
                    sFld.setAliasName(StringUtil.isEmpty((String)templateFieldDTO.getAliasName()) ? templateFieldDTO.getName() : templateFieldDTO.getAliasName());
                    sFld.setFieldType(FieldType.getByValue((Integer)templateFieldDTO.getFieldType()));
                    sFld.setNullable(Boolean.valueOf(templateFieldDTO.getNullable() != null && templateFieldDTO.getNullable() != false));
                    sFld.setDefaultValue((Object)templateFieldDTO.getDefaultValue());
                    sFld.setLength(templateFieldDTO.getLength());
                    sFld.setScale(templateFieldDTO.getScale());
                    fields.add(sFld);
                }
                if (featureType != FeatureType.Unknown) {
                    IFeatureClass featureClass = workspace.createFeatureClass(templateDatasetDTO.getName(), (IFields)new Fields(fields), featureType, geoField.getName(), null);
                    if (featureClass == null) continue;
                    featureClass.createSpatialIndex();
                    continue;
                }
                workspace.createTable(templateDatasetDTO.getName(), (IFields)new Fields(fields));
            }
        }
        DownloadUtil.downloadZipFile(Arrays.asList(filegdb), (String)filegdb.getParent(), (String)(templateDTO.getName() + ".zip"));
    }

    private GeoTemplateDTO convert(DmGeoTemplate dmGeoTemplate) {
        GeoTemplateDTO templateDTO = new GeoTemplateDTO();
        templateDTO.setId(dmGeoTemplate.getId());
        templateDTO.setCode(dmGeoTemplate.getCode());
        templateDTO.setName(dmGeoTemplate.getName());
        templateDTO.setCategory(dmGeoTemplate.getCategory());
        List<GeoTemplateDatasetDTO> datasetDTOS = new ArrayList<GeoTemplateDatasetDTO>();
        try {
            if (StringUtil.isNotEmpty((String)dmGeoTemplate.getDatasets())) {
                datasetDTOS = JSONArray.parseArray((String)dmGeoTemplate.getDatasets(), GeoTemplateDatasetDTO.class);
                datasetDTOS.forEach(d -> d.setId(templateDTO.getCode() + "_" + d.getName()));
                datasetDTOS.sort(Comparator.comparing(GeoTemplateDatasetDTO::getName));
            }
        }
        catch (Exception e) {
            log.error(dmGeoTemplate.getName() + "\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        templateDTO.setDatasets(datasetDTOS);
        return templateDTO;
    }
}

