/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.config.OutputPathConfig;
import com.geoway.adf.dms.common.dto.TransferResult;
import com.geoway.adf.dms.common.gis.VectorDataTransfer;
import com.geoway.adf.dms.common.gis.WorkspaceUtil;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.util.ZipAndRarUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.input.ExcuteStatus;
import com.geoway.adf.dms.datasource.dto.output.OutputDataResultDTO;
import com.geoway.adf.dms.datasource.dto.output.OutputParams;
import com.geoway.adf.dms.datasource.service.DataOutputService;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DataOutputServiceImpl
implements DataOutputService {
    private static final Logger log = LoggerFactory.getLogger(DataOutputServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutorData;
    private static Map<String, OutputDataResultDTO> runningTasks = new ConcurrentHashMap<String, OutputDataResultDTO>();

    @Override
    public void downloadVectorData(OutputParams outputParams) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(outputParams.getSrcDatasetId());
        String srcName = datasetNameInfo.getShortName();
        if (StringUtil.isEmptyOrWhiteSpace((String)outputParams.getTargetName())) {
            outputParams.setTargetName(srcName);
        }
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            localPath.toFile().mkdirs();
        }
        OutputDataResultDTO dataResultDTO = new OutputDataResultDTO();
        dataResultDTO.setSrcName(srcName);
        dataResultDTO.setTargetName(outputParams.getTargetName());
        dataResultDTO.setStatus(ExcuteStatus.NotStarted);
        dataResultDTO.setOutputPath(localPath.toString());
        this.exportVectorData(dataResultDTO, localPath.toString(), outputParams);
        if (dataResultDTO.getStatus() != ExcuteStatus.Successed) {
            throw new RuntimeException(dataResultDTO.getMessage());
        }
        DownloadUtil.downloadFile((String)(localPath.resolve(outputParams.getTargetName()) + ".zip"));
    }

    @Override
    public String exportVectorDataAsync(OutputParams outputParams) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(outputParams.getSrcDatasetId());
        String srcName = datasetNameInfo.getShortName();
        if (StringUtil.isEmptyOrWhiteSpace((String)outputParams.getTargetName())) {
            outputParams.setTargetName(srcName);
        }
        String id = UUID.randomUUID().toString();
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        if (!localPath.toFile().exists()) {
            localPath.toFile().mkdirs();
        }
        OutputDataResultDTO dataResultDTO = new OutputDataResultDTO();
        dataResultDTO.setSrcName(srcName);
        dataResultDTO.setTargetName(outputParams.getTargetName());
        dataResultDTO.setStatus(ExcuteStatus.NotStarted);
        dataResultDTO.setOutputPath(localPath.toString());
        LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
        this.threadPoolTaskExecutorData.execute(() -> {
            if (userInfo != null) {
                ThreadLocalUtil.addCurrentUser((LoginUserInfo)userInfo);
            }
            this.exportVectorData(dataResultDTO, localPath.toString(), outputParams);
            if (userInfo != null) {
                ThreadLocalUtil.removeUser();
            }
        });
        runningTasks.put(id, dataResultDTO);
        return id;
    }

    @Override
    public OutputDataResultDTO getExportResult(String id) {
        if (runningTasks.containsKey(id)) {
            return runningTasks.get(id);
        }
        throw new RuntimeException("\u4e0d\u5b58\u5728\u6b63\u5728\u6267\u884c\u7684\u5bfc\u51fa\u4efb\u52a1");
    }

    @Override
    public void downloadExportData(String id) {
        OutputDataResultDTO dataResultDTO = this.getExportResult(id);
        if (dataResultDTO.getStatus() != ExcuteStatus.Successed) {
            throw new RuntimeException(dataResultDTO.getMessage());
        }
        Path localPath = OutputPathConfig.getOutputPath().resolve(id);
        DownloadUtil.downloadFile((String)(localPath.resolve(dataResultDTO.getTargetName()) + ".zip"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportVectorData(OutputDataResultDTO resultDTO, String resultPath, OutputParams outputParams) {
        block26: {
            IFeatureWorkspace srcWorkspace = null;
            IFeatureWorkspace targetWorkspace = null;
            try {
                resultDTO.setStatus(ExcuteStatus.Running);
                DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(outputParams.getSrcDatasetId());
                String dsKey = datasetNameInfo.getDsKey();
                DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
                String name = datasetNameInfo.getName();
                DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(dsKey);
                if (dataSourceDTO.getDataStoreType().intValue() == DataStoreTypeEnum.GeoDatabase.getValue()) {
                    QueryFilter queryFilter;
                    srcWorkspace = this.geoDatabaseService.openGeoWorkspace(dsKey);
                    GeoDatasetType geoDatasetType = GeoDatasetUtil.convertDatasetType(datasetType);
                    IGeoDataset srcDataset = GeoDatasetUtil.openDataset(srcWorkspace, geoDatasetType, name);
                    Assert.notNull((Object)srcDataset, (String)(name + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    boolean isFeature = srcDataset instanceof IFeatureClass;
                    Path localPath = Paths.get(resultPath, new String[0]);
                    String targetName = outputParams.getTargetName();
                    String targetFile = localPath.resolve(targetName).toString();
                    switch (outputParams.getFormat()) {
                        case GeoPackage: {
                            targetFile = targetFile + ".gpkg";
                            break;
                        }
                        case FileGDB: {
                            targetFile = targetFile + ".gdb";
                            break;
                        }
                        case MDB: {
                            targetFile = targetFile + ".mdb";
                            isFeature = false;
                            break;
                        }
                        case Shapefile: {
                            break;
                        }
                        case GeoJSON: {
                            targetFile = targetFile + ".geojson";
                            break;
                        }
                        case GML: {
                            targetFile = targetFile + ".gml";
                            break;
                        }
                        case KML: {
                            targetFile = targetFile + ".kml";
                            break;
                        }
                        case Excel: {
                            targetFile = targetFile + ".xlsx";
                            isFeature = false;
                            break;
                        }
                        case Csv: {
                            targetFile = targetFile + ".csv";
                            isFeature = false;
                            break;
                        }
                        case Dbf: {
                            targetFile = targetFile + ".dbf";
                            isFeature = false;
                            break;
                        }
                        default: {
                            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff1a" + (Object)((Object)outputParams.getFormat()));
                        }
                    }
                    if (!localPath.toFile().exists()) {
                        localPath.toFile().mkdir();
                    }
                    targetWorkspace = WorkspaceUtil.createLocalFileGeodatabase((String)targetFile);
                    ITable targetDataset = this.createDataset((ITable)srcDataset, isFeature, targetWorkspace, targetName, outputParams.getFields(), outputParams.getTargetSrid());
                    Assert.notNull((Object)targetDataset, (String)(targetName + "\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25\uff01"));
                    if (isFeature && !StringUtil.isEmptyOrWhiteSpace((String)outputParams.getGeometry())) {
                        SpatialQueryFilter spatailFilter = new SpatialQueryFilter();
                        IGeometry queryGeometry = GeometryFunc.createGeometry((String)outputParams.getGeometry());
                        spatailFilter.setGeometry(queryGeometry);
                        spatailFilter.setSpatialRel(outputParams.getRelation());
                        queryFilter = spatailFilter;
                    } else {
                        queryFilter = new QueryFilter();
                    }
                    queryFilter.setWhereClause(outputParams.getCondition());
                    this.exportVectorData(resultDTO, srcDataset, (IGeoDataset)targetDataset, (IQueryFilter)queryFilter);
                    if (srcWorkspace != null) {
                        srcWorkspace.close();
                    }
                    if (targetWorkspace != null) {
                        targetWorkspace.close();
                    }
                    if (resultDTO.getStatus() == ExcuteStatus.Successed) {
                        String zipFile = localPath.resolve(targetName + ".zip").toString();
                        ZipAndRarUtil.toZip((String)targetFile, (String)zipFile, (boolean)true);
                    }
                    break block26;
                }
                resultDTO.setStatus(ExcuteStatus.Failed);
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b");
            }
            catch (Exception ex) {
                log.error("\u6570\u636e\u5bfc\u51fa\u5f02\u5e38", (Throwable)ex);
                resultDTO.setStatus(ExcuteStatus.Failed);
                resultDTO.setMessage("\u6570\u636e\u5bfc\u51fa\u5f02\u5e38\uff0c" + ex.getMessage());
            }
            finally {
                if (srcWorkspace != null) {
                    srcWorkspace.close();
                }
                if (targetWorkspace != null) {
                    targetWorkspace.close();
                }
            }
        }
    }

    private ITable createDataset(ITable srcDataset, boolean isFeature, IFeatureWorkspace tarWorkspace, String tarFCName, String fields, Integer srid) {
        isFeature = isFeature && srcDataset instanceof IFeatureClass;
        Fields newFields = new Fields();
        for (int i = 0; i < srcDataset.getFields().getFieldCount(); ++i) {
            IField tempField = srcDataset.getFields().getField(i).clone();
            if (tempField.getFieldType() == FieldType.OID) {
                newFields.addField(tempField);
                continue;
            }
            if (tempField.getFieldType() == FieldType.Shape) {
                if (!isFeature) continue;
                if (srid != null && srid > 0) {
                    ISpatialReferenceSystem tarSR = SpatialReferenceSystemFunc.createSpatialReference((int)srid);
                    if (tarSR == null) {
                        tarSR = ((IFeatureClass)srcDataset).getSpatialReferenceSystem();
                    }
                    GeometryField geometryField = (GeometryField)tempField;
                    geometryField.setSpatialReferenceSystem(tarSR);
                    if (geometryField.getGeometryType() == GeometryType.Unknown) {
                        geometryField.setGeometryType(GeometryType.Polygon);
                    }
                }
                newFields.addField(tempField);
                continue;
            }
            if (StringUtil.isNotEmpty((String)fields)) {
                List<String> fieldList = Arrays.asList(fields.split(","));
                if (!ListUtil.exist(fieldList, f -> f.equalsIgnoreCase(tempField.getName())) || newFields.findFieldIndex(tempField.getName()) >= 0) continue;
                newFields.addField(tempField);
                continue;
            }
            if (newFields.findFieldIndex(tempField.getName()) >= 0) continue;
            newFields.addField(tempField);
        }
        if (isFeature) {
            IFeatureClass srcFc = (IFeatureClass)srcDataset;
            IFeatureClass iFeatClass = tarWorkspace.createFeatureClass(tarFCName, (IFields)newFields, srcFc.getFeatureType(), srcFc.getShapeFieldName(), srcFc.getSubTypeFieldName());
            if (iFeatClass != null) {
                iFeatClass.createSpatialIndex();
            }
            return (ITable)iFeatClass;
        }
        ITable iTable = tarWorkspace.createTable(tarFCName, (IFields)newFields);
        return iTable;
    }

    private void exportVectorData(OutputDataResultDTO resultDTO, IGeoDataset srcDataset, IGeoDataset targetGeoData, IQueryFilter filter) {
        TransferResult result;
        VectorDataTransfer vectorDataTransfer = new VectorDataTransfer();
        vectorDataTransfer.setIsErrorContinue(true);
        vectorDataTransfer.setProgressCallback((sCount, eCount) -> {
            resultDTO.setSuccessCount((Long)sCount);
            resultDTO.setErrorCount((Long)eCount);
        });
        vectorDataTransfer.setCountCallback(iCount -> resultDTO.setTotalCount((Long)iCount));
        vectorDataTransfer.setErrorCallback(msg -> {
            log.error(msg);
            resultDTO.setMessage((String)msg);
        });
        if (targetGeoData.getType() == GeoDatasetType.FeatureClass) {
            result = vectorDataTransfer.copyFeature((IFeatureClass)srcDataset, (IFeatureClass)targetGeoData, filter);
        } else if (targetGeoData.getType() == GeoDatasetType.Table) {
            result = vectorDataTransfer.copyTable((ITable)srcDataset, (ITable)targetGeoData, filter);
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + targetGeoData.getType());
        }
        resultDTO.setStatus(result.isSuccess() ? ExcuteStatus.Successed : ExcuteStatus.Failed);
    }
}

