/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseUrlDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatabaseCreateDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatabaseEditDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DatumDataSourceService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DatumDataSourceServiceImpl
implements DatumDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(DatumDataSourceServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;

    @Override
    public String createDatumDatabase(DatumDatabaseCreateDTO datumDatabaseCreateDTO) {
        DataSourceDTO dataSourceDTO = new DataSourceDTO();
        dataSourceDTO.setName(datumDatabaseCreateDTO.getName());
        dataSourceDTO.setDataStoreType(datumDatabaseCreateDTO.getDataStoreType() == null ? DataStoreTypeEnum.DatumDatabase.getValue() : datumDatabaseCreateDTO.getDataStoreType().intValue());
        dataSourceDTO.setDataSourceType(DataSourceTypeEnum.DatumDatabase.getValue());
        DatumDatabaseUrlDTO urlDTO = new DatumDatabaseUrlDTO();
        urlDTO.setGeoDatabaseKey(datumDatabaseCreateDTO.getGeoDatabaseKey());
        urlDTO.setFileStorageKeys(datumDatabaseCreateDTO.getFileStorageKeys());
        dataSourceDTO.setUrl(JSON.toJSONString((Object)urlDTO));
        return this.dataSourceService.addDataSource(dataSourceDTO);
    }

    @Override
    public void updateDatumDatabase(DatumDatabaseEditDTO datumDatabaseEditDTO) {
        DatumDatabaseDTO datumDatabaseDTO = (DatumDatabaseDTO)this.dataSourceService.getDataSourceDetail(datumDatabaseEditDTO.getKey());
        DataSourceDTO dataSourceDTO = new DataSourceDTO();
        dataSourceDTO.setKey(datumDatabaseDTO.getKey());
        dataSourceDTO.setDataStoreType(datumDatabaseDTO.getDataStoreType());
        dataSourceDTO.setDataSourceType(datumDatabaseDTO.getDataSourceType());
        if (datumDatabaseEditDTO.getName() != null) {
            dataSourceDTO.setName(datumDatabaseEditDTO.getName());
        } else {
            dataSourceDTO.setName(datumDatabaseDTO.getName());
        }
        DatumDatabaseUrlDTO urlDTO = (DatumDatabaseUrlDTO)JSON.parseObject((String)datumDatabaseDTO.getUrl(), DatumDatabaseUrlDTO.class);
        if (datumDatabaseEditDTO.getFileStorageKeys() != null) {
            urlDTO.setFileStorageKeys(datumDatabaseEditDTO.getFileStorageKeys());
        }
        dataSourceDTO.setUrl(JSON.toJSONString((Object)urlDTO));
        this.dataSourceService.updateDataSource(dataSourceDTO);
    }

    @Override
    public void deleteDatumDatabase(String key, Boolean deleteBizInfo) {
        List<SimpleDatasetDTO> datasets = this.dataSourceService.listDatasets(key);
        if (datasets != null && datasets.size() > 0) {
            throw new RuntimeException("\u8be5\u6587\u4ef6\u6570\u636e\u5e93\u4e0b\u5b58\u5728\u6570\u636e\u96c6\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.dataSourceService.deleteDataSource(key, deleteBizInfo);
    }
}

