/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatumDatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ModelDatasetTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsDatumDao;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.DatumDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.model.ModelDatasetDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.model.create.ModelDatasetEditDTO;
import com.geoway.adf.dms.datasource.entity.DsDatum;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.ModelDatabaseService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ModelDatabaseServiceImpl
implements ModelDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(ModelDatabaseServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private DsDatumDao datumDao;

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        return this.datumDatabaseService.testConnect(dataSourceDTO);
    }

    @Override
    public List<DatumDatabaseDTO> listModelDatabase(String keyword) {
        ArrayList<DataStoreTypeEnum> dataStoreTypes = new ArrayList<DataStoreTypeEnum>();
        dataStoreTypes.add(DataStoreTypeEnum.ModelDatabase);
        ArrayList<DataSourceTypeEnum> dataSourceTypes = new ArrayList<DataSourceTypeEnum>();
        dataSourceTypes.add(DataSourceTypeEnum.DatumDatabase);
        List<DataSourceDTO> list = this.dataSourceManager.listDataSource(dataStoreTypes, dataSourceTypes, keyword);
        List result = ListUtil.convertAll(list, f -> (DatumDatabaseDTO)f);
        return result;
    }

    @Override
    public DatumDatabaseDTO getModelDatabaseDetailWithOutPassWord(String key) {
        return (DatumDatabaseDTO)this.dataSourceManager.getDataSourceWithoutPassword(key);
    }

    @Override
    public DatasetPageList<SimpleDatasetDTO> listModelDataset(String dsKey, List<ModelDatasetTypeEnum> modelTypes, String keyword, Integer pageIndex, Integer rows) {
        List dsDatumList = this.datumDao.selectByDsKey(dsKey);
        if (modelTypes != null && modelTypes.size() > 0) {
            dsDatumList = ListUtil.findAll(dsDatumList, dsDatum -> modelTypes.contains((Object)ModelDatasetTypeEnum.getByValue(dsDatum.getModelType())));
        }
        if (StringUtil.isNotEmpty((String)keyword)) {
            dsDatumList = ListUtil.findAll(dsDatumList, dsDatum -> dsDatum.getName().toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)) || dsDatum.getAliasName().toLowerCase(Locale.ROOT).contains(keyword.toLowerCase(Locale.ROOT)));
        }
        HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>(0);
        for (ModelDatasetTypeEnum modelDatasetType : ModelDatasetTypeEnum.values()) {
            typeCount.put(modelDatasetType.getValue(), 0);
        }
        List result = ListUtil.convertAll((List)dsDatumList, this::convertSimpleDatasetDTO);
        this.dataSourceManager.fillSimpleDatasetMeta(dsKey, result);
        for (SimpleDatasetDTO simpleDatasetDTO : result) {
            typeCount.put(simpleDatasetDTO.getModelType() == null ? 0 : simpleDatasetDTO.getModelType(), typeCount.get(simpleDatasetDTO.getModelType()) == null ? 1 : (Integer)typeCount.get(simpleDatasetDTO.getModelType()) + 1);
        }
        DatasetPageList<SimpleDatasetDTO> datasetPageList = new DatasetPageList<SimpleDatasetDTO>(result, pageIndex, rows);
        datasetPageList.setTypeCounts(typeCount);
        return datasetPageList;
    }

    @Override
    public List<SimpleDatasetDTO> listDatasets(DataSourceDTO dataSourceDTO) {
        List<DsDatum> dsDatumList = this.datumDao.selectByDsKey(dataSourceDTO.getKey());
        ArrayList<SimpleDatasetDTO> result = new ArrayList<SimpleDatasetDTO>();
        for (DsDatum dsDatum : dsDatumList) {
            SimpleDatasetDTO simpleDatasetDTO = this.convertSimpleDatasetDTO(dsDatum);
            result.add(simpleDatasetDTO);
        }
        this.dataSourceManager.fillSimpleDatasetMeta(dataSourceDTO.getKey(), result);
        return result;
    }

    @Override
    public ModelDatasetDTO getDatasetDetail(String id) {
        DatumDatasetDTO datumDataset = this.datumDatabaseService.getDatasetDetail(id);
        return this.convertModelDatasetDTO(datumDataset);
    }

    @Override
    public ModelDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, String name) {
        DatumDatasetDTO datumDataset = this.datumDatabaseService.getDatasetDetail(dataSourceDTO, name);
        return this.convertModelDatasetDTO(datumDataset);
    }

    @Override
    public String createModelDataset(ModelDatasetCreateDTO createDTO) {
        DatumDatasetCreateDTO datumDatasetCreateDTO = new DatumDatasetCreateDTO();
        BeanUtils.copyProperties((Object)createDTO, (Object)datumDatasetCreateDTO);
        datumDatasetCreateDTO.setModelDatasetType(createDTO.getModelDatasetType());
        if (createDTO.getModelDatasetType().intValue() == ModelDatasetTypeEnum.GenericModelDataset.getValue()) {
            datumDatasetCreateDTO.setDatumDatasetType(DatumDatasetTypeEnum.DatumDataset.getValue());
        } else {
            datumDatasetCreateDTO.setDatumDatasetType(DatumDatasetTypeEnum.GeoDatumDataset.getValue());
        }
        String datumDatasetId = this.datumDatabaseService.createDatumDataset(datumDatasetCreateDTO);
        if (StringUtil.isNotEmpty((String)createDTO.getDataPhase())) {
            this.dataSourceManager.saveDatasetDataPhase(datumDatasetId, createDTO.getDataPhase());
        }
        return datumDatasetId;
    }

    @Override
    public void updateModelDataset(ModelDatasetEditDTO editDTO) {
        this.datumDatabaseService.updateDatumDataset(editDTO);
        if (StringUtil.isNotEmpty((String)editDTO.getDataPhase())) {
            this.dataSourceManager.saveDatasetDataPhase(editDTO.getId(), editDTO.getDataPhase());
        }
    }

    @Override
    public void deleteModelDataset(String id) {
        this.datumDatabaseService.deleteDatumDataset(id);
    }

    private SimpleDatasetDTO convertSimpleDatasetDTO(DsDatum dsDatum) {
        SimpleDatasetDTO simpleDatasetDTO = new SimpleDatasetDTO();
        simpleDatasetDTO.setId(dsDatum.getDatasetId());
        simpleDatasetDTO.setName(dsDatum.getName());
        simpleDatasetDTO.setAliasName(dsDatum.getAliasName());
        simpleDatasetDTO.setType(DatasetTypeEnum.ModelDataset.getValue());
        simpleDatasetDTO.setDatumType(dsDatum.getDatumDatasetType());
        DatumDatasetTypeEnum datumType = DatumDatasetTypeEnum.getByValue(dsDatum.getDatumDatasetType());
        if (datumType == null) {
            simpleDatasetDTO.setDatumType(DatumDatasetTypeEnum.DatumDataset.getValue());
        }
        simpleDatasetDTO.setFeatureType(dsDatum.getFeatureType().intValue());
        simpleDatasetDTO.setModelType(dsDatum.getModelType() == null ? 0 : dsDatum.getModelType());
        return simpleDatasetDTO;
    }

    private ModelDatasetDTO convertModelDatasetDTO(DatumDatasetDTO datumDataset) {
        ModelDatasetDTO modelDataset = new ModelDatasetDTO();
        DatasetNameInfo nameInfo = DatasetUtil.getDatasetNameInfo(datumDataset.getId());
        BeanUtils.copyProperties((Object)datumDataset, (Object)modelDataset);
        modelDataset.setRangeRender(datumDataset.getRender());
        modelDataset.setId(datumDataset.getId());
        modelDataset.setType(DatasetTypeEnum.ModelDataset.getValue());
        modelDataset.setTypeDesc(DatasetTypeEnum.ModelDataset.getDesc());
        this.dataSourceManager.setDatasetMeta(modelDataset);
        if (modelDataset.getRender() != null) {
            modelDataset.getRender().setXmax(null);
            modelDataset.getRender().setXmin(null);
            modelDataset.getRender().setYmin(null);
            modelDataset.getRender().setYmax(null);
        }
        DsDatum dsDatum = this.datumDao.selectByDsKeyAndName(nameInfo.getDsKey(), nameInfo.getName());
        modelDataset.setModelType(dsDatum.getModelType());
        modelDataset.setExtent(null);
        return modelDataset;
    }
}

