/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.license.LicenseCheckAnnotation;
import com.geoway.adf.dms.config.util.IpMapUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ServiceFormatEnum;
import com.geoway.adf.dms.datasource.dao.DsDataStoreDao;
import com.geoway.adf.dms.datasource.dao.DsDatasetMetaDao;
import com.geoway.adf.dms.datasource.dao.DsServiceDao;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datasource.TileFileDataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseUrlDTO;
import com.geoway.adf.dms.datasource.dto.funcservice.DatasetFuncServiceDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.encrypt.DataSourceParamsEncrypt;
import com.geoway.adf.dms.datasource.entity.DsDataStore;
import com.geoway.adf.dms.datasource.entity.DsDatasetMeta;
import com.geoway.adf.dms.datasource.entity.DsService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.JdbcWorkspaceFactory;
import com.geoway.adf.gis.geosrv.ServiceType;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Primary
@Component
@LicenseCheckAnnotation(moduleIds={64001, 64100, 64600, 65044})
public class DataSourceManager {
    private static final Logger log = LoggerFactory.getLogger(DataSourceManager.class);
    @Resource
    private DsDataStoreDao dataStoreDao;
    @Resource
    private DsDatasetMetaDao dsDatasetMetaDao;
    @Resource
    private DsServiceDao dsServiceDao;
    @Resource
    private DataSourceParamsEncrypt dataSourceParamsEncrypt;
    private DatabaseDTO systemDataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Autowired
    public void initSystemDataSource(DataSource dataSource) {
        try (JdbcWorkspace workspace = null;){
            DataSourceTypeEnum dataSourceType;
            workspace = JdbcWorkspaceFactory.openWorkspace((DataSource)dataSource);
            String driverClassName = workspace.getDriverClassName();
            String url = workspace.getUrl();
            String username = workspace.getUserName();
            String pg = "postgresql";
            String oracle = "oracle";
            String mysql = "mysql";
            String kingbase = "kingbase";
            String highgo = "highgo";
            String gaussdb = "gaussdb";
            String sqlite = "sqlite";
            if (driverClassName.contains(pg)) {
                dataSourceType = DataSourceTypeEnum.PostgreSql;
            } else if (driverClassName.contains(kingbase)) {
                dataSourceType = DataSourceTypeEnum.KingBase;
            } else if (driverClassName.contains(oracle)) {
                dataSourceType = DataSourceTypeEnum.OracleSpatial;
            } else if (driverClassName.contains(mysql)) {
                dataSourceType = DataSourceTypeEnum.MySql;
            } else if (driverClassName.contains(highgo)) {
                dataSourceType = DataSourceTypeEnum.HighgoSecurity;
            } else if (driverClassName.contains(gaussdb)) {
                dataSourceType = DataSourceTypeEnum.GaussDB;
            } else if (driverClassName.contains(sqlite)) {
                dataSourceType = DataSourceTypeEnum.Sqlite;
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u5e93\u7c7b\u578b\uff1a" + driverClassName);
            }
            DatabaseDTO systemDb = new DatabaseDTO();
            systemDb.setDataSourceType(dataSourceType.getValue());
            systemDb.setDataStoreType(DataStoreTypeEnum.GeoDatabase.getValue());
            systemDb.setUrl(url);
            systemDb.setUserName(username);
            systemDb.setIsDefault(false);
            if (dataSourceType != DataSourceTypeEnum.Sqlite) {
                String hostAndPort = url;
                int index = url.lastIndexOf("/");
                if (index > 0) {
                    hostAndPort = url.substring(0, index);
                    systemDb.setDbName(url.substring(index + 1));
                }
                systemDb.setHost(hostAndPort);
                index = hostAndPort.lastIndexOf(":");
                if (index > 0) {
                    systemDb.setHost(hostAndPort.substring(0, index));
                    systemDb.setPort(hostAndPort.substring(index + 1));
                }
            }
            String key = this.generateDataSourceKey(systemDb);
            systemDb.setKey(key);
            systemDb.setName("key");
            this.systemDataSource = systemDb;
            Class<?> clazz = dataSource.getClass();
            try {
                Method getPassword = clazz.getMethod("getPassword", null);
                Object pwd = getPassword.invoke((Object)dataSource, (Object[])null);
                this.systemDataSource.setPassword(pwd == null ? null : pwd.toString());
            }
            catch (NoSuchMethodException e) {
                log.error("init biz database pwd error.");
            }
        }
    }

    public String generateDataSourceKey(DataSourceDTO dataSourceDTO) {
        String strUrl = dataSourceDTO.getUrl();
        if (dataSourceDTO.getUserName() != null && dataSourceDTO.getUserName().length() > 0) {
            strUrl = (dataSourceDTO.getUserName() == null ? "" : dataSourceDTO.getUserName()) + "@" + strUrl;
        }
        String key = StringUtil.MD5((String)strUrl);
        if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.DatumDatabase.getValue()) {
            key = UUID.randomUUID().toString().replace("-", "");
        } else if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.MinIO.getValue() || dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.OBS.getValue() || dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.OSS.getValue() || dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.S3.getValue()) {
            strUrl = (Object)((Object)DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType())) + ":" + strUrl;
            key = StringUtil.MD5((String)strUrl);
        }
        return key;
    }

    public List<DataSourceDTO> listDataSource(List<DataStoreTypeEnum> dataStoreTypes, List<DataSourceTypeEnum> dataSourceTypes, String keyword) {
        return this.listDataSource(dataStoreTypes, dataSourceTypes, keyword, null);
    }

    public List<DataSourceDTO> listDataSource(List<DataStoreTypeEnum> dataStoreTypes, List<DataSourceTypeEnum> dataSourceTypes, String keyword, String category) {
        List storeTypes = null;
        if (dataStoreTypes != null && dataStoreTypes.size() > 0) {
            storeTypes = ListUtil.convertAll(dataStoreTypes, t -> t.getValue());
        }
        List sourceTypes = null;
        if (dataSourceTypes != null && dataSourceTypes.size() > 0) {
            sourceTypes = ListUtil.convertAll(dataSourceTypes, t -> t.getValue());
        }
        List<DsDataStore> dataStoreList = this.dataStoreDao.selectByType(storeTypes, sourceTypes, category, keyword);
        return ListUtil.convertAll(dataStoreList, d -> {
            DataSourceDTO dataSourceDTO = this.convertDataSource((DsDataStore)d);
            this.clearDataSourcePassword(dataSourceDTO);
            return dataSourceDTO;
        });
    }

    public List<DataSourceDTO> listDataSourceWithPassword(List<DataStoreTypeEnum> dataStoreTypes, List<DataSourceTypeEnum> dataSourceTypes) {
        List storeTypes = null;
        if (dataStoreTypes != null && dataStoreTypes.size() > 0) {
            storeTypes = ListUtil.convertAll(dataStoreTypes, t -> t.getValue());
        }
        List sourceTypes = null;
        if (dataSourceTypes != null && dataSourceTypes.size() > 0) {
            sourceTypes = ListUtil.convertAll(dataSourceTypes, t -> t.getValue());
        }
        List<DsDataStore> dataStoreList = this.dataStoreDao.selectByType(storeTypes, sourceTypes, null, null);
        return ListUtil.convertAll(dataStoreList, this::convertDataSource);
    }

    public DataSourceDTO getDataSourceDetail(String key) {
        Assert.notNull((Object)key, (String)" \u6570\u636e\u6e90\u8fde\u63a5\u6807\u8bc6\u4e3a\u7a7a");
        if ("service".equals(key)) {
            DataSourceDTO dataSourceDTO = new DataSourceDTO();
            dataSourceDTO.setKey(key);
            dataSourceDTO.setDataStoreType(DataStoreTypeEnum.ServiceServer.getValue());
            return dataSourceDTO;
        }
        if ("tile".equals(key)) {
            TileFileDataSourceDTO dataSourceDTO = new TileFileDataSourceDTO();
            dataSourceDTO.setKey(key);
            dataSourceDTO.setName("\u6587\u4ef6\u74e6\u7247\u5e93");
            dataSourceDTO.setDataStoreType(DataStoreTypeEnum.TileFileSource.getValue());
            dataSourceDTO.setDataSourceType(DataSourceTypeEnum.ShareFolder.getValue());
            return dataSourceDTO;
        }
        if (key.startsWith("file")) {
            String filePath = StringUtil.trimStart((String)key, (String)"file:");
            DataSourceDTO dataSourceDTO = this.buildLocalFileDataSource(new File(filePath));
            return dataSourceDTO;
        }
        DsDataStore dataStore = this.dataStoreDao.selectByPrimaryKey(key);
        if (dataStore == null) {
            if (this.systemDataSource != null && ("key".equals(key) || this.systemDataSource.getKey().equals(key))) {
                return this.getSystemDataSourceDetail();
            }
            log.error(key);
            throw new RuntimeException("\u6570\u636e\u6e90\u8fde\u63a5\u4e0d\u5b58\u5728\uff01");
        }
        return this.convertDataSource(dataStore);
    }

    public DataSourceDTO getGeoDatabaseDetail(String key) {
        DataSourceDTO dataSource = this.getDataSourceDetail(key);
        if (dataSource instanceof DatumDatabaseDTO) {
            DatumDatabaseDTO datumDatabaseDTO = (DatumDatabaseDTO)dataSource;
            dataSource = datumDatabaseDTO.getGeoDatabase();
        }
        return dataSource;
    }

    public DataSourceDTO getDefaultDataSource(Integer dataStoreType, Integer dataSourceType) {
        DsDataStore dataStore = this.dataStoreDao.selectDefaultDataStore(dataStoreType, dataSourceType);
        if (dataStore != null) {
            return this.convertDataSource(dataStore);
        }
        return null;
    }

    public DataSourceDTO getDataSourceDetailByName(String name) {
        DsDataStore dataStore = this.dataStoreDao.selectByName(name);
        Assert.notNull((Object)dataStore, (String)(name + " \u8fde\u63a5\u4e0d\u5b58\u5728"));
        return this.convertDataSource(dataStore);
    }

    public DatabaseDTO getSystemDataSourceDetail() {
        DatabaseDTO databaseDTO = new DatabaseDTO();
        BeanUtils.copyProperties((Object)this.systemDataSource, (Object)databaseDTO);
        return databaseDTO;
    }

    public String getDataSourceName(String key) {
        DsDataStore dataStore = this.dataStoreDao.selectByPrimaryKey(key);
        if (dataStore == null) {
            return key;
        }
        return dataStore.getName();
    }

    public DataSourceDTO getDataSourceWithoutPassword(String key) {
        DataSourceDTO dataStore = this.getDataSourceDetail(key);
        this.clearDataSourcePassword(dataStore);
        return dataStore;
    }

    public void clearDataSourcePassword(DataSourceDTO dataSourceDTO) {
        dataSourceDTO.setPassword(null);
        if (dataSourceDTO instanceof DatumDatabaseDTO) {
            DatumDatabaseDTO datumDatabaseDTO = (DatumDatabaseDTO)dataSourceDTO;
            if (datumDatabaseDTO.getGeoDatabase() != null) {
                datumDatabaseDTO.getGeoDatabase().setPassword(null);
            }
            if (datumDatabaseDTO.getFileStorage() != null) {
                datumDatabaseDTO.getFileStorage().forEach(s -> s.setPassword(null));
            }
        }
    }

    public DataSourceDTO convertDataSource(DsDataStore dsDataStore) {
        dsDataStore = this.dataSourceParamsEncrypt.decryptDataSource(dsDataStore);
        DataSourceDTO dataSourceDTO = null;
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dsDataStore.getDataSourceType());
        String url = dsDataStore.getUrl();
        if (url != null && url.length() > 0) {
            switch (dataSourceTypeEnum) {
                case OracleSpatial: 
                case PostgreSql: 
                case KingBase: 
                case Highgo: 
                case HighgoSecurity: 
                case GaussDB: 
                case SqlServer: 
                case MySql: 
                case MongoDB: 
                case HBase: {
                    try {
                        String hostAndPort;
                        DatabaseDTO databaseDTO = new DatabaseDTO();
                        dataSourceDTO = databaseDTO;
                        int index = url.lastIndexOf("/");
                        if (index > 0) {
                            hostAndPort = url.substring(0, index);
                            databaseDTO.setDbName(url.substring(index + 1));
                        } else {
                            hostAndPort = url;
                        }
                        String[] contents = hostAndPort.split(":");
                        if (contents.length == 2) {
                            databaseDTO.setHost(contents[0]);
                            databaseDTO.setPort(contents[1]);
                            break;
                        }
                        databaseDTO.setHost(hostAndPort);
                    }
                    catch (Exception e) {
                        log.error(url + " \u89e3\u6790\u5f02\u5e38", (Throwable)e);
                    }
                    break;
                }
                case DatumDatabase: {
                    try {
                        DatumDatabaseDTO datumDatabaseDTO = new DatumDatabaseDTO();
                        dataSourceDTO = datumDatabaseDTO;
                        DatumDatabaseUrlDTO urlDTO = (DatumDatabaseUrlDTO)JSON.parseObject((String)url, DatumDatabaseUrlDTO.class);
                        if (urlDTO == null) break;
                        try {
                            datumDatabaseDTO.setGeoDatabase((DatabaseDTO)this.getDataSourceDetail(urlDTO.getGeoDatabaseKey()));
                        }
                        catch (Exception e) {
                            log.error(String.format("\u6587\u4ef6\u6570\u636e\u5e93[%s]\u5173\u8054\u7a7a\u95f4\u5e93[%s]\u83b7\u53d6\u5931\u8d25", dsDataStore.getName(), urlDTO.getGeoDatabaseKey()), (Throwable)e);
                        }
                        datumDatabaseDTO.setFileStorage(new ArrayList<DataSourceDTO>());
                        if (urlDTO.getFileStorageKeys() == null) break;
                        for (String key : urlDTO.getFileStorageKeys()) {
                            try {
                                datumDatabaseDTO.getFileStorage().add(this.getDataSourceDetail(key));
                            }
                            catch (Exception e) {
                                log.error(String.format("\u6587\u4ef6\u6570\u636e\u5e93[%s]\u5173\u8054\u6587\u4ef6\u5b58\u50a8[%s]\u83b7\u53d6\u5931\u8d25", dsDataStore.getName(), key), (Throwable)e);
                            }
                        }
                        break;
                    }
                    catch (Exception e) {
                        log.error(url + " \u89e3\u6790\u5f02\u5e38", (Throwable)e);
                        break;
                    }
                }
                default: {
                    dataSourceDTO = new DataSourceDTO();
                }
            }
        }
        BeanUtils.copyProperties((Object)dsDataStore, dataSourceDTO);
        dataSourceDTO.setIsDefault(dsDataStore.getIsDefault() != null && dsDataStore.getIsDefault() > 0);
        return dataSourceDTO;
    }

    public DataSourceDTO buildLocalFileDataSource(File file) {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        DataSourceDTO localDataSource = new DataSourceDTO();
        localDataSource.setName(fileSystemView.getSystemDisplayName(file));
        localDataSource.setUrl(file.toString());
        localDataSource.setDataStoreType(DataStoreTypeEnum.FileStorageSystem.getValue());
        localDataSource.setDataSourceType(DataSourceTypeEnum.ShareFolder.getValue());
        localDataSource.setKey("file:" + localDataSource.getUrl());
        return localDataSource;
    }

    public DatasetMetaDTO getDatasetMeta(String id) {
        DsDatasetMeta dsDatasetMeta = this.dsDatasetMetaDao.selectByPrimaryKey(id);
        return this.convertDatasetMeta(dsDatasetMeta);
    }

    public void saveDatasetMeta(String id, DatasetMetaDTO datasetMetaDTO) {
        DsDatasetMeta existDatasetMeta;
        DsDatasetMeta dsDatasetInfo = new DsDatasetMeta();
        dsDatasetInfo.setId(id);
        dsDatasetInfo.setDetail(datasetMetaDTO.getDetail());
        dsDatasetInfo.setDataPhase(datasetMetaDTO.getDataPhase());
        if (datasetMetaDTO.getRender() != null) {
            dsDatasetInfo.setRender(JSON.toJSONString((Object)datasetMetaDTO.getRender()));
        }
        if ((existDatasetMeta = this.dsDatasetMetaDao.selectByPrimaryKey(id)) == null) {
            this.dsDatasetMetaDao.insert(dsDatasetInfo);
        } else {
            this.dsDatasetMetaDao.updateByPrimaryKey(dsDatasetInfo);
        }
    }

    public void saveDatasetDataPhase(String datasetId, String dataPhase) {
        DsDatasetMeta dsDatasetMeta = this.dsDatasetMetaDao.selectByPrimaryKey(datasetId);
        if (dsDatasetMeta == null) {
            DsDatasetMeta dsDatasetInfo = new DsDatasetMeta();
            dsDatasetInfo.setId(datasetId);
            dsDatasetInfo.setDataPhase(dataPhase);
            this.dsDatasetMetaDao.insert(dsDatasetInfo);
        } else {
            this.dsDatasetMetaDao.updateDataPhase(datasetId, dataPhase);
        }
    }

    public DatasetRenderDTO getDatasetRender(String id) {
        DsDatasetMeta dsDatasetMeta = this.dsDatasetMetaDao.selectByPrimaryKey(id);
        if (dsDatasetMeta == null) {
            return null;
        }
        return this.parseRenderStr(dsDatasetMeta.getRender());
    }

    public void saveDatasetRender(String id, DatasetRenderDTO datasetRender) {
        DsDatasetMeta dsDatasetInfo = new DsDatasetMeta();
        dsDatasetInfo.setId(id);
        if (datasetRender != null) {
            if (datasetRender.getServiceFormat() == null) {
                if (datasetRender.getServiceType().intValue() == ServiceType.RasterTileService.getValue()) {
                    datasetRender.setServiceFormat(ServiceFormatEnum.WMTS.getValue());
                } else if (datasetRender.getServiceType().intValue() == ServiceType.Tiles3dService.getValue()) {
                    datasetRender.setServiceFormat(ServiceFormatEnum.Model3DTile.getValue());
                }
            }
            dsDatasetInfo.setRender(JSON.toJSONString((Object)datasetRender));
        } else {
            dsDatasetInfo.setRender("");
        }
        if (this.dsDatasetMetaDao.existDataset(id) > 0) {
            this.dsDatasetMetaDao.updateByPrimaryKeySelective(dsDatasetInfo);
        } else if (datasetRender != null) {
            this.dsDatasetMetaDao.insert(dsDatasetInfo);
        }
    }

    public void fillSimpleDatasetMeta(String dsKey, List<SimpleDatasetDTO> datasetDTOS) {
        Map<String, DsDatasetMeta> datasetMetaMap = this.dsDatasetMetaDao.selectByIdpPrefix(dsKey).stream().collect(Collectors.toMap(DsDatasetMeta::getId, v -> v));
        for (SimpleDatasetDTO datasetDTO : datasetDTOS) {
            DsDatasetMeta dsDatasetMeta = datasetMetaMap.get(datasetDTO.getId());
            if (dsDatasetMeta != null) {
                datasetDTO.setHasRender(StringUtil.isNotEmpty((String)dsDatasetMeta.getRender()));
            }
            datasetDTO.setTypeDesc(this.parseTypeDesc(datasetDTO.getType(), dsDatasetMeta));
            if (datasetDTO.getSubsets() == null) continue;
            for (SimpleDatasetDTO subset : datasetDTO.getSubsets()) {
                DsDatasetMeta subDatasetMeta = datasetMetaMap.get(subset.getId());
                if (subDatasetMeta != null) {
                    subset.setHasRender(StringUtil.isNotEmpty((String)subDatasetMeta.getRender()));
                }
                subset.setTypeDesc(this.parseTypeDesc(subset.getType(), subDatasetMeta));
            }
        }
    }

    public void fillDatasetMeta(String dsKey, List<DatasetDTO> datasetDTOS) {
        Map<String, DsDatasetMeta> datasetMetaMap = this.dsDatasetMetaDao.selectByIdpPrefix(dsKey).stream().collect(Collectors.toMap(DsDatasetMeta::getId, v -> v));
        for (DatasetDTO datasetDTO : datasetDTOS) {
            if (!datasetMetaMap.containsKey(datasetDTO.getId())) continue;
            DsDatasetMeta dsDatasetMeta = datasetMetaMap.get(datasetDTO.getId());
            this.setDatasetMeta(datasetDTO, dsDatasetMeta);
        }
    }

    public void setDatasetMeta(DatasetDTO datasetDTO) {
        DsDatasetMeta dsDatasetMeta = this.dsDatasetMetaDao.selectByPrimaryKey(datasetDTO.getId());
        this.setDatasetMeta(datasetDTO, dsDatasetMeta);
    }

    public List<String> getHasRenderDatasetIds(String dsKey) {
        return this.dsDatasetMetaDao.selectHasRenderIds(dsKey);
    }

    public List<DatasetFuncServiceDTO> getDatasetFuncService(String id) {
        DsDatasetMeta dsDatasetMeta = this.dsDatasetMetaDao.selectByPrimaryKey(id);
        if (dsDatasetMeta == null) {
            return null;
        }
        try {
            String str = dsDatasetMeta.getFuncServices();
            if (StringUtil.isNotEmpty((String)str)) {
                return JSON.parseArray((String)str, DatasetFuncServiceDTO.class);
            }
        }
        catch (Exception e) {
            log.error("\u5173\u8054\u529f\u80fd\u670d\u52a1\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }

    public void saveDatasetFuncService(String id, List<DatasetFuncServiceDTO> funcServiceDTOs) {
        DsDatasetMeta dsDatasetInfo = new DsDatasetMeta();
        dsDatasetInfo.setId(id);
        if (funcServiceDTOs != null) {
            dsDatasetInfo.setFuncServices(JSON.toJSONString(funcServiceDTOs));
        } else {
            dsDatasetInfo.setFuncServices("");
        }
        if (this.dsDatasetMetaDao.existDataset(id) > 0) {
            this.dsDatasetMetaDao.updateByPrimaryKeySelective(dsDatasetInfo);
        } else if (funcServiceDTOs != null) {
            this.dsDatasetMetaDao.insert(dsDatasetInfo);
        }
    }

    private void setDatasetMeta(DatasetDTO datasetDTO, DsDatasetMeta dsDatasetMeta) {
        datasetDTO.setTypeDesc(this.parseTypeDesc(datasetDTO.getType(), dsDatasetMeta));
        if (dsDatasetMeta != null) {
            DatasetMetaDTO datasetMetaDTO = this.convertDatasetMeta(dsDatasetMeta);
            datasetDTO.setDataPhase(dsDatasetMeta.getDataPhase());
            datasetDTO.setFunctionServices(datasetMetaDTO.getFunctionServices());
            DatasetRenderDTO datasetRenderDTO = datasetMetaDTO.getRender();
            datasetDTO.setRender(datasetRenderDTO);
            datasetDTO.setHasRender(datasetRenderDTO != null);
            if (datasetRenderDTO != null) {
                ExtentDTO extentDTO = DatasetUtil.getDatasetExtent(datasetDTO);
                if (extentDTO != null) {
                    datasetRenderDTO.setXmin(extentDTO.getXmin());
                    datasetRenderDTO.setYmin(extentDTO.getYmin());
                    datasetRenderDTO.setXmax(extentDTO.getXmax());
                    datasetRenderDTO.setYmax(extentDTO.getYmax());
                }
                try {
                    String serviceId = datasetRenderDTO.getServiceId();
                    if (StringUtil.isEmptyOrWhiteSpace((String)serviceId)) {
                        serviceId = DatasetNameInfo.buildDatasetId(datasetRenderDTO.getServerKey(), datasetRenderDTO.getServiceType(), datasetRenderDTO.getServiceName());
                        datasetRenderDTO.setServiceId(serviceId);
                    }
                    if (serviceId.startsWith("service")) {
                        String serviceName = new DatasetNameInfo(datasetRenderDTO.getServiceId()).getName();
                        List<DsService> dsServices = this.dsServiceDao.selectByName(serviceName);
                        if (dsServices != null && dsServices.size() > 0) {
                            DsService dsService = dsServices.get(0);
                            datasetRenderDTO.setExtension(dsService.getExt());
                        }
                    } else {
                        DatasetMetaDTO serviceMetaDTO = this.getDatasetMeta(serviceId);
                        if (serviceMetaDTO != null) {
                            datasetRenderDTO.setExtension(serviceMetaDTO.getDetail());
                        }
                    }
                }
                catch (Exception e) {
                    log.error(datasetDTO.getName() + "\u8bfb\u53d6\u6e32\u67d3\u7d22\u5f15\u670d\u52a1\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
                }
            }
        } else {
            datasetDTO.setDataPhase(null);
            datasetDTO.setRender(null);
            datasetDTO.setHasRender(false);
        }
    }

    private DatasetMetaDTO convertDatasetMeta(DsDatasetMeta dsDatasetMeta) {
        if (dsDatasetMeta == null) {
            return null;
        }
        DatasetMetaDTO datasetMetaDTO = new DatasetMetaDTO();
        datasetMetaDTO.setDataPhase(dsDatasetMeta.getDataPhase());
        datasetMetaDTO.setDetail(dsDatasetMeta.getDetail());
        datasetMetaDTO.setRender(this.parseRenderStr(dsDatasetMeta.getRender()));
        try {
            String str = dsDatasetMeta.getFuncServices();
            if (StringUtil.isNotEmpty((String)str)) {
                List funcServiceDTO = JSON.parseArray((String)str, DatasetFuncServiceDTO.class);
                datasetMetaDTO.setFunctionServices(funcServiceDTO);
            }
        }
        catch (Exception e) {
            log.error("\u529f\u80fd\u670d\u52a1\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return datasetMetaDTO;
    }

    private String parseTypeDesc(Integer datasetType, DsDatasetMeta dsDatasetMeta) {
        if (datasetType == null || datasetType.intValue() == DatasetTypeEnum.Unknown.getValue()) {
            return null;
        }
        String typeDesc = DatasetTypeEnum.getByValue(datasetType).getDesc();
        if (datasetType.intValue() == DatasetTypeEnum.GroupDataset.getValue()) {
            typeDesc = null;
            if (dsDatasetMeta != null) {
                try {
                    if (StringUtil.isNotEmpty((String)dsDatasetMeta.getDetail())) {
                        JSONObject jsonObject = JSONObject.parseObject((String)dsDatasetMeta.getDetail());
                        typeDesc = jsonObject.getString("typeDesc");
                    }
                }
                catch (Exception e) {
                    log.error(dsDatasetMeta.getDetail(), (Throwable)e);
                }
            }
        }
        return typeDesc;
    }

    private DatasetRenderDTO parseRenderStr(String str) {
        try {
            if (StringUtil.isNotEmpty((String)str)) {
                DatasetRenderDTO renderInfo = (DatasetRenderDTO)JSON.parseObject((String)str, DatasetRenderDTO.class);
                Map ipMap = IpMapUtil.getIpMap();
                renderInfo.setServer(IpMapUtil.getIpAfterMap((Map)ipMap, (String)renderInfo.getServer()));
                renderInfo.setUrl(IpMapUtil.getIpAfterMap((Map)ipMap, (String)renderInfo.getUrl()));
                if (StringUtil.isNotEmpty((String)renderInfo.getMapServer())) {
                    renderInfo.setMapServer(IpMapUtil.getIpAfterMap((Map)ipMap, (String)renderInfo.getMapServer()));
                    if (renderInfo.getServiceCapabilities() != null) {
                        for (String capability : renderInfo.getServiceCapabilities().keySet()) {
                            renderInfo.getServiceCapabilities().put(capability, IpMapUtil.getIpAfterMap((Map)ipMap, (String)renderInfo.getServiceCapabilities().get(capability)));
                        }
                    }
                }
                if (renderInfo.getServiceFormat() == null) {
                    if (renderInfo.getServiceType().intValue() == ServiceType.RasterTileService.getValue()) {
                        renderInfo.setServiceFormat(ServiceFormatEnum.WMTS.getValue());
                    } else if (renderInfo.getServiceType().intValue() == ServiceType.Tiles3dService.getValue()) {
                        renderInfo.setServiceFormat(ServiceFormatEnum.Model3DTile.getValue());
                    }
                }
                return renderInfo;
            }
        }
        catch (Exception e) {
            log.error("\u6e32\u67d3\u7d22\u5f15\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

