/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.constant.ConstantsValue;
import com.geoway.adf.dms.datasource.dao.DsDatumDao;
import com.geoway.adf.dms.datasource.dao.DsDatumFieldsDao;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchUpdateDTO;
import com.geoway.adf.dms.datasource.dto.edit.GeoDataEditDTO;
import com.geoway.adf.dms.datasource.entity.DsDatum;
import com.geoway.adf.dms.datasource.entity.DsDatumField;
import com.geoway.adf.dms.datasource.service.DatumDatabaseEditService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseEditService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DatumDatabaseEditServiceImpl
implements DatumDatabaseEditService {
    @Resource
    private DsDatumFieldsDao datumFieldsDao;
    @Resource
    private DsDatumDao datumDao;
    @Resource
    private GeoDatabaseEditService geoDatabaseEditService;

    @Override
    public boolean updateData(GeoDataEditDTO geoDataEditDTO) {
        Map<String, Object> data = geoDataEditDTO.getData();
        Assert.notNull(data, (String)"\u66f4\u65b0\u6570\u636e\u4e3a\u7a7a\uff01");
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(geoDataEditDTO.getDatasetId());
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        List<DsDatumField> dsDatumFieldList = this.datumFieldsDao.selectByDatasetId(dsDatum.getDatasetId());
        for (DsDatumField dsDatumField : dsDatumFieldList) {
            String updateFld = null;
            for (String key : data.keySet()) {
                if (!key.equalsIgnoreCase(dsDatumField.getName())) continue;
                updateFld = key;
                break;
            }
            if (updateFld != null && !ConstantsValue.boolValue((Short)dsDatumField.getSystem()).booleanValue()) continue;
            data.remove(updateFld);
        }
        geoDataEditDTO.setDatasetId(dsDatum.getGeoDatasetId());
        return this.geoDatabaseEditService.updateData(geoDataEditDTO);
    }

    @Override
    public boolean deleteData(String datasetId, String objectId, Boolean updateRenderIndex) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(datasetId);
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        return this.geoDatabaseEditService.deleteData(dsDatum.getGeoDatasetId(), objectId, updateRenderIndex);
    }

    @Override
    public long batchUpdateDataByFilter(DataBatchUpdateDTO dataBatchUpdateDTO) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(dataBatchUpdateDTO.getDatasetId());
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        List<DsDatumField> dsDatumFieldList = this.datumFieldsDao.selectByDatasetId(dsDatum.getDatasetId());
        for (DsDatumField dsDatumField : dsDatumFieldList) {
            if (!ConstantsValue.boolValue((Short)dsDatumField.getSystem()).booleanValue() || !dsDatumField.getName().equalsIgnoreCase(dataBatchUpdateDTO.getUpdateField())) continue;
            throw new RuntimeException("\u7cfb\u7edf\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        dataBatchUpdateDTO.setDatasetId(dsDatum.getGeoDatasetId());
        return this.geoDatabaseEditService.batchUpdateDataByFilter(dataBatchUpdateDTO);
    }

    @Override
    public long deleteDataByFilter(DataBatchDeleteDTO dataBatchDeleteDTO) {
        DsDatum dsDatum = this.datumDao.selectByPrimaryKey(dataBatchDeleteDTO.getDatasetId());
        Assert.notNull((Object)dsDatum, (String)"\u6587\u4ef6\u6570\u636e\u96c6\u4e0d\u5b58\u5728\uff01");
        dataBatchDeleteDTO.setDatasetId(dsDatum.getGeoDatasetId());
        return this.geoDatabaseEditService.deleteDataByFilter(dataBatchDeleteDTO);
    }
}

