/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.properties.UserRightProperties;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.district.HotDistrictDatasetDTO;
import com.geoway.adf.dms.datasource.dto.district.HotDistrictRecordDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DistrictHotService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geosrv.vtile.VTileServiceStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class DistrictHotServiceImpl
implements DistrictHotService {
    private static final Logger log = LoggerFactory.getLogger(DistrictHotServiceImpl.class);
    @Resource
    private RenderIndexService renderIndexService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private UserRightProperties userRightProperties;
    private final String tableName = "tbdm_districthot";
    private final String field_id = "objectid";
    private final String field_name = "f_name";
    private final String field_datasetId = "f_datasetid";
    private final String field_fieldName = "f_fieldname";
    private final String field_fieldValue = "f_fieldvalue";
    private final String serviceName = "_hotRegion";

    @Override
    public List<HotDistrictRecordDTO> list(String keyword) {
        List recordList = this.queryRecords(null);
        if (!StringUtil.isEmptyOrWhiteSpace((String)keyword)) {
            recordList = ListUtil.findAll(recordList, f -> f.getName().contains(keyword));
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer add(HotDistrictRecordDTO addDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)addDTO.getDistrictValues())) {
            throw new RuntimeException("\u884c\u653f\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        addDTO.setDistrictValues(addDTO.getDistrictValues().trim().replace("\uff0c", ","));
        HotDistrictRecordDTO sameName = this.getByName(addDTO.getName());
        if (sameName != null) {
            throw new RuntimeException("\u5df2\u5b58\u5728\u540c\u540d\u70ed\u70b9\u533a\u57df\uff01");
        }
        IFeatureWorkspace workspace = this.getSystemWorkspace();
        IFeatureCursor cursor = null;
        try {
            String districtTableName = this.getDistrictTableName();
            IFeatureClass featureClass = workspace.openFeatureClass(districtTableName);
            if (featureClass == null) {
                throw new RuntimeException("\u70ed\u70b9\u533a\u57df\u8868\u6253\u5f00\u5931\u8d25\uff01");
            }
            IGeometry region = this.getGeometry(addDTO.getDatasetId(), addDTO.getDistrictFieldName(), addDTO.getDistrictValues());
            cursor = featureClass.insertFeature();
            IFeature feature = featureClass.createFeature();
            feature.setValue("f_name", (Object)addDTO.getName());
            feature.setValue("f_datasetid", (Object)addDTO.getDatasetId());
            feature.setValue("f_fieldname", (Object)addDTO.getDistrictFieldName());
            feature.setValue("f_fieldvalue", (Object)addDTO.getDistrictValues());
            feature.setGeometry(region);
            cursor.insertFeature(feature);
            cursor.release();
            featureClass.updateExtent();
            HotDistrictRecordDTO record = this.getByName(addDTO.getName());
            Integer oid = record.getId();
            this.createVectorRenderIndex(featureClass);
            Integer n = oid;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(HotDistrictRecordDTO editDTO) {
        if (StringUtil.isEmptyOrWhiteSpace((String)editDTO.getDistrictValues())) {
            throw new RuntimeException("\u884c\u653f\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        editDTO.setDistrictValues(editDTO.getDistrictValues().trim().replace("\uff0c", ","));
        IFeatureWorkspace workspace = this.getSystemWorkspace();
        IFeatureCursor cursor = null;
        try {
            String districtTableName = this.getDistrictTableName();
            IFeatureClass featureClass = workspace.openFeatureClass(districtTableName);
            if (featureClass == null) {
                throw new RuntimeException("\u70ed\u70b9\u533a\u57df\u8868\u6253\u5f00\u5931\u8d25\uff01");
            }
            SpatialQueryFilter filter = new SpatialQueryFilter();
            filter.setWhereClause(String.format("%s = %d", "objectid", editDTO.getId()));
            cursor = featureClass.updateFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            boolean updateGeometry = false;
            if (feature != null) {
                HotDistrictRecordDTO sameName;
                String name;
                String string = name = feature.getValue("f_name") == null ? "" : feature.getValue("f_name").toString();
                if (editDTO.getName() != null && !editDTO.getName().equals(name) && (sameName = this.getByName(editDTO.getName())) != null) {
                    throw new RuntimeException("\u5df2\u5b58\u5728\u540c\u540d\u70ed\u70b9\u533a\u57df\uff01");
                }
                feature.setValue("f_name", (Object)editDTO.getName());
                if (editDTO.getDatasetId() != null) {
                    feature.setValue("f_datasetid", (Object)editDTO.getDatasetId());
                    updateGeometry = true;
                }
                if (editDTO.getDistrictFieldName() != null) {
                    feature.setValue("f_fieldname", (Object)editDTO.getDistrictFieldName());
                    updateGeometry = true;
                }
                if (editDTO.getDistrictValues() != null) {
                    feature.setValue("f_fieldvalue", (Object)editDTO.getDistrictValues());
                    updateGeometry = true;
                }
                if (updateGeometry) {
                    String datasetId = feature.getValue("f_datasetid") == null ? null : feature.getValue("f_datasetid").toString();
                    String fieldName = feature.getValue("f_fieldname") == null ? null : feature.getValue("f_fieldname").toString();
                    String fieldValue = feature.getValue("f_fieldvalue") == null ? null : feature.getValue("f_fieldvalue").toString();
                    IGeometry region = this.getGeometry(datasetId, fieldName, fieldValue);
                    feature.setGeometry(region);
                }
                cursor.updateFeature(feature);
            }
            cursor.release();
            featureClass.updateExtent();
            this.createVectorRenderIndex(featureClass);
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Integer id) {
        try (IFeatureWorkspace workspace = this.getSystemWorkspace();){
            String districtTableName = this.getDistrictTableName();
            IFeatureClass featureClass = workspace.openFeatureClass(districtTableName);
            if (featureClass == null) {
                throw new RuntimeException("\u70ed\u70b9\u533a\u57df\u8868\u6253\u5f00\u5931\u8d25\uff01");
            }
            featureClass.deleteFeature((Object)id);
            this.createVectorRenderIndex(featureClass);
        }
    }

    @Override
    public HotDistrictDatasetDTO getHotDistrictDataset() {
        String districtTableName = this.getDistrictTableName();
        DatabaseDTO systemDataSource = this.dataSourceManager.getSystemDataSourceDetail();
        DatasetDTO dataset = this.geoDatabaseService.getDatasetDetail(systemDataSource, DatasetTypeEnum.FeatureClass, districtTableName);
        this.dataSourceManager.clearDataSourcePassword(systemDataSource);
        HotDistrictDatasetDTO hotDistrictDataset = new HotDistrictDatasetDTO();
        BeanUtils.copyProperties((Object)dataset, (Object)hotDistrictDataset);
        hotDistrictDataset.setNameField("f_name");
        return hotDistrictDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtentDTO getHotDistrictExtent(Integer id) {
        try (IFeatureWorkspace workspace = this.getSystemWorkspace();){
            String districtTableName = this.getDistrictTableName();
            IFeatureClass featureClass = workspace.openFeatureClass(districtTableName);
            if (featureClass == null) {
                throw new RuntimeException("\u70ed\u70b9\u533a\u57df\u8868\u6253\u5f00\u5931\u8d25\uff01");
            }
            String shapeField = featureClass.getShapeFieldName();
            String sql = String.format("select st_extent(%s) as box from %s where %s='%s'", shapeField, featureClass.getFullName(), "objectid", id);
            Map result = workspace.queryOne(sql, new Object[0]);
            Object box = result.get("box");
            Assert.notNull(box, (String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e");
            String[] boxExtent = box.toString().substring(4, box.toString().length() - 1).split(",");
            String[] minValues = boxExtent[0].split(" ");
            String[] maxValues = boxExtent[1].split(" ");
            ExtentDTO extentDTO = new ExtentDTO();
            extentDTO.setXmin(Double.valueOf(Double.parseDouble(minValues[0])));
            extentDTO.setYmin(Double.valueOf(Double.parseDouble(minValues[1])));
            extentDTO.setXmax(Double.valueOf(Double.parseDouble(maxValues[0])));
            extentDTO.setYmax(Double.valueOf(Double.parseDouble(maxValues[1])));
            ExtentDTO extentDTO2 = extentDTO;
            return extentDTO2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IGeometry getGeometry(String datasetId, String fieldName, String fieldValue) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
        if (datasetType != DatasetTypeEnum.FeatureClass) {
            throw new RuntimeException("\u5bfc\u5165\u8303\u56f4\u5931\u8d25-\u8bf7\u9009\u62e9\u5408\u9002\u7684\u6570\u636e\u7c7b\u578b\uff01");
        }
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        IFeatureCursor cursor = null;
        ArrayList<IGeometry> geometryList = new ArrayList<IGeometry>();
        try {
            IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
            Assert.notNull((Object)featureClass, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            SpatialQueryFilter filter = null;
            if (!StringUtil.isEmptyOrWhiteSpace((String)fieldValue)) {
                if (StringUtil.isEmptyOrWhiteSpace((String)fieldName)) {
                    throw new RuntimeException("\u653f\u533a\u4ee3\u7801\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u653f\u533a\u4ee3\u7801\u5b57\u6bb5\uff01");
                }
                List values = Arrays.asList(fieldValue.split(","));
                values = ListUtil.convertAll(values, f -> "'" + f + "'");
                filter = new SpatialQueryFilter();
                filter.setWhereClause(String.format("%s in (%s)", fieldName, String.join((CharSequence)",", values)));
            }
            cursor = featureClass.searchFeature(filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                geometryList.add(feature.getGeometry());
                feature = cursor.nextFeature();
            }
            cursor.release();
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
        if (geometryList.size() == 0) {
            throw new RuntimeException("\u5bfc\u5165\u8303\u56f4\u5931\u8d25-\u672a\u67e5\u8be2\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u8303\u56f4\u6570\u636e\uff01");
        }
        IGeometry unionGeometry = (IGeometry)geometryList.get(0);
        for (int i = 1; i < geometryList.size(); ++i) {
            unionGeometry = unionGeometry.union((IGeometry)geometryList.get(i));
        }
        return unionGeometry;
    }

    private HotDistrictRecordDTO getByName(String name) {
        String whereClause = String.format("%s = '%s'", "f_name", name);
        List<HotDistrictRecordDTO> recordList = this.queryRecords(whereClause);
        if (recordList.size() > 0) {
            return recordList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HotDistrictRecordDTO> queryRecords(String whereClause) {
        IFeatureWorkspace workspace = this.getSystemWorkspace();
        IFeatureCursor cursor = null;
        ArrayList<HotDistrictRecordDTO> recordList = new ArrayList<HotDistrictRecordDTO>();
        try {
            String districtTableName = this.getDistrictTableName();
            IFeatureClass featureClass = workspace.openFeatureClass(districtTableName);
            if (featureClass == null) {
                throw new RuntimeException("\u70ed\u70b9\u533a\u57df\u8868\u6253\u5f00\u5931\u8d25\uff01");
            }
            SpatialQueryFilter filter = new SpatialQueryFilter();
            filter.setWhereClause(whereClause);
            cursor = featureClass.searchFeature((IQueryFilter)filter);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                HotDistrictRecordDTO record = new HotDistrictRecordDTO();
                record.setId(Integer.parseInt(feature.getObjectId().toString()));
                record.setName(feature.getValue("f_name") == null ? "" : feature.getValue("f_name").toString());
                record.setDatasetId(feature.getValue("f_datasetid") == null ? "" : feature.getValue("f_datasetid").toString());
                record.setDistrictFieldName(feature.getValue("f_fieldname") == null ? "" : feature.getValue("f_fieldname").toString());
                record.setDistrictValues(feature.getValue("f_fieldvalue") == null ? "" : feature.getValue("f_fieldvalue").toString());
                recordList.add(record);
                feature = cursor.nextFeature();
            }
            cursor.release();
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return recordList;
    }

    private IFeatureWorkspace getSystemWorkspace() {
        IFeatureWorkspace workspace = this.geoDatabaseService.openGeoWorkspace("key");
        Assert.notNull((Object)workspace, (String)"\u70ed\u70b9\u533a\u57df\u83b7\u53d6\u5931\u8d25-\u5de5\u4f5c\u7a7a\u95f4\u6253\u5f00\u5931\u8d25\uff01");
        return workspace;
    }

    private String getDistrictTableName() {
        if (Boolean.TRUE.equals(this.userRightProperties.getTenantEnabled())) {
            LoginUserInfo userInfo = ThreadLocalUtil.getCurrentUser();
            if (userInfo == null) {
                throw new HttpClientErrorException(HttpStatus.UNAUTHORIZED, "\u7cfb\u7edf\u672a\u767b\u5f55");
            }
            if (StringUtil.isEmpty((String)userInfo.getTenantId())) {
                return this.tableName;
            }
            return userInfo.getTenantId() + "." + this.tableName;
        }
        return this.tableName;
    }

    private void createVectorRenderIndex(IFeatureClass featureClass) {
        String dsKey = this.dataSourceManager.getSystemDataSourceDetail().getKey();
        String datasetId = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)featureClass);
        VTileServiceCreateDTO serviceCreateDTO = new VTileServiceCreateDTO();
        serviceCreateDTO.setDatasetId(datasetId);
        serviceCreateDTO.setServiceName("_hotRegion");
        serviceCreateDTO.setStyleJson(this.getDefaultStyleJson("tbdm_districthot"));
        serviceCreateDTO.setStyleId("_hotRegion");
        this.renderIndexService.createVectorRenderIndex(serviceCreateDTO);
    }

    private String getDefaultStyleJson(String datasetName) {
        JSONObject renderStyle = new JSONObject(true);
        JSONObject background = new JSONObject(true);
        background.put("backgroundColor", (Object)"#000000");
        background.put("watermark", (Object)"");
        background.put("fillOpacity", (Object)50);
        background.put("waterMarkOpacity", (Object)100);
        background.put("rule", (Object)"across");
        renderStyle.put("background", (Object)background);
        renderStyle.put("GlobalStyle", (Object)new JSONObject());
        renderStyle.put("layers", (Object)VTileServiceStyle.getLayers((String)datasetName, (String)"polygon"));
        renderStyle.put("styles", (Object)this.getStyles(datasetName, "polygon"));
        return renderStyle.toJSONString();
    }

    private JSONObject getStyles(String dataServiceName, String type) {
        JSONObject styles = new JSONObject(true);
        JSONArray items = new JSONArray();
        JSONObject item = VTileServiceStyle.getUnitStyles((String)dataServiceName, (String)type, (String)dataServiceName, (String)"", (String)"", (String)"#f5dcbb", (boolean)true);
        item.getJSONArray("style").getJSONObject(0).put("fillOpacity", (Object)1.0);
        items.add((Object)item);
        styles.put("1-30", (Object)items);
        return styles;
    }
}

