/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchDeleteDTO;
import com.geoway.adf.dms.datasource.dto.edit.DataBatchUpdateDTO;
import com.geoway.adf.dms.datasource.dto.edit.GeoDataEditDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseEditService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoTableQueryCheckUtil;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GeoDatabaseEditServiceImpl
implements GeoDatabaseEditService {
    private static final Logger log = LoggerFactory.getLogger(GeoDatabaseEditServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoServerEngineService geoServerEngineService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object insertData(GeoDataEditDTO geoDataEditDTO) {
        Assert.notNull((Object)geoDataEditDTO.getDatasetId(), (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(geoDataEditDTO.getDatasetId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
            IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, datasetNameInfo.getName());
            Assert.notNull((Object)dataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            Object objectId = this.insert(dataset, geoDataEditDTO);
            this.sysLogService.addLog(101, String.format("\u63d2\u51651\u6761\u6570\u636e\uff1a%s > %s", dataSourceDTO.getName(), dataset.getFullName()));
            if (Boolean.TRUE.equals(geoDataEditDTO.getUpdateRenderIndex())) {
                this.updateRenderIndex(geoDataEditDTO.getDatasetId());
            }
            Object object = objectId;
            return object;
        }
    }

    @Override
    public List<Object> batchInsertData(List<GeoDataEditDTO> geoDataEditDTOs) {
        LinkedHashMap<String, List> datasetGroup = new LinkedHashMap<String, List>();
        for (GeoDataEditDTO geoDataEditDTO : geoDataEditDTOs) {
            Assert.notNull((Object)geoDataEditDTO.getDatasetId(), (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            List datas = datasetGroup.computeIfAbsent(geoDataEditDTO.getDatasetId(), k -> new ArrayList());
            datas.add(geoDataEditDTO);
        }
        ArrayList<IFeatureWorkspace> workspaces = new ArrayList<IFeatureWorkspace>();
        ArrayList<Object> resultIds = new ArrayList<Object>();
        try {
            ArrayList<String> sysLogs = new ArrayList<String>();
            for (Object datasetId : datasetGroup.keySet()) {
                DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
                DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
                IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
                Assert.notNull((Object)workspace, (String)(dataSourceDTO.getName() + "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01"));
                workspaces.add(workspace);
                GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
                IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, datasetNameInfo.getName());
                Assert.notNull((Object)dataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                workspace.beginTransaction();
                for (GeoDataEditDTO geoDataEditDTO : (List)datasetGroup.get(datasetId)) {
                    resultIds.add(this.insert(dataset, geoDataEditDTO));
                }
                sysLogs.add(String.format("\u63d2\u5165%d\u6761\u6570\u636e\uff1a%s > %s", ((List)datasetGroup.get(datasetId)).size(), dataSourceDTO.getName(), dataset.getFullName()));
            }
            for (IFeatureWorkspace workspace : workspaces) {
                workspace.commitTransaction();
            }
            for (String log : sysLogs) {
                this.sysLogService.addLog(101, log);
            }
            for (Object datasetId : datasetGroup.keySet()) {
                if (!Boolean.TRUE.equals(((GeoDataEditDTO)((List)datasetGroup.get(datasetId)).get(0)).getUpdateRenderIndex())) continue;
                this.updateRenderIndex((String)datasetId);
            }
            ArrayList<Object> arrayList = resultIds;
            return arrayList;
        }
        catch (Exception e) {
            try {
                for (IFeatureWorkspace workspace : workspaces) {
                    if (!workspace.getInTransaction()) continue;
                    workspace.rollbackTransaction();
                }
            }
            catch (Exception e2) {
                log.error("\u56de\u6eda\u4e8b\u52a1\u5f02\u5e38", (Throwable)e2);
            }
            throw e;
        }
        finally {
            for (IFeatureWorkspace workspace : workspaces) {
                workspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object insert(IGeoDataset dataset, GeoDataEditDTO geoDataEditDTO) {
        if (dataset.getType() == GeoDatasetType.FeatureClass) {
            IFeatureClass featureClass = (IFeatureClass)dataset;
            IFeature feature = featureClass.createFeature();
            if (geoDataEditDTO.getWkt() != null) {
                IGeometry geometry = GeometryFunc.createGeometry((String)geoDataEditDTO.getWkt());
                if (geometry == null) {
                    throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e0d\u6b63\u786e");
                }
                feature.setGeometry(geometry);
            }
            if (geoDataEditDTO.getData() != null) {
                for (String fldName : geoDataEditDTO.getData().keySet()) {
                    if (!feature.getFields().contains(fldName)) {
                        throw new RuntimeException(String.format("[%s]\u5b57\u6bb5\u4e0d\u5b58\u5728", fldName));
                    }
                    feature.setValue(fldName, geoDataEditDTO.getData().get(fldName));
                }
            }
            IFeatureCursor cursor = featureClass.insertFeature();
            try {
                cursor.insertFeature(feature);
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
            return feature.getObjectId();
        }
        if (dataset.getType() == GeoDatasetType.Table) {
            ITable table = (ITable)dataset;
            IRow row = table.createRow();
            if (geoDataEditDTO.getData() != null) {
                for (String fldName : geoDataEditDTO.getData().keySet()) {
                    if (!row.getFields().contains(fldName)) {
                        throw new RuntimeException(String.format("[%s]\u5b57\u6bb5\u4e0d\u5b58\u5728", fldName));
                    }
                    row.setValue(fldName, geoDataEditDTO.getData().get(fldName));
                }
            }
            ICursor cursor = table.insertRow();
            try {
                cursor.insertRow(row);
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
            return row.getObjectId();
        }
        throw new RuntimeException(dataset.getFullName() + ":" + dataset.getType() + " \u4e0d\u652f\u6301\u7f16\u8f91");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateData(GeoDataEditDTO geoDataEditDTO) {
        Assert.notNull((Object)geoDataEditDTO.getDatasetId(), (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)geoDataEditDTO.getObjectId(), (String)"\u6570\u636eoid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(geoDataEditDTO.getDatasetId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
            IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, datasetNameInfo.getName());
            Assert.notNull((Object)dataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            boolean result = this.update(dataset, geoDataEditDTO);
            if (result) {
                this.sysLogService.addLog(101, String.format("\u4fee\u65391\u6761\u6570\u636e\uff1a%s > %s", dataSourceDTO.getName(), dataset.getFullName()));
                if (Boolean.TRUE.equals(geoDataEditDTO.getUpdateRenderIndex())) {
                    this.updateRenderIndex(geoDataEditDTO.getDatasetId());
                }
            }
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public boolean batchUpdateData(List<GeoDataEditDTO> geoDataEditDTOs) {
        LinkedHashMap<String, List> datasetGroup = new LinkedHashMap<String, List>();
        for (GeoDataEditDTO geoDataEditDTO : geoDataEditDTOs) {
            Assert.notNull((Object)geoDataEditDTO.getDatasetId(), (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.notNull((Object)geoDataEditDTO.getObjectId(), (String)"\u6570\u636eoid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Iterator<Object> datas = datasetGroup.computeIfAbsent(geoDataEditDTO.getDatasetId(), k -> new ArrayList());
            datas.add(geoDataEditDTO);
        }
        ArrayList<IFeatureWorkspace> workspaces = new ArrayList<IFeatureWorkspace>();
        try {
            ArrayList<String> sysLogs = new ArrayList<String>();
            for (Object datasetId : datasetGroup.keySet()) {
                DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo((String)datasetId);
                DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
                IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
                Assert.notNull((Object)workspace, (String)(dataSourceDTO.getName() + "\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01"));
                workspaces.add(workspace);
                GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
                IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, datasetNameInfo.getName());
                Assert.notNull((Object)dataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                workspace.beginTransaction();
                for (GeoDataEditDTO geoDataEditDTO : (List)datasetGroup.get(datasetId)) {
                    this.update(dataset, geoDataEditDTO);
                }
                sysLogs.add(String.format("\u4fee\u6539%d\u6761\u6570\u636e\uff1a%s > %s", ((List)datasetGroup.get(datasetId)).size(), dataSourceDTO.getName(), dataset.getFullName()));
            }
            for (IFeatureWorkspace workspace : workspaces) {
                workspace.commitTransaction();
            }
            for (String log : sysLogs) {
                this.sysLogService.addLog(101, log);
            }
            for (Object datasetId : datasetGroup.keySet()) {
                if (!Boolean.TRUE.equals(((GeoDataEditDTO)((List)datasetGroup.get(datasetId)).get(0)).getUpdateRenderIndex())) continue;
                this.updateRenderIndex((String)datasetId);
            }
            boolean datas = true;
            return datas;
        }
        catch (Exception e) {
            try {
                for (IFeatureWorkspace workspace : workspaces) {
                    if (!workspace.getInTransaction()) continue;
                    workspace.rollbackTransaction();
                }
            }
            catch (Exception e2) {
                log.error("\u56de\u6eda\u4e8b\u52a1\u5f02\u5e38", (Throwable)e2);
            }
            throw e;
        }
        finally {
            for (IFeatureWorkspace workspace : workspaces) {
                workspace.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(IGeoDataset dataset, GeoDataEditDTO geoDataEditDTO) {
        ITable table = null;
        IField shapeField = null;
        if (dataset.getType() == GeoDatasetType.Table) {
            if (geoDataEditDTO.getData() == null || geoDataEditDTO.getData().size() == 0) {
                return true;
            }
            table = (ITable)dataset;
        } else {
            if (geoDataEditDTO.getWkt() == null && (geoDataEditDTO.getData() == null || geoDataEditDTO.getData().size() == 0)) {
                return true;
            }
            IFeatureClass featureClass = null;
            if (dataset.getType() == GeoDatasetType.FeatureClass) {
                featureClass = (IFeatureClass)dataset;
            } else if (dataset.getType() == GeoDatasetType.MosaicDataset) {
                featureClass = ((IMosaicDataset)dataset).getCatalog();
            } else {
                throw new RuntimeException(dataset.getName() + ":" + dataset.getType() + " \u4e0d\u652f\u6301\u7f16\u8f91");
            }
            table = (ITable)featureClass;
            shapeField = featureClass.getFields().findField(featureClass.getShapeFieldName());
        }
        Assert.notNull((Object)table.getOidFieldName(), (String)(dataset.getName() + " \u6ca1\u6709\u4e3b\u952e\uff0c\u4e0d\u652f\u6301\u7f16\u8f91"));
        IField oidField = table.getFields().findField(table.getOidFieldName());
        Assert.notNull((Object)oidField, (String)(table.getOidFieldName() + " \u4e3b\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01"));
        String oidFieldName = oidField.getName();
        if (StringUtil.isNotEmpty((String)oidField.getPhysicalName())) {
            oidFieldName = "\"" + oidField.getPhysicalName() + "\"";
        }
        ArrayList<String> updateFieldNames = new ArrayList<String>();
        updateFieldNames.add(table.getOidFieldName());
        for (String fld : geoDataEditDTO.getData().keySet()) {
            if (fld.equalsIgnoreCase(table.getOidFieldName())) continue;
            if (table.getFields().contains(fld)) {
                updateFieldNames.add(fld);
                continue;
            }
            throw new RuntimeException(fld + " \u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        if (geoDataEditDTO.getWkt() != null && shapeField != null) {
            updateFieldNames.add(shapeField.getName());
        }
        QueryFilter filter = new QueryFilter();
        filter.setSubFields(String.join((CharSequence)",", updateFieldNames));
        filter.setWhereClause(oidFieldName + "=" + geoDataEditDTO.getObjectId());
        ICursor cursor = table.updateRow((IQueryFilter)filter);
        try {
            IRow row = cursor.nextRow();
            Assert.notNull((Object)row, (String)String.format("[%s]->[%s]\u6570\u636e\u4e0d\u5b58\u5728", dataset.getName(), geoDataEditDTO.getObjectId()));
            for (String fldName : geoDataEditDTO.getData().keySet()) {
                row.setValue(fldName, geoDataEditDTO.getData().get(fldName));
            }
            if (geoDataEditDTO.getWkt() != null && shapeField != null) {
                IGeometry geometry = GeometryFunc.createGeometry((String)geoDataEditDTO.getWkt());
                if (geometry == null) {
                    throw new RuntimeException("\u51e0\u4f55\u56fe\u5f62\u4e0d\u6b63\u786e");
                }
                row.setValue(shapeField.getName(), (Object)geometry);
            }
            boolean bl = cursor.updateRow(row);
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
        }
    }

    @Override
    public boolean deleteData(String datasetId, String objectId, Boolean updateRenderIndex) {
        Assert.notNull((Object)datasetId, (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)objectId, (String)"\u6570\u636eoid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            String[] ids;
            IGeoDataset geoDataset = GeoDatasetUtil.openDataset(workspace, GeoDatasetType.getByValue((Integer)datasetNameInfo.getType()), datasetNameInfo.getName());
            Assert.notNull((Object)geoDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            ITable table = null;
            if (geoDataset instanceof ITable) {
                table = (ITable)geoDataset;
            } else if (geoDataset instanceof IMosaicDataset) {
                table = (ITable)((IMosaicDataset)geoDataset).getCatalog();
            }
            if (table == null) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b");
            }
            workspace.beginTransaction();
            for (String id : ids = objectId.split(",")) {
                table.deleteRow((Object)id);
            }
            workspace.commitTransaction();
            this.sysLogService.addLog(101, String.format("\u5220\u9664%d\u6761\u6570\u636e\uff1a%s > %s", ids.length, dataSourceDTO.getName(), datasetNameInfo.getName()));
            if (Boolean.TRUE.equals(updateRenderIndex)) {
                this.updateRenderIndex(datasetId);
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long batchUpdateDataByFilter(DataBatchUpdateDTO dataBatchUpdateDTO) {
        Assert.notNull((Object)dataBatchUpdateDTO.getDatasetId(), (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dataBatchUpdateDTO.getUpdateField(), (String)"\u66f4\u65b0\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)dataBatchUpdateDTO.getUpdateValueScript(), (String)"\u66f4\u65b0\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(dataBatchUpdateDTO.getDatasetId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        QueryFilterBasicDTO checkFilter = new QueryFilterBasicDTO();
        checkFilter.setCondition(dataBatchUpdateDTO.getCondition());
        checkFilter.setFields(dataBatchUpdateDTO.getUpdateValueScript());
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), checkFilter);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            String tableFullName;
            IGeoDataset geoDataset = GeoDatasetUtil.openDataset(workspace, GeoDatasetType.getByValue((Integer)datasetNameInfo.getType()), datasetNameInfo.getName());
            Assert.notNull((Object)geoDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            ITable table = null;
            if (geoDataset instanceof ITable) {
                table = (ITable)geoDataset;
            } else if (geoDataset instanceof IMosaicDataset) {
                table = (ITable)((IMosaicDataset)geoDataset).getCatalog();
            }
            if (table == null) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b");
            }
            int index = geoDataset.getFullName().indexOf(".");
            if (index > 0) {
                String schema = geoDataset.getFullName().substring(0, index);
                String tableName = geoDataset.getFullName().substring(index + 1);
                tableFullName = schema + ".\"" + tableName + "\"";
            } else {
                tableFullName = "\"" + geoDataset.getFullName() + "\"";
            }
            IField updateField = table.getFields().findField(dataBatchUpdateDTO.getUpdateField());
            Assert.notNull((Object)updateField, (String)(dataBatchUpdateDTO.getUpdateField() + " \u66f4\u65b0\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01"));
            String updateFieldName = updateField.getName();
            if (StringUtil.isNotEmpty((String)updateField.getPhysicalName())) {
                updateFieldName = "\"" + updateField.getPhysicalName() + "\"";
            }
            SpatialQueryFilter queryFilter = SpatailQueryUtil.buildFilter(dataBatchUpdateDTO, (IGeoDataset)table);
            String whereClause = ((JdbcWorkspace)workspace).getWhereClause(table, (IQueryFilter)queryFilter);
            String updateSQL = String.format("UPDATE %s SET %s=%s %s", tableFullName, updateFieldName, dataBatchUpdateDTO.getUpdateValueScript(), StringUtil.isEmpty((String)whereClause) ? "" : whereClause);
            int count = workspace.excuteSql(updateSQL);
            if (count > 0) {
                this.sysLogService.addLog(101, String.format("\u4fee\u6539%d\u6761\u6570\u636e\uff1a%s > %s", count, dataSourceDTO.getName(), datasetNameInfo.getName()));
                if (Boolean.TRUE.equals(dataBatchUpdateDTO.getUpdateRenderIndex())) {
                    this.updateRenderIndex(dataBatchUpdateDTO.getDatasetId());
                }
            }
            long l = count;
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long deleteDataByFilter(DataBatchDeleteDTO dataBatchDeleteDTO) {
        Assert.notNull((Object)dataBatchDeleteDTO.getDatasetId(), (String)"\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(dataBatchDeleteDTO.getDatasetId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        QueryFilterBasicDTO checkFilter = new QueryFilterBasicDTO();
        checkFilter.setCondition(dataBatchDeleteDTO.getCondition());
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), checkFilter);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IGeoDataset geoDataset = GeoDatasetUtil.openDataset(workspace, GeoDatasetType.getByValue((Integer)datasetNameInfo.getType()), datasetNameInfo.getName());
            Assert.notNull((Object)geoDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            ITable table = null;
            if (geoDataset instanceof ITable) {
                table = (ITable)geoDataset;
            } else if (geoDataset instanceof IMosaicDataset) {
                table = (ITable)((IMosaicDataset)geoDataset).getCatalog();
            }
            if (table == null) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b");
            }
            SpatialQueryFilter queryFilter = SpatailQueryUtil.buildFilter(dataBatchDeleteDTO, (IGeoDataset)table);
            long count = table.deleteRow((IQueryFilter)queryFilter);
            if (count > 0L) {
                this.sysLogService.addLog(101, String.format("\u5220\u9664%d\u6761\u6570\u636e\uff1a%s > %s", count, dataSourceDTO.getName(), datasetNameInfo.getName()));
                if (Boolean.TRUE.equals(dataBatchDeleteDTO.getUpdateRenderIndex())) {
                    this.updateRenderIndex(dataBatchDeleteDTO.getDatasetId());
                }
            }
            long l = count;
            return l;
        }
    }

    private void updateRenderIndex(String datasetId) {
        try {
            DatasetRenderDTO datasetRenderDTO = this.dataSourceManager.getDatasetRender(datasetId);
            if (datasetRenderDTO != null && Boolean.TRUE.equals(datasetRenderDTO.getIsCreate()) && !StringUtil.isEmptyOrWhiteSpace((String)datasetRenderDTO.getServerKey())) {
                DataSourceDTO serverSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetRenderDTO.getServerKey());
                IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
                IGeoService geoService = geoServer.getService(ServiceType.getByValue((Integer)datasetRenderDTO.getServiceType()), datasetRenderDTO.getServiceName());
                if (geoService != null) {
                    geoServer.reCreateCache(geoService);
                } else {
                    log.error(datasetRenderDTO.getServiceName() + "\u6e32\u67d3\u7d22\u5f15\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7d22\u5f15\u5f02\u5e38", (Throwable)e);
        }
    }
}

