/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dao.DmThumbDao;
import com.geoway.adf.dms.datasource.dto.datum.ThumbDTO;
import com.geoway.adf.dms.datasource.dto.datum.create.ThumbCreateDTO;
import com.geoway.adf.dms.datasource.entity.DmThumb;
import com.geoway.adf.dms.datasource.service.ThumbService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import sun.misc.BASE64Encoder;

@Service
public class ThumbServiceImpl
implements ThumbService {
    private static final Logger log = LoggerFactory.getLogger(ThumbServiceImpl.class);
    @Resource
    private DmThumbDao dmThumbDao;

    @Override
    public String insertThumb(ThumbCreateDTO createDTO) {
        Assert.notNull((Object)createDTO.getImage(), (String)"\u8bf7\u8bbe\u7f6e\u62c7\u6307\u56fe\uff01");
        DmThumb thumb = new DmThumb();
        if (StringUtil.isEmptyOrWhiteSpace((String)createDTO.getCustomKey())) {
            thumb.setId(UUID.randomUUID().toString().replace("-", ""));
            DmThumb sameThumb = this.dmThumbDao.selectByDataId(createDTO.getDataId(), createDTO.getSize());
            if (sameThumb != null) {
                this.dmThumbDao.deleteByPrimaryKey(sameThumb.getId());
            }
        } else {
            thumb.setId(createDTO.getCustomKey());
            DmThumb sameThumb = this.dmThumbDao.selectByPrimaryKey(createDTO.getCustomKey());
            if (sameThumb != null) {
                this.dmThumbDao.deleteByPrimaryKey(sameThumb.getId());
            }
        }
        thumb.setDatasetId(createDTO.getDatasetId());
        thumb.setImage(this.getBase64Image(createDTO.getImage()).getBytes(StandardCharsets.UTF_8));
        thumb.setXSize(createDTO.getSize());
        thumb.setYSize(createDTO.getSize());
        thumb.setDataId(createDTO.getDataId());
        thumb.setOffset(0);
        this.dmThumbDao.insert(thumb);
        return thumb.getId();
    }

    @Override
    public ThumbDTO queryThumb(String dataId, Integer size) {
        DmThumb thumb = this.dmThumbDao.selectByDataId(dataId, size);
        return thumb == null ? null : this.convertThumbDTO(thumb);
    }

    @Override
    public List<ThumbDTO> queryThumbs(List<String> dataIds, Integer size) {
        if (dataIds == null || dataIds.size() == 0) {
            return null;
        }
        List<DmThumb> list = this.dmThumbDao.selectByDataIds(dataIds, size);
        return list.size() == 0 ? new ArrayList() : ListUtil.convertAll(list, this::convertThumbDTO);
    }

    @Override
    public ThumbDTO queryThumb(String customKey) {
        DmThumb thumb = this.dmThumbDao.selectByPrimaryKey(customKey);
        return thumb == null ? null : this.convertThumbDTO(thumb);
    }

    private String getBase64Image(byte[] bytes) {
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            String picture = encoder.encodeBuffer(bytes).trim();
            picture = picture.replaceAll("\n", "").replaceAll("\r", "");
            String format = "image/png";
            picture = "data:" + format + ";base64," + picture;
            return picture;
        }
        catch (Exception e) {
            throw new RuntimeException("\u76ee\u5f55\u56fe\u7247\u4fdd\u5b58\u5931\u8d25\uff01", e);
        }
    }

    private ThumbDTO convertThumbDTO(DmThumb thumb) {
        ThumbDTO dto = new ThumbDTO();
        dto.setId(thumb.getId());
        dto.setDataId(thumb.getDataId());
        dto.setSize(thumb.getXSize());
        dto.setImageBase64(new String((byte[])thumb.getImage(), StandardCharsets.UTF_8));
        return dto;
    }
}

