/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.PinyinUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ServiceFormatEnum;
import com.geoway.adf.dms.datasource.constant.TileFileSourceFormatEnum;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.RasterDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TileDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datasource.TileFileDataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatabaseDTO;
import com.geoway.adf.dms.datasource.dto.datum.DatumDatasetDTO;
import com.geoway.adf.dms.datasource.dto.model.ModelDatasetDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.IMEServiceCreateDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.RenderIndexResultDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.RenderIndexSelectDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTileServiceCreateDTO;
import com.geoway.adf.dms.datasource.geosrv.AtlasServer;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.service.RenderIndexService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.ITableView;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.ime.IMEDatasourceType;
import com.geoway.adf.gis.geosrv.ime.IMEServer;
import com.geoway.adf.gis.geosrv.ime.IMEServicePublishParams;
import com.geoway.adf.gis.geosrv.publish.IServicePublishParams;
import com.geoway.adf.gis.geosrv.publish.PublishDataset;
import com.geoway.adf.gis.geosrv.vtile.VTileDatasourceType;
import com.geoway.adf.gis.geosrv.vtile.VTileGrid;
import com.geoway.adf.gis.geosrv.vtile.VTileServer;
import com.geoway.adf.gis.geosrv.vtile.VTileService;
import com.geoway.adf.gis.geosrv.vtile.VTileServicePublishParams;
import com.geoway.adf.gis.geosrv.vtile.VTileServiceStyle;
import com.geoway.adf.gis.tile.TileType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class RenderIndexServiceImpl
implements RenderIndexService {
    private static final Logger log = LoggerFactory.getLogger(RenderIndexServiceImpl.class);
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoServerEngineService geoServerEngineService;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;

    @Override
    public List<RenderIndexResultDTO> createVectorRenderIndex(List<VTileServiceCreateDTO> serviceCreateDTOs) {
        ArrayList<RenderIndexResultDTO> resultDTOS = new ArrayList<RenderIndexResultDTO>();
        for (VTileServiceCreateDTO serviceCreateDTO : serviceCreateDTOs) {
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(serviceCreateDTO.getDatasetId());
            RenderIndexResultDTO resultDTO = new RenderIndexResultDTO();
            resultDTO.setDatasetId(serviceCreateDTO.getDatasetId());
            resultDTO.setDatasetName(datasetNameInfo.getName());
            resultDTOS.add(resultDTO);
            try {
                DatasetRenderDTO renderDTO = this.createVectorRenderIndex(serviceCreateDTO);
                resultDTO.setRender(renderDTO);
                resultDTO.setSuccess(true);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                resultDTO.setSuccess(false);
                resultDTO.setMessage(e.getMessage());
            }
        }
        return resultDTOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetRenderDTO createVectorRenderIndex(VTileServiceCreateDTO serviceCreateDTO) {
        List grids;
        IGeoDataset geoDataset;
        IGeoService geoService;
        DataSourceDTO serverSourceDTO;
        if (StringUtil.isNotEmpty((String)serviceCreateDTO.getServerKey())) {
            serverSourceDTO = this.dataSourceService.getDataSourceDetail(serviceCreateDTO.getServerKey());
        } else {
            serverSourceDTO = this.getDefaultGeoServerSource(DataSourceTypeEnum.VTileServer);
            serviceCreateDTO.setServerKey(serverSourceDTO.getKey());
        }
        IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
        String datasetId = serviceCreateDTO.getDatasetId();
        DatasetNameInfo nameInfo = new DatasetNameInfo(datasetId);
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(nameInfo.getType());
        switch (datasetType) {
            case FeatureClass: 
            case Table: 
            case TableView: {
                break;
            }
            case MosaicDataset: {
                MosaicDatasetDTO mosaicDatasetDTO = (MosaicDatasetDTO)this.dataSourceService.getDatasetDetail(serviceCreateDTO.getDatasetId());
                datasetId = mosaicDatasetDTO.getCatalogDatasetId();
                nameInfo = new DatasetNameInfo(datasetId);
                break;
            }
            case DatumDataset: {
                DatumDatasetDTO datumDatasetDTO = (DatumDatasetDTO)this.dataSourceService.getDatasetDetail(serviceCreateDTO.getDatasetId());
                datasetId = datumDatasetDTO.getGeoDatasetId();
                nameInfo = new DatasetNameInfo(datasetId);
                break;
            }
            case ModelDataset: {
                ModelDatasetDTO modelDatasetDTO = (ModelDatasetDTO)this.dataSourceService.getDatasetDetail(serviceCreateDTO.getDatasetId());
                datasetId = modelDatasetDTO.getGeoDatasetId();
                nameInfo = new DatasetNameInfo(datasetId);
                break;
            }
        }
        DatasetRenderDTO datasetRender = this.dataSourceManager.getDatasetRender(datasetId);
        if (datasetRender != null && Boolean.TRUE.equals(datasetRender.getIsCreate()) && datasetRender.getServiceName().equals(serviceCreateDTO.getServiceName()) && (geoService = geoServer.getService(ServiceType.VectorTileService, datasetRender.getServiceName())) != null) {
            geoServer.reCreateCache(geoService);
            return datasetRender;
        }
        ArrayList<String> publishFields = new ArrayList<String>();
        String oidFieldName = null;
        String shapeFieldName = null;
        FeatureType featureType = FeatureType.Unknown;
        Double centerX = null;
        Double centerY = null;
        Integer gridUnit = null;
        Integer srid = null;
        DatabaseDTO geoDataSource = this.geoDatabaseService.getDatabaseDetail(nameInfo.getDsKey());
        DataSourceTypeEnum geoDataSourcType = DataSourceTypeEnum.getByValue(geoDataSource.getDataSourceType());
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(geoDataSource);){
            geoDataset = workspace.openGeoDataset(nameInfo.getName());
            Assert.notNull((Object)geoDataset, (String)(nameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            IFields fields = null;
            if (geoDataset instanceof IFeatureClass) {
                IFeatureClass featureClass = (IFeatureClass)geoDataset;
                fields = featureClass.getFields();
                shapeFieldName = this.getPublishFieldName(geoDataSourcType, featureClass.getFields().findField(featureClass.getShapeFieldName()));
                oidFieldName = this.getPublishFieldName(geoDataSourcType, featureClass.getFields().findField(featureClass.getOidFieldName()));
                featureType = featureClass.getFeatureType();
                if (featureClass.getExtent() != null && !featureClass.getExtent().isEmpty()) {
                    centerX = (featureClass.getExtent().getXMax() + featureClass.getExtent().getXMin()) / 2.0;
                    centerY = (featureClass.getExtent().getYMax() + featureClass.getExtent().getYMin()) / 2.0;
                }
                if (featureClass.getSpatialReferenceSystem() != null) {
                    if (featureClass.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Projected) {
                        gridUnit = 0;
                    }
                    srid = featureClass.getSpatialReferenceSystem().getSrid();
                }
            } else if (geoDataset instanceof ITableView) {
                ITableView tableView = (ITableView)geoDataset;
                featureType = tableView.getFeatureType();
                if (tableView instanceof ITable) {
                    ITable table = (ITable)geoDataset;
                    fields = table.getFields();
                    for (IField field : fields) {
                        if (field.getFieldType() == FieldType.OID) {
                            if (oidFieldName != null) continue;
                            oidFieldName = this.getPublishFieldName(geoDataSourcType, field);
                            continue;
                        }
                        if (field.getFieldType() != FieldType.Shape || shapeFieldName != null) continue;
                        shapeFieldName = this.getPublishFieldName(geoDataSourcType, field);
                        GeometryField geometryField = (GeometryField)field;
                        if (geometryField.getSpatialReferenceSystem() == null) continue;
                        if (geometryField.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Projected) {
                            gridUnit = 0;
                        }
                        srid = geometryField.getSpatialReferenceSystem().getSrid();
                    }
                }
            } else {
                throw new RuntimeException(geoDataset.getName() + ":" + geoDataset.getType() + "\u4e0d\u652f\u6301\u521b\u5efa\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15");
            }
            if (shapeFieldName == null) {
                throw new RuntimeException(geoDataset.getName() + "\u4e0d\u5b58\u5728\u51e0\u4f55\u5b57\u6bb5");
            }
            if (serviceCreateDTO.getFields() == null) {
                for (IField field : fields) {
                    publishFields.add(this.getPublishFieldName(geoDataSourcType, field));
                }
            } else {
                publishFields.add(shapeFieldName);
                if (oidFieldName != null) {
                    publishFields.add(oidFieldName);
                }
                for (String fldName : serviceCreateDTO.getFields()) {
                    IField field = fields.findField(fldName);
                    if (field == null || field.getFieldType() == FieldType.OID || field.getFieldType() == FieldType.Shape) continue;
                    publishFields.add(this.getPublishFieldName(geoDataSourcType, field));
                }
            }
        }
        DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(nameInfo.getDsKey(), geoDataset);
        datasetDTO.setDataSource(geoDataSource);
        PublishDataset publishDataset = this.getPublishDataset(datasetDTO, ServiceType.VectorTileService);
        String serviceName = this.generateServiceName(geoServer, ServiceType.VectorTileService, serviceCreateDTO.getServiceName());
        VTileServicePublishParams publishParams = new VTileServicePublishParams();
        publishParams.setPublishDataset(publishDataset);
        publishParams.setServiceName(serviceName);
        publishParams.setServiceAliasName(datasetDTO.getAliasName());
        publishParams.setGridId(serviceCreateDTO.getGridId());
        publishParams.setCacheDatasourceId(serviceCreateDTO.getCacheDatasourceId());
        publishParams.setCutStartLevel(serviceCreateDTO.getCutStartLevel());
        publishParams.setCutEndLevel(serviceCreateDTO.getCutEndLevel());
        publishParams.setFeatureType(Integer.valueOf(featureType.getValue()));
        publishParams.setGeometryField(shapeFieldName);
        publishParams.setFieldNameList(publishFields);
        publishParams.setStyleId(serviceCreateDTO.getStyleId());
        publishParams.setStyleJson(serviceCreateDTO.getStyleJson());
        publishParams.setCreateMapCache(serviceCreateDTO.getCreateMapCache());
        publishParams.setCenterX(centerX);
        publishParams.setCenterY(centerY);
        publishParams.setGridUnit(gridUnit);
        publishParams.setSrid(srid);
        if (StringUtil.isEmptyOrWhiteSpace((String)publishParams.getGridId()) && !StringUtil.isEmptyOrWhiteSpace((String)this.defaultCoordSchemeProperties.getTilingSchemeName()) && (grids = ((VTileServer)geoServer).getGrids()) != null && grids.size() > 0) {
            for (VTileGrid grid : grids) {
                if (!grid.getName().equals(this.defaultCoordSchemeProperties.getTilingSchemeName())) continue;
                publishParams.setGridId(grid.getId());
                break;
            }
        }
        VTileService geoService2 = (VTileService)geoServer.publishService((IServicePublishParams)publishParams);
        if (datasetRender != null && Boolean.TRUE.equals(datasetRender.getIsCreate())) {
            try {
                if (!datasetRender.getServiceName().equals(serviceName)) {
                    geoServer.deleteService(ServiceType.VectorTileService, datasetRender.getServiceName());
                }
            }
            catch (Exception e) {
                log.error("\u670d\u52a1\u5220\u9664\u5931\u8d25\uff1a" + datasetRender.getServiceName(), (Throwable)e);
            }
        }
        DatasetRenderDTO datasetRenderInfo = new DatasetRenderDTO();
        datasetRenderInfo.setIsCreate(true);
        datasetRenderInfo.setServerKey(serviceCreateDTO.getServerKey());
        datasetRenderInfo.setServer(geoServer.getUrl());
        datasetRenderInfo.setServiceName(serviceName);
        datasetRenderInfo.setServiceType(ServiceType.VectorTileService.getValue());
        datasetRenderInfo.setUrl(geoService2.getServiceUrl());
        datasetRenderInfo.setMapServer(geoService2.getMapServerUrl());
        datasetRenderInfo.setStyleId(geoService2.getStyleId());
        datasetRenderInfo.setHasLabel(geoService2.getHasLabel());
        datasetRenderInfo.setServiceCapabilities(geoService2.getServiceCapabilities());
        if (geoServer instanceof AtlasServer) {
            datasetRenderInfo.setServer(((AtlasServer)geoServer).getVTileServer().getUrl());
        }
        this.dataSourceManager.saveDatasetRender(datasetId, datasetRenderInfo);
        this.sysLogService.addLog(141, String.format("\u521b\u5efa[%s > %s]\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\uff1a%s > %s", datasetDTO.getDataSource().getName(), datasetDTO.getName(), serverSourceDTO.getName(), serviceName));
        return datasetRenderInfo;
    }

    @Override
    public List<RenderIndexResultDTO> createRasterRenderIndex(List<IMEServiceCreateDTO> serviceCreateDTOs) {
        ArrayList<RenderIndexResultDTO> resultDTOS = new ArrayList<RenderIndexResultDTO>();
        for (IMEServiceCreateDTO serviceCreateDTO : serviceCreateDTOs) {
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(serviceCreateDTO.getDatasetId());
            RenderIndexResultDTO resultDTO = new RenderIndexResultDTO();
            resultDTO.setDatasetId(serviceCreateDTO.getDatasetId());
            resultDTO.setDatasetName(datasetNameInfo.getName());
            resultDTOS.add(resultDTO);
            try {
                DatasetRenderDTO renderDTO = this.createRasterRenderIndex(serviceCreateDTO);
                resultDTO.setRender(renderDTO);
                resultDTO.setSuccess(true);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                resultDTO.setSuccess(false);
                resultDTO.setMessage(e.getMessage());
            }
        }
        return resultDTOS;
    }

    @Override
    public DatasetRenderDTO createRasterRenderIndex(IMEServiceCreateDTO serviceCreateDTO) {
        return this.createRasterRenderIndex(serviceCreateDTO, false);
    }

    @Override
    public DatasetRenderDTO createRasterRenderIndex(IMEServiceCreateDTO serviceCreateDTO, Boolean withCatalogRenderIndex) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(serviceCreateDTO.getDatasetId());
        if (withCatalogRenderIndex.booleanValue()) {
            DataSourceDTO serverSourceDTO;
            VTileServiceCreateDTO vTileServiceCreateDTO = new VTileServiceCreateDTO();
            MosaicDatasetDTO mosaicDatasetDTO = (MosaicDatasetDTO)datasetDTO;
            vTileServiceCreateDTO.setDatasetId(mosaicDatasetDTO.getCatalogDatasetId());
            DatasetRenderDTO catalogDatasetRender = this.dataSourceManager.getDatasetRender(mosaicDatasetDTO.getCatalogDatasetId());
            if (catalogDatasetRender != null) {
                vTileServiceCreateDTO.setServiceName(catalogDatasetRender.getServiceName());
            } else {
                String catServiceName = serviceCreateDTO.getServiceName();
                if (catServiceName.length() > 56) {
                    catServiceName = catServiceName.substring(0, 56);
                }
                catServiceName = catServiceName + "_cat";
                vTileServiceCreateDTO.setServiceName(catServiceName);
            }
            if (StringUtil.isNotEmpty((String)serviceCreateDTO.getServerKey()) && (serverSourceDTO = this.dataSourceService.getDataSourceDetail(serviceCreateDTO.getServerKey())).getDataSourceType().intValue() == DataSourceTypeEnum.AtlasServer.getValue()) {
                vTileServiceCreateDTO.setServerKey(serviceCreateDTO.getServerKey());
            }
            if (StringUtil.isEmptyOrWhiteSpace((String)serviceCreateDTO.getCatalogStyleJson())) {
                JSONObject styleJson = VTileServiceStyle.getRenderStyle((String)vTileServiceCreateDTO.getServiceName(), (String)"polygon");
                JSONObject styleLevelMap = styleJson.getJSONObject("styles");
                for (String key : styleLevelMap.keySet()) {
                    JSONArray styles = styleLevelMap.getJSONArray(key).getJSONObject(0).getJSONArray("style");
                    JSONObject item = styles.getJSONObject(0);
                    item.put("fillOpacity", (Object)0);
                    item.put("fill", (Object)false);
                }
                vTileServiceCreateDTO.setStyleJson(JSONObject.toJSONString((Object)styleJson));
            } else {
                vTileServiceCreateDTO.setStyleJson(serviceCreateDTO.getCatalogStyleJson());
            }
            this.createVectorRenderIndex(vTileServiceCreateDTO);
        }
        return this.createIMERenderIndex(datasetDTO, serviceCreateDTO, ServiceType.DTileService);
    }

    @Override
    public DatasetRenderDTO createTileRenderIndex(IMEServiceCreateDTO serviceCreateDTO) {
        ServiceType serviceType;
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(serviceCreateDTO.getDatasetId());
        TileDatasetDTO tileDatasetDTO = (TileDatasetDTO)datasetDTO;
        switch (TileType.getByValue((Integer)tileDatasetDTO.getTileType())) {
            case RasterTile: {
                serviceType = ServiceType.RasterTileService;
                break;
            }
            case TerrainTile: {
                serviceType = ServiceType.TerrainService;
                break;
            }
            case Model3DTile: {
                serviceType = ServiceType.Tiles3dService;
                break;
            }
            default: {
                throw new RuntimeException("\u6570\u636e\u96c6\u4e0d\u652f\u6301\u53d1\u5e03\u670d\u52a1");
            }
        }
        return this.createIMERenderIndex(datasetDTO, serviceCreateDTO, serviceType);
    }

    private DatasetRenderDTO createIMERenderIndex(DatasetDTO datasetDTO, IMEServiceCreateDTO serviceCreateDTO, ServiceType serviceType) {
        IGeoService geoService;
        DataSourceDTO serverSourceDTO;
        if (StringUtil.isNotEmpty((String)serviceCreateDTO.getServerKey())) {
            serverSourceDTO = this.dataSourceService.getDataSourceDetail(serviceCreateDTO.getServerKey());
        } else {
            serverSourceDTO = this.getDefaultGeoServerSource(DataSourceTypeEnum.IMEServer);
            serviceCreateDTO.setServerKey(serverSourceDTO.getKey());
        }
        IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
        DatasetRenderDTO datasetRender = this.dataSourceManager.getDatasetRender(serviceCreateDTO.getDatasetId());
        if (datasetRender != null && Boolean.TRUE.equals(datasetRender.getIsCreate()) && datasetRender.getServiceName().equals(serviceCreateDTO.getServiceName()) && (geoService = geoServer.getService(ServiceType.Unknown, datasetRender.getServiceName())) != null) {
            geoServer.reCreateCache(geoService);
            return datasetRender;
        }
        PublishDataset publishDataset = this.getPublishDataset(datasetDTO, serviceType);
        int idx = datasetDTO.getFullName().indexOf(".");
        String oldFullName = idx > 0 ? datasetDTO.getFullName().substring(0, idx) + "." + datasetDTO.getName() : datasetDTO.getName();
        publishDataset.setDatasetName(oldFullName);
        String serviceName = this.generateServiceName(geoServer, ServiceType.Unknown, serviceCreateDTO.getServiceName());
        IMEServicePublishParams publishParams = new IMEServicePublishParams();
        publishParams.setPublishDataset(publishDataset);
        publishParams.setServiceName(serviceName);
        publishParams.setServiceAliasName(datasetDTO.getAliasName());
        publishParams.setServiceType(serviceType);
        if (serviceType == ServiceType.DTileService && !StringUtil.isEmptyOrWhiteSpace((String)this.defaultCoordSchemeProperties.getTilingSchemeName())) {
            publishParams.setPyramidKey(this.defaultCoordSchemeProperties.getTilingSchemeName());
        }
        IGeoService geoService2 = geoServer.publishService((IServicePublishParams)publishParams);
        if (datasetRender != null && Boolean.TRUE.equals(datasetRender.getIsCreate())) {
            try {
                if (datasetRender.getServiceName().equals(serviceName)) {
                    geoServer.deleteService(geoService2.getServiceType(), datasetRender.getServiceName());
                }
            }
            catch (Exception e) {
                log.error("\u670d\u52a1\u5220\u9664\u5931\u8d25\uff1a" + datasetRender.getServiceName(), (Throwable)e);
            }
        }
        DatasetRenderDTO datasetRenderInfo = new DatasetRenderDTO();
        datasetRenderInfo.setIsCreate(true);
        datasetRenderInfo.setServerKey(serviceCreateDTO.getServerKey());
        datasetRenderInfo.setServer(geoServer.getUrl());
        datasetRenderInfo.setServiceName(serviceName);
        datasetRenderInfo.setServiceType(serviceType.getValue());
        datasetRenderInfo.setUrl(geoService2.getServiceUrl());
        this.dataSourceManager.saveDatasetRender(datasetDTO.getId(), datasetRenderInfo);
        this.sysLogService.addLog(141, String.format("\u521b\u5efa%s[%s > %s]\u6e32\u67d3\u7d22\u5f15\uff1a%s > %s", DatasetTypeEnum.getByValue(datasetDTO.getType()).getDesc(), datasetDTO.getDataSource().getName(), datasetDTO.getName(), serverSourceDTO.getName(), serviceName));
        return datasetRenderInfo;
    }

    @Override
    public void reloadRenderIndexCache(DatasetRenderDTO datasetRenderDTO) {
        if (!StringUtil.isEmptyOrWhiteSpace((String)datasetRenderDTO.getServerKey())) {
            DataSourceDTO serverSourceDTO = this.dataSourceService.getDataSourceDetail(datasetRenderDTO.getServerKey());
            IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
            IGeoService geoService = geoServer.getService(ServiceType.getByValue((Integer)datasetRenderDTO.getServiceType()), datasetRenderDTO.getServiceName());
            if (geoService != null) {
                geoServer.reCreateCache(geoService);
            } else {
                log.error(datasetRenderDTO.getServiceName() + "\u6e32\u67d3\u7d22\u5f15\u4e0d\u5b58\u5728");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetRenderDTO createTempRenderIndex(String datasetId) {
        DataSourceDTO dataSourceDTO;
        DatasetNameInfo datasetNameInfo = new DatasetNameInfo(datasetId);
        DatasetTypeEnum datasetTypeEnum = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
        if (datasetTypeEnum == DatasetTypeEnum.FeatureClass || datasetTypeEnum == DatasetTypeEnum.TableView || datasetTypeEnum == DatasetTypeEnum.DatumDataset || datasetTypeEnum == DatasetTypeEnum.MosaicDataset) {
            FeatureClassDTO featureClassDTO;
            DataSourceDTO serverSourceDTO = this.getDefaultGeoServerSource(DataSourceTypeEnum.VTileServer);
            IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
            DataSourceDTO dataSourceDTO2 = this.dataSourceService.getDataSourceDetail(datasetNameInfo.getDsKey());
            DatasetDTO datasetDTO = null;
            SpatialReferenceSystemType srsType = SpatialReferenceSystemType.Geographic;
            String serviceName = datasetNameInfo.getShortName();
            if (dataSourceDTO2.getDataStoreType().intValue() == DataStoreTypeEnum.DatumDatabase.getValue()) {
                dataSourceDTO2 = ((DatumDatabaseDTO)dataSourceDTO2).getGeoDatabase();
                String geoDatasetId = this.datumDatabaseService.getGeoDatasetId(datasetId);
                Assert.notNull((Object)geoDatasetId, (String)(datasetNameInfo.getName() + " \u6587\u4ef6\u6570\u636e\u96c6\u8bfb\u53d6\u5931\u8d25"));
                datasetNameInfo = new DatasetNameInfo(geoDatasetId);
                if (datasetNameInfo.getType().intValue() != DatasetTypeEnum.FeatureClass.getValue()) {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + (Object)((Object)datasetTypeEnum));
                }
            }
            if (dataSourceDTO2.getDataStoreType().intValue() == DataStoreTypeEnum.GeoDatabase.getValue()) {
                try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO2);){
                    IGeoDataset geoDataset = featureWorkspace.openGeoDataset(datasetNameInfo.getName());
                    Assert.notNull((Object)geoDataset, (String)(datasetNameInfo.getName() + " \u6570\u636e\u96c6\u4e0d\u5b58\u5728"));
                    if (geoDataset.getType() == GeoDatasetType.MosaicDataset) {
                        IMosaicDataset mosaicDataset = (IMosaicDataset)geoDataset;
                        if (mosaicDataset.getSpatialReferenceSystem() != null) {
                            srsType = mosaicDataset.getSpatialReferenceSystem().getType();
                        }
                        datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO2, (IGeoDataset)mosaicDataset.getCatalog());
                    } else if (geoDataset.getType() == GeoDatasetType.FeatureClass) {
                        IFeatureClass featureClass = (IFeatureClass)geoDataset;
                        if (featureClass.getSpatialReferenceSystem() != null) {
                            srsType = featureClass.getSpatialReferenceSystem().getType();
                        }
                        datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO2, geoDataset);
                    } else if (geoDataset.getType() == GeoDatasetType.TableView) {
                        ITableView tableView = (ITableView)geoDataset;
                        if (tableView.getFeatureType() == FeatureType.Unknown) {
                            throw new RuntimeException("\u4e0d\u652f\u6301\u975e\u7a7a\u95f4\u89c6\u56fe\u7c7b\u578b");
                        }
                        for (int i = 0; i < ((ITable)tableView).getFields().getFieldCount(); ++i) {
                            IField field = ((ITable)tableView).getFields().getField(i);
                            if (!(field instanceof GeometryField)) continue;
                            if (((GeometryField)field).getSpatialReferenceSystem() == null) break;
                            srsType = ((GeometryField)field).getSpatialReferenceSystem().getType();
                            break;
                        }
                        datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO2, geoDataset);
                    } else {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + geoDataset.getType());
                    }
                    Long count = geoDataset.getDataCount();
                    if (count != null && count > 1000000L) {
                        log.error(datasetNameInfo.getName());
                        throw new RuntimeException("\u6570\u636e\u96c6\u8981\u7d20\u6570\u91cf\u8d85\u51fa\u9650\u5236");
                    }
                    datasetDTO.setDataSource(dataSourceDTO2);
                }
            } else if (dataSourceDTO2.getDataStoreType().intValue() == DataStoreTypeEnum.FileStorageSystem.getValue()) {
                if (dataSourceDTO2.getDataSourceType().intValue() != DataSourceTypeEnum.ShareFolder.getValue()) {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + dataSourceDTO2.getDataSourceType());
                }
                datasetDTO = this.dataSourceService.getDatasetDetail(dataSourceDTO2, datasetTypeEnum, datasetNameInfo.getName());
                datasetDTO.setDataSource(dataSourceDTO2);
                serviceName = FileUtil.getFileNameWithoutExtension((String)datasetDTO.getName());
                if (datasetDTO instanceof FeatureClassDTO && ((FeatureClassDTO)datasetDTO).getSpatialRef() != null) {
                    srsType = ((FeatureClassDTO)datasetDTO).getSpatialRef().getType();
                }
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5b58\u50a8\u7c7b\u578b\uff1a" + dataSourceDTO2.getDataStoreType());
            }
            PublishDataset publishDataset = this.getPublishDataset(datasetDTO, ServiceType.VectorTileService);
            if ((serviceName = PinyinUtil.convertToPinYin((String)serviceName).toLowerCase(Locale.ROOT)).length() > 30) {
                serviceName = serviceName.substring(0, 30);
            }
            VTileServicePublishParams publishParams = new VTileServicePublishParams();
            publishParams.setPublishDataset(publishDataset);
            publishParams.setServiceName(serviceName);
            publishParams.setServiceAliasName(datasetDTO.getAliasName());
            if (srsType == SpatialReferenceSystemType.Geographic) {
                publishParams.setGridUnit(Integer.valueOf(1));
                publishParams.setGridId("-1");
            } else {
                List grids;
                publishParams.setGridUnit(Integer.valueOf(0));
                if (!StringUtil.isEmptyOrWhiteSpace((String)this.defaultCoordSchemeProperties.getTilingSchemeName()) && (grids = ((VTileServer)geoServer).getGrids()) != null && grids.size() > 0) {
                    for (VTileGrid grid : grids) {
                        if (!grid.getName().equals(this.defaultCoordSchemeProperties.getTilingSchemeName())) continue;
                        publishParams.setGridId(grid.getId());
                        break;
                    }
                }
            }
            VTileService geoService = (VTileService)geoServer.publishTempService((IServicePublishParams)publishParams);
            DatasetRenderDTO datasetRenderInfo = new DatasetRenderDTO();
            datasetRenderInfo.setIsCreate(true);
            datasetRenderInfo.setServerKey(serverSourceDTO.getKey());
            datasetRenderInfo.setServer(geoServer.getUrl());
            datasetRenderInfo.setServiceName(serviceName);
            datasetRenderInfo.setServiceType(ServiceType.VectorTileService.getValue());
            datasetRenderInfo.setUrl(geoService.getServiceUrl());
            datasetRenderInfo.setMapServer(geoService.getMapServerUrl());
            datasetRenderInfo.setStyleId(geoService.getStyleId());
            datasetRenderInfo.setServiceCapabilities(geoService.getServiceCapabilities());
            if (datasetDTO instanceof FeatureClassDTO && (featureClassDTO = (FeatureClassDTO)datasetDTO).getExtent() != null) {
                datasetRenderInfo.setXmin(featureClassDTO.getExtent().getXmin());
                datasetRenderInfo.setYmin(featureClassDTO.getExtent().getYmin());
                datasetRenderInfo.setXmax(featureClassDTO.getExtent().getXmax());
                datasetRenderInfo.setYmax(featureClassDTO.getExtent().getYmax());
            }
            return datasetRenderInfo;
        }
        if (datasetTypeEnum == DatasetTypeEnum.TileDataset) {
            DataSourceDTO dataSourceDTO3 = this.dataSourceService.getDataSourceDetail(datasetNameInfo.getDsKey());
            if (dataSourceDTO3.getDataSourceType().intValue() == DataSourceTypeEnum.ShareFolder.getValue()) {
                DataSourceDTO serverSourceDTO = this.getDefaultGeoServerSource(DataSourceTypeEnum.IMEServer);
                IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
                DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
                PublishDataset publishDataset = this.getPublishDataset(datasetDTO, ServiceType.Unknown);
                IMEServicePublishParams publishParams = new IMEServicePublishParams();
                publishParams.setPublishDataset(publishDataset);
                publishParams.setServiceType(ServiceType.RasterTileService);
                IGeoService geoService = geoServer.publishTempService((IServicePublishParams)publishParams);
                DatasetRenderDTO datasetRenderInfo = new DatasetRenderDTO();
                datasetRenderInfo.setIsCreate(true);
                datasetRenderInfo.setServerKey(serverSourceDTO.getKey());
                datasetRenderInfo.setServer(geoServer.getUrl());
                datasetRenderInfo.setServiceType(ServiceType.RasterTileService.getValue());
                datasetRenderInfo.setUrl(geoService.getServiceUrl());
                datasetRenderInfo.setServiceFormat(ServiceFormatEnum.WMTS.getValue());
                return datasetRenderInfo;
            }
        } else if (datasetTypeEnum == DatasetTypeEnum.RasterDataset && (dataSourceDTO = this.dataSourceService.getDataSourceDetail(datasetNameInfo.getDsKey())).getDataSourceType().intValue() == DataSourceTypeEnum.ShareFolder.getValue()) {
            RasterDatasetDTO rasterDatasetDTO;
            IMEServer imeServer;
            DataSourceDTO serverSourceDTO = this.getDefaultGeoServerSource(DataSourceTypeEnum.IMEServer);
            IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
            if (geoServer instanceof AtlasServer) {
                imeServer = ((AtlasServer)geoServer).getImeServer();
            } else if (geoServer instanceof IMEServer) {
                imeServer = (IMEServer)geoServer;
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578b\uff1a" + serverSourceDTO.getName());
            }
            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(datasetId);
            IGeoService geoService = imeServer.publishTempDTileService(datasetDTO.getFullName(), Integer.valueOf(4490));
            DatasetRenderDTO datasetRenderInfo = new DatasetRenderDTO();
            datasetRenderInfo.setIsCreate(true);
            datasetRenderInfo.setServerKey(serverSourceDTO.getKey());
            datasetRenderInfo.setServer(geoServer.getUrl());
            datasetRenderInfo.setServiceName(geoService.getName());
            datasetRenderInfo.setServiceType(ServiceType.DTileService.getValue());
            datasetRenderInfo.setUrl(geoService.getServiceUrl());
            if (datasetDTO instanceof RasterDatasetDTO && (rasterDatasetDTO = (RasterDatasetDTO)datasetDTO).getExtent() != null) {
                datasetRenderInfo.setXmin(rasterDatasetDTO.getExtent().getXmin());
                datasetRenderInfo.setYmin(rasterDatasetDTO.getExtent().getYmin());
                datasetRenderInfo.setXmax(rasterDatasetDTO.getExtent().getXmax());
                datasetRenderInfo.setYmax(rasterDatasetDTO.getExtent().getYmax());
            }
            return datasetRenderInfo;
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + (Object)((Object)datasetTypeEnum));
    }

    @Override
    public List<RenderIndexResultDTO> saveSelectRenderIndex(List<RenderIndexSelectDTO> serviceSelectDTOs) {
        ArrayList<RenderIndexResultDTO> resultDTOS = new ArrayList<RenderIndexResultDTO>();
        for (RenderIndexSelectDTO serviceSelectDTO : serviceSelectDTOs) {
            DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(serviceSelectDTO.getDatasetId());
            RenderIndexResultDTO resultDTO = new RenderIndexResultDTO();
            resultDTO.setDatasetId(serviceSelectDTO.getDatasetId());
            resultDTO.setDatasetName(datasetNameInfo.getName());
            resultDTOS.add(resultDTO);
            try {
                DatasetRenderDTO renderDTO = this.saveSelectRenderIndex(serviceSelectDTO);
                resultDTO.setRender(renderDTO);
                resultDTO.setSuccess(true);
            }
            catch (RuntimeException e) {
                log.error(e.getMessage(), (Throwable)e);
                resultDTO.setSuccess(false);
                resultDTO.setMessage(e.getMessage());
            }
        }
        return resultDTOS;
    }

    @Override
    public DatasetRenderDTO saveSelectRenderIndex(RenderIndexSelectDTO serviceSelectDTO) {
        DatasetRenderDTO datasetRenderInfo;
        String datasetId;
        DatasetNameInfo nameInfo;
        DatasetTypeEnum datasetType;
        String serverKey = serviceSelectDTO.getServerKey();
        String serviceName = serviceSelectDTO.getServiceName();
        ServiceType serviceType = ServiceType.Unknown;
        if (StringUtil.isNotEmpty((String)serviceSelectDTO.getServiceId())) {
            DatasetNameInfo serviceNameInfo = DatasetUtil.getDatasetNameInfo(serviceSelectDTO.getServiceId());
            serverKey = serviceNameInfo.getDsKey();
            serviceName = serviceNameInfo.getName();
            serviceType = ServiceType.getByValue((Integer)serviceNameInfo.getType());
        }
        if ((datasetType = DatasetTypeEnum.getByValue((nameInfo = DatasetUtil.getDatasetNameInfo(datasetId = serviceSelectDTO.getDatasetId())).getType())) == DatasetTypeEnum.FeatureClass) {
            serviceType = ServiceType.VectorTileService;
        }
        switch (datasetType) {
            case FeatureClass: 
            case Table: 
            case TableView: {
                serviceType = ServiceType.VectorTileService;
                break;
            }
            case MosaicDataset: {
                if (serviceType != ServiceType.VectorTileService) break;
                MosaicDatasetDTO mosaicDatasetDTO = (MosaicDatasetDTO)this.dataSourceService.getDatasetDetail(serviceSelectDTO.getDatasetId());
                datasetId = mosaicDatasetDTO.getCatalogDatasetId();
                break;
            }
            case DatumDataset: {
                if (serviceType != ServiceType.VectorTileService) break;
                DatumDatasetDTO datumDatasetDTO = (DatumDatasetDTO)this.dataSourceService.getDatasetDetail(serviceSelectDTO.getDatasetId());
                datasetId = datumDatasetDTO.getGeoDatasetId();
                break;
            }
            case ModelDataset: {
                if (serviceType != ServiceType.VectorTileService) break;
                ModelDatasetDTO modelDatasetDTO = (ModelDatasetDTO)this.dataSourceService.getDatasetDetail(serviceSelectDTO.getDatasetId());
                datasetId = modelDatasetDTO.getGeoDatasetId();
                break;
            }
        }
        if (!serverKey.equals("service")) {
            DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(serverKey);
            IGeoServer geoServer = this.geoServerEngineService.getGeoServer(dataSourceDTO);
            IGeoService geoService = geoServer.getService(serviceType, serviceName);
            if (geoService == null) {
                throw new RuntimeException(serviceName + "\u670d\u52a1\u4e0d\u5b58\u5728\uff01");
            }
            datasetRenderInfo = new DatasetRenderDTO();
            datasetRenderInfo.setIsCreate(false);
            datasetRenderInfo.setServerKey(serverKey);
            datasetRenderInfo.setServer(geoServer.getUrl());
            datasetRenderInfo.setServiceName(serviceName);
            datasetRenderInfo.setServiceType(geoService.getServiceType().getValue());
            datasetRenderInfo.setUrl(geoService.getServiceUrl());
            if (geoService instanceof VTileService) {
                VTileService vTileService = (VTileService)geoService;
                String styleId = serviceSelectDTO.getStyleId();
                if (StringUtil.isEmptyOrWhiteSpace((String)styleId)) {
                    styleId = vTileService.getStyleId();
                }
                datasetRenderInfo.setMapServer(vTileService.getMapServerUrl());
                datasetRenderInfo.setStyleId(styleId);
                datasetRenderInfo.setHasLabel(vTileService.getHasLabel());
                datasetRenderInfo.setUrl(vTileService.getServiceUrl(styleId));
                datasetRenderInfo.setServiceCapabilities(vTileService.getServiceCapabilities(styleId));
                if (geoServer instanceof AtlasServer) {
                    datasetRenderInfo.setServer(((AtlasServer)geoServer).getVTileServer().getUrl());
                }
            }
        } else {
            DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(serviceSelectDTO.getServiceId());
            if (!(datasetDTO instanceof ServiceDatasetDTO) || datasetDTO.getRender() == null) {
                log.error(serviceSelectDTO.getServiceId());
                throw new RuntimeException("\u6e32\u67d3\u7d22\u5f15\u670d\u52a1\u4e0d\u6b63\u786e\uff01");
            }
            datasetRenderInfo = new DatasetRenderDTO();
            BeanUtils.copyProperties((Object)datasetDTO.getRender(), (Object)datasetRenderInfo);
            datasetRenderInfo.setServiceId(serviceSelectDTO.getServiceId());
        }
        this.dataSourceManager.saveDatasetRender(datasetId, datasetRenderInfo);
        return datasetRenderInfo;
    }

    @Override
    public void deleteDatasetRender(String datasetId) {
        DatasetMetaDTO datasetMetaDTO;
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
        String datasourceName = this.dataSourceManager.getDataSourceName(datasetNameInfo.getDsKey());
        if (datasetType == DatasetTypeEnum.DatumDataset) {
            datasetId = this.datumDatabaseService.getGeoDatasetId(datasetId);
        }
        if (datasetType == DatasetTypeEnum.MosaicDataset) {
            MosaicDatasetDTO mosaicDatasetDTO = (MosaicDatasetDTO)this.dataSourceService.getDatasetDetail(datasetId);
            this.deleteDatasetRender(mosaicDatasetDTO.getCatalogDatasetId());
        }
        if ((datasetMetaDTO = this.dataSourceManager.getDatasetMeta(datasetId)) != null && datasetMetaDTO.getRender() != null) {
            this.dataSourceManager.saveDatasetRender(datasetId, null);
            try {
                if (Boolean.TRUE.equals(datasetMetaDTO.getRender().getIsCreate())) {
                    String serverKey = datasetMetaDTO.getRender().getServerKey();
                    String serviceName = datasetMetaDTO.getRender().getServiceName();
                    ServiceType serviceType = ServiceType.getByValue((Integer)datasetMetaDTO.getRender().getServiceType());
                    DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
                    this.geoServerEngineService.deleteServerService(serverKey, serviceType, serviceName);
                    this.sysLogService.addLog(141, String.format("\u5220\u9664%s[%s > %s]\u6e32\u67d3\u7d22\u5f15\uff1a%s > %s", datasetType.getDesc(), datasourceName, datasetNameInfo.getName(), dataSourceDTO.getName(), serviceName));
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u6e32\u67d3\u7d22\u5f15\u670d\u52a1\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PublishDataset getPublishDataset(DatasetDTO datasetDTO, ServiceType serviceType) {
        int dbType;
        PublishDataset publishDataset;
        block32: {
            DataSourceTypeEnum dataSourceTypeEnum;
            DataSourceDTO dataSourceDTO;
            block31: {
                dataSourceDTO = datasetDTO.getDataSource();
                publishDataset = new PublishDataset();
                publishDataset.setDatasetName(datasetDTO.getFullName());
                publishDataset.setDbUrl(dataSourceDTO.getUrl());
                publishDataset.setDbUser(dataSourceDTO.getUserName());
                publishDataset.setDbPassword(dataSourceDTO.getPassword());
                dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType());
                if (serviceType != ServiceType.VectorTileService) break block31;
                switch (dataSourceTypeEnum) {
                    case OracleSpatial: {
                        dbType = VTileDatasourceType.oracle.value;
                        break block32;
                    }
                    case PostgreSql: 
                    case Highgo: 
                    case GaussDB: {
                        dbType = VTileDatasourceType.postgresql.value;
                        break block32;
                    }
                    case KingBase: {
                        dbType = VTileDatasourceType.kingbase.value;
                        break block32;
                    }
                    case HighgoSecurity: {
                        dbType = VTileDatasourceType.highgo.value;
                        break block32;
                    }
                    case MySql: {
                        dbType = VTileDatasourceType.mysql.value;
                        break block32;
                    }
                    case MongoDB: {
                        dbType = VTileDatasourceType.mongodb.value;
                        break block32;
                    }
                    case ShareFolder: {
                        String ext = FileUtil.getExtension((String)datasetDTO.getFullName()).toLowerCase();
                        if (ext.equals(".shp")) {
                            dbType = VTileDatasourceType.shapefile.value;
                            publishDataset.setDatasetName(FileUtil.getFileNameWithoutExtension((String)datasetDTO.getName()));
                            publishDataset.setDbUrl(datasetDTO.getFullName());
                        } else {
                            String parentPath = FileUtil.getDirectoryName((String)datasetDTO.getFullName());
                            if (!parentPath.endsWith(".gdb")) throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\uff1a" + datasetDTO.getFullName());
                            dbType = VTileDatasourceType.filegdb.value;
                            publishDataset.setDatasetName(datasetDTO.getName());
                            publishDataset.setDbUrl(parentPath);
                        }
                        break block32;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
                    }
                }
            }
            block9 : switch (dataSourceTypeEnum) {
                case OracleSpatial: {
                    dbType = IMEDatasourceType.oracle.value;
                    break;
                }
                case PostgreSql: 
                case Highgo: 
                case GaussDB: {
                    dbType = IMEDatasourceType.postgresql.value;
                    break;
                }
                case KingBase: {
                    dbType = IMEDatasourceType.kingbase.value;
                    break;
                }
                case HighgoSecurity: {
                    dbType = IMEDatasourceType.highgo.value;
                    break;
                }
                case MySql: {
                    dbType = IMEDatasourceType.mysql.value;
                    break;
                }
                case MongoDB: {
                    dbType = IMEDatasourceType.mongodb.value;
                    break;
                }
                case ShareFolder: {
                    if (dataSourceDTO instanceof TileFileDataSourceDTO) {
                        TileFileSourceFormatEnum sourceFormatEnum = TileFileSourceFormatEnum.getByValue(((TileFileDataSourceDTO)dataSourceDTO).getTileSourceFormat());
                        String path = dataSourceDTO.getUrl();
                        switch (sourceFormatEnum) {
                            case ArcGIS: {
                                dbType = IMEDatasourceType.arcgisTiles.value;
                                publishDataset.setDbUrl(FileUtil.getDirectoryName((String)path));
                                publishDataset.setDatasetName(FileUtil.getFileName((String)path));
                                break block9;
                            }
                            case MbTiles: {
                                dbType = IMEDatasourceType.mbTiles.value;
                                publishDataset.setDatasetName(FileUtil.getFileName((String)path));
                                break block9;
                            }
                            case Tiles3d: {
                                dbType = IMEDatasourceType.file3dtiles.value;
                                publishDataset.setDbUrl(FileUtil.getDirectoryName((String)path));
                                publishDataset.setDatasetName(FileUtil.getFileName((String)path));
                                break block9;
                            }
                        }
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)sourceFormatEnum));
                    }
                    if (!(datasetDTO instanceof TileDatasetDTO)) throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
                    TileType tileType = TileType.getByValue((Integer)((TileDatasetDTO)datasetDTO).getTileType());
                    String path = datasetDTO.getFullName();
                    switch (tileType) {
                        case RasterTile: {
                            dbType = IMEDatasourceType.arcgisTiles.value;
                            publishDataset.setDbUrl(FileUtil.getDirectoryName((String)path));
                            publishDataset.setDatasetName(FileUtil.getFileName((String)path));
                            break block9;
                        }
                        case TerrainTile: {
                            dbType = IMEDatasourceType.mbTiles.value;
                            publishDataset.setDbUrl(FileUtil.getDirectoryName((String)path));
                            publishDataset.setDatasetName(FileUtil.getFileName((String)path));
                            break block9;
                        }
                        case Model3DTile: {
                            dbType = IMEDatasourceType.file3dtiles.value;
                            publishDataset.setDbUrl(FileUtil.getDirectoryName((String)path));
                            publishDataset.setDatasetName(FileUtil.getFileName((String)path));
                            break block9;
                        }
                    }
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u74e6\u7247\u6570\u636e\u7c7b\u578b\uff1a" + tileType);
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
                }
            }
        }
        publishDataset.setDbType(String.valueOf(dbType));
        return publishDataset;
    }

    private DataSourceDTO getDefaultGeoServerSource(DataSourceTypeEnum serverSourceType) {
        DataSourceDTO serverSourceDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.ServiceServer.getValue(), DataSourceTypeEnum.AtlasServer.getValue());
        if (serverSourceDTO == null && (serverSourceDTO = this.dataSourceService.getDefaultDataSource(DataStoreTypeEnum.ServiceServer.getValue(), serverSourceType.getValue())) == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u670d\u52a1\u5668");
        }
        return serverSourceDTO;
    }

    private String generateServiceName(IGeoServer geoServer, ServiceType serviceType, String serviceName) {
        String newServiceName = serviceName;
        IGeoService service = geoServer.getService(serviceType, serviceName);
        int idx = 0;
        while (service != null) {
            newServiceName = serviceName + "_" + ++idx;
            service = geoServer.getService(serviceType, newServiceName);
        }
        return newServiceName;
    }

    private String getPublishFieldName(DataSourceTypeEnum dataSourceType, IField field) {
        if (StringUtil.isEmpty((String)field.getPhysicalName())) {
            if (dataSourceType == DataSourceTypeEnum.OracleSpatial) {
                return field.getName().toUpperCase();
            }
            return field.getName().toLowerCase();
        }
        return field.getPhysicalName();
    }
}

