/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.DownloadUtil;
import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsDatasetRelationDao;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.create.FieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.query.BufferAnalyseFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.dto.query.StatMethodEnum;
import com.geoway.adf.dms.datasource.dto.query.StatQueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import com.geoway.adf.dms.datasource.event.DatasetAfterDataQueryEvent;
import com.geoway.adf.dms.datasource.event.DatasetAfterDeleteEvent;
import com.geoway.adf.dms.datasource.event.DatasetBeforeDataQueryEvent;
import com.geoway.adf.dms.datasource.event.DatasetBeforeDeleteEvent;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.service.ThumbService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoTableQueryCheckUtil;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureDataset;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IGroupDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.IPgWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.ITableView;
import com.geoway.adf.gis.geodb.JdbcWorkspace;
import com.geoway.adf.gis.geodb.JdbcWorkspaceFactory;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GeoDatabaseServiceImpl
implements GeoDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(GeoDatabaseServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoServerEngineService geoServerEngineService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private DsDatasetRelationDao datasetRelationDao;
    @Resource
    private ThumbService thumbService;
    private final DataSource systemDataSource;
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public GeoDatabaseServiceImpl(DataSource dataSource, ApplicationEventPublisher applicationEventPublisher) {
        this.systemDataSource = dataSource;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        workspace.close();
        return true;
    }

    @Override
    public List<DatabaseDTO> listGeoDatabase(List<DataSourceTypeEnum> dataSourceTypes, String keyword) {
        List<DataSourceDTO> list = this.dataSourceManager.listDataSource(Arrays.asList(DataStoreTypeEnum.GeoDatabase), dataSourceTypes, keyword);
        ArrayList<DatabaseDTO> results = new ArrayList<DatabaseDTO>();
        for (DataSourceDTO d : list) {
            if (!(d instanceof DatabaseDTO)) continue;
            results.add((DatabaseDTO)d);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listAllDatabaseNames(DataSourceDTO dataSource) {
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataSource.getDataSourceType());
        if (dataSourceTypeEnum == DataSourceTypeEnum.PostgreSql || dataSourceTypeEnum == DataSourceTypeEnum.KingBase || dataSourceTypeEnum == DataSourceTypeEnum.Highgo || dataSourceTypeEnum == DataSourceTypeEnum.HighgoSecurity || dataSourceTypeEnum == DataSourceTypeEnum.GaussDB) {
            try (IFeatureWorkspace workspace = null;){
                List databaseNames;
                workspace = GeoDatabaseUtil.openGeoDatabase(dataSource);
                Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
                IPgWorkspace pgWorkspace = (IPgWorkspace)workspace;
                List list = databaseNames = pgWorkspace.getDatabaseNames();
                return list;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listAllDatabaseSchemas(String key) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType());
        if (dataSourceTypeEnum == DataSourceTypeEnum.PostgreSql || dataSourceTypeEnum == DataSourceTypeEnum.KingBase || dataSourceTypeEnum == DataSourceTypeEnum.Highgo || dataSourceTypeEnum == DataSourceTypeEnum.HighgoSecurity || dataSourceTypeEnum == DataSourceTypeEnum.GaussDB) {
            try (IFeatureWorkspace workspace = null;){
                List schemaNames;
                workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
                Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
                IPgWorkspace pgWorkspace = (IPgWorkspace)workspace;
                List list = schemaNames = pgWorkspace.getSchemaNames();
                return list;
            }
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceTypeEnum));
    }

    @Override
    public DatabaseDTO getDatabaseDetail(String key) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        if (dataSourceDTO instanceof DatabaseDTO) {
            return (DatabaseDTO)dataSourceDTO;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleDatasetDTO> listDatasets(DataSourceDTO dataSourceDTO) {
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
        try {
            List datasets = workspace.getDatasets();
            for (IGeoDataset dataset : datasets) {
                SimpleDatasetDTO datasetDTO = GeoDatasetUtil.getSimpleDatasetDTO(dataSourceDTO.getKey(), dataset);
                if (datasetDTO == null) continue;
                datasetDTOS.add(datasetDTO);
            }
            this.dataSourceManager.fillSimpleDatasetMeta(dataSourceDTO.getKey(), datasetDTOS);
        }
        finally {
            workspace.close();
        }
        return datasetDTOS;
    }

    @Override
    public DatasetPageList<SimpleDatasetDTO> listGeoDatasets(String dsKey, List<GeoDatasetType> datasetTypes, List<FeatureType> featureTypes, String schema, String keyword, Integer pageIndex, Integer rows) {
        return this.listGeoDatasets(dsKey, datasetTypes, featureTypes, schema, true, keyword, pageIndex, rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetPageList<SimpleDatasetDTO> listGeoDatasets(String dsKey, List<GeoDatasetType> types, List<FeatureType> featureTypes, String schema, Boolean useMetaTable, String keyword, Integer pageIndex, Integer rows) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            List datasets;
            ArrayList<GeoDatasetType> filterTypes = null;
            if (types != null) {
                filterTypes = new ArrayList<GeoDatasetType>(types);
                if (filterTypes.contains(GeoDatasetType.FeatureClass)) {
                    if (!filterTypes.contains(GeoDatasetType.FeatureDataset)) {
                        filterTypes.add(GeoDatasetType.FeatureDataset);
                    }
                    if (!filterTypes.contains(GeoDatasetType.GroupDataset)) {
                        filterTypes.add(GeoDatasetType.GroupDataset);
                    }
                }
                if (filterTypes.contains(GeoDatasetType.Table) && !filterTypes.contains(GeoDatasetType.GroupDataset)) {
                    filterTypes.add(GeoDatasetType.GroupDataset);
                }
            }
            if (workspace instanceof IPgWorkspace) {
                IPgWorkspace pgWorkspace = (IPgWorkspace)workspace;
                if (Boolean.FALSE.equals(useMetaTable)) {
                    pgWorkspace.setUseMetaTable(false);
                }
                datasets = pgWorkspace.getDatasets(schema, filterTypes == null ? null : filterTypes.toArray(new GeoDatasetType[0]));
            } else {
                datasets = workspace.getDatasets(filterTypes == null ? null : filterTypes.toArray(new GeoDatasetType[0]));
            }
            HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>();
            typeCount.put(GeoDatasetType.FeatureDataset.getValue(), 0);
            typeCount.put(GeoDatasetType.GroupDataset.getValue(), 0);
            typeCount.put(GeoDatasetType.FeatureClass.getValue(), 0);
            typeCount.put(GeoDatasetType.MosaicDataset.getValue(), 0);
            typeCount.put(GeoDatasetType.Table.getValue(), 0);
            typeCount.put(GeoDatasetType.TableView.getValue(), 0);
            ArrayList<IGeoDataset> resultGeoDatasets = new ArrayList<IGeoDataset>();
            HashMap subGeoDatasetMap = new HashMap();
            for (IGeoDataset dataset : datasets) {
                GeoDatasetType geoDatasetType = dataset.getType();
                ArrayList<IGeoDataset> subGeoDatasets = new ArrayList<IGeoDataset>();
                if (geoDatasetType == GeoDatasetType.FeatureDataset || geoDatasetType == GeoDatasetType.GroupDataset) {
                    for (IGeoDataset subset : dataset.getSubsets()) {
                        if (!this.filterDataset(subset, featureTypes, keyword) && (featureTypes != null && featureTypes.size() != 0 || !this.filterDataset(dataset, null, keyword)) || types != null && !types.contains(dataset.getType()) && !types.contains(subset.getType())) continue;
                        subGeoDatasets.add(subset);
                        typeCount.put(subset.getType().getValue(), typeCount.get(subset.getType().getValue()) == null ? 1 : (Integer)typeCount.get(subset.getType().getValue()) + 1);
                    }
                    if (subGeoDatasets.size() == 0 && (!StringUtil.isEmptyOrWhiteSpace((String)keyword) || featureTypes != null && featureTypes.size() > 0 || types != null && !types.contains(dataset.getType()))) continue;
                    subGeoDatasetMap.put(dataset, subGeoDatasets);
                    resultGeoDatasets.add(dataset);
                    typeCount.put(geoDatasetType.getValue(), typeCount.get(geoDatasetType.getValue()) == null ? 1 : (Integer)typeCount.get(geoDatasetType.getValue()) + 1);
                    continue;
                }
                if (!this.filterDataset(dataset, featureTypes, keyword)) continue;
                resultGeoDatasets.add(dataset);
                typeCount.put(geoDatasetType.getValue(), typeCount.get(geoDatasetType.getValue()) == null ? 1 : (Integer)typeCount.get(geoDatasetType.getValue()) + 1);
            }
            List pageDatasets = new PageList(resultGeoDatasets, pageIndex, rows).getList();
            ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
            for (IGeoDataset dataset : pageDatasets) {
                SimpleDatasetDTO datasetDTO = GeoDatasetUtil.getSimpleDatasetDTO(dataSourceDTO.getKey(), dataset, false);
                if (datasetDTO == null) continue;
                List subGeoDatasets = (List)subGeoDatasetMap.get(dataset);
                if (subGeoDatasets != null) {
                    ArrayList<SimpleDatasetDTO> subDatasetDTOs = new ArrayList<SimpleDatasetDTO>();
                    for (IGeoDataset subset : subGeoDatasets) {
                        SimpleDatasetDTO subsetDTO = GeoDatasetUtil.getSimpleDatasetDTO(dsKey, subset);
                        if (subsetDTO == null) continue;
                        subDatasetDTOs.add(subsetDTO);
                    }
                    datasetDTO.setSubsets(subDatasetDTOs);
                }
                datasetDTOS.add(datasetDTO);
            }
            this.dataSourceManager.fillSimpleDatasetMeta(dsKey, datasetDTOS);
            DatasetPageList<SimpleDatasetDTO> datasetPageList = new DatasetPageList<SimpleDatasetDTO>();
            datasetPageList.setList(datasetDTOS);
            datasetPageList.setTotal(Long.valueOf(resultGeoDatasets.size()));
            datasetPageList.setTypeCounts(typeCount);
            DatasetPageList<SimpleDatasetDTO> datasetPageList2 = datasetPageList;
            return datasetPageList2;
        }
    }

    private boolean filterDataset(IGeoDataset geoDataset, List<FeatureType> featureTypes, String keyword) {
        if (!this.filterDatasetName(geoDataset, keyword)) {
            return false;
        }
        if (featureTypes != null && featureTypes.size() > 0) {
            if (geoDataset.getType() == GeoDatasetType.FeatureClass) {
                IFeatureClass featureClass = (IFeatureClass)geoDataset;
                if (!featureTypes.contains(featureClass.getFeatureType())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean filterDatasetName(IGeoDataset geoDataset, String keyword) {
        if (StringUtil.isEmptyOrWhiteSpace((String)keyword)) {
            return true;
        }
        keyword = keyword.trim().toLowerCase();
        if (geoDataset.getName().toLowerCase().contains(keyword)) {
            return true;
        }
        return geoDataset.getAliasName() != null && geoDataset.getAliasName().toLowerCase().contains(keyword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageList<FeatureClassDTO> listAllFeatureClass(String dsKey, List<FeatureType> featureTypes, String schema, Boolean onlyWithoutRender, Boolean withDetail, String keyword, Integer pageIndex, Integer rows) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType[] filterTypes = new GeoDatasetType[]{GeoDatasetType.FeatureDataset, GeoDatasetType.FeatureClass, GeoDatasetType.GroupDataset};
            List datasets = StringUtil.isNotEmpty((String)schema) && workspace instanceof IPgWorkspace ? ((IPgWorkspace)workspace).getDatasets(schema, filterTypes) : workspace.getDatasets(filterTypes);
            List<IGeoDataset> resultDatasets = new ArrayList<IGeoDataset>();
            for (IGeoDataset dataset : datasets) {
                if (dataset.getType() == GeoDatasetType.FeatureDataset || dataset.getType() == GeoDatasetType.GroupDataset) {
                    for (IGeoDataset subset : dataset.getSubsets()) {
                        if (!this.filterDataset(subset, featureTypes, keyword)) continue;
                        resultDatasets.add(subset);
                    }
                    continue;
                }
                if (!this.filterDataset(dataset, featureTypes, keyword)) continue;
                resultDatasets.add(dataset);
            }
            if (resultDatasets.size() == 0) {
                PageList pageList = new PageList();
                return pageList;
            }
            resultDatasets.sort(Comparator.comparing(IGeoDataset::getName));
            if (Boolean.TRUE.equals(onlyWithoutRender)) {
                List<String> ids = this.dataSourceManager.getHasRenderDatasetIds(dsKey);
                resultDatasets = ListUtil.findAll(resultDatasets, d -> !ids.contains(GeoDatasetUtil.getGeoDatasetId(dsKey, d)));
            }
            List pageDatasets = new PageList(resultDatasets, pageIndex, rows).getList();
            ArrayList<DatasetDTO> datasetDTOS = new ArrayList<DatasetDTO>();
            if (Boolean.TRUE.equals(withDetail)) {
                for (IGeoDataset geoDataset : pageDatasets) {
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO, geoDataset);
                    if (!(datasetDTO instanceof FeatureClassDTO)) continue;
                    datasetDTO.setDataSource(null);
                    datasetDTOS.add((FeatureClassDTO)datasetDTO);
                }
            } else {
                for (IGeoDataset geoDataset : pageDatasets) {
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, geoDataset);
                    if (!(datasetDTO instanceof FeatureClassDTO)) continue;
                    datasetDTOS.add((FeatureClassDTO)datasetDTO);
                }
            }
            this.dataSourceManager.fillDatasetMeta(dsKey, datasetDTOS);
            PageList pageList = new PageList(datasetDTOS, Long.valueOf(resultDatasets.size()));
            return pageList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageList<MosaicDatasetDTO> listMosaicDataset(String dsKey, String schema, Boolean onlyWithoutRender, Boolean withDetail, String keyword, Integer pageIndex, Integer rows) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            List datasets = StringUtil.isNotEmpty((String)schema) && workspace instanceof IPgWorkspace ? ((IPgWorkspace)workspace).getDatasets(schema, new GeoDatasetType[]{GeoDatasetType.MosaicDataset}) : workspace.getDatasets(new GeoDatasetType[]{GeoDatasetType.MosaicDataset});
            List resultDatasets = new ArrayList<IGeoDataset>();
            for (IGeoDataset dataset : datasets) {
                if (!this.filterDatasetName(dataset, keyword)) continue;
                resultDatasets.add(dataset);
            }
            if (Boolean.TRUE.equals(onlyWithoutRender)) {
                List<String> ids = this.dataSourceManager.getHasRenderDatasetIds(dsKey);
                resultDatasets = ListUtil.findAll(resultDatasets, d -> !ids.contains(GeoDatasetUtil.getGeoDatasetId(dsKey, d)));
            }
            List pageDatasets = new PageList(resultDatasets, pageIndex, rows).getList();
            ArrayList<DatasetDTO> datasetDTOS = new ArrayList<DatasetDTO>();
            if (Boolean.TRUE.equals(withDetail)) {
                for (IGeoDataset geoDataset : pageDatasets) {
                    DatasetDTO mosaicDatasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO, geoDataset);
                    if (!(mosaicDatasetDTO instanceof MosaicDatasetDTO)) continue;
                    mosaicDatasetDTO.setDataSource(null);
                    datasetDTOS.add((MosaicDatasetDTO)mosaicDatasetDTO);
                }
            } else {
                for (IGeoDataset geoDataset : pageDatasets) {
                    DatasetDTO mosaicDatasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, geoDataset);
                    if (!(mosaicDatasetDTO instanceof MosaicDatasetDTO)) continue;
                    datasetDTOS.add((MosaicDatasetDTO)mosaicDatasetDTO);
                }
            }
            this.dataSourceManager.fillDatasetMeta(dsKey, datasetDTOS);
            PageList pageList = new PageList(datasetDTOS, Long.valueOf(resultDatasets.size()));
            return pageList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageList<TableDatasetDTO> listAllTable(String dsKey, String schema, Boolean withDetail, String keyword, Integer pageIndex, Integer rows) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType[] filterTypes = new GeoDatasetType[]{GeoDatasetType.Table, GeoDatasetType.GroupDataset};
            List datasets = StringUtil.isNotEmpty((String)schema) && workspace instanceof IPgWorkspace ? ((IPgWorkspace)workspace).getDatasets(schema, filterTypes) : workspace.getDatasets(filterTypes);
            ArrayList<IGeoDataset> resultDatasets = new ArrayList<IGeoDataset>();
            for (IGeoDataset dataset : datasets) {
                if (dataset.getType() == GeoDatasetType.GroupDataset) {
                    for (IGeoDataset subset : dataset.getSubsets()) {
                        if (subset.getType() != GeoDatasetType.Table || !this.filterDatasetName(subset, keyword)) continue;
                        resultDatasets.add(subset);
                    }
                    continue;
                }
                if (!this.filterDatasetName(dataset, keyword)) continue;
                resultDatasets.add(dataset);
            }
            if (resultDatasets.size() == 0) {
                PageList pageList = new PageList();
                return pageList;
            }
            resultDatasets.sort(Comparator.comparing(IGeoDataset::getName));
            List pageDatasets = new PageList(resultDatasets, pageIndex, rows).getList();
            ArrayList<DatasetDTO> datasetDTOS = new ArrayList<DatasetDTO>();
            if (Boolean.TRUE.equals(withDetail)) {
                for (IGeoDataset geoDataset : pageDatasets) {
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO, geoDataset);
                    if (!(datasetDTO instanceof TableDatasetDTO)) continue;
                    datasetDTO.setDataSource(null);
                    datasetDTOS.add((TableDatasetDTO)datasetDTO);
                }
            } else {
                for (IGeoDataset geoDataset : pageDatasets) {
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, geoDataset);
                    if (!(datasetDTO instanceof TableDatasetDTO)) continue;
                    datasetDTO.setHasRender(false);
                    datasetDTOS.add((TableDatasetDTO)datasetDTO);
                }
            }
            this.dataSourceManager.fillDatasetMeta(dsKey, datasetDTOS);
            PageList pageList = new PageList(datasetDTOS, Long.valueOf(resultDatasets.size()));
            return pageList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DatasetDTO> listSubFeatureClass(String featureDatasetId, Boolean withDetail) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(featureDatasetId);
        String dsKey = datasetNameInfo.getDsKey();
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IFeatureDataset featureDataset = null;
            if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.FeatureDataset.getValue()) {
                featureDataset = workspace.openFeatureDataset(datasetNameInfo.getName());
            } else if (datasetNameInfo.getType().intValue() == DatasetTypeEnum.GroupDataset.getValue()) {
                featureDataset = workspace.openGroupDataset(datasetNameInfo.getName());
            }
            Assert.notNull((Object)featureDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            ArrayList<DatasetDTO> datasetDTOS = new ArrayList<DatasetDTO>();
            if (Boolean.TRUE.equals(withDetail)) {
                for (IGeoDataset geoDataset : featureDataset.getSubsets()) {
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO, geoDataset);
                    datasetDTO.setDataSource(null);
                    datasetDTOS.add(datasetDTO);
                }
            } else {
                for (IGeoDataset geoDataset : featureDataset.getSubsets()) {
                    DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDTO(dsKey, geoDataset);
                    if (datasetDTO == null) continue;
                    datasetDTOS.add(datasetDTO);
                }
            }
            this.dataSourceManager.fillDatasetMeta(dsKey, datasetDTOS);
            ArrayList<DatasetDTO> arrayList = datasetDTOS;
            return arrayList;
        }
    }

    @Override
    public DatasetDTO getDatasetDetail(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(datasetNameInfo.getDsKey());
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
        return this.getDatasetDetail(dataSourceDTO, datasetType, datasetNameInfo.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, DatasetTypeEnum datasetType, String name) {
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType geoDatasetType = GeoDatasetUtil.convertDatasetType(datasetType);
            IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, geoDatasetType, name);
            Assert.notNull((Object)dataset, (String)(name + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            DatasetDTO datasetDTO = GeoDatasetUtil.getGeoDatasetDetail(dataSourceDTO, dataset);
            this.dataSourceManager.setDatasetMeta(datasetDTO);
            if (dataset.getType() == GeoDatasetType.MosaicDataset) {
                IFeatureClass catalogFeatureClass = ((IMosaicDataset)dataset).getCatalog();
                String catalogDatasetId = GeoDatasetUtil.getGeoDatasetId(dataSourceDTO.getKey(), (IGeoDataset)catalogFeatureClass);
                MosaicDatasetDTO mosaicDatasetDTO = (MosaicDatasetDTO)datasetDTO;
                mosaicDatasetDTO.setCatalogDatasetId(catalogDatasetId);
                mosaicDatasetDTO.setRangeRender(this.dataSourceManager.getDatasetRender(catalogDatasetId));
            }
            datasetDTO.setDataSource(dataSourceDTO);
            datasetDTO.setResourceId(String.format("Atlas://\u6570\u636e\u8d44\u6e90/%s/%s/%s", dataSourceDTO.getName(), geoDatasetType.getDesc(), dataset.getFullName()));
            DatasetDTO datasetDTO2 = datasetDTO;
            return datasetDTO2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(String key, String schema) {
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(key);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            if (StringUtil.isNotEmpty((String)schema) && workspace instanceof IPgWorkspace) {
                ((IPgWorkspace)workspace).synchronize(schema);
            } else {
                workspace.synchronize();
            }
            this.sysLogService.addLog(100, "\u540c\u6b65\u7a7a\u95f4\u6570\u636e\u5e93\uff1a" + dataSourceDTO.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String synchronizeDataset(String key, String datasetName) {
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(key);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            String id;
            this.sysLogService.addLog(100, "\u540c\u6b65\u7a7a\u95f4\u6570\u636e\u96c6\uff1a" + dataSourceDTO.getName() + "->" + datasetName);
            workspace.synchronizeDataset(datasetName);
            IGeoDataset geoDataset = workspace.openGeoDataset(datasetName);
            if (geoDataset == null) {
                String string = null;
                return string;
            }
            String string = id = GeoDatasetUtil.getGeoDatasetId(key, geoDataset);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataset(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(datasetNameInfo.getDsKey());
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDeleteEvent(this, id));
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
            IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, datasetNameInfo.getName());
            Assert.notNull((Object)dataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            if (!dataset.delete()) {
                throw new RuntimeException(datasetNameInfo.getName() + "\u5220\u9664\u5931\u8d25");
            }
            if (dataset.getSubsets() != null) {
                for (IGeoDataset subDataset : dataset.getSubsets()) {
                    String subId = GeoDatasetUtil.getGeoDatasetId(datasetNameInfo.getDsKey(), subDataset);
                    this.geoServerEngineService.deleteRelateService(subId);
                    this.datasetRelationDao.deleteByDatasetId(subId);
                }
            }
            if (datasetType == GeoDatasetType.MosaicDataset) {
                this.thumbService.deleteByDatasetId(id);
            }
            this.geoServerEngineService.deleteRelateService(id);
            this.datasetRelationDao.deleteByDatasetId(id);
            this.sysLogService.addLog(101, String.format("\u5220\u9664%s\uff1a%s > %s", datasetType.getDesc(), dataSourceDTO.getName(), dataset.getName()));
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetAfterDeleteEvent(this, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDatasetFields(String datasetId, FieldsEditDTO fieldsEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        String dsKey = datasetNameInfo.getDsKey();
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
            String name = datasetNameInfo.getName();
            IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, name);
            Assert.notNull((Object)dataset, (String)(name + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            this.updateDatasetFields(dataset, fieldsEditDTO, dataSourceDTO);
        }
    }

    @Override
    public void updateDatasetFields(IGeoDataset dataset, FieldsEditDTO fieldsEditDTO, DataSourceDTO dataSourceDTO) {
        IField field;
        ITable table = null;
        if (dataset instanceof IMosaicDataset) {
            table = (ITable)((IMosaicDataset)dataset).getCatalog();
        } else if (dataset instanceof ITable) {
            table = (ITable)dataset;
        }
        if (table == null) {
            throw new UnsupportedOperationException(dataset.getType() + " \u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        if (fieldsEditDTO.getAddFields() != null) {
            for (FieldDTO addField : fieldsEditDTO.getAddFields()) {
                if (table.getFields().findField(addField.getName()) != null) continue;
                field = FieldUtil.convertField(addField);
                if (!table.addField(field)) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5[{%s}]\u65b0\u589e\u5931\u8d25", field.getName()));
                }
                this.sysLogService.addLog(101, String.format("\u65b0\u589e%s\u5b57\u6bb5\uff1a%s > %s > %s", dataset.getType(), dataSourceDTO.getName(), dataset.getFullName(), addField.getName()));
            }
        }
        if (fieldsEditDTO.getDeleteFields() != null) {
            for (String delField : fieldsEditDTO.getDeleteFields()) {
                if (table.getFields().findField(delField) == null) continue;
                if (!table.deleteField(delField)) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5[{%s}]\u5220\u9664\u5931\u8d25", delField));
                }
                this.sysLogService.addLog(101, String.format("\u5220\u9664%s\u5b57\u6bb5\uff1a%s > %s > %s", dataset.getType(), dataSourceDTO.getName(), dataset.getFullName(), delField));
            }
        }
        if (fieldsEditDTO.getUpdateFields() != null) {
            for (FieldDTO editField : fieldsEditDTO.getUpdateFields()) {
                field = table.getFields().findField(editField.getName());
                if (field == null || field.getAliasName().equals(editField.getAliasName())) continue;
                if (!table.alterFieldAliasName(field.getName(), editField.getAliasName())) {
                    throw new RuntimeException(String.format("\u5b57\u6bb5[{%s}]\u4fee\u6539\u5931\u8d25", field.getName()));
                }
                this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\u5b57\u6bb5\uff1a%s > %s > %s", dataset.getType(), dataSourceDTO.getName(), dataset.getFullName(), editField.getName()));
            }
        }
    }

    @Override
    public void exportFields(String datasetId, HttpServletRequest request, HttpServletResponse response) {
        List<FieldDTO> fieldDTOS;
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        String dsKey = datasetNameInfo.getDsKey();
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(dsKey);
        DatasetDTO datasetDTO = this.getDatasetDetail(dataSourceDTO, DatasetTypeEnum.getByValue(datasetNameInfo.getType()), datasetNameInfo.getName());
        if (datasetDTO instanceof TableDatasetDTO) {
            fieldDTOS = ((TableDatasetDTO)datasetDTO).getFields();
        } else if (datasetDTO instanceof FeatureClassDTO) {
            fieldDTOS = ((FeatureClassDTO)datasetDTO).getFields();
        } else if (datasetDTO instanceof MosaicDatasetDTO) {
            fieldDTOS = ((MosaicDatasetDTO)datasetDTO).getFields();
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + datasetNameInfo.getType());
        }
        ArrayList<List<Object>> excelContents = new ArrayList<List<Object>>();
        excelContents.add(Arrays.asList("\u5b57\u6bb5\u540d\u79f0", "\u5b57\u6bb5\u522b\u540d", "\u5b57\u6bb5\u7c7b\u578b", "\u5b57\u6bb5\u957f\u5ea6", "\u9ed8\u8ba4\u503c", "\u662f\u5426\u53ef\u4e3a\u7a7a"));
        for (FieldDTO fieldDTO : fieldDTOS) {
            if (FieldType.OID.getValue() == fieldDTO.getFieldType().intValue() || FieldType.Shape.getValue() == fieldDTO.getFieldType().intValue()) continue;
            excelContents.add(Arrays.asList(fieldDTO.getName(), fieldDTO.getAliasName(), FieldUtil.getFieldTypeStr(FieldType.getByValue((Integer)fieldDTO.getFieldType())), String.valueOf(fieldDTO.getLength()), fieldDTO.getDefaultValue(), Boolean.FALSE.equals(fieldDTO.getNullable()) ? "\u5426" : "\u662f"));
        }
        try {
            DownloadUtil.setDownloadFileName((String)(datasetDTO.getName() + "-\u5b57\u6bb5\u6a21\u677f.xlsx"), (HttpServletRequest)request, (HttpServletResponse)response);
            ExcelUtil.writeExcel(excelContents, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(datasetNameInfo.getShortName() + "\u5b57\u6bb5\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public List<FieldDTO> loadFieldTemplateFile(MultipartFile file) {
        try {
            List excelContents = ExcelUtil.readExcelDataList((InputStream)file.getInputStream(), null);
            ArrayList<FieldDTO> fieldList = new ArrayList<FieldDTO>();
            int rowCount = excelContents.size();
            if (rowCount < 2) {
                return fieldList;
            }
            for (int i = 1; i < rowCount; ++i) {
                List row = (List)excelContents.get(i);
                FieldDTO field = new FieldDTO();
                if (row == null) continue;
                String name = (String)row.get(0);
                if (StringUtil.isEmptyOrWhiteSpace((String)(name = name.replace(" ", "")))) continue;
                field.setName(name);
                String aliasName = row.size() > 1 ? (String)row.get(1) : null;
                field.setAliasName(aliasName == null ? "" : aliasName);
                String typeStr = row.size() > 2 ? (String)row.get(2) : "";
                FieldType fieldType = FieldUtil.getFieldTypeByStr(typeStr);
                field.setFieldType(Integer.valueOf(fieldType.getValue()));
                String lengthStr = row.size() > 3 ? (String)row.get(3) : "";
                int length = 0;
                if (StringUtil.isNotEmpty((String)lengthStr)) {
                    try {
                        length = Integer.parseInt(lengthStr);
                    }
                    catch (Exception e) {
                        log.error(lengthStr + "\u4e0d\u662f\u6570\u503c\uff1a" + e.getMessage());
                        length = 0;
                    }
                }
                field.setLength(Integer.valueOf(length));
                String defaultValue = row.size() > 4 ? (String)row.get(4) : null;
                field.setDefaultValue(defaultValue);
                fieldList.add(field);
                String nullable = row.size() > 5 ? (String)row.get(5) : null;
                field.setNullable(Boolean.valueOf(!"\u5426".equals(nullable)));
                fieldList.add(field);
            }
            return fieldList;
        }
        catch (IOException e) {
            throw new RuntimeException("\u5b57\u6bb5\u6a21\u677f\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public IFeatureWorkspace openGeoWorkspace(String key) {
        JdbcWorkspace workspace;
        if ("key".equals(key)) {
            workspace = JdbcWorkspaceFactory.openWorkspace((DataSource)this.systemDataSource);
        } else {
            DatabaseDTO dataSourceDTO = this.getDatabaseDetail(key);
            workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        }
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        return workspace;
    }

    @Override
    public ExtentDTO calculateExtent(String datasetId) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        String dsKey = datasetNameInfo.getDsKey();
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(dsKey);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
            IGeoDataset dataset = GeoDatasetUtil.openDataset(workspace, datasetType, datasetNameInfo.getName());
            Assert.notNull((Object)dataset, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            this.sysLogService.addLog(101, String.format("\u8ba1\u7b97%s\u8303\u56f4\uff1a%s > %s", dataset.getType().getDesc(), dataSourceDTO.getName(), dataset.getFullName()));
            switch (dataset.getType()) {
                case GroupDataset: {
                    IGroupDataset groupDataset = (IGroupDataset)dataset;
                    for (IGeoDataset subset : groupDataset.getSubsets()) {
                        if (!(subset instanceof IFeatureClass)) continue;
                        IFeatureClass featureClass = (IFeatureClass)subset;
                        IEnvelope iEnvelope = featureClass.updateExtent();
                    }
                    Iterator iterator = null;
                    return iterator;
                }
                case FeatureDataset: {
                    IFeatureDataset featureDataset = (IFeatureDataset)dataset;
                    for (IGeoDataset subset : featureDataset.getSubsets()) {
                        if (!(subset instanceof IFeatureClass)) continue;
                        IFeatureClass featureClass = (IFeatureClass)subset;
                        IEnvelope iEnvelope = featureClass.updateExtent();
                    }
                    Iterator iterator = null;
                    return iterator;
                }
                case FeatureClass: {
                    ExtentDTO extentDTO;
                    IFeatureClass featureClass = (IFeatureClass)dataset;
                    IEnvelope envelope = featureClass.updateExtent();
                    ExtentDTO extentDTO2 = extentDTO = GeoDatasetUtil.toExtentDTO(envelope);
                    return extentDTO2;
                }
                case MosaicDataset: {
                    ExtentDTO extentDTO;
                    IMosaicDataset mosaicDataset = (IMosaicDataset)dataset;
                    IEnvelope envelope = mosaicDataset.updateExtent();
                    ExtentDTO extentDTO3 = extentDTO = GeoDatasetUtil.toExtentDTO(envelope);
                    return extentDTO3;
                }
            }
            throw new UnsupportedOperationException(dataset.getType() + " \u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataQueryResult queryGeoDataset(String datasetId, QueryFilterDTO queryFilterDTO) {
        DataQueryResult dataQueryResult;
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(datasetNameInfo.getDsKey());
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), queryFilterDTO);
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try {
            DataQueryResult result;
            SpatailQueryUtil.initDefaultQueryFilter(queryFilterDTO);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDataQueryEvent(this, queryFilterDTO));
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
            switch (datasetType) {
                case FeatureClass: {
                    IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
                    Assert.notNull((Object)featureClass, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    result = SpatailQueryUtil.queryFeatureClass(featureClass, queryFilterDTO);
                    break;
                }
                case Table: {
                    ITable table = workspace.openTable(datasetNameInfo.getName());
                    Assert.notNull((Object)table, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    result = SpatailQueryUtil.queryTable(table, queryFilterDTO);
                    break;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = workspace.openMosaicDataset(datasetNameInfo.getName());
                    Assert.notNull((Object)mosaicDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    result = SpatailQueryUtil.queryFeatureClass(mosaicDataset.getCatalog(), queryFilterDTO);
                    result.setName(mosaicDataset.getName());
                    result.setAliasName(mosaicDataset.getAliasName());
                    break;
                }
                case TableView: {
                    ITableView tableView = workspace.openTableView(datasetNameInfo.getName());
                    Assert.notNull((Object)tableView, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    result = SpatailQueryUtil.queryTable((ITable)tableView, queryFilterDTO);
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + (Object)((Object)datasetType));
                }
            }
            result.setId(datasetId);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetAfterDataQueryEvent(this, result));
            dataQueryResult = result;
        }
        catch (Throwable throwable) {
            workspace.close();
            throw throwable;
        }
        workspace.close();
        return dataQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataQueryResult queryGeoDataset(String dsKey, String datasetName, QueryFilterDTO queryFilterDTO) {
        DataQueryResult dataQueryResult;
        DataSourceDTO dataSourceDTO = this.getQueryDataSource(dsKey);
        dsKey = dataSourceDTO.getKey();
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), queryFilterDTO);
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try {
            IGeoDataset geoDataset = workspace.openGeoDataset(datasetName);
            Assert.notNull((Object)geoDataset, (String)(datasetName + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDataQueryEvent(this, queryFilterDTO));
            DataQueryResult result = SpatailQueryUtil.queryGeoDataset(geoDataset, queryFilterDTO);
            result.setId(GeoDatasetUtil.getGeoDatasetId(dsKey, geoDataset));
            result.setName(geoDataset.getName());
            result.setAliasName(geoDataset.getAliasName());
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetAfterDataQueryEvent(this, result));
            dataQueryResult = result;
        }
        catch (Throwable throwable) {
            workspace.close();
            throw throwable;
        }
        workspace.close();
        return dataQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryDataCount(String datasetId, QueryFilterBasicDTO queryFilterDTO) {
        long l;
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatabaseDTO dataSourceDTO = this.getDatabaseDetail(datasetNameInfo.getDsKey());
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), queryFilterDTO);
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try {
            long result;
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDataQueryEvent(this, queryFilterDTO));
            DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
            switch (datasetType) {
                case FeatureClass: {
                    IFeatureClass featureClass = workspace.openFeatureClass(datasetNameInfo.getName());
                    Assert.notNull((Object)featureClass, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    SpatialQueryFilter filter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, (IGeoDataset)featureClass);
                    result = featureClass.featureCount((IQueryFilter)filter);
                    break;
                }
                case Table: {
                    ITable table = workspace.openTable(datasetNameInfo.getName());
                    Assert.notNull((Object)table, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    SpatialQueryFilter filter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, (IGeoDataset)table);
                    result = table.count((IQueryFilter)filter);
                    break;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = workspace.openMosaicDataset(datasetNameInfo.getName());
                    Assert.notNull((Object)mosaicDataset, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    SpatialQueryFilter filter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, (IGeoDataset)mosaicDataset.getCatalog());
                    result = mosaicDataset.getCatalog().featureCount((IQueryFilter)filter);
                    break;
                }
                case TableView: {
                    ITableView tableView = workspace.openTableView(datasetNameInfo.getName());
                    Assert.notNull((Object)tableView, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
                    SpatialQueryFilter filter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, (IGeoDataset)tableView);
                    result = ((ITable)tableView).count((IQueryFilter)filter);
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + (Object)((Object)datasetType));
                }
            }
            l = result;
        }
        catch (Throwable throwable) {
            workspace.close();
            throw throwable;
        }
        workspace.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryDataCount(String dsKey, String datasetName, QueryFilterBasicDTO queryFilterDTO) {
        long l;
        DataSourceDTO dataSourceDTO = this.getQueryDataSource(dsKey);
        dsKey = dataSourceDTO.getKey();
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), queryFilterDTO);
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try {
            long result;
            IGeoDataset geoDataset = workspace.openGeoDataset(datasetName);
            Assert.notNull((Object)geoDataset, (String)(datasetName + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDataQueryEvent(this, queryFilterDTO));
            SpatialQueryFilter filter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, geoDataset);
            GeoDatasetType datasetType = geoDataset.getType();
            switch (datasetType) {
                case FeatureClass: 
                case Table: 
                case TableView: {
                    result = ((ITable)geoDataset).count((IQueryFilter)filter);
                    break;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = (IMosaicDataset)geoDataset;
                    result = mosaicDataset.getCatalog().featureCount((IQueryFilter)filter);
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + datasetType);
                }
            }
            l = result;
        }
        catch (Throwable throwable) {
            workspace.close();
            throw throwable;
        }
        workspace.close();
        return l;
    }

    @Override
    public List<Object> queryDataFieldUniqValues(String datasetId, QueryFilterBasicDTO queryFilterDTO, Integer limit) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        return this.queryDataFieldUniqValues(datasetNameInfo.getDsKey(), datasetNameInfo.getName(), queryFilterDTO, limit);
    }

    @Override
    public List<Object> queryDataFieldUniqValues(String dsKey, String datasetName, QueryFilterBasicDTO queryFilterDTO, Integer limit) {
        DataSourceDTO dataSource = this.getQueryDataSource(dsKey);
        dsKey = dataSource.getKey();
        GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSource.getDataSourceType()), queryFilterDTO);
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSource);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        ICursor cursor = null;
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            IGeoDataset geoDataset = workspace.openGeoDataset(datasetName);
            Assert.notNull((Object)geoDataset, (String)"\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
            ITable table = null;
            switch (geoDataset.getType()) {
                case FeatureClass: 
                case Table: 
                case TableView: {
                    table = (ITable)geoDataset;
                    break;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = (IMosaicDataset)geoDataset;
                    table = (ITable)mosaicDataset.getCatalog();
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + geoDataset.getType());
                }
            }
            String fieldName = queryFilterDTO.getFields();
            if (StringUtil.isEmptyOrWhiteSpace((String)fieldName)) {
                throw new RuntimeException("\u67e5\u8be2\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            IField field = table.getFields().findField(fieldName.trim());
            if (field == null) {
                throw new RuntimeException(fieldName + "\u5b57\u6bb5\u4e0d\u5b58\u5728");
            }
            if (field.getPhysicalName() != null && !field.getPhysicalName().isEmpty()) {
                fieldName = "\"" + field.getPhysicalName() + "\"";
            }
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDataQueryEvent(this, queryFilterDTO));
            SpatialQueryFilter queryFilter = SpatailQueryUtil.buildQueryFilter(queryFilterDTO, geoDataset);
            queryFilter.setSubFields("distinct " + fieldName);
            queryFilter.setLimit(limit);
            cursor = table.searchRow((IQueryFilter)queryFilter);
            IRow row = cursor.nextRow();
            while (row != null) {
                results.add(row.getValue(0));
                row = cursor.nextRow();
            }
        }
        catch (Exception e) {
            log.error(dataSource.getName() + "->" + datasetName);
            throw new RuntimeException(datasetName + "\u67e5\u8be2\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            workspace.close();
        }
        return results;
    }

    @Override
    public DataQueryResult queryByObjectId(String datasetId, Object objectId, String fields, Boolean returnGeometry) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        return this.queryByObjectId(datasetNameInfo.getDsKey(), datasetNameInfo.getName(), objectId, fields, returnGeometry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataQueryResult queryByObjectId(String dsKey, String datasetName, Object objectId, String fields, Boolean returnGeometry) {
        DataSourceDTO dataSource = this.getQueryDataSource(dsKey);
        dsKey = dataSource.getKey();
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSource);){
            IGeoDataset geoDataset = workspace.openGeoDataset(datasetName);
            Assert.notNull((Object)geoDataset, (String)"\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
            ITable table = null;
            String shapeField = null;
            switch (geoDataset.getType()) {
                case FeatureClass: {
                    table = (ITable)geoDataset;
                    shapeField = ((IFeatureClass)geoDataset).getShapeFieldName();
                    break;
                }
                case Table: 
                case TableView: {
                    String oidFieldName;
                    IField fld2;
                    table = (ITable)geoDataset;
                    for (IField fld2 : table.getFields()) {
                        if (fld2.getFieldType() != FieldType.Shape) continue;
                        shapeField = fld2.getName();
                        break;
                    }
                    if ((oidFieldName = table.getOidFieldName()) != null || table.getType() != GeoDatasetType.TableView || (fld2 = table.getFields().findField("vid")) == null) break;
                    oidFieldName = "vid";
                    QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
                    queryFilterDTO.setFields(fields);
                    queryFilterDTO.setReturnGeometry(returnGeometry);
                    queryFilterDTO.setCondition(String.format("%s = '%s'", oidFieldName, objectId));
                    GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSource.getDataSourceType()), queryFilterDTO);
                    DataQueryResult dataQueryResult = SpatailQueryUtil.queryTable(table, queryFilterDTO);
                    return dataQueryResult;
                }
                case MosaicDataset: {
                    IMosaicDataset mosaicDataset = (IMosaicDataset)geoDataset;
                    table = (ITable)mosaicDataset.getCatalog();
                    shapeField = mosaicDataset.getCatalog().getShapeFieldName();
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + geoDataset.getType());
                }
            }
            DataQueryResult queryResult = new DataQueryResult();
            queryResult.setId(GeoDatasetUtil.getGeoDatasetId(dsKey, geoDataset));
            queryResult.setName(table.getName());
            queryResult.setAliasName(table.getAliasName());
            queryResult.setData(new ArrayList<FeatureResult>());
            ArrayList<String> selectFields = new ArrayList<String>();
            ArrayList<ReturnField> attFields = new ArrayList<ReturnField>();
            SpatailQueryUtil.getFilterFields(table, shapeField, returnGeometry, returnGeometry, fields, selectFields, attFields);
            queryResult.setFields(attFields);
            IRow row = table.getRow(objectId);
            if (row != null) {
                FeatureResult featureResult = SpatailQueryUtil.convertRow(row, attFields);
                if (returnGeometry.booleanValue() && shapeField != null) {
                    IGeometry geo = null;
                    if (row instanceof IFeature) {
                        geo = ((IFeature)row).getGeometry();
                    } else {
                        Object value = row.getValue(shapeField);
                        if (value instanceof IGeometry) {
                            geo = (IGeometry)value;
                        }
                    }
                    if (geo != null) {
                        featureResult.setGeometry(geo.toWkt());
                        featureResult.setExtent(GeoDatasetUtil.toExtentDTO(geo.getEnvelope()));
                    }
                }
                queryResult.getData().add(featureResult);
            }
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetAfterDataQueryEvent(this, queryResult));
            DataQueryResult dataQueryResult = queryResult;
            return dataQueryResult;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StatQueryResultDTO> queryDataStatistics(String dsKey, String datasetName, StatQueryFilterDTO statFilter) {
        StatMethodEnum statMethod = StatMethodEnum.getByValue(statFilter.getStatMethod());
        if (statMethod == null) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7edf\u8ba1\u65b9\u6cd5");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)statFilter.getFields())) {
            throw new RuntimeException("\u7edf\u8ba1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DataSourceDTO dataSource = this.getQueryDataSource(dsKey);
        dsKey = dataSource.getKey();
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSource);){
            String queryStr;
            IGeoDataset dataset = workspace.openGeoDataset(datasetName);
            Assert.notNull((Object)dataset, (String)(datasetName + "\u6253\u5f00\u5931\u8d25\uff01"));
            ITable table = null;
            if (dataset.getType() == GeoDatasetType.MosaicDataset) {
                IMosaicDataset mosaicDataset = (IMosaicDataset)dataset;
                table = (ITable)mosaicDataset.getCatalog();
            } else if (dataset instanceof ITable) {
                table = (ITable)dataset;
            }
            Assert.notNull((Object)table, (String)"\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01");
            List statFieldNames = StringUtil.split((String)statFilter.getFields(), (String)",", f -> f.trim());
            ArrayList<IField> statFields = new ArrayList<IField>();
            for (String fldName : statFieldNames) {
                IField fld = table.getFields().findField(fldName);
                if (fld == null) {
                    throw new RuntimeException(fldName + "\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
                }
                statFields.add(fld);
            }
            switch (statMethod) {
                case Number: {
                    queryStr = "Count(%s)";
                    break;
                }
                case Sum: {
                    queryStr = "Sum(%s)";
                    break;
                }
                case Max: {
                    queryStr = "Max(%s)";
                    break;
                }
                case Min: {
                    queryStr = "Min(%s)";
                    break;
                }
                case Average: {
                    queryStr = "Avg(%s)";
                    break;
                }
                case UniqueNumber: {
                    queryStr = "Count(distinct %s)";
                    break;
                }
                default: {
                    throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7edf\u8ba1\u65b9\u6cd5");
                }
            }
            ArrayList<String> queryFieldList = new ArrayList<String>();
            for (IField statField : statFields) {
                String queryName = statField.getName();
                if (statField.getPhysicalName() != null && !statField.getPhysicalName().isEmpty()) {
                    queryName = "\"" + statField.getPhysicalName() + "\"";
                }
                queryFieldList.add(String.format(queryStr + " as %s_value", queryName, statField.getName()));
            }
            String groupByFields = null;
            List groupFields = null;
            if (!StringUtil.isEmptyOrWhiteSpace((String)statFilter.getGroupBy())) {
                groupFields = StringUtil.split((String)statFilter.getGroupBy(), (String)",", f -> f.trim());
                ArrayList<String> groupQueryField = new ArrayList<String>();
                for (String grpField : groupFields) {
                    IField fld = table.getFields().findField(grpField);
                    if (fld == null) {
                        throw new RuntimeException(grpField + "\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01");
                    }
                    String fieldName = fld.getName();
                    if (fld.getPhysicalName() != null && !fld.getPhysicalName().isEmpty()) {
                        fieldName = "\"" + fld.getPhysicalName() + "\"";
                    }
                    groupQueryField.add(fieldName);
                }
                groupByFields = String.join((CharSequence)",", groupQueryField);
                queryFieldList.addAll(groupQueryField);
            }
            String queryFields = String.join((CharSequence)",", queryFieldList);
            statFilter.setFields(queryFields);
            GeoTableQueryCheckUtil.checkTableSingleQuery(DataSourceTypeEnum.getByValue(dataSource.getDataSourceType()), statFilter);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetBeforeDataQueryEvent(this, statFilter));
            SpatialQueryFilter queryFilter = SpatailQueryUtil.buildQueryFilter(statFilter, (IGeoDataset)table);
            queryFilter.setSubFields(queryFields);
            queryFilter.setLimit(statFilter.getLimitCount());
            if (workspace instanceof JdbcWorkspace && statFilter.getQueryTimeout() != null && statFilter.getQueryTimeout() > 0) {
                ((JdbcWorkspace)workspace).setQueryTimeout(statFilter.getQueryTimeout().intValue());
            }
            if (!StringUtil.isEmptyOrWhiteSpace((String)groupByFields)) {
                String postfix = String.format(" group by %s", groupByFields);
                if (!StringUtil.isEmptyOrWhiteSpace((String)statFilter.getOrderBy())) {
                    postfix = postfix + " order by " + statFilter.getOrderBy();
                }
                queryFilter.setPostfixClause(postfix);
            }
            ArrayList<StatQueryResultDTO> statResult = new ArrayList<StatQueryResultDTO>();
            ICursor cursor = null;
            try {
                ArrayList<StatQueryResultDTO> groupValues;
                cursor = table.searchRow((IQueryFilter)queryFilter);
                IRow row = cursor.nextRow();
                while (row != null) {
                    Object grpField2;
                    groupValues = new LinkedHashMap();
                    if (groupFields != null) {
                        for (Object grpField2 : groupFields) {
                            Object groupObject = row.getValue((String)grpField2);
                            String group = groupObject == null ? "" : groupObject.toString();
                            groupValues.put(grpField2, group);
                        }
                    }
                    LinkedHashMap<String, Double> statValues = new LinkedHashMap<String, Double>();
                    grpField2 = statFieldNames.iterator();
                    while (grpField2.hasNext()) {
                        String statField = (String)grpField2.next();
                        String keyName = statField + "_value";
                        Object value = row.getValue(keyName);
                        BigDecimal decimal = new BigDecimal(value == null ? "0" : value.toString());
                        decimal = decimal.setScale((int)statFilter.getPrecision(), 4);
                        statValues.put(statField, decimal.doubleValue());
                    }
                    StatQueryResultDTO item = new StatQueryResultDTO();
                    item.setGroups((Map<String, String>)((Object)groupValues));
                    item.setValues(statValues);
                    statResult.add(item);
                    row = cursor.nextRow();
                }
                groupValues = statResult;
                return groupValues;
            }
            catch (Exception e) {
                String sqlState;
                if (e instanceof SQLException && (sqlState = ((SQLException)e).getSQLState()).equals("57014")) {
                    log.error("\u67e5\u8be2\u7edf\u8ba1\u5931\u8d25\uff01", (Throwable)e);
                    throw new RuntimeException("\u67e5\u8be2\u7edf\u8ba1\u8d85\u65f6\uff01");
                }
                throw new RuntimeException("\u67e5\u8be2\u7edf\u8ba1\u5931\u8d25\uff01", e);
            }
            finally {
                if (cursor != null) {
                    cursor.release();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataQueryResult bufferAnalyse(String dsKey, BufferAnalyseFilterDTO bufferAnalyseFilter) {
        DataQueryResult dataQueryResult;
        DataSourceDTO dataSourceDTO = this.getQueryDataSource(dsKey);
        dsKey = dataSourceDTO.getKey();
        DataSourceTypeEnum dataSourceType = DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType());
        GeoTableQueryCheckUtil.checkTableSingleQuery(dataSourceType, bufferAnalyseFilter);
        switch (dataSourceType) {
            case PostgreSql: 
            case KingBase: 
            case Highgo: 
            case HighgoSecurity: 
            case GaussDB: {
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + (Object)((Object)dataSourceType));
            }
        }
        IFeatureWorkspace workspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);
        Assert.notNull((Object)workspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try {
            IFeatureClass srcFeatureClass = workspace.openFeatureClass(bufferAnalyseFilter.getSrcDatasetName());
            Assert.notNull((Object)srcFeatureClass, (String)(bufferAnalyseFilter.getSrcDatasetName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            IFeatureClass bufferFeatureClass = workspace.openFeatureClass(bufferAnalyseFilter.getBufferDatasetName());
            Assert.notNull((Object)bufferFeatureClass, (String)(bufferAnalyseFilter.getBufferDatasetName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
            double bufferDistance = bufferAnalyseFilter.getBufferDistance().floatValue();
            if (bufferFeatureClass.getSpatialReferenceSystem() != null && bufferFeatureClass.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Geographic) {
                bufferDistance = bufferDistance * 360.0 / 4.007501668557849E7;
            }
            SpatailQueryUtil.initDefaultQueryFilter(bufferAnalyseFilter);
            ArrayList<String> selectFields = new ArrayList<String>();
            ArrayList<ReturnField> attFields = new ArrayList<ReturnField>();
            SpatailQueryUtil.getFilterFields((ITable)srcFeatureClass, srcFeatureClass.getShapeFieldName(), bufferAnalyseFilter.getReturnGeometry(), bufferAnalyseFilter.getReturnExtent(), bufferAnalyseFilter.getFields(), selectFields, attFields);
            DataQueryResult queryResult = new DataQueryResult();
            queryResult.setId(GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)srcFeatureClass));
            queryResult.setName(srcFeatureClass.getName());
            queryResult.setAliasName(srcFeatureClass.getAliasName());
            queryResult.setData(new ArrayList<FeatureResult>());
            queryResult.setFields(attFields);
            String joinSql = String.format("JOIN %s ON ST_%s(%s.%s,ST_Buffer(%s.%s,%s))", bufferFeatureClass.getFullName(), bufferAnalyseFilter.getRelation(), srcFeatureClass.getFullName(), srcFeatureClass.getShapeFieldName(), bufferFeatureClass.getFullName(), bufferFeatureClass.getShapeFieldName(), BigDecimal.valueOf(bufferDistance).toPlainString());
            if (bufferAnalyseFilter.getReturnCount().booleanValue()) {
                Object count = workspace.queryScalar(String.format("select count(*) from %s %s", srcFeatureClass.getFullName(), joinSql), new Object[0]);
                queryResult.setTotal(Long.valueOf(count.toString()));
            }
            String sql = String.format("select %s.* from %s %s limit %d offset %d", srcFeatureClass.getFullName(), srcFeatureClass.getFullName(), joinSql, bufferAnalyseFilter.getRows(), bufferAnalyseFilter.getPageIndex() * bufferAnalyseFilter.getRows());
            ICursor featureCursor = workspace.excuteQuerySql(sql);
            try {
                IRow feature = featureCursor.nextRow();
                while (feature != null) {
                    FeatureResult featureResult = SpatailQueryUtil.convertRow(feature, attFields);
                    Object value = feature.getValue(srcFeatureClass.getShapeFieldName());
                    if (value instanceof IGeometry) {
                        IGeometry geo = (IGeometry)value;
                        if (bufferAnalyseFilter.getReturnGeometry().booleanValue()) {
                            featureResult.setGeometry(geo.toWkt());
                        }
                        if (bufferAnalyseFilter.getReturnExtent().booleanValue()) {
                            featureResult.setExtent(GeoDatasetUtil.toExtentDTO(geo.getEnvelope()));
                        }
                    }
                    queryResult.getData().add(featureResult);
                    feature = featureCursor.nextRow();
                }
            }
            finally {
                if (featureCursor != null) {
                    featureCursor.release();
                }
            }
            dataQueryResult = queryResult;
        }
        catch (Throwable throwable) {
            workspace.close();
            throw throwable;
        }
        workspace.close();
        return dataQueryResult;
    }

    private DataSourceDTO getQueryDataSource(String dsKey) {
        DataSourceDTO dataSource;
        if (StringUtil.isEmpty((String)dsKey)) {
            dataSource = this.dataSourceManager.getDefaultDataSource(DataStoreTypeEnum.GeoDatabase.getValue(), null);
            Assert.notNull((Object)dataSource, (String)"\u672a\u914d\u7f6e\u9ed8\u8ba4\u6570\u636e\u6e90\uff01");
        } else {
            dataSource = this.dataSourceManager.getGeoDatabaseDetail(dsKey);
        }
        return dataSource;
    }
}

