/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.properties.DefaultCoordSchemeProperties;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.config.util.IpMapUtil;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ServiceFormatEnum;
import com.geoway.adf.dms.datasource.dao.DsServiceDao;
import com.geoway.adf.dms.datasource.dto.DatasetMetaDTO;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.create.ExternalServiceCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.ServiceEditDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.ServiceDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.funcservice.DatasetFuncServiceDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.VTilePropertiesDTO;
import com.geoway.adf.dms.datasource.entity.DsService;
import com.geoway.adf.dms.datasource.geosrv.AtlasServer;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.geosrv.ime.IMEServer;
import com.geoway.adf.gis.geosrv.vtile.VTileGrid;
import com.geoway.adf.gis.geosrv.vtile.VTileServer;
import com.geoway.adf.gis.geosrv.vtile.VTileService;
import com.geoway.adf.gis.geosrv.vtile.VTileServiceStyle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class GeoServerEngineServiceImpl
implements GeoServerEngineService {
    private static final Logger log = LoggerFactory.getLogger(GeoServerEngineServiceImpl.class);
    @Resource
    private DsServiceDao dsServiceDao;
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private DefaultCoordSchemeProperties defaultCoordSchemeProperties;

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
        return geoServer.testConnect();
    }

    @Override
    public List<DataSourceDTO> listServer(List<DataSourceTypeEnum> sourceTypes, String keyword) {
        return this.listServer(sourceTypes, keyword, null);
    }

    @Override
    public List<DataSourceDTO> listServer(List<DataSourceTypeEnum> sourceTypes, String keyword, String category) {
        ArrayList<DataStoreTypeEnum> storeTypes = new ArrayList<DataStoreTypeEnum>();
        storeTypes.add(DataStoreTypeEnum.ServiceServer);
        return this.dataSourceManager.listDataSource(storeTypes, sourceTypes, keyword, category);
    }

    @Override
    public List<SimpleDatasetDTO> listDatasets(DataSourceDTO dataSourceDTO) {
        IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
        List serviceDatasets = geoServer.getServices();
        ArrayList<SimpleDatasetDTO> datasetDTOS = new ArrayList<SimpleDatasetDTO>();
        for (IGeoService geoService : serviceDatasets) {
            SimpleDatasetDTO datasetDTO = this.buildSimpleDatasetDTO(dataSourceDTO.getKey(), geoService);
            datasetDTOS.add(datasetDTO);
        }
        return datasetDTOS;
    }

    @Override
    public List<ServiceDatasetDTO> listService(String key, List<ServiceType> serviceTypes) {
        Map ipMap = IpMapUtil.getIpMap();
        if (this.isExternalService(key)) {
            List types = null;
            if (serviceTypes != null && serviceTypes.size() > 0) {
                types = ListUtil.convertAll(serviceTypes, t -> t.getValue());
            }
            List<DsService> dsServices = this.dsServiceDao.selectByType(types);
            ArrayList<ServiceDatasetDTO> datasetDTOS = new ArrayList<ServiceDatasetDTO>();
            for (DsService dsService : dsServices) {
                ServiceDatasetDTO datasetDTO = this.buildExternalService(dsService);
                datasetDTOS.add(datasetDTO);
            }
            return datasetDTOS;
        }
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
        IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
        List serviceDatasets = geoServer.getServices(serviceTypes, null, 0, 10000).getList();
        return ListUtil.convertAll((List)serviceDatasets, f -> this.buildServiceDatasetDTO(dataSourceDTO.getKey(), (IGeoService)f, ipMap));
    }

    @Override
    public DatasetPageList<ServiceDatasetDTO> listService(String key, List<ServiceType> serviceTypes, String keyword, Integer pageIndex, Integer rows) {
        DatasetPageList<ServiceDatasetDTO> datasetPageList;
        if (this.isExternalService(key)) {
            List datasetDTOS = this.listService(key, serviceTypes);
            if (!StringUtil.isEmptyOrWhiteSpace((String)keyword)) {
                datasetDTOS = ListUtil.findAll(datasetDTOS, d -> d.getName().toLowerCase().contains(keyword.toLowerCase()));
            }
            datasetPageList = new DatasetPageList<ServiceDatasetDTO>(datasetDTOS, pageIndex, rows);
        } else {
            DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(key);
            IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
            PageList serviceDatasets = geoServer.getServices(serviceTypes, keyword, pageIndex == null ? 0 : pageIndex, rows == null ? 100000 : rows);
            Map ipMap = IpMapUtil.getIpMap();
            List datasetDTOS = ListUtil.convertAll((List)serviceDatasets.getList(), f -> this.buildServiceDatasetDTO(dataSourceDTO.getKey(), (IGeoService)f, ipMap));
            datasetPageList = new DatasetPageList();
            datasetPageList.setList(datasetDTOS);
            datasetPageList.setTotal(serviceDatasets.getTotal());
        }
        if (datasetPageList.getList() != null) {
            datasetPageList.getList().sort(Comparator.comparing(DatasetDTO::getName));
        }
        return datasetPageList;
    }

    @Override
    public ServiceDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, String name) {
        ServiceDatasetDTO serviceDatasetDTO;
        if (dataSourceDTO == null || this.isExternalService(dataSourceDTO.getKey())) {
            serviceDatasetDTO = this.getExternalServiceDetailByName(name);
        } else {
            IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
            IGeoService geoService = geoServer.getService(ServiceType.Unknown, name);
            Assert.notNull((Object)geoService, (String)(name + " \u7a7a\u95f4\u670d\u52a1\u4e0d\u5b58\u5728\uff01"));
            Map ipMap = IpMapUtil.getIpMap();
            serviceDatasetDTO = this.buildServiceDatasetDTO(dataSourceDTO.getKey(), geoService, ipMap);
        }
        Assert.notNull((Object)serviceDatasetDTO, (String)(name + " \u7a7a\u95f4\u670d\u52a1\u8bfb\u53d6\u5931\u8d25\uff01"));
        serviceDatasetDTO.setDataSource(dataSourceDTO);
        DatasetMetaDTO datasetMetaDTO = this.dataSourceManager.getDatasetMeta(serviceDatasetDTO.getId());
        if (datasetMetaDTO != null) {
            serviceDatasetDTO.setDataPhase(datasetMetaDTO.getDataPhase());
            serviceDatasetDTO.setExtension(datasetMetaDTO.getDetail());
            if (serviceDatasetDTO.getRender() != null) {
                serviceDatasetDTO.getRender().setExtension(serviceDatasetDTO.getExtension());
            }
        }
        return serviceDatasetDTO;
    }

    @Override
    public ServiceDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, ServiceType serviceType, String name) {
        ServiceDatasetDTO serviceDatasetDTO;
        if (dataSourceDTO == null || this.isExternalService(dataSourceDTO.getKey())) {
            serviceDatasetDTO = this.getExternalServiceDetailByName(name);
            if (dataSourceDTO != null) {
                dataSourceDTO.setName(ServiceType.getByValue((Integer)serviceDatasetDTO.getServiceType()).getDesc());
            }
        } else {
            IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
            IGeoService geoService = geoServer.getService(serviceType, name);
            Assert.notNull((Object)geoService, (String)(name + " \u7a7a\u95f4\u670d\u52a1\u4e0d\u5b58\u5728\uff01"));
            Map ipMap = IpMapUtil.getIpMap();
            serviceDatasetDTO = this.buildServiceDatasetDTO(dataSourceDTO.getKey(), geoService, ipMap);
        }
        if (serviceDatasetDTO != null) {
            serviceDatasetDTO.setDataSource(dataSourceDTO);
            DatasetMetaDTO datasetMetaDTO = this.dataSourceManager.getDatasetMeta(serviceDatasetDTO.getId());
            if (datasetMetaDTO != null) {
                serviceDatasetDTO.setDataPhase(datasetMetaDTO.getDataPhase());
                if (serviceDatasetDTO.getExtension() == null) {
                    serviceDatasetDTO.setExtension(datasetMetaDTO.getDetail());
                    if (serviceDatasetDTO.getRender() != null) {
                        serviceDatasetDTO.getRender().setExtension(serviceDatasetDTO.getExtension());
                    }
                }
            }
        }
        return serviceDatasetDTO;
    }

    @Override
    public boolean deleteService(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        if (this.isExternalService(datasetNameInfo.getDsKey())) {
            boolean f = this.dsServiceDao.deleteByPrimaryKey(id) > 0;
            this.sysLogService.addLog(141, String.format("\u5220\u9664\u7a7a\u95f4\u670d\u52a1\uff1a%s", datasetNameInfo.getName()));
            return f;
        }
        ServiceType serviceType = ServiceType.getByValue((Integer)datasetNameInfo.getType());
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
        IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
        geoServer.deleteService(serviceType, datasetNameInfo.getName());
        this.sysLogService.addLog(141, String.format("\u5220\u9664\u7a7a\u95f4\u670d\u52a1\uff1a%s > %s", dataSourceDTO.getName(), datasetNameInfo.getName()));
        return true;
    }

    @Override
    public boolean deleteServerService(String serverKey, ServiceType serviceType, String serviceName) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
        IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
        geoServer.deleteService(serviceType, serviceName);
        this.sysLogService.addLog(141, String.format("\u5220\u9664\u7a7a\u95f4\u670d\u52a1\uff1a%s > %s", dataSourceDTO.getName(), serviceName));
        return true;
    }

    @Override
    public Integer getExternalServiceCount() {
        Integer count = this.dsServiceDao.count();
        if (count == null) {
            count = 0;
        }
        return count;
    }

    @Override
    public String addExternalService(ExternalServiceCreateDTO serviceCreateDTO) {
        List<DsService> services = this.dsServiceDao.selectByName(serviceCreateDTO.getName());
        if (services != null && services.size() > 0) {
            throw new RuntimeException("\u670d\u52a1\u540d\u79f0\u91cd\u590d");
        }
        DsService dsService = new DsService();
        dsService.setName(serviceCreateDTO.getName());
        dsService.setAliasName(serviceCreateDTO.getName());
        dsService.setUrl(serviceCreateDTO.getUrl());
        dsService.setServiceFormat(serviceCreateDTO.getServiceFormat());
        dsService.setExt(serviceCreateDTO.getExtension());
        dsService.setServiceType(serviceCreateDTO.getServiceType());
        String id = this.getDatasetId("service", ServiceType.getByValue((Integer)serviceCreateDTO.getServiceType()), serviceCreateDTO.getName());
        dsService.setId(id);
        this.dsServiceDao.insert(dsService);
        if (!StringUtil.isEmptyOrWhiteSpace((String)serviceCreateDTO.getDataPhase())) {
            this.dataSourceManager.saveDatasetDataPhase(id, serviceCreateDTO.getDataPhase());
        }
        this.sysLogService.addLog(141, String.format("\u65b0\u589e%s\uff1a%s", ServiceType.getByValue((Integer)serviceCreateDTO.getServiceType()).getDesc(), serviceCreateDTO.getName()));
        return id;
    }

    @Override
    public void updateService(ServiceEditDTO serviceEditDTO) {
        String id = serviceEditDTO.getId();
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        if (this.isExternalService(datasetNameInfo.getDsKey())) {
            DsService dsService = this.dsServiceDao.selectByPrimaryKey(id);
            Assert.notNull((Object)dsService, (String)"\u7a7a\u95f4\u670d\u52a1\u4e0d\u5b58\u5728");
            if (serviceEditDTO.getAlias() != null) {
                dsService.setAliasName(serviceEditDTO.getAlias());
            }
            if (serviceEditDTO.getServiceFormat() != null) {
                dsService.setServiceFormat(serviceEditDTO.getServiceFormat());
            }
            if (serviceEditDTO.getExtension() != null) {
                dsService.setExt(serviceEditDTO.getExtension());
            }
            dsService.setUrl(serviceEditDTO.getUrl());
            this.dsServiceDao.updateByPrimaryKey(dsService);
            this.dataSourceManager.saveDatasetDataPhase(id, serviceEditDTO.getDataPhase());
        } else {
            DatasetMetaDTO datasetMetaDTO = this.dataSourceManager.getDatasetMeta(id);
            if (datasetMetaDTO == null) {
                datasetMetaDTO = new DatasetMetaDTO();
            }
            datasetMetaDTO.setDataPhase(serviceEditDTO.getDataPhase());
            datasetMetaDTO.setDetail(serviceEditDTO.getExtension());
            this.dataSourceManager.saveDatasetMeta(id, datasetMetaDTO);
        }
    }

    @Override
    public IGeoServer getGeoServer(DataSourceDTO dataSourceDTO) {
        AtlasServer geoServer;
        if (dataSourceDTO == null) {
            throw new RuntimeException("\u670d\u52a1\u5668\u4e3a\u7a7a");
        }
        Map ipMap = IpMapUtil.getIpMap();
        dataSourceDTO.setUrl(IpMapUtil.getIpBeforMap((Map)ipMap, (String)dataSourceDTO.getUrl()));
        DataSourceTypeEnum dataSourceTypeEnum = DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType());
        switch (dataSourceTypeEnum) {
            case AtlasServer: {
                geoServer = new AtlasServer(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case IMEServer: {
                geoServer = new IMEServer(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            case VTileServer: {
                geoServer = new VTileServer(dataSourceDTO.getUrl(), dataSourceDTO.getUserName(), dataSourceDTO.getPassword());
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
            }
        }
        if (!geoServer.testConnect()) {
            throw new RuntimeException("\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
        return geoServer;
    }

    @Override
    public VTilePropertiesDTO getVTileProperties(String serverKey) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
        IGeoServer myGeoServer = this.getGeoServer(dataSourceDTO);
        VTileServer geoServer = null;
        if (myGeoServer instanceof VTileServer) {
            geoServer = (VTileServer)myGeoServer;
        } else if (myGeoServer instanceof AtlasServer) {
            geoServer = ((AtlasServer)myGeoServer).getVTileServer();
        } else {
            throw new RuntimeException(dataSourceDTO.getName() + " \u4e0d\u662f\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u5f15\u64ce");
        }
        VTilePropertiesDTO vTilePropertiesDTO = new VTilePropertiesDTO();
        HashMap<String, String> gridUnit = new HashMap<String, String>(0);
        gridUnit.put("0", "meter");
        gridUnit.put("1", "degree");
        vTilePropertiesDTO.setGridUnit(gridUnit);
        vTilePropertiesDTO.setGrids(geoServer.getGrids());
        vTilePropertiesDTO.setCacheDatasources(geoServer.getMongoDatasource());
        vTilePropertiesDTO.setMapServerUrl(geoServer.getMapServerUrl());
        if (!StringUtil.isEmptyOrWhiteSpace((String)this.defaultCoordSchemeProperties.getTilingSchemeName()) && geoServer.getGrids() != null && geoServer.getGrids().size() > 0) {
            for (VTileGrid grid : geoServer.getGrids()) {
                if (grid.getName().equals(this.defaultCoordSchemeProperties.getTilingSchemeName())) {
                    grid.setIsDefault(Integer.valueOf(1));
                    continue;
                }
                grid.setIsDefault(Integer.valueOf(0));
            }
        }
        return vTilePropertiesDTO;
    }

    @Override
    public List<VTileServiceStyle> listVTileServiceStyle(String serverKey, String serviceName) {
        if (this.isExternalService(serverKey)) {
            ServiceDatasetDTO serviceDatasetDTO = this.getExternalServiceDetailByName(serviceName);
            if (StringUtil.isEmptyOrWhiteSpace((String)serviceDatasetDTO.getStyleId())) {
                return new ArrayList<VTileServiceStyle>();
            }
            ArrayList<VTileServiceStyle> list = new ArrayList<VTileServiceStyle>();
            VTileServiceStyle serviceStyle = new VTileServiceStyle();
            serviceStyle.setBelongService(serviceName);
            serviceStyle.setStyleId(serviceDatasetDTO.getStyleId());
            serviceStyle.setName(serviceDatasetDTO.getStyleId());
            serviceStyle.setId("service-" + serviceName + "-" + serviceDatasetDTO.getStyleId());
            list.add(serviceStyle);
            return list;
        }
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
        IGeoServer myGeoServer = this.getGeoServer(dataSourceDTO);
        VTileServer geoServer = null;
        if (myGeoServer instanceof VTileServer) {
            geoServer = (VTileServer)myGeoServer;
        } else if (myGeoServer instanceof AtlasServer) {
            geoServer = ((AtlasServer)myGeoServer).getVTileServer();
        } else {
            throw new RuntimeException(dataSourceDTO.getName() + " \u4e0d\u662f\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u5f15\u64ce");
        }
        IGeoService service = geoServer.getService(ServiceType.VectorTileService, serviceName);
        if (service != null) {
            return geoServer.getServiceStyles(service.getId());
        }
        return new ArrayList<VTileServiceStyle>();
    }

    @Override
    public void setVTileServiceDefaultStyle(String serverKey, String serviceName, String styleId) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
        IGeoServer myGeoServer = this.getGeoServer(dataSourceDTO);
        VTileServer geoServer = null;
        if (myGeoServer instanceof VTileServer) {
            geoServer = (VTileServer)myGeoServer;
        } else if (myGeoServer instanceof AtlasServer) {
            geoServer = ((AtlasServer)myGeoServer).getVTileServer();
        } else {
            throw new RuntimeException(dataSourceDTO.getName() + " \u4e0d\u662f\u77e2\u91cf\u74e6\u7247\u670d\u52a1\u5f15\u64ce");
        }
        IGeoService service = geoServer.getService(ServiceType.VectorTileService, serviceName);
        Assert.notNull((Object)service, (String)"\u670d\u52a1\u4e0d\u5b58\u5728\uff01");
        geoServer.setDefaultStyle(service.getId(), styleId);
    }

    @Override
    public void deleteRelateService(String datasetId) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue(datasetNameInfo.getType());
        String datasourceName = this.dataSourceManager.getDataSourceName(datasetNameInfo.getDsKey());
        DatasetMetaDTO datasetMetaDTO = this.dataSourceManager.getDatasetMeta(datasetId);
        if (datasetMetaDTO != null && datasetMetaDTO.getRender() != null) {
            this.dataSourceManager.saveDatasetRender(datasetId, null);
            try {
                if (Boolean.TRUE.equals(datasetMetaDTO.getRender().getIsCreate())) {
                    String serverKey = datasetMetaDTO.getRender().getServerKey();
                    String serviceName = datasetMetaDTO.getRender().getServiceName();
                    ServiceType serviceType = ServiceType.getByValue((Integer)datasetMetaDTO.getRender().getServiceType());
                    DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
                    IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
                    geoServer.deleteService(serviceType, serviceName);
                    this.sysLogService.addLog(141, String.format("\u5220\u9664%s[%s > %s]\u6e32\u67d3\u7d22\u5f15\uff1a%s > %s", datasetType.getDesc(), datasourceName, datasetNameInfo.getName(), dataSourceDTO.getName(), serviceName));
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u6e32\u67d3\u7d22\u5f15\u670d\u52a1\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            }
        }
        if (datasetMetaDTO != null && datasetMetaDTO.getFunctionServices() != null) {
            this.dataSourceManager.saveDatasetFuncService(datasetId, null);
            try {
                for (DatasetFuncServiceDTO funcServiceDTO : datasetMetaDTO.getFunctionServices()) {
                    String serverKey = funcServiceDTO.getServerKey();
                    String serviceName = funcServiceDTO.getServiceName();
                    ServiceType serviceType = ServiceType.getByValue((Integer)funcServiceDTO.getServiceType());
                    DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(serverKey);
                    IGeoServer geoServer = this.getGeoServer(dataSourceDTO);
                    geoServer.deleteService(serviceType, serviceName);
                    this.sysLogService.addLog(141, String.format("\u5220\u9664%s[%s > %s]\u670d\u52a1\uff1a%s > %s", datasetType.getDesc(), datasourceName, datasetNameInfo.getName(), dataSourceDTO.getName(), serviceName));
                }
            }
            catch (Exception e) {
                log.error("\u5220\u9664\u670d\u52a1\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isExternalService(String key) {
        return StringUtil.isEmptyOrWhiteSpace((String)key) || "service".equals(key);
    }

    private ServiceDatasetDTO getExternalServiceDetailByName(String name) {
        List<DsService> dsServices = this.dsServiceDao.selectByName(name);
        if (dsServices == null || dsServices.size() == 0) {
            throw new RuntimeException(name + " \u7a7a\u95f4\u670d\u52a1\u4e0d\u5b58\u5728");
        }
        DsService dsService = dsServices.get(0);
        ServiceDatasetDTO serviceDataset = this.buildExternalService(dsService);
        return serviceDataset;
    }

    private ServiceDatasetDTO buildExternalService(DsService dsService) {
        ServiceDatasetDTO serviceDataset = new ServiceDatasetDTO();
        serviceDataset.setId(dsService.getId());
        serviceDataset.setName(dsService.getName());
        serviceDataset.setFullName(dsService.getName());
        serviceDataset.setAliasName(dsService.getAliasName());
        serviceDataset.setType(DatasetTypeEnum.ServiceDataset.getValue());
        serviceDataset.setTypeDesc(DatasetTypeEnum.ServiceDataset.getDesc());
        serviceDataset.setDsKey("service");
        serviceDataset.setServiceUrl(dsService.getUrl());
        serviceDataset.setServiceType(dsService.getServiceType());
        serviceDataset.setServiceFormat(dsService.getServiceFormat());
        serviceDataset.setExtension(dsService.getExt());
        String serviceUrl = dsService.getUrl();
        try {
            if (dsService.getServiceType().intValue() == ServiceType.VectorTileService.getValue()) {
                URL url = new URL(serviceUrl);
                String mapServerTag = "/mapserver/";
                int mapserverIndex = serviceUrl.indexOf(mapServerTag);
                if (mapserverIndex > 0) {
                    int nameIndex;
                    String mapServerUrl = serviceUrl.substring(0, mapserverIndex + mapServerTag.length() - 1);
                    serviceDataset.setMapServerUrl(mapServerUrl);
                    String styleIdTag = "styleId=";
                    String query = url.getQuery();
                    if (query != null && query.contains(styleIdTag)) {
                        List<String> querys = Arrays.asList(query.split("&"));
                        for (String strQuery : querys) {
                            if (!strQuery.startsWith(styleIdTag) || strQuery.length() <= styleIdTag.length()) continue;
                            String styleId = strQuery.substring(styleIdTag.length());
                            serviceDataset.setStyleId(styleId);
                            break;
                        }
                    }
                    String funcStr = null;
                    String serviceName = null;
                    int funcIndex = serviceUrl.indexOf("/", mapserverIndex + mapServerTag.length());
                    if (funcIndex > 0 && (nameIndex = serviceUrl.indexOf("/", funcIndex + (funcStr = serviceUrl.substring(mapserverIndex + mapServerTag.length(), funcIndex)).length())) > 0) {
                        serviceName = serviceUrl.substring(funcIndex + 1, nameIndex);
                    }
                    String queryStr = "";
                    int endIndex = serviceUrl.indexOf("?");
                    if (endIndex > 0) {
                        queryStr = serviceUrl.substring(endIndex);
                    }
                    if (serviceName != null) {
                        serviceDataset.setName(serviceName);
                        if (serviceUrl.contains("/mapserver/vmap/") || serviceUrl.contains("/mapserver/all/")) {
                            HashMap<String, String> urlMap = new HashMap<String, String>();
                            urlMap.put("mapImg", String.format("%s/vmap/%s/getMap%s", mapServerUrl, serviceName, queryStr));
                            urlMap.put("labelImg", String.format("%s/label/%s/getImg%s", mapServerUrl, serviceName, queryStr));
                            urlMap.put("labelData", String.format("%s/label/%s/getData%s", mapServerUrl, serviceName, queryStr));
                            urlMap.put("labelImgData", String.format("%s/label/%s/getImgData%s", mapServerUrl, serviceName, queryStr));
                            urlMap.put("all", String.format("%s/all/%s/getMap%s", mapServerUrl, serviceName, queryStr));
                            serviceDataset.setHasLabel(true);
                            serviceDataset.setServiceCapabilities(urlMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(dsService.getUrl() + "\u670d\u52a1\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        DatasetRenderDTO renderDTO = this.getServiceRender("service", serviceDataset, null);
        serviceDataset.setRender(renderDTO);
        return serviceDataset;
    }

    private ServiceDatasetDTO buildServiceDatasetDTO(String dsKey, IGeoService geoService, Map<String, String> ipMap) {
        ServiceDatasetDTO serviceDataset = new ServiceDatasetDTO();
        serviceDataset.setId(this.getDatasetId(dsKey, geoService.getServiceType(), geoService.getName()));
        serviceDataset.setName(geoService.getName());
        serviceDataset.setFullName(geoService.getName());
        serviceDataset.setAliasName(geoService.getAliasName());
        serviceDataset.setType(DatasetTypeEnum.ServiceDataset.getValue());
        serviceDataset.setTypeDesc(DatasetTypeEnum.ServiceDataset.getDesc());
        serviceDataset.setDsKey(dsKey);
        serviceDataset.setServiceUrl(geoService.getServiceUrl());
        serviceDataset.setServiceType(geoService.getServiceType().getValue());
        if (geoService.getServiceType() == ServiceType.RasterTileService) {
            serviceDataset.setServiceFormat(ServiceFormatEnum.WMTS.getValue());
        } else if (geoService.getServiceType() == ServiceType.Tiles3dService) {
            serviceDataset.setServiceFormat(ServiceFormatEnum.Model3DTile.getValue());
        }
        if (geoService instanceof VTileService) {
            VTileService vTileService = (VTileService)geoService;
            serviceDataset.setMapServerUrl(vTileService.getMapServerUrl());
            serviceDataset.setStyleId(vTileService.getStyleId());
            serviceDataset.setHasLabel(vTileService.getHasLabel());
            serviceDataset.setServiceCapabilities(vTileService.getServiceCapabilities());
            serviceDataset.setDataServiceTableNames(vTileService.getDataServiceTableNames());
        }
        serviceDataset.setServiceUrl(IpMapUtil.getIpAfterMap(ipMap, (String)serviceDataset.getServiceUrl()));
        if (StringUtil.isNotEmpty((String)serviceDataset.getMapServerUrl())) {
            serviceDataset.setMapServerUrl(IpMapUtil.getIpAfterMap(ipMap, (String)serviceDataset.getMapServerUrl()));
            for (String capability : serviceDataset.getServiceCapabilities().keySet()) {
                serviceDataset.getServiceCapabilities().put(capability, IpMapUtil.getIpAfterMap(ipMap, (String)serviceDataset.getServiceCapabilities().get(capability)));
            }
        }
        serviceDataset.setRender(this.getServiceRender(dsKey, serviceDataset, geoService));
        return serviceDataset;
    }

    private SimpleDatasetDTO buildSimpleDatasetDTO(String dsKey, IGeoService geoService) {
        SimpleDatasetDTO datasetDTO = new SimpleDatasetDTO();
        datasetDTO.setId(this.getDatasetId(dsKey, geoService.getServiceType(), geoService.getName()));
        datasetDTO.setName(geoService.getName());
        datasetDTO.setFullName(geoService.getName());
        datasetDTO.setAliasName(geoService.getAliasName());
        datasetDTO.setType(DatasetTypeEnum.ServiceDataset.getValue());
        datasetDTO.setTypeDesc(DatasetTypeEnum.ServiceDataset.getDesc());
        datasetDTO.setServiceType(geoService.getServiceType().getValue());
        return datasetDTO;
    }

    private String getDatasetId(String dsKey, ServiceType serviceType, String datasetName) {
        return DatasetNameInfo.buildDatasetId(dsKey, serviceType.getValue(), datasetName);
    }

    private DatasetRenderDTO getServiceRender(String dsKey, ServiceDatasetDTO serviceDataset, IGeoService geoService) {
        DatasetRenderDTO renderDTO = new DatasetRenderDTO();
        renderDTO.setIsCreate(false);
        renderDTO.setServerKey(dsKey);
        renderDTO.setUrl(serviceDataset.getServiceUrl());
        renderDTO.setServiceType(serviceDataset.getServiceType());
        renderDTO.setServiceName(serviceDataset.getName());
        renderDTO.setServer(geoService == null ? null : geoService.getServer().getUrl());
        renderDTO.setMapServer(serviceDataset.getMapServerUrl());
        renderDTO.setStyleId(serviceDataset.getStyleId());
        renderDTO.setHasLabel(serviceDataset.getHasLabel());
        renderDTO.setServiceCapabilities(serviceDataset.getServiceCapabilities());
        renderDTO.setServiceFormat(serviceDataset.getServiceFormat());
        renderDTO.setServiceId(serviceDataset.getId());
        renderDTO.setExtension(serviceDataset.getExtension());
        return renderDTO;
    }
}

