/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dao.DsDatasetMetaDao;
import com.geoway.adf.dms.datasource.dao.DsDatasetRelationDao;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.atlas.AtlasDatasetDTO;
import com.geoway.adf.dms.datasource.dto.atlas.AtlasDatasetFormatEnum;
import com.geoway.adf.dms.datasource.dto.atlas.AtlasFeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.atlas.AtlasSimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.entity.DsDatasetRelation;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.AtlasDataSourceService;
import com.geoway.adf.dms.datasource.util.AtlasDataSourceUtil;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.atlas.gis.toolkit.meta.api.AtlasGisToolkitApi;
import com.geoway.atlas.gis.toolkit.meta.api.AtlasHbaseDataApi;
import com.geoway.atlas.gis.toolkit.meta.bean.hbase.HbaseAdminer;
import com.geoway.atlas.gis.toolkit.meta.bean.hbase.HbaseReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AtlasDataSourceServiceImpl
implements AtlasDataSourceService {
    private static final Logger log = LoggerFactory.getLogger(AtlasDataSourceServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private DsDatasetMetaDao dsDatasetMetaDao;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private DsDatasetRelationDao dsDatasetRelationDao;

    @Override
    public boolean testConnect(DataSourceDTO dataSourceDTO) {
        AtlasConnectionStr atlasConnectionStr = new AtlasConnectionStr(dataSourceDTO);
        String[] featureClassNames = AtlasGisToolkitApi.getFeatureClassNames((String)atlasConnectionStr.format.getDesc(), (String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName);
        return true;
    }

    @Override
    public List<DataSourceDTO> listDataSource(List<DataSourceTypeEnum> dataSourceTypes, String keyword) {
        return this.listDataSource(dataSourceTypes, keyword, null);
    }

    @Override
    public List<DataSourceDTO> listDataSource(List<DataSourceTypeEnum> dataSourceTypes, String keyword, String category) {
        List<DataSourceDTO> list = this.dataSourceManager.listDataSource(Arrays.asList(DataStoreTypeEnum.AtlasDataSource), dataSourceTypes, keyword, category);
        return list;
    }

    @Override
    public List<AtlasSimpleDatasetDTO> listDatasets(DataSourceDTO dataSourceDTO) {
        AtlasConnectionStr atlasConnectionStr = new AtlasConnectionStr(dataSourceDTO);
        String[] featureClassNames = AtlasGisToolkitApi.getFeatureClassNames((String)atlasConnectionStr.format.getDesc(), (String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName);
        ArrayList<AtlasSimpleDatasetDTO> datasetDTOS = new ArrayList<AtlasSimpleDatasetDTO>();
        for (String featureClassName : featureClassNames) {
            try {
                SimpleFeatureType simpleFeatureType = AtlasGisToolkitApi.getSimpleFeatureType((String)atlasConnectionStr.format.getDesc(), (String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName, (String)featureClassName);
                AtlasFeatureClassDTO featureClassDTO = AtlasDataSourceUtil.convertAtlasFeatureClass(featureClassName, simpleFeatureType);
                String datasetId = DatasetUtil.getDatasetId(dataSourceDTO.getKey(), DatasetTypeEnum.FeatureClass, featureClassName);
                featureClassDTO.setId(datasetId);
                featureClassDTO.setDsKey(dataSourceDTO.getKey());
                featureClassDTO.setFormat(atlasConnectionStr.format.getValue());
                AtlasSimpleDatasetDTO simpleDataset = this.convertSimpleDataset(featureClassDTO);
                datasetDTOS.add(simpleDataset);
            }
            catch (Exception e) {
                log.error(dataSourceDTO.getUrl() + "/" + featureClassName + "\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
            }
        }
        datasetDTOS.sort(Comparator.comparing(SimpleDatasetDTO::getName));
        return datasetDTOS;
    }

    @Override
    public DatasetPageList<AtlasSimpleDatasetDTO> listDatasets(String dsKey, List<DatasetTypeEnum> datasetTypes, String keyword, Integer pageIndex, Integer rows) {
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(dsKey);
        List<AtlasSimpleDatasetDTO> allDatasetDTOS = this.listDatasets(dataSourceDTO);
        List<Object> datasetDTOS = new ArrayList();
        if (StringUtil.isEmptyOrWhiteSpace((String)keyword) && datasetTypes == null) {
            datasetDTOS = allDatasetDTOS;
        } else {
            for (AtlasSimpleDatasetDTO simpleDatasetDTO : allDatasetDTOS) {
                if (datasetTypes != null && !datasetTypes.contains((Object)DatasetTypeEnum.getByValue(simpleDatasetDTO.getType()))) continue;
                if (StringUtil.isEmptyOrWhiteSpace((String)keyword) || simpleDatasetDTO.getName().toLowerCase().contains(keyword.toLowerCase())) {
                    datasetDTOS.add(simpleDatasetDTO);
                    continue;
                }
                if (simpleDatasetDTO.getSubsets() == null || simpleDatasetDTO.getSubsets().size() <= 0) continue;
                ArrayList<SimpleDatasetDTO> subDatasetDTOs = new ArrayList<SimpleDatasetDTO>();
                for (SimpleDatasetDTO subset : simpleDatasetDTO.getSubsets()) {
                    if (!subset.getName().toLowerCase().contains(keyword.toLowerCase())) continue;
                    subDatasetDTOs.add(subset);
                }
                if (subDatasetDTOs.size() <= 0) continue;
                simpleDatasetDTO.setSubsets(subDatasetDTOs);
                datasetDTOS.add(simpleDatasetDTO);
            }
        }
        DatasetPageList<AtlasSimpleDatasetDTO> datasetPageList = new DatasetPageList<AtlasSimpleDatasetDTO>(datasetDTOS, pageIndex, rows);
        HashMap<Integer, Integer> typeCount = new HashMap<Integer, Integer>();
        typeCount.put(GeoDatasetType.FeatureClass.getValue(), 0);
        datasetPageList.setTypeCounts(typeCount);
        for (SimpleDatasetDTO simpleDatasetDTO : datasetDTOS) {
            typeCount.put(simpleDatasetDTO.getType(), typeCount.get(simpleDatasetDTO.getType()) == null ? 1 : (Integer)typeCount.get(simpleDatasetDTO.getType()) + 1);
            if (simpleDatasetDTO.getSubsets() == null) continue;
            for (SimpleDatasetDTO subset : simpleDatasetDTO.getSubsets()) {
                typeCount.put(subset.getType(), typeCount.get(subset.getType()) == null ? 1 : (Integer)typeCount.get(subset.getType()) + 1);
            }
        }
        return datasetPageList;
    }

    @Override
    public AtlasDatasetDTO getDatasetDetail(DataSourceDTO dataSourceDTO, String datasetName) {
        AtlasConnectionStr atlasConnectionStr = new AtlasConnectionStr(dataSourceDTO);
        SimpleFeatureType simpleFeatureType = AtlasGisToolkitApi.getSimpleFeatureType((String)atlasConnectionStr.format.getDesc(), (String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName, (String)datasetName);
        Assert.notNull((Object)simpleFeatureType, (String)(datasetName + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
        String featureClassName = simpleFeatureType.getTypeName();
        String datasetId = DatasetUtil.getDatasetId(dataSourceDTO.getKey(), DatasetTypeEnum.FeatureClass, featureClassName);
        AtlasFeatureClassDTO featureClassDTO = AtlasDataSourceUtil.convertAtlasFeatureClass(featureClassName, simpleFeatureType);
        featureClassDTO.setDataSource(dataSourceDTO);
        featureClassDTO.setId(datasetId);
        featureClassDTO.setDsKey(dataSourceDTO.getKey());
        featureClassDTO.setFormat(atlasConnectionStr.format.getValue());
        featureClassDTO.setResourceId(String.format("Atlas://\u6570\u636e\u8d44\u6e90/%s/%s/%s", dataSourceDTO.getName(), GeoDatasetType.FeatureClass.getDesc(), featureClassDTO.getFullName()));
        return featureClassDTO;
    }

    @Override
    public void deleteDataset(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
        AtlasConnectionStr atlasConnectionStr = new AtlasConnectionStr(dataSourceDTO);
        HbaseAdminer hbaseAdminer = AtlasHbaseDataApi.getHbaseAdminer((String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName);
        hbaseAdminer.deleteTable(datasetNameInfo.getName());
        this.dsDatasetRelationDao.deleteByDatasetId(id);
        GeoDatasetType datasetType = GeoDatasetType.getByValue((Integer)datasetNameInfo.getType());
        this.sysLogService.addLog(101, String.format("\u5220\u9664%s\uff1a%s > %s", datasetType.getDesc(), dataSourceDTO.getName(), datasetNameInfo.getName()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataQueryResult queryGeoDataset(String datasetId, QueryFilterDTO filterDTO) {
        ArrayList<Object> selectFields;
        if (filterDTO.getPageIndex() == null || filterDTO.getPageIndex() < 0) {
            filterDTO.setPageIndex(0);
        }
        if (filterDTO.getRows() == null || filterDTO.getRows() < 0) {
            filterDTO.setRows(10);
        }
        if (filterDTO.getRows() > 50000) {
            log.warn("\u67e5\u8be2\u7ed3\u679c\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u8d85\u8fc750000\u6761");
            filterDTO.setRows(50000);
        }
        if (filterDTO.getReturnCount() == null) {
            filterDTO.setReturnCount(false);
        }
        if (filterDTO.getReturnGeometry() == null) {
            filterDTO.setReturnGeometry(false);
        }
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(datasetId);
        DataSourceDTO dataSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
        AtlasConnectionStr atlasConnectionStr = new AtlasConnectionStr(dataSourceDTO);
        SimpleFeatureType simpleFeatureType = AtlasGisToolkitApi.getSimpleFeatureType((String)atlasConnectionStr.format.getDesc(), (String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName, (String)datasetNameInfo.getName());
        Assert.notNull((Object)simpleFeatureType, (String)(datasetNameInfo.getName() + "\u6570\u636e\u96c6\u6253\u5f00\u5931\u8d25\uff01"));
        AtlasFeatureClassDTO atlasFeatureClassDTO = AtlasDataSourceUtil.convertAtlasFeatureClass(datasetNameInfo.getName(), simpleFeatureType);
        if (StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getFields()) || "*".equals(filterDTO.getFields())) {
            selectFields = new ArrayList<FieldDTO>(atlasFeatureClassDTO.getFields());
        } else {
            List strFields = StringUtil.split((String)filterDTO.getFields(), (String)",", String::toString);
            selectFields = new ArrayList();
            for (String strFld : strFields) {
                FieldDTO fld = (FieldDTO)ListUtil.find(atlasFeatureClassDTO.getFields(), f -> f.getName().equalsIgnoreCase(strFld));
                if (fld == null) continue;
                selectFields.add(fld);
            }
        }
        FieldDTO shapeFld = (FieldDTO)ListUtil.find(selectFields, f -> f.getName().equalsIgnoreCase(atlasFeatureClassDTO.getShapeField()));
        if (shapeFld != null) {
            selectFields.remove(shapeFld);
        }
        DataQueryResult queryResult = new DataQueryResult();
        queryResult.setName(atlasFeatureClassDTO.getName());
        queryResult.setAliasName(atlasFeatureClassDTO.getAliasName());
        queryResult.setData(new ArrayList<FeatureResult>());
        queryResult.setFields(ListUtil.convertAll(selectFields, f -> new ReturnField(f.getName(), f.getAliasName(), f.getFieldType())));
        if (filterDTO.getReturnCount().booleanValue()) {
            queryResult.setTotal(AtlasGisToolkitApi.getCount((SimpleFeatureType)simpleFeatureType));
        }
        String featureClassName = simpleFeatureType.getTypeName();
        ArrayList simpleFeatureList = new ArrayList();
        try (HbaseReader hbaseReader = AtlasHbaseDataApi.getHbaseReader((String)atlasConnectionStr.rawUrl, (String)atlasConnectionStr.dataSetName, (String)featureClassName);){
            long startTime = System.currentTimeMillis();
            hbaseReader.getSimpleFeatures(filterDTO.getPageIndex() + 1, filterDTO.getRows().intValue(), simpleFeatureList);
            Iterator iterator = simpleFeatureList.iterator();
            while (true) {
                Iterator iterator2;
                HashMap<String, Object> attMap;
                FeatureResult featureResult;
                SimpleFeature feature;
                if (iterator.hasNext()) {
                    feature = (SimpleFeature)iterator.next();
                    featureResult = new FeatureResult();
                    featureResult.setObjectId(feature.getID());
                    featureResult.setName(feature.getID());
                    if (filterDTO.getReturnGeometry().booleanValue()) {
                        // empty if block
                    }
                    attMap = new HashMap<String, Object>();
                    iterator2 = selectFields.iterator();
                } else {
                    long endTime = System.currentTimeMillis();
                    System.out.println("\u8017\u65f6:" + (endTime - startTime));
                    DataQueryResult dataQueryResult = queryResult;
                    return dataQueryResult;
                }
                while (iterator2.hasNext()) {
                    FieldDTO fieldDTO = (FieldDTO)iterator2.next();
                    if (fieldDTO.getFieldType().intValue() == FieldType.Shape.getValue()) continue;
                    attMap.put(fieldDTO.getName(), feature.getAttribute(fieldDTO.getName()));
                }
                featureResult.setAttributes(attMap);
                queryResult.getData().add(featureResult);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(datasetNameInfo.getName() + "\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    @Override
    public void uploadFileData(String dsKey, String srcFile, String targetName, Boolean overwrite) {
        srcFile = UploadPathConfig.getFullPath((String)srcFile).toAbsolutePath().toString();
        AtlasConnectionStr srcConnectionStr = new AtlasConnectionStr(srcFile);
        String inputFeatureClassUrl = Paths.get(srcConnectionStr.rawUrl, FileUtil.getFileNameWithoutExtension((String)srcFile)).toString();
        DataSourceDTO atlasDataSource = this.dataSourceManager.getDataSourceDetail(dsKey);
        AtlasConnectionStr targetConnectionStr = new AtlasConnectionStr(atlasDataSource);
        String outputFeatureClassUrl = String.format("%s/%s/%s", targetConnectionStr.rawUrl, targetConnectionStr.dataSetName, targetName);
        AtlasDataSourceUtil.inputData(inputFeatureClassUrl, srcConnectionStr.format.getDesc(), outputFeatureClassUrl, targetConnectionStr.format.getDesc(), overwrite);
    }

    @Override
    public void downloadFileData(String dsKey, String datasetName, String targetFile) {
        DataSourceDTO atlasDataSource = this.dataSourceManager.getDataSourceDetail(dsKey);
        AtlasConnectionStr srcConnectionStr = new AtlasConnectionStr(atlasDataSource);
        String srcFeatureClassUrl = String.format("%s/%s/%s", srcConnectionStr.rawUrl, srcConnectionStr.dataSetName, datasetName);
        AtlasConnectionStr tarConnectionStr = new AtlasConnectionStr(targetFile);
        String tarFeatureClassUrl = tarConnectionStr.rawUrl + File.separator + FileUtil.getFileNameWithoutExtension((String)targetFile);
        AtlasDataSourceUtil.inputData(srcFeatureClassUrl, srcConnectionStr.format.getDesc(), tarFeatureClassUrl, tarConnectionStr.format.getDesc(), true);
    }

    @Override
    public void uploadGeoDatabaseData(String geoDatasetId, String atlasKey, String atlasDatasetName) {
        String inputFeatureClassUrl;
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(geoDatasetId);
        String geoDatasetName = datasetNameInfo.getName();
        DataSourceDTO geoDatabase = this.dataSourceManager.getDataSourceDetail(datasetNameInfo.getDsKey());
        String inputDataFormat = "jdbc";
        DataSourceTypeEnum srcType = DataSourceTypeEnum.getByValue(geoDatabase.getDataSourceType());
        switch (srcType) {
            case PostgreSql: 
            case KingBase: 
            case Highgo: 
            case GaussDB: {
                inputFeatureClassUrl = String.format("postgresql://%s/%s@%s/%s", geoDatabase.getUserName(), geoDatabase.getPassword(), geoDatabase.getUrl(), geoDatasetName);
                break;
            }
            case HighgoSecurity: {
                inputFeatureClassUrl = String.format("highgo://%s/%s@%s/%s", geoDatabase.getUserName(), geoDatabase.getPassword(), geoDatabase.getUrl(), geoDatasetName);
                break;
            }
            case OracleSpatial: {
                inputFeatureClassUrl = String.format("oracle://%s:%s@%s/%s", geoDatabase.getUserName(), geoDatabase.getPassword(), geoDatabase.getUrl(), geoDatasetName);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u6765\u7c7b\u578b\uff1a" + (Object)((Object)srcType));
            }
        }
        DataSourceDTO atlasDataSource = this.dataSourceManager.getDataSourceDetail(atlasKey);
        atlasDatasetName = atlasDatasetName.toLowerCase();
        if (atlasDataSource.getDataSourceType().intValue() != DataSourceTypeEnum.HBase.getValue()) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u6570\u636e\u6e90\u6765\u7c7b\u578b\uff1a" + atlasDataSource.getDataSourceType());
        }
        AtlasConnectionStr targetConnectionStr = new AtlasConnectionStr(atlasDataSource);
        String outputFeatureClassUrl = String.format("%s/%s/%s", targetConnectionStr.rawUrl, targetConnectionStr.dataSetName, atlasDatasetName);
        String outputDataFormat = targetConnectionStr.format.getDesc();
        AtlasDataSourceUtil.inputData(inputFeatureClassUrl, inputDataFormat, outputFeatureClassUrl, outputDataFormat, true);
        String atlasDatasetId = DatasetUtil.getDatasetId(atlasKey, DatasetTypeEnum.FeatureClass, atlasDatasetName);
        this.dsDatasetRelationDao.deleteByTargetDatasetId(atlasDatasetId);
        DsDatasetRelation relation = new DsDatasetRelation();
        relation.setSourceId(geoDatasetId);
        relation.setRelation("AnalysisCache");
        relation.setTargetId(atlasDatasetId);
        this.dsDatasetRelationDao.insert(relation);
    }

    private AtlasSimpleDatasetDTO convertSimpleDataset(AtlasDatasetDTO dataset) {
        AtlasSimpleDatasetDTO simpleDatasetDTO = new AtlasSimpleDatasetDTO();
        BeanUtils.copyProperties((Object)dataset, (Object)simpleDatasetDTO);
        return simpleDatasetDTO;
    }

    class AtlasConnectionStr {
        public AtlasDatasetFormatEnum format;
        public String rawUrl;
        public String dataSetName;

        public AtlasConnectionStr(DataSourceDTO dataSourceDTO) {
            int index;
            String hbasePath;
            if (dataSourceDTO.getDataSourceType().intValue() == DataSourceTypeEnum.HBase.getValue()) {
                hbasePath = "hbase://";
                index = dataSourceDTO.getUrl().lastIndexOf("/");
                if (index <= 0) {
                    throw new RuntimeException(dataSourceDTO.getUrl() + " \u8fde\u63a5\u5730\u5740\u4e0d\u6b63\u786e");
                }
            } else {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b\uff1a" + dataSourceDTO.getDataSourceType());
            }
            this.rawUrl = hbasePath + dataSourceDTO.getUrl().substring(0, index);
            this.dataSetName = dataSourceDTO.getUrl().substring(index + 1);
            this.format = AtlasDatasetFormatEnum.GwVector;
        }

        public AtlasConnectionStr(String dataFilePath) {
            this.format = AtlasDatasetFormatEnum.Unknown;
            String ext = FileUtil.getExtension((String)FileUtil.getFileName((String)dataFilePath));
            if (ext.equalsIgnoreCase(".shp")) {
                this.format = AtlasDatasetFormatEnum.Shapefile;
                this.rawUrl = FileUtil.getDirectoryName((String)dataFilePath);
                this.dataSetName = FileUtil.getFileNameWithoutExtension((String)dataFilePath);
            } else if (ext.equalsIgnoreCase(".geojson")) {
                this.format = AtlasDatasetFormatEnum.Geojson;
                this.rawUrl = FileUtil.getDirectoryName((String)dataFilePath);
                this.dataSetName = FileUtil.getFileNameWithoutExtension((String)dataFilePath);
            } else if (ext.isEmpty()) {
                String parent = FileUtil.getDirectoryName((String)dataFilePath);
                String pExt = FileUtil.getExtension((String)parent);
                if (pExt.equalsIgnoreCase(".gdb")) {
                    this.format = AtlasDatasetFormatEnum.Filegdb;
                    this.rawUrl = parent;
                    this.dataSetName = FileUtil.getFileName((String)dataFilePath);
                } else if (pExt.equalsIgnoreCase(".gpkg")) {
                    this.format = AtlasDatasetFormatEnum.Jdbc;
                    this.rawUrl = "geopkg://" + parent;
                    this.dataSetName = FileUtil.getFileName((String)dataFilePath);
                }
            }
            if (this.format == AtlasDatasetFormatEnum.Unknown) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff1a" + dataFilePath);
            }
        }
    }
}

