/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.encrypt;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.encrypt.Base64Encryptor;
import com.geoway.adf.dms.datasource.encrypt.IEncryptor;
import com.geoway.adf.dms.datasource.encrypt.SwxaJCEEncryptor;
import com.geoway.adf.dms.datasource.entity.DsDataStore;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@EnableConfigurationProperties(value={DataSourceParamsEncryptProperties.class})
@Component
public class DataSourceParamsEncrypt {
    private IEncryptor encryptor = null;

    public DataSourceParamsEncrypt(DataSourceParamsEncryptProperties dataSourceParamsEncryptProperties) {
        if ("SwxaJCE".equals(dataSourceParamsEncryptProperties.getType())) {
            this.encryptor = new SwxaJCEEncryptor(dataSourceParamsEncryptProperties.getIniPath());
        } else if ("Base64".equals(dataSourceParamsEncryptProperties.getType())) {
            this.encryptor = new Base64Encryptor();
        }
    }

    public DsDataStore encryptDataSource(DsDataStore dsDataStore) {
        if (this.encryptor == null) {
            return dsDataStore;
        }
        DsDataStore encDataSource = new DsDataStore();
        BeanUtils.copyProperties((Object)dsDataStore, (Object)encDataSource);
        if (StringUtil.isNotEmpty((String)dsDataStore.getUserName())) {
            encDataSource.setUserName(this.encryptor.encode(dsDataStore.getUserName()));
        }
        if (StringUtil.isNotEmpty((String)dsDataStore.getPassword())) {
            encDataSource.setPassword(this.encryptor.encode(dsDataStore.getPassword()));
        }
        if (StringUtil.isNotEmpty((String)dsDataStore.getUrl())) {
            encDataSource.setUrl(this.encryptor.encode(dsDataStore.getUrl()));
        }
        return encDataSource;
    }

    public DsDataStore decryptDataSource(DsDataStore dsDataStore) {
        if (this.encryptor == null) {
            return dsDataStore;
        }
        DsDataStore decDataSource = new DsDataStore();
        BeanUtils.copyProperties((Object)dsDataStore, (Object)decDataSource);
        if (StringUtil.isNotEmpty((String)dsDataStore.getUserName())) {
            decDataSource.setUserName(this.encryptor.decode(dsDataStore.getUserName()));
        }
        if (StringUtil.isNotEmpty((String)dsDataStore.getPassword())) {
            decDataSource.setPassword(this.encryptor.decode(dsDataStore.getPassword()));
        }
        if (StringUtil.isNotEmpty((String)dsDataStore.getUrl())) {
            decDataSource.setUrl(this.encryptor.decode(dsDataStore.getUrl()));
        }
        return decDataSource;
    }

    @ConfigurationProperties(prefix="datasource-params-encrypt")
    public static class DataSourceParamsEncryptProperties {
        private String type;
        private String iniPath;

        public String getType() {
            return this.type;
        }

        public String getIniPath() {
            return this.iniPath;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setIniPath(String iniPath) {
            this.iniPath = iniPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSourceParamsEncryptProperties)) {
                return false;
            }
            DataSourceParamsEncryptProperties other = (DataSourceParamsEncryptProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$iniPath = this.getIniPath();
            String other$iniPath = other.getIniPath();
            return !(this$iniPath == null ? other$iniPath != null : !this$iniPath.equals(other$iniPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSourceParamsEncryptProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $iniPath = this.getIniPath();
            result = result * 59 + ($iniPath == null ? 43 : $iniPath.hashCode());
            return result;
        }

        public String toString() {
            return "DataSourceParamsEncrypt.DataSourceParamsEncryptProperties(type=" + this.getType() + ", iniPath=" + this.getIniPath() + ")";
        }
    }
}

