/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import com.geoway.adf.dms.datasource.event.DatasetCreateEvent;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GeoServerEngineService;
import com.geoway.adf.dms.datasource.service.MosaicDatasetService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IFields;
import com.geoway.adf.gis.geosrv.IGeoServer;
import com.geoway.adf.gis.geosrv.IGeoService;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.raster.info.PixelDataType;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MosaicDatasetServiceImpl
implements MosaicDatasetService {
    private static final Logger log = LoggerFactory.getLogger(MosaicDatasetServiceImpl.class);
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;
    @Resource
    private GeoServerEngineService geoServerEngineService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Override
    public String createMosaicDataset(MosaicDatasetCreateDTO mosaicDatasetCreateDTO) {
        String dsKey = mosaicDatasetCreateDTO.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            PixelDataType pixelDataType;
            int bandCount;
            ISpatialReferenceSystem spatialReferenceSystem;
            IMosaicDataset mosaicDataset;
            String newDatasetName = mosaicDatasetCreateDTO.getName();
            if (!StringUtil.isEmptyOrWhiteSpace((String)mosaicDatasetCreateDTO.getSchemaName())) {
                newDatasetName = mosaicDatasetCreateDTO.getSchemaName() + "." + mosaicDatasetCreateDTO.getName();
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            Fields exFields = null;
            if (mosaicDatasetCreateDTO.getFields() != null && mosaicDatasetCreateDTO.getFields().size() > 0) {
                exFields = new Fields();
                for (FieldDTO fieldDTO : mosaicDatasetCreateDTO.getFields()) {
                    if (exFields.contains(fieldDTO.getName())) continue;
                    exFields.addField(FieldUtil.convertField(fieldDTO));
                }
            }
            if ((mosaicDataset = featureWorkspace.createMosaicDataset(newDatasetName, (IFields)exFields, spatialReferenceSystem = SpatialReferenceSystemFunc.createSpatialReference((int)mosaicDatasetCreateDTO.getSrid()), bandCount = mosaicDatasetCreateDTO.getBandCount() == null ? -1 : mosaicDatasetCreateDTO.getBandCount(), pixelDataType = mosaicDatasetCreateDTO.getPixelDataType() == null ? PixelDataType.Unknown : PixelDataType.getByValue((Integer)mosaicDatasetCreateDTO.getPixelDataType()))) != null) {
                mosaicDataset.getCatalog().createSpatialIndex();
                mosaicDataset.getBoundary().createSpatialIndex();
                if (StringUtil.isNotEmpty((String)mosaicDatasetCreateDTO.getAliasName()) && !mosaicDatasetCreateDTO.getName().equals(mosaicDatasetCreateDTO.getAliasName())) {
                    mosaicDataset.alterAliasName(mosaicDatasetCreateDTO.getAliasName());
                }
                if (mosaicDatasetCreateDTO.getInvalidValue() != 0.0) {
                    mosaicDataset.defineNoDataValue(mosaicDatasetCreateDTO.getInvalidValue());
                }
                String datasetId = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)mosaicDataset);
                if (StringUtil.isNotEmpty((String)mosaicDatasetCreateDTO.getDataPhase())) {
                    this.dataSourceManager.saveDatasetDataPhase(datasetId, mosaicDatasetCreateDTO.getDataPhase());
                }
                this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", mosaicDataset.getType().getDesc(), dataSourceDTO.getName(), mosaicDataset.getFullName()));
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new DatasetCreateEvent(this, datasetId));
                String string = datasetId;
                return string;
            }
            throw new RuntimeException("\u9576\u5d4c\u6570\u636e\u96c6\u521b\u5efa\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMosaicDataset(MosaicDatasetEditDTO mosaicDatasetEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(mosaicDatasetEditDTO.getId());
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IEnvelope envelope;
            IMosaicDataset mosaicDataset = featureWorkspace.openMosaicDataset(datasetNameInfo.getName());
            Assert.notNull((Object)mosaicDataset, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            if (!StringUtil.equals((String)mosaicDataset.getAliasName(), (String)mosaicDatasetEditDTO.getAliasName())) {
                mosaicDataset.alterAliasName(mosaicDatasetEditDTO.getAliasName());
            }
            this.dataSourceManager.saveDatasetDataPhase(mosaicDatasetEditDTO.getId(), mosaicDatasetEditDTO.getDataPhase());
            if (mosaicDatasetEditDTO.getInvalidValue() != null && Double.compare(mosaicDatasetEditDTO.getInvalidValue(), mosaicDataset.getRasterInfo().getInvalidValue()[0]) != 0) {
                mosaicDataset.defineNoDataValue(mosaicDatasetEditDTO.getInvalidValue());
                this.reloadRenderIndexCache(mosaicDatasetEditDTO.getId());
            }
            if ((envelope = GeoDatasetUtil.toEnvelope(mosaicDatasetEditDTO.getExtent())) != null) {
                mosaicDataset.changeExtent(envelope);
            }
            IFeatureClass catFeatureClass = mosaicDataset.getCatalog();
            if (mosaicDatasetEditDTO.getFields() != null) {
                this.geoDatabaseService.updateDatasetFields((IGeoDataset)catFeatureClass, mosaicDatasetEditDTO.getFields(), dataSourceDTO);
            }
            this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\uff1a%s > %s", mosaicDataset.getType().getDesc(), dataSourceDTO.getName(), mosaicDataset.getFullName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateStatisticValue(String id) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(id);
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(datasetNameInfo.getDsKey());
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            IMosaicDataset mosaicDataset = featureWorkspace.openMosaicDataset(datasetNameInfo.getName());
            Assert.notNull((Object)mosaicDataset, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            mosaicDataset.calculateStatisticInfo(true);
            this.sysLogService.addLog(101, String.format("%s\uff1a%s > %s \u8ba1\u7b97\u7edf\u8ba1\u503c", mosaicDataset.getType().getDesc(), dataSourceDTO.getName(), mosaicDataset.getFullName()));
        }
    }

    private void reloadRenderIndexCache(String datasetId) {
        try {
            DatasetRenderDTO datasetRenderDTO = this.dataSourceManager.getDatasetRender(datasetId);
            if (datasetRenderDTO == null) {
                return;
            }
            if (!StringUtil.isEmptyOrWhiteSpace((String)datasetRenderDTO.getServerKey())) {
                DataSourceDTO serverSourceDTO = this.dataSourceManager.getDataSourceDetail(datasetRenderDTO.getServerKey());
                IGeoServer geoServer = this.geoServerEngineService.getGeoServer(serverSourceDTO);
                IGeoService geoService = geoServer.getService(ServiceType.getByValue((Integer)datasetRenderDTO.getServiceType()), datasetRenderDTO.getServiceName());
                if (geoService != null) {
                    geoServer.reCreateCache(geoService);
                } else {
                    log.error(datasetRenderDTO.getServiceName() + "\u6e32\u67d3\u7d22\u5f15\u4e0d\u5b58\u5728");
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

