/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.FilterDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.ITableView;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.GeometryField;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialQueryFilter;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatailQueryUtil {
    private static final Logger log = LoggerFactory.getLogger(SpatailQueryUtil.class);

    public static DataQueryResult queryGeoDataset(IGeoDataset geoDataset, QueryFilterDTO queryFilterDTO) {
        DataQueryResult result;
        SpatailQueryUtil.initDefaultQueryFilter(queryFilterDTO);
        switch (geoDataset.getType()) {
            case FeatureClass: {
                IFeatureClass featureClass = (IFeatureClass)geoDataset;
                result = SpatailQueryUtil.queryFeatureClass(featureClass, queryFilterDTO);
                break;
            }
            case Table: {
                ITable table = (ITable)geoDataset;
                result = SpatailQueryUtil.queryTable(table, queryFilterDTO);
                break;
            }
            case MosaicDataset: {
                IMosaicDataset mosaicDataset = (IMosaicDataset)geoDataset;
                result = SpatailQueryUtil.queryFeatureClass(mosaicDataset.getCatalog(), queryFilterDTO);
                result.setName(mosaicDataset.getName());
                result.setAliasName(mosaicDataset.getAliasName());
                break;
            }
            case TableView: {
                ITableView tableView = (ITableView)geoDataset;
                result = SpatailQueryUtil.queryTable((ITable)tableView, queryFilterDTO);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u67e5\u8be2\u7684\u6570\u636e\u96c6\u7c7b\u578b\uff1a" + geoDataset.getType());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataQueryResult queryFeatureClass(IFeatureClass featureClass, QueryFilterDTO filterDTO) {
        SpatialQueryFilter queryFilter = SpatailQueryUtil.buildQueryFilter(filterDTO, (IGeoDataset)featureClass);
        queryFilter.setOffset(Integer.valueOf(filterDTO.getPageIndex() * filterDTO.getRows()));
        queryFilter.setLimit(filterDTO.getRows());
        ArrayList<String> selectFields = new ArrayList<String>();
        ArrayList<ReturnField> attFields = new ArrayList<ReturnField>();
        SpatailQueryUtil.getFilterFields((ITable)featureClass, featureClass.getShapeFieldName(), filterDTO.getReturnGeometry(), filterDTO.getReturnExtent(), filterDTO.getFields(), selectFields, attFields);
        queryFilter.setSubFields(StringUtil.join((String)",", selectFields));
        DataQueryResult queryResult = new DataQueryResult();
        queryResult.setName(featureClass.getName());
        queryResult.setAliasName(featureClass.getAliasName());
        queryResult.setData(new ArrayList<FeatureResult>());
        queryResult.setFields(attFields);
        if (filterDTO.getReturnCount().booleanValue()) {
            queryResult.setTotal(featureClass.featureCount((IQueryFilter)queryFilter));
        }
        IFeatureCursor featureCursor = featureClass.searchFeature((IQueryFilter)queryFilter);
        try {
            IFeature feature = featureCursor.nextFeature();
            while (feature != null) {
                FeatureResult featureResult = SpatailQueryUtil.convertRow((IRow)feature, attFields);
                IGeometry geo = feature.getGeometry();
                if (geo != null) {
                    if (filterDTO.getCutGeometry().booleanValue() && queryFilter.getGeometry() != null) {
                        geo = geo.intersection(queryFilter.getGeometry());
                    }
                    if (geo != null) {
                        if (filterDTO.getReturnGeometry().booleanValue()) {
                            ISpatialReferenceSystem targetSrs;
                            if (filterDTO.getReturnGeometrySrid() != null && !SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)(targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)filterDTO.getReturnGeometrySrid())), (ISpatialReferenceSystem)featureClass.getSpatialReferenceSystem())) {
                                geo.project(featureClass.getSpatialReferenceSystem(), targetSrs);
                            }
                            featureResult.setGeometry(geo.toWkt());
                        }
                        if (filterDTO.getReturnExtent().booleanValue()) {
                            featureResult.setExtent(GeoDatasetUtil.toExtentDTO(geo.getEnvelope()));
                        }
                    }
                }
                queryResult.getData().add(featureResult);
                feature = featureCursor.nextFeature();
            }
        }
        finally {
            if (featureCursor != null) {
                featureCursor.release();
            }
        }
        return queryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataQueryResult queryTable(ITable table, QueryFilterDTO filterDTO) {
        String oidFieldName;
        IField fld2;
        SpatialQueryFilter queryFilter = SpatailQueryUtil.buildQueryFilter(filterDTO, (IGeoDataset)table);
        queryFilter.setOffset(Integer.valueOf(filterDTO.getPageIndex() * filterDTO.getRows()));
        queryFilter.setLimit(filterDTO.getRows());
        String shapeFieldName = null;
        for (IField fld2 : table.getFields()) {
            if (fld2.getFieldType() != FieldType.Shape) continue;
            shapeFieldName = fld2.getName();
            break;
        }
        if ((oidFieldName = table.getOidFieldName()) == null && table.getType() == GeoDatasetType.TableView && (fld2 = table.getFields().findField("vid")) != null) {
            oidFieldName = "vid";
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        ArrayList<ReturnField> attFields = new ArrayList<ReturnField>();
        SpatailQueryUtil.getFilterFields(table, shapeFieldName, filterDTO.getReturnGeometry(), filterDTO.getReturnExtent(), filterDTO.getFields(), selectFields, attFields);
        queryFilter.setSubFields(StringUtil.join((String)",", selectFields));
        DataQueryResult queryResult = new DataQueryResult();
        queryResult.setName(table.getName());
        queryResult.setAliasName(table.getAliasName());
        queryResult.setData(new ArrayList<FeatureResult>());
        queryResult.setFields(attFields);
        if (filterDTO.getReturnCount().booleanValue()) {
            queryResult.setTotal(table.count((IQueryFilter)queryFilter));
        }
        ICursor cursor = table.searchRow((IQueryFilter)queryFilter);
        try {
            IRow row = cursor.nextRow();
            while (row != null) {
                Object value;
                FeatureResult featureResult = SpatailQueryUtil.convertRow(row, attFields);
                if (filterDTO.getReturnGeometry().booleanValue() && shapeFieldName != null && (value = row.getValue(shapeFieldName)) instanceof IGeometry) {
                    IGeometry geo = (IGeometry)value;
                    if (filterDTO.getCutGeometry().booleanValue() && queryFilter.getGeometry() != null) {
                        geo = geo.intersection(queryFilter.getGeometry());
                    }
                    if (geo != null) {
                        if (filterDTO.getReturnGeometry().booleanValue()) {
                            ISpatialReferenceSystem sourceSrs;
                            ISpatialReferenceSystem targetSrs;
                            IField geometryField = table.getFields().findField(shapeFieldName);
                            if (filterDTO.getReturnGeometrySrid() != null && geometryField instanceof GeometryField && !SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)(targetSrs = SpatialReferenceSystemFunc.createSpatialReference((int)filterDTO.getReturnGeometrySrid())), (ISpatialReferenceSystem)(sourceSrs = ((GeometryField)geometryField).getSpatialReferenceSystem()))) {
                                geo.project(sourceSrs, targetSrs);
                            }
                            featureResult.setGeometry(geo.toWkt());
                        }
                        if (filterDTO.getReturnExtent().booleanValue()) {
                            featureResult.setExtent(GeoDatasetUtil.toExtentDTO(geo.getEnvelope()));
                        }
                    }
                }
                if (featureResult.getObjectId() == null && table.getType() == GeoDatasetType.TableView && oidFieldName != null) {
                    featureResult.setObjectId(row.getValue(oidFieldName));
                    featureResult.setName(row.getValue(oidFieldName));
                }
                queryResult.getData().add(featureResult);
                row = cursor.nextRow();
            }
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
        }
        return queryResult;
    }

    public static FeatureResult convertRow(IRow row, List<ReturnField> attFields) {
        FeatureResult featureResult = new FeatureResult();
        featureResult.setObjectId(row.getObjectId());
        featureResult.setName(row.getObjectId());
        HashMap<String, Object> attMap = new HashMap<String, Object>();
        for (ReturnField fld : attFields) {
            Object value = row.getValue(fld.getName());
            if (value instanceof IGeometry) {
                attMap.put(fld.getName(), ((IGeometry)value).toWkt());
                continue;
            }
            attMap.put(fld.getName(), value);
        }
        featureResult.setAttributes(attMap);
        return featureResult;
    }

    public static void initDefaultQueryFilter(QueryFilterDTO queryFilterDTO) {
        if (queryFilterDTO.getPageIndex() == null || queryFilterDTO.getPageIndex() < 0) {
            queryFilterDTO.setPageIndex(0);
        }
        if (queryFilterDTO.getRows() == null || queryFilterDTO.getRows() < 0) {
            queryFilterDTO.setRows(10);
        }
        if (queryFilterDTO.getRows() > 50000) {
            log.warn("\u67e5\u8be2\u7ed3\u679c\u6761\u4ef6\u8bbe\u7f6e\u4e0d\u80fd\u8d85\u8fc750000\u6761");
            queryFilterDTO.setRows(50000);
        }
        if (queryFilterDTO.getReturnCount() == null) {
            queryFilterDTO.setReturnCount(false);
        }
        if (queryFilterDTO.getReturnGeometry() == null) {
            queryFilterDTO.setReturnGeometry(false);
        }
        if (queryFilterDTO.getReturnExtent() == null) {
            queryFilterDTO.setReturnExtent(false);
        }
        if (queryFilterDTO.getCutGeometry() == null) {
            queryFilterDTO.setCutGeometry(false);
        }
    }

    public static void getFilterFields(ITable geoTable, String shapeField, Boolean returnGeometry, Boolean returnExtent, String filterFields, List<String> selectFields, List<ReturnField> attFields) {
        if (filterFields == null || filterFields.isEmpty() || "*".equals(filterFields)) {
            for (IField fld : geoTable.getFields()) {
                if (!returnGeometry.booleanValue() && !returnExtent.booleanValue() && fld.getFieldType() == FieldType.Shape) continue;
                if (fld.getPhysicalName() != null && !fld.getPhysicalName().isEmpty()) {
                    selectFields.add("\"" + fld.getPhysicalName() + "\"");
                } else {
                    selectFields.add(fld.getName());
                }
                if (fld.getName().equalsIgnoreCase(shapeField)) continue;
                attFields.add(new ReturnField(fld.getName(), fld.getAliasName(), fld.getFieldType().getValue()));
            }
        } else {
            IField fld;
            List strFields = StringUtil.split((String)filterFields, (String)",", String::toString);
            boolean containsIdField = false;
            boolean containsShapeField = false;
            String oidFieldName = geoTable.getOidFieldName();
            if (oidFieldName == null && geoTable.getType() == GeoDatasetType.TableView && (fld = geoTable.getFields().findField("vid")) != null) {
                oidFieldName = "vid";
            }
            for (String strFld : strFields) {
                IField fld2 = geoTable.getFields().findField(strFld);
                if (fld2 != null) {
                    if (!returnGeometry.booleanValue() && !returnExtent.booleanValue() && fld2.getFieldType() == FieldType.Shape) continue;
                    if (fld2.getPhysicalName() != null && !fld2.getPhysicalName().isEmpty()) {
                        selectFields.add("\"" + fld2.getPhysicalName() + "\"");
                    } else {
                        selectFields.add(fld2.getName());
                    }
                    if (fld2.getName().equalsIgnoreCase(oidFieldName)) {
                        containsIdField = true;
                    }
                    if (fld2.getName().equalsIgnoreCase(shapeField)) {
                        containsShapeField = true;
                        continue;
                    }
                    attFields.add(new ReturnField(fld2.getName(), fld2.getAliasName(), fld2.getFieldType().getValue()));
                    continue;
                }
                throw new RuntimeException(String.format("[%s]\u6570\u636e\u96c6\u4e0d\u5b58\u5728\u5b57\u6bb5[%s]", geoTable.getName(), strFld));
            }
            if (!containsIdField && StringUtil.isNotEmpty((String)oidFieldName)) {
                selectFields.add(oidFieldName);
            }
            if (!containsShapeField && returnGeometry.booleanValue() && shapeField != null) {
                selectFields.add(shapeField);
            }
        }
    }

    public static SpatialQueryFilter buildQueryFilter(QueryFilterBasicDTO filterDTO, IGeoDataset geoDataset) {
        if (filterDTO == null) {
            return null;
        }
        SpatialQueryFilter queryFilter = SpatailQueryUtil.buildFilter(filterDTO, geoDataset);
        if (queryFilter != null && !StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getOrderBy())) {
            queryFilter.setPostfixClause(" order by " + filterDTO.getOrderBy());
        }
        return queryFilter;
    }

    public static SpatialQueryFilter buildFilter(FilterDTO filterDTO, IGeoDataset geoDataset) {
        SpatialQueryFilter queryFilter;
        block3: {
            FeatureType featureType;
            IGeometry queryGeometry;
            block5: {
                block4: {
                    ISpatialReferenceSystem sourceSrs;
                    if (filterDTO == null) {
                        return null;
                    }
                    queryFilter = new SpatialQueryFilter();
                    queryGeometry = SpatailQueryUtil.getFilterGeometry(filterDTO);
                    queryFilter.setGeometry(queryGeometry);
                    queryFilter.setSpatialRel(filterDTO.getRelation());
                    queryFilter.setWhereClause(filterDTO.getCondition());
                    if (queryGeometry == null) break block3;
                    featureType = FeatureType.Unknown;
                    if (!(geoDataset instanceof IFeatureClass)) break block4;
                    IFeatureClass featureClass = (IFeatureClass)geoDataset;
                    featureType = featureClass.getFeatureType();
                    if (filterDTO.getGeometrySrid() == null || featureClass.getSpatialReferenceSystem() == null || SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)(sourceSrs = SpatialReferenceSystemFunc.createSpatialReference((int)filterDTO.getGeometrySrid())), (ISpatialReferenceSystem)featureClass.getSpatialReferenceSystem())) break block5;
                    queryGeometry.project(sourceSrs, featureClass.getSpatialReferenceSystem());
                    break block5;
                }
                if (geoDataset instanceof ITable) {
                    for (IField fld : ((ITable)geoDataset).getFields()) {
                        ISpatialReferenceSystem sourceSrs;
                        if (!(fld instanceof GeometryField)) continue;
                        featureType = FeatureType.getByGeometryType((GeometryType)((GeometryField)fld).getGeometryType());
                        queryFilter.setGeometryField(fld.getName());
                        GeometryField geometryField = (GeometryField)fld;
                        if (filterDTO.getGeometrySrid() == null || geometryField.getSpatialReferenceSystem() == null || SpatialReferenceSystemFunc.equals((ISpatialReferenceSystem)(sourceSrs = SpatialReferenceSystemFunc.createSpatialReference((int)filterDTO.getGeometrySrid())), (ISpatialReferenceSystem)geometryField.getSpatialReferenceSystem())) break;
                        queryGeometry.project(sourceSrs, geometryField.getSpatialReferenceSystem());
                        break;
                    }
                }
            }
            queryFilter.setSpatialRels(SpatailQueryUtil.getSpatialRelationships(filterDTO.getRelation(), queryGeometry, featureType));
        }
        return queryFilter;
    }

    public static IGeometry getFilterGeometry(FilterDTO filterDTO) {
        IGeometry queryGeometry = null;
        if (filterDTO.getGeometryList() != null && filterDTO.getGeometryList().size() > 0) {
            IGeometry unionGeo = null;
            for (String geoWkt : filterDTO.getGeometryList()) {
                IGeometry geo = GeometryFunc.createGeometry((String)geoWkt);
                if (geo == null) {
                    log.error(geoWkt);
                    throw new RuntimeException("\u65e0\u6548\u7684\u51e0\u4f55\u8fc7\u6ee4\u6761\u4ef6");
                }
                if (unionGeo != null) {
                    unionGeo = unionGeo.union(geo);
                    continue;
                }
                unionGeo = geo;
            }
            if (unionGeo == null) {
                throw new RuntimeException("\u8303\u56f4\u5408\u5e76\u9519\u8bef");
            }
            queryGeometry = unionGeo;
        } else if (!StringUtil.isEmptyOrWhiteSpace((String)filterDTO.getGeometry()) && (queryGeometry = GeometryFunc.createGeometry((String)filterDTO.getGeometry())) == null) {
            log.error(filterDTO.getGeometry());
            throw new RuntimeException("\u65e0\u6548\u7684\u51e0\u4f55\u8fc7\u6ee4\u6761\u4ef6");
        }
        return queryGeometry;
    }

    public static SpatialRelationType[] getSpatialRelationships(SpatialRelationType querySpatialRel, IGeometry queryGeometry, FeatureType targetFeatureType) {
        if (queryGeometry == null) {
            return null;
        }
        return new SpatialRelationType[]{querySpatialRel};
    }
}

