/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.dto;

import com.geoway.adf.dms.common.util.StringUtil;

public class DatasetNameInfo {
    public static final String KEY_SEPARATOR = "-";
    private String dsKey;
    private Integer type;
    private String name;

    public DatasetNameInfo(String datasetId) {
        try {
            String[] connectStrings = datasetId.split(KEY_SEPARATOR, 3);
            this.dsKey = connectStrings[0];
            this.type = Integer.parseInt(connectStrings[1]);
            String nameBase64 = connectStrings[2];
            this.name = StringUtil.safeUrlBase64Decode((String)nameBase64);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u96c6id\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + datasetId);
        }
    }

    public String getShortName() {
        String shortName = this.name;
        int index = this.name.lastIndexOf(".");
        if (index >= 0) {
            shortName = this.name.substring(index + 1);
        }
        return shortName;
    }

    public static String buildDatasetId(String dsKey, Integer type, String fullName) {
        return dsKey + KEY_SEPARATOR + type + KEY_SEPARATOR + StringUtil.safeUrlBase64Encode((String)fullName);
    }

    public String getDsKey() {
        return this.dsKey;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

