/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.service.impl;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetNameInfo;
import com.geoway.adf.dms.datasource.dto.create.TableCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TableEditDTO;
import com.geoway.adf.dms.datasource.dto.create.TableViewCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TableViewEditDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.TableDatasetService;
import com.geoway.adf.dms.datasource.util.DatasetUtil;
import com.geoway.adf.dms.datasource.util.FieldUtil;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.dms.datasource.util.GeoDatasetUtil;
import com.geoway.adf.dms.datasource.util.GeoTableQueryCheckUtil;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.ITableView;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.field.Fields;
import com.geoway.adf.gis.geodb.field.IField;
import com.geoway.adf.gis.geodb.field.IFields;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TableDatasetServiceImpl
implements TableDatasetService {
    @Resource
    private DataSourceManager dataSourceManager;
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private SysLogService sysLogService;

    @Override
    public String createTable(TableCreateDTO tableCreateDTO) {
        String dsKey = tableCreateDTO.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            String newDatasetName = tableCreateDTO.getName();
            if (!StringUtil.isEmptyOrWhiteSpace((String)tableCreateDTO.getSchemaName())) {
                newDatasetName = tableCreateDTO.getSchemaName() + "." + tableCreateDTO.getName();
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            Assert.notNull(tableCreateDTO.getFields(), (String)"\u5b57\u6bb5\u4e0d\u80fd\u672a\u7a7a");
            Fields fields = new Fields();
            IField oidField = FieldUtil.buildObjectIdField("f_oid", "\u7f16\u53f7");
            fields.addField(oidField);
            for (FieldDTO fieldDTO : tableCreateDTO.getFields()) {
                if (fieldDTO.getFieldType().intValue() == FieldType.OID.getValue()) {
                    oidField.setName(fieldDTO.getName());
                    oidField.setAliasName(fieldDTO.getAliasName());
                    continue;
                }
                if (fields.contains(fieldDTO.getName())) continue;
                fields.addField(FieldUtil.convertField(fieldDTO));
            }
            ITable table = featureWorkspace.createTable(newDatasetName, (IFields)fields);
            if (table != null) {
                if (StringUtil.isNotEmpty((String)tableCreateDTO.getAliasName()) && !tableCreateDTO.getAliasName().equals(tableCreateDTO.getName())) {
                    table.alterAliasName(tableCreateDTO.getAliasName());
                }
                this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", table.getType().getDesc(), dataSourceDTO.getName(), table.getFullName()));
                String string = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)table);
                return string;
            }
            throw new RuntimeException(tableCreateDTO.getName() + "\u8868\u683c\u521b\u5efa\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTable(TableEditDTO tableEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(tableEditDTO.getId());
        String dsKey = datasetNameInfo.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            ITable table = featureWorkspace.openTable(datasetNameInfo.getName());
            Assert.notNull((Object)table, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            if (!StringUtil.equals((String)table.getAliasName(), (String)tableEditDTO.getAliasName())) {
                table.alterAliasName(tableEditDTO.getAliasName());
            }
            if (tableEditDTO.getFields() != null) {
                this.geoDatabaseService.updateDatasetFields((IGeoDataset)table, tableEditDTO.getFields(), dataSourceDTO);
            }
            this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\uff1a%s > %s", table.getType().getDesc(), dataSourceDTO.getName(), table.getFullName()));
        }
    }

    @Override
    public String createTableView(TableViewCreateDTO tableViewCreateDTO) {
        String dsKey = tableViewCreateDTO.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            String newDatasetName = tableViewCreateDTO.getName();
            if (!StringUtil.isEmptyOrWhiteSpace((String)tableViewCreateDTO.getSchemaName())) {
                newDatasetName = tableViewCreateDTO.getSchemaName() + "." + tableViewCreateDTO.getName();
            }
            if (featureWorkspace.datasetExist(newDatasetName)) {
                throw new RuntimeException(newDatasetName + " \u5df2\u5b58\u5728\uff01");
            }
            ITableView tableView = featureWorkspace.createTableView(newDatasetName, tableViewCreateDTO.getDefinitionSql());
            if (tableView != null) {
                if (StringUtil.isNotEmpty((String)tableViewCreateDTO.getAliasName()) && !tableViewCreateDTO.getAliasName().equals(tableViewCreateDTO.getName())) {
                    tableView.alterAliasName(tableViewCreateDTO.getAliasName());
                }
                this.sysLogService.addLog(101, String.format("\u521b\u5efa%s\uff1a%s > %s", tableView.getType().getDesc(), dataSourceDTO.getName(), tableView.getFullName()));
                String string = GeoDatasetUtil.getGeoDatasetId(dsKey, (IGeoDataset)tableView);
                return string;
            }
            throw new RuntimeException(tableViewCreateDTO.getName() + "\u89c6\u56fe\u521b\u5efa\u5931\u8d25");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableView(TableViewEditDTO tableViewEditDTO) {
        DatasetNameInfo datasetNameInfo = DatasetUtil.getDatasetNameInfo(tableViewEditDTO.getId());
        String dsKey = datasetNameInfo.getDsKey();
        DatabaseDTO dataSourceDTO = this.geoDatabaseService.getDatabaseDetail(dsKey);
        if (!StringUtil.isEmptyOrWhiteSpace((String)tableViewEditDTO.getDefinitionSql())) {
            GeoTableQueryCheckUtil.checkTableQuerySql(DataSourceTypeEnum.getByValue(dataSourceDTO.getDataSourceType()), tableViewEditDTO.getDefinitionSql());
        }
        Assert.notNull((Object)featureWorkspace, (String)"\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff01");
        try (IFeatureWorkspace featureWorkspace = GeoDatabaseUtil.openGeoDatabase(dataSourceDTO);){
            ITableView tableView = featureWorkspace.openTableView(datasetNameInfo.getName());
            Assert.notNull((Object)tableView, (String)(datasetNameInfo.getName() + " \u6253\u5f00\u5931\u8d25"));
            if (!StringUtil.isEmptyOrWhiteSpace((String)tableViewEditDTO.getDefinitionSql()) && !tableView.getDefinitionSql().equals(tableViewEditDTO.getDefinitionSql())) {
                tableViewEditDTO.setDefinitionSql(tableViewEditDTO.getDefinitionSql().trim());
                tableView.updateView(tableViewEditDTO.getDefinitionSql());
            }
            if (!StringUtil.equals((String)tableView.getAliasName(), (String)tableViewEditDTO.getAliasName())) {
                tableView.alterAliasName(tableViewEditDTO.getAliasName());
                this.sysLogService.addLog(101, String.format("\u4fee\u6539%s\uff1a%s > %s", tableView.getType().getDesc(), dataSourceDTO.getName(), tableView.getFullName()));
            }
        }
    }
}

