/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.datasource.util;

import com.geoway.adf.dms.common.util.ExcelUtil;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.dms.common.util.ObjectCloseUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.datasource.dto.file.FileDataTypeEnum;
import com.geoway.adf.dms.datasource.dto.file.SelectFileDataDTO;
import com.geoway.adf.dms.datasource.util.GeoDatabaseUtil;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.ITable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SelectFileDataUtil {
    private static final Logger log = LoggerFactory.getLogger(SelectFileDataUtil.class);

    public static FileDataTypeEnum getDataType(IFileStorage fileStorage, String filePath) {
        FileDataTypeEnum typeEnum = FileDataTypeEnum.File;
        IFileset file = fileStorage.getFile(filePath);
        if (file != null) {
            if (file.getIsDirectory()) {
                typeEnum = SelectFileDataUtil.isFileGDB(fileStorage, file) ? FileDataTypeEnum.FileGDB : (SelectFileDataUtil.isGridFile(fileStorage, file) ? FileDataTypeEnum.RasterGridFile : (SelectFileDataUtil.isArcgisTileFile(fileStorage, file) ? FileDataTypeEnum.ArcgisTile : (SelectFileDataUtil.is3dTilesFile(fileStorage, file) ? FileDataTypeEnum.Tiles3d : FileDataTypeEnum.Folder)));
            } else {
                String ext;
                switch (ext = file.getExt().toLowerCase()) {
                    case ".gpkg": {
                        typeEnum = FileDataTypeEnum.GeoPackage;
                        break;
                    }
                    case ".db": {
                        typeEnum = FileDataTypeEnum.SQLite;
                        break;
                    }
                    case ".mdb": {
                        typeEnum = FileDataTypeEnum.MDB;
                        break;
                    }
                    case ".geojson": {
                        typeEnum = FileDataTypeEnum.GeoJSON;
                        break;
                    }
                    case ".kml": {
                        typeEnum = FileDataTypeEnum.KML;
                        break;
                    }
                    case ".gml": {
                        typeEnum = FileDataTypeEnum.GML;
                        break;
                    }
                    case ".000": {
                        typeEnum = FileDataTypeEnum.S57;
                        break;
                    }
                    case ".xls": 
                    case ".xlsx": {
                        typeEnum = FileDataTypeEnum.Excel;
                        break;
                    }
                    case ".csv": {
                        typeEnum = FileDataTypeEnum.Csv;
                        break;
                    }
                    case ".dbf": {
                        typeEnum = FileDataTypeEnum.Dbf;
                        break;
                    }
                    case ".txt": {
                        typeEnum = FileDataTypeEnum.Txt;
                        break;
                    }
                }
            }
        }
        return typeEnum;
    }

    public static SelectFileDataDTO getSelectFileData(IFileStorage fileStorage, String filePath, List<FileDataTypeEnum> filterTypes, String customFileExts) {
        FilterResult filterResult = null;
        SelectFileDataDTO openFileDataDTO = null;
        IFileset fileset = fileStorage.getFile(filePath);
        if (fileset == null) {
            return null;
        }
        String fileName = fileset.getName();
        String fileFullPath = fileset.getFullPath();
        if (fileset.getIsDirectory()) {
            if (SelectFileDataUtil.isFileGDB(fileStorage, fileset)) {
                filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.FileGDB, filterTypes);
                if (filterResult.canDisplay) {
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.FileGDB.getValue());
                }
            } else if (SelectFileDataUtil.isGridFile(fileStorage, fileset)) {
                filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterGridFile, filterTypes);
                if (filterResult.canDisplay) {
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterGridFile.getValue());
                }
            } else {
                if (SelectFileDataUtil.isGridInfo(fileStorage, fileset)) {
                    return null;
                }
                if (SelectFileDataUtil.isArcgisTileFile(fileStorage, fileset)) {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.ArcgisTile, filterTypes);
                    if (filterResult.canDisplay) {
                        openFileDataDTO = new SelectFileDataDTO();
                        openFileDataDTO.setType(FileDataTypeEnum.ArcgisTile.getValue());
                    }
                } else if (SelectFileDataUtil.is3dTilesFile(fileStorage, fileset)) {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Tiles3d, filterTypes);
                    if (filterResult.canDisplay) {
                        openFileDataDTO = new SelectFileDataDTO();
                        openFileDataDTO.setType(FileDataTypeEnum.Tiles3d.getValue());
                    }
                } else {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Folder, filterTypes);
                    if (filterResult.canDisplay) {
                        openFileDataDTO = new SelectFileDataDTO();
                        openFileDataDTO.setType(FileDataTypeEnum.Folder.getValue());
                    }
                }
            }
        } else {
            List filterExts;
            String ext = FileUtil.getExtension((String)filePath).toLowerCase();
            if (filterTypes.contains((Object)FileDataTypeEnum.File) && StringUtil.isNotEmpty((String)customFileExts) && !(filterExts = StringUtil.split((String)customFileExts, (String)",", s -> s.toLowerCase())).contains(ext)) {
                return null;
            }
            switch (ext) {
                case ".gpkg": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.GeoPackage, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.GeoPackage.getValue());
                    break;
                }
                case ".db": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.SQLite, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.SQLite.getValue());
                    break;
                }
                case ".mdb": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.MDB, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.MDB.getValue());
                    break;
                }
                case ".000": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.S57, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.S57.getValue());
                    break;
                }
                case ".geojson": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.GeoJSON, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.GeoJSON.getValue());
                    break;
                }
                case ".gml": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.GML, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.GML.getValue());
                    break;
                }
                case ".kml": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.KML, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.KML.getValue());
                    break;
                }
                case ".shp": {
                    FileDataTypeEnum type;
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Shapefile, filterTypes);
                    if (!filterResult.canDisplay || (type = SelectFileDataUtil.getShpfileGeoType(fileset)) == null) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(type.getValue());
                    break;
                }
                case ".mif": {
                    FileDataTypeEnum type;
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.MapInfo, filterTypes);
                    if (!filterResult.canDisplay || (type = SelectFileDataUtil.getFeatureType(fileset)) == null) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(type.getValue());
                    break;
                }
                case ".e00": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.E00, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.E00.getValue());
                    break;
                }
                case ".dxf": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Dxf, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.Dxf.getValue());
                    break;
                }
                case ".tif": 
                case ".tiff": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterTifFile, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterTifFile.getValue());
                    break;
                }
                case ".img": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterImgFile, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterImgFile.getValue());
                    break;
                }
                case ".bmp": 
                case ".jpg": 
                case ".jp2": 
                case ".png": 
                case ".bil": 
                case ".asc": 
                case ".vrt": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterDataset, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterDataset.getValue());
                    break;
                }
                case ".dem": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterDemFile, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterDemFile.getValue());
                    break;
                }
                case ".nc": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterNetCDF, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterNetCDF.getValue());
                    break;
                }
                case ".h5": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.RasterHDF5, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.RasterHDF5.getValue());
                    break;
                }
                case ".mbtiles": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.MBTiles, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.MBTiles.getValue());
                    break;
                }
                case ".xls": 
                case ".xlsx": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Excel, filterTypes);
                    if (!filterResult.canDisplay || fileName.startsWith("~$")) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.Excel.getValue());
                    break;
                }
                case ".csv": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Csv, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.Csv.getValue());
                    break;
                }
                case ".dbf": {
                    String shpFile;
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Dbf, filterTypes);
                    if (!filterResult.canDisplay || (filterTypes.contains((Object)FileDataTypeEnum.Shapefile) || filterTypes.contains((Object)FileDataTypeEnum.FeatureClass)) && fileStorage.fileExist(shpFile = FileUtil.changeExtension((String)fileFullPath, (String)"shp"))) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.Dbf.getValue());
                    break;
                }
                case ".txt": {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.Txt, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.Txt.getValue());
                    break;
                }
                default: {
                    filterResult = SelectFileDataUtil.canDisplayFilter(FileDataTypeEnum.File, filterTypes);
                    if (!filterResult.canDisplay) break;
                    openFileDataDTO = new SelectFileDataDTO();
                    openFileDataDTO.setType(FileDataTypeEnum.File.getValue());
                }
            }
        }
        if (openFileDataDTO != null) {
            openFileDataDTO.setName(fileName);
            openFileDataDTO.setExt(FileUtil.getExtension((String)fileName));
            openFileDataDTO.setFullPath(filePath);
            openFileDataDTO.setRelativePath(fileName);
            openFileDataDTO.setCanChoose(filterResult.canChoose);
            openFileDataDTO.setCanOpen(filterResult.canOpen);
        }
        return openFileDataDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SelectFileDataDTO> getDataFromFile(IFileStorage fileStorage, String parentFullPath, FileDataTypeEnum parentDataTypeEnum, List<FileDataTypeEnum> filterTypes, String customFileExts) {
        ArrayList<SelectFileDataDTO> lstChildObject = new ArrayList<SelectFileDataDTO>();
        FilterResult result = SelectFileDataUtil.canDisplayFilter(parentDataTypeEnum, filterTypes);
        if (!result.canOpen) {
            return lstChildObject;
        }
        switch (parentDataTypeEnum) {
            case Folder: {
                IFileset parentFile = fileStorage.getFile(parentFullPath);
                Assert.notNull((Object)parentFile, (String)("\u8def\u5f84\u4e0d\u5b58\u5728 :" + parentFullPath));
                List subFiles = parentFile.listFiles();
                for (IFileset subFile : subFiles) {
                    SelectFileDataDTO selectFileDataDTO = SelectFileDataUtil.getSelectFileData(fileStorage, subFile.getFullPath(), filterTypes, customFileExts);
                    if (selectFileDataDTO == null) continue;
                    lstChildObject.add(selectFileDataDTO);
                }
                break;
            }
            case GeoPackage: 
            case SQLite: 
            case FileGDB: 
            case MDB: 
            case KML: 
            case S57: {
                try (IFeatureWorkspace workspace = null;){
                    IFileset file = fileStorage.getFile(parentFullPath);
                    Assert.notNull((Object)file, (String)("\u8def\u5f84\u4e0d\u5b58\u5728 :" + parentFullPath));
                    workspace = GeoDatabaseUtil.openFileGeoDatabase(fileStorage, file.getFullPath());
                    for (FileDataTypeEnum openDataTypeEnum : filterTypes) {
                        if (openDataTypeEnum == FileDataTypeEnum.FeatureClass) {
                            lstChildObject.addAll(SelectFileDataUtil.getDatasets(workspace, GeoDatasetType.FeatureClass));
                            lstChildObject.forEach(o -> o.setFullPath(fileStorage.combinePaths(parentFullPath, new String[]{o.getName()})));
                            continue;
                        }
                        if (openDataTypeEnum != FileDataTypeEnum.Table) continue;
                        lstChildObject.addAll(SelectFileDataUtil.getDatasets(workspace, GeoDatasetType.Table));
                        lstChildObject.forEach(o -> o.setFullPath(fileStorage.combinePaths(parentFullPath, new String[]{o.getName()})));
                    }
                    break;
                }
            }
            case Excel: {
                try {
                    for (FileDataTypeEnum openDataTypeEnum : filterTypes) {
                        if (openDataTypeEnum != FileDataTypeEnum.ExcelSheet && openDataTypeEnum != FileDataTypeEnum.Table) continue;
                        IFileset file = fileStorage.getFile(parentFullPath);
                        InputStream inputStream = file.openFileStream();
                        Throwable throwable = null;
                        try {
                            List sheets = ExcelUtil.readExcelSheets((InputStream)inputStream);
                            for (String sheet : sheets) {
                                String sheetPath = parentFullPath + fileStorage.getSeparator() + sheet;
                                SelectFileDataDTO openFileDataDTO = new SelectFileDataDTO();
                                openFileDataDTO.setType(FileDataTypeEnum.ExcelSheet.getValue());
                                openFileDataDTO.setName(sheet);
                                openFileDataDTO.setFullPath(sheetPath);
                                openFileDataDTO.setCanChoose(true);
                                openFileDataDTO.setCanOpen(false);
                                lstChildObject.add(openFileDataDTO);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    log.error(parentFullPath, (Throwable)e);
                    break;
                }
            }
        }
        lstChildObject.sort((l1, l2) -> {
            int r = Boolean.compare(l2.getType().intValue() == FileDataTypeEnum.Folder.getValue(), l1.getType().intValue() == FileDataTypeEnum.Folder.getValue());
            if (r == 0) {
                return l1.getName().compareTo(l2.getName());
            }
            return r;
        });
        return lstChildObject;
    }

    public static List<SelectFileDataDTO> getDataFromFolderRecursion(IFileStorage fileStorage, String parentFullPath, List<FileDataTypeEnum> filterTypes, String customFileExts) {
        ArrayList<SelectFileDataDTO> lstChildObject = new ArrayList<SelectFileDataDTO>();
        List<SelectFileDataDTO> subFileDatas = SelectFileDataUtil.getDataFromFile(fileStorage, parentFullPath, FileDataTypeEnum.Folder, filterTypes, customFileExts);
        for (SelectFileDataDTO subFile : subFileDatas) {
            if (subFile.getCanChoose().booleanValue()) {
                lstChildObject.add(subFile);
            }
            if (subFile.getType().intValue() == FileDataTypeEnum.Folder.getValue()) {
                lstChildObject.addAll(SelectFileDataUtil.getDataFromFolderRecursion(fileStorage, subFile.getFullPath(), filterTypes, customFileExts));
                continue;
            }
            lstChildObject.addAll(SelectFileDataUtil.getDataFromFile(fileStorage, subFile.getFullPath(), FileDataTypeEnum.getByValue(subFile.getType()), filterTypes, customFileExts));
        }
        return lstChildObject;
    }

    private static List<SelectFileDataDTO> getDatasets(IFeatureWorkspace workspace, GeoDatasetType datasetType) {
        ArrayList<SelectFileDataDTO> lstChildObject = new ArrayList<SelectFileDataDTO>();
        List enumDataset = workspace.getDatasets(new GeoDatasetType[]{datasetType});
        for (IGeoDataset dataset : enumDataset) {
            SelectFileDataDTO openFileDataDTO = null;
            if (dataset.getType() == GeoDatasetType.FeatureClass) {
                openFileDataDTO = new SelectFileDataDTO();
                openFileDataDTO.setType(FileDataTypeEnum.FeatureClass.getValue());
                openFileDataDTO.setName(dataset.getName());
                openFileDataDTO.setCanChoose(true);
                openFileDataDTO.setCanOpen(false);
                switch (((IFeatureClass)dataset).getFeatureType()) {
                    case Point: {
                        openFileDataDTO.setType(FileDataTypeEnum.PointFeatureClass.getValue());
                        break;
                    }
                    case Polyline: {
                        openFileDataDTO.setType(FileDataTypeEnum.LineFeatureClass.getValue());
                        break;
                    }
                    case Polygon: {
                        openFileDataDTO.setType(FileDataTypeEnum.PolygonFeatureClass.getValue());
                        break;
                    }
                }
            } else if (dataset.getType() == GeoDatasetType.Table) {
                openFileDataDTO = new SelectFileDataDTO();
                openFileDataDTO.setType(FileDataTypeEnum.Table.getValue());
                openFileDataDTO.setName(dataset.getName());
                openFileDataDTO.setCanChoose(true);
                openFileDataDTO.setCanOpen(false);
            }
            if (openFileDataDTO == null) continue;
            lstChildObject.add(openFileDataDTO);
        }
        return lstChildObject;
    }

    private static boolean isFileGDB(IFileStorage fileStorage, IFileset file) {
        String gdbPath = fileStorage.combinePaths(file.getFullPath(), new String[]{"gdb"});
        return file.getName().toLowerCase().endsWith(".gdb") && fileStorage.fileExist(gdbPath);
    }

    private static boolean isGridFile(IFileStorage fileStorage, IFileset file) {
        String adfPath = fileStorage.combinePaths(file.getFullPath(), new String[]{"w001001.adf"});
        return fileStorage.fileExist(adfPath);
    }

    private static boolean isGridInfo(IFileStorage fileStorage, IFileset file) {
        String adfPath = fileStorage.combinePaths(file.getFullPath(), new String[]{"arc.dir"});
        return file.getName().equalsIgnoreCase("info") && fileStorage.fileExist(adfPath);
    }

    private static boolean isArcgisTileFile(IFileStorage fileStorage, IFileset file) {
        String cdiPath = fileStorage.combinePaths(file.getFullPath(), new String[]{"conf.cdi"});
        String xmlPath = fileStorage.combinePaths(file.getFullPath(), new String[]{"conf.xml"});
        return fileStorage.fileExist(cdiPath) && fileStorage.fileExist(xmlPath);
    }

    private static boolean is3dTilesFile(IFileStorage fileStorage, IFileset file) {
        String tilesetPath = fileStorage.combinePaths(file.getFullPath(), new String[]{"tileset.json"});
        return fileStorage.fileExist(tilesetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDataTypeEnum getFeatureType(IFileset fileset) {
        try (IFeatureWorkspace workspace = null;){
            workspace = GeoDatabaseUtil.openFileGeoDatabase(fileset.getFileStorage(), fileset.getFullPath());
            IGeoDataset geoDataset = workspace.openGeoDataset(FileUtil.getFileNameWithoutExtension((String)fileset.getName()));
            if (geoDataset instanceof IFeatureClass) {
                FeatureType type = ((IFeatureClass)geoDataset).getFeatureType();
                switch (type) {
                    case Point: {
                        FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.PointFeatureClass;
                        return fileDataTypeEnum;
                    }
                    case Polyline: {
                        FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.LineFeatureClass;
                        return fileDataTypeEnum;
                    }
                    case Polygon: {
                        FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.PolygonFeatureClass;
                        return fileDataTypeEnum;
                    }
                    case Unknown: 
                    case Annotation: 
                    case Mixed: {
                        log.error(fileset.getFullPath() + "\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + type);
                    }
                }
            } else if (geoDataset instanceof ITable) {
                FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.Table;
                return fileDataTypeEnum;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileDataTypeEnum getShpfileGeoType(IFileset fileset) {
        int type;
        InputStream reader;
        block9: {
            block8: {
                block7: {
                    reader = null;
                    reader = fileset.openFileStream();
                    reader.skip(32L);
                    type = reader.read();
                    if (type != 1 && type != 8 && type != 11 && type != 18 && type != 21 && type != 28) break block7;
                    FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.PointFeatureClass;
                    ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
                    return fileDataTypeEnum;
                }
                if (type != 3 && type != 13 && type != 23) break block8;
                FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.LineFeatureClass;
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
                return fileDataTypeEnum;
            }
            if (type != 5 && type != 15 && type != 25) break block9;
            FileDataTypeEnum fileDataTypeEnum = FileDataTypeEnum.PolygonFeatureClass;
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
            return fileDataTypeEnum;
        }
        try {
            try {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684shpfile\u51e0\u4f55\u7c7b\u578b\uff1a" + type);
            }
            catch (Exception e) {
                log.error(fileset.getFullPath(), (Throwable)e);
                ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
            }
        }
        catch (Throwable throwable) {
            ObjectCloseUtil.close((AutoCloseable[])new AutoCloseable[]{reader});
            throw throwable;
        }
        return null;
    }

    public static FilterResult canDisplayFilter(FileDataTypeEnum currentType, List<FileDataTypeEnum> filterTypes) {
        FilterResult result = new FilterResult();
        for (FileDataTypeEnum filterType : filterTypes) {
            FilterResult oneResult;
            switch (filterType) {
                case File: {
                    oneResult = SelectFileDataUtil.allFileFilter(currentType);
                    break;
                }
                case Folder: {
                    oneResult = SelectFileDataUtil.folderFilter(currentType);
                    break;
                }
                case GeoPackage: {
                    oneResult = SelectFileDataUtil.gpkgGDBFilter(currentType);
                    break;
                }
                case SQLite: {
                    oneResult = SelectFileDataUtil.sqliteGDBFilter(currentType);
                    break;
                }
                case FileGDB: {
                    oneResult = SelectFileDataUtil.fileGDBFilter(currentType);
                    break;
                }
                case MDB: {
                    oneResult = SelectFileDataUtil.mdbGDBFilter(currentType);
                    break;
                }
                case Shapefile: {
                    oneResult = SelectFileDataUtil.shpfileFilter(currentType);
                    break;
                }
                case GeoJSON: {
                    oneResult = SelectFileDataUtil.geojsonFilter(currentType);
                    break;
                }
                case KML: {
                    oneResult = SelectFileDataUtil.kmlFilter(currentType);
                    break;
                }
                case GML: {
                    oneResult = SelectFileDataUtil.gmlFilter(currentType);
                    break;
                }
                case S57: {
                    oneResult = SelectFileDataUtil.s57Filter(currentType);
                    break;
                }
                case MapInfo: {
                    oneResult = SelectFileDataUtil.mapInfoFilter(currentType);
                    break;
                }
                case E00: {
                    oneResult = SelectFileDataUtil.e00Filter(currentType);
                    break;
                }
                case Dxf: {
                    oneResult = SelectFileDataUtil.dxfFilter(currentType);
                    break;
                }
                case FeatureClass: {
                    oneResult = SelectFileDataUtil.featureClassFilter(currentType);
                    break;
                }
                case Table: {
                    oneResult = SelectFileDataUtil.tableFilter(currentType);
                    break;
                }
                case RasterDataset: {
                    oneResult = SelectFileDataUtil.rasterDatasetFilter(currentType);
                    break;
                }
                case RasterTifFile: {
                    oneResult = SelectFileDataUtil.rasterTifFilter(currentType);
                    break;
                }
                case RasterImgFile: {
                    oneResult = SelectFileDataUtil.rasterImgFilter(currentType);
                    break;
                }
                case RasterGridFile: {
                    oneResult = SelectFileDataUtil.rasterGridFilter(currentType);
                    break;
                }
                case RasterDemFile: {
                    oneResult = SelectFileDataUtil.rasterDemFilter(currentType);
                    break;
                }
                case RasterNetCDF: {
                    oneResult = SelectFileDataUtil.rasterNetCDFFilter(currentType);
                    break;
                }
                case RasterHDF5: {
                    oneResult = SelectFileDataUtil.rasterHDF5Filter(currentType);
                    break;
                }
                case TileDataset: {
                    oneResult = SelectFileDataUtil.tileDatasetFilter(currentType);
                    break;
                }
                case MBTiles: {
                    oneResult = SelectFileDataUtil.MBTilesFilter(currentType);
                    break;
                }
                case ArcgisTile: {
                    oneResult = SelectFileDataUtil.arcgisTileFilter(currentType);
                    break;
                }
                case Tiles3d: {
                    oneResult = SelectFileDataUtil.tiles3dFilter(currentType);
                    break;
                }
                case Excel: {
                    oneResult = SelectFileDataUtil.excelFilter(currentType);
                    break;
                }
                case ExcelSheet: {
                    oneResult = SelectFileDataUtil.sheetFilter(currentType);
                    break;
                }
                case Csv: {
                    oneResult = SelectFileDataUtil.csvFilter(currentType);
                    break;
                }
                case Dbf: {
                    oneResult = SelectFileDataUtil.dbfFilter(currentType);
                    break;
                }
                case Txt: {
                    oneResult = SelectFileDataUtil.TxtFilter(currentType);
                    break;
                }
                default: {
                    oneResult = new FilterResult();
                }
            }
            result.canDisplay = result.canDisplay || oneResult.canDisplay;
            result.canChoose = result.canChoose || oneResult.canChoose;
            result.canOpen = result.canOpen || oneResult.canOpen;
        }
        return result;
    }

    private static FilterResult folderFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: 
            case FileGDB: 
            case RasterGridFile: 
            case ArcgisTile: 
            case Tiles3d: {
                return new FilterResult(true, true, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult allFileFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: 
            case FileGDB: 
            case RasterGridFile: 
            case ArcgisTile: 
            case Tiles3d: {
                return new FilterResult(true, true, false);
            }
        }
        return new FilterResult(true, false, true);
    }

    private static FilterResult gpkgGDBFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case GeoPackage: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult sqliteGDBFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case SQLite: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult fileGDBFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case FileGDB: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult mdbGDBFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case MDB: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult shpfileFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Shapefile: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult geojsonFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case GeoJSON: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult gmlFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case GML: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult s57Filter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case S57: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult kmlFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case KML: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult mapInfoFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case MapInfo: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult e00Filter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case E00: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult dxfFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Dxf: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult featureClassFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: 
            case GeoPackage: 
            case SQLite: 
            case FileGDB: 
            case MDB: 
            case KML: 
            case S57: 
            case E00: 
            case Dxf: {
                return new FilterResult(true, true, false);
            }
            case Shapefile: 
            case GeoJSON: 
            case GML: 
            case MapInfo: 
            case FeatureClass: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterDatasetFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterDataset: 
            case RasterTifFile: 
            case RasterImgFile: 
            case RasterGridFile: 
            case RasterDemFile: 
            case RasterNetCDF: 
            case RasterHDF5: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterTifFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterTifFile: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterImgFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterImgFile: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterGridFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterGridFile: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterDemFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterDemFile: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterNetCDFFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterNetCDF: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult rasterHDF5Filter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case RasterHDF5: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult tileDatasetFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case TileDataset: 
            case MBTiles: 
            case ArcgisTile: 
            case Tiles3d: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult MBTilesFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case MBTiles: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult arcgisTileFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case ArcgisTile: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult tiles3dFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Tiles3d: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult TxtFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Txt: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult tableFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: 
            case GeoPackage: 
            case SQLite: 
            case FileGDB: 
            case MDB: 
            case KML: 
            case S57: {
                return new FilterResult(true, true, false);
            }
            case Excel: {
                return new FilterResult(true, true, true);
            }
            case Table: 
            case ExcelSheet: 
            case Csv: 
            case Dbf: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult excelFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Excel: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult sheetFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: 
            case Excel: {
                return new FilterResult(true, true, false);
            }
            case ExcelSheet: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult csvFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Csv: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    private static FilterResult dbfFilter(FileDataTypeEnum enumCategoryType) {
        switch (enumCategoryType) {
            case Folder: {
                return new FilterResult(true, true, false);
            }
            case Dbf: {
                return new FilterResult(true, false, true);
            }
        }
        return new FilterResult(false, false, false);
    }

    static class FilterResult {
        public boolean canDisplay = false;
        public boolean canOpen = false;
        public boolean canChoose = false;

        public FilterResult() {
        }

        public FilterResult(boolean pCanDisplay, boolean pCanOpen, boolean pCanChoose) {
            this.canDisplay = pCanDisplay;
            this.canOpen = pCanOpen;
            this.canChoose = pCanChoose;
        }
    }
}

