/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.basic.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtil {
    private static Logger c = LoggerFactory.getLogger(XmlUtil.class);
    private static DocumentBuilderFactory R;
    private static XPath S;

    public static Document createDocument() throws ParserConfigurationException {
        DocumentBuilder documentBuilder = R.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        return document;
    }

    public static Document readDocumentFromStr(String string) throws ParserConfigurationException, IOException, SAXException {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        DocumentBuilder documentBuilder = R.newDocumentBuilder();
        return documentBuilder.parse(inputSource);
    }

    public static Document readDocumentFromFile(File file) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = R.newDocumentBuilder();
        return documentBuilder.parse(file);
    }

    public static Element appendElement(Element element, String string, Object object) {
        Element element2 = element.getOwnerDocument().createElement(string);
        if (object != null) {
            element2.setTextContent(object.toString());
        }
        element.appendChild(element2);
        return element2;
    }

    public static Node findfirstNode(Node node, String string) {
        try {
            Node node2 = (Node)S.evaluate(string, node, XPathConstants.NODE);
            return node2;
        }
        catch (Exception exception) {
            c.error(string + " \u67e5\u627e\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public static NodeList findNodeList(Node node, String string) {
        try {
            NodeList nodeList = (NodeList)S.evaluate(string, node, XPathConstants.NODESET);
            return nodeList;
        }
        catch (Exception exception) {
            c.error(string + " \u67e5\u627e\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public static String findfirstNodeStringValue(Node node, String string) {
        try {
            String string2 = (String)S.evaluate(string, node, XPathConstants.STRING);
            return string2;
        }
        catch (Exception exception) {
            c.error(string + " \u67e5\u627e\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public static Double findfirstNodeDoubleValue(Node node, String string) {
        try {
            String string2 = (String)S.evaluate(string, node, XPathConstants.STRING);
            if (string2 == null || string2.trim().length() == 0) {
                return Double.NaN;
            }
            return Double.valueOf(string2);
        }
        catch (Exception exception) {
            c.error(string + " \u67e5\u627e\u5f02\u5e38", (Throwable)exception);
            return Double.NaN;
        }
    }

    public static Integer findfirstNodeIntValue(Node node, String string) {
        try {
            Double d = (Double)S.evaluate(string, node, XPathConstants.NUMBER);
            if (d != null) {
                return d.intValue();
            }
            return null;
        }
        catch (Exception exception) {
            c.error(string + " \u67e5\u627e\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public static Boolean findfirstNodeBooleanValue(Node node, String string) {
        try {
            Boolean bl = (Boolean)S.evaluate(string, node, XPathConstants.BOOLEAN);
            return bl;
        }
        catch (Exception exception) {
            c.error(string + " \u67e5\u627e\u5f02\u5e38", (Throwable)exception);
            return null;
        }
    }

    public static String toXmlString(Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "no");
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        String string = stringWriter.toString();
        try {
            stringWriter.close();
        }
        catch (Exception exception) {
            c.error(exception.getMessage());
        }
        return string;
    }

    public static void write2File(File file, Document document) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        FileWriter fileWriter = new FileWriter(file);
        transformer.transform(new DOMSource(document), new StreamResult(fileWriter));
        try {
            fileWriter.close();
        }
        catch (Exception exception) {
            c.error(exception.getMessage());
        }
    }

    static {
        try {
            R = DocumentBuilderFactory.newInstance();
            R.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        XPathFactory xPathFactory = XPathFactory.newInstance();
        S = xPathFactory.newXPath();
    }
}

