/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.directory;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.a;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryFileStorage
implements IFileStorage {
    private static final Logger a = LoggerFactory.getLogger(DirectoryFileStorage.class);
    private String b;
    private String c;
    private String d;
    private boolean e;

    public DirectoryFileStorage(String string, String string2, String string3) {
        this.c = string2;
        this.d = string3;
        this.e = System.getProperty("os.name").toLowerCase().contains("windows");
        Path path = Paths.get(string, new String[0]).normalize();
        if (this.e && path.toString().endsWith(":")) {
            path = Paths.get(path.toString() + "\\", new String[0]);
        }
        this.b = path.toFile().getAbsolutePath();
    }

    @Override
    public String getStorageUrl() {
        return this.b;
    }

    @Override
    public String getUserName() {
        return this.c;
    }

    @Override
    public String getPassword() {
        return this.d;
    }

    @Override
    public String getType() {
        return "standard";
    }

    @Override
    public String getSeparator() {
        return File.separator;
    }

    @Override
    public boolean connect() {
        File file = new File(this.b);
        if (this.c != null && this.c.length() > 0 && this.d != null && this.d.length() > 0 && this.e && this.b.startsWith("\\\\")) {
            NtlmPasswordAuthentication ntlmPasswordAuthentication;
            String string = "smb:" + this.b.replace("\\", "/");
            SmbFile smbFile = new SmbFile(string, ntlmPasswordAuthentication = new NtlmPasswordAuthentication(null, this.c, this.d));
            if (!smbFile.exists()) {
                throw new RuntimeException("\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + this.b);
            }
            if (file.exists() && file.isDirectory()) {
                return true;
            }
            try {
                String string2;
                String string3 = "net use " + this.b + " /del";
                Process process = Runtime.getRuntime().exec(string3);
                process.waitFor();
                string3 = "net use " + this.b;
                if (this.c != null && this.c.length() > 0) {
                    string3 = string3 + " \"" + this.d + "\"  /user:\"" + this.c;
                }
                a.debug("\u6267\u884c\u5171\u4eab\u76ee\u5f55\u8fde\u63a5\u547d\u4ee4\uff1a" + string3);
                Process process2 = Runtime.getRuntime().exec(string3);
                InputStream inputStream = process2.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "GBK"));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2).append("\n");
                }
                inputStream.close();
                String string4 = stringBuilder.toString();
                if (string4.length() == 0) {
                    InputStream inputStream2 = process2.getErrorStream();
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2, "GBK"));
                    StringBuilder stringBuilder2 = new StringBuilder();
                    while ((string2 = bufferedReader2.readLine()) != null) {
                        stringBuilder2.append(string2).append("\n");
                    }
                    String string5 = stringBuilder2.toString();
                    if (string5.length() > 0) {
                        a.error(string5);
                    }
                } else {
                    a.debug(string4);
                }
                process2.waitFor();
            }
            catch (Exception exception) {
                a.error("\u8fde\u63a5\u5f02\u5e38", (Throwable)exception);
            }
        }
        if (file.exists() && file.isDirectory()) {
            return true;
        }
        throw new RuntimeException("\u8def\u5f84\u4e0d\u5b58\u5728\uff1a" + this.b);
    }

    @Override
    public void close() {
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        String string2 = this.a(string);
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(string2, new String[0]));){
            for (Path path : directoryStream) {
                String string3 = path.toString();
                String string4 = this.b(string3);
                a a2 = new a(this, path.toFile(), string4);
                arrayList.add(a2);
                if (!bl || !a2.getIsDirectory()) continue;
                arrayList.addAll(this.listFile(string3, bl));
            }
        }
        catch (NoSuchFileException | NotDirectoryException fileSystemException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        String string2 = this.a(string);
        File file = new File(string2);
        return file.exists();
    }

    @Override
    public IFileset getFile(String string) {
        String string2 = this.a(string);
        File file = new File(string2);
        if (file.exists()) {
            String string3 = this.b(string2);
            a a2 = new a(this, file, string3);
            return a2;
        }
        return null;
    }

    @Override
    public IFileset getParentFile(String string) {
        String string2 = new File(string).getParent();
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.getFile(string2);
    }

    @Override
    public boolean deleteFile(String string) {
        File file = new File(this.a(string));
        return file.delete();
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        File file = new File(this.a(string), string2);
        if (!file.mkdirs()) {
            return null;
        }
        return this.getFile(string + "/" + string2);
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        return Paths.get(string, stringArray).normalize().toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        File file = new File(this.a(string2));
        DirectoryFileStorage.a(new File(string), file, bl);
        return this.getFile(string2);
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        File file = new File(this.a(string));
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        return this.getFile(string);
    }

    @Override
    public InputStream openFileStream(String string) {
        File file = new File(this.a(string));
        if (!file.isFile() || !file.exists()) {
            throw new RuntimeException(string + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    private static void a(File file, File file2, boolean bl) {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u4e0d\u5b58\u5728");
        }
        if (file.isFile()) {
            if (bl || !file2.exists()) {
                File file3 = file2.getParentFile();
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                DirectoryFileStorage.a(file, file2);
            }
            return;
        }
        if (!(file2.exists() || file2.isFile() || file2.mkdirs())) {
            throw new RuntimeException(file2.getAbsolutePath() + " \u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file4 : fileArray) {
            File file5 = new File(file2, file4.getName());
            DirectoryFileStorage.a(file4, file5, bl);
        }
    }

    private static void a(File file, File file2) {
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                int n;
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[2048];
                while ((n = fileInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                a.error("\u6e90\u6587\u4ef6\uff1a" + file.getAbsolutePath());
                a.error("\u76ee\u6807\u6587\u4ef6\uff1a" + file2.getAbsolutePath());
                throw new RuntimeException("\u590d\u5236\u6587\u4ef6\u5f02\u5e38:" + exception.getMessage(), exception);
            }
        }
    }

    private String a(String string) {
        if (string == null || string.isEmpty()) {
            return this.b;
        }
        String string2 = (string = Paths.get(string, new String[0]).normalize().toString()).startsWith(this.b) ? string : (this.b.startsWith(string) ? string : Paths.get(this.b, string).normalize().toString());
        while (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (this.e) {
            if (string2.endsWith(":")) {
                string2 = string + "\\";
            }
        } else if (string2.isEmpty()) {
            string2 = "/";
        }
        return string2;
    }

    private String b(String string) {
        if (string.toLowerCase().startsWith(this.b.toLowerCase())) {
            if (string.length() == this.b.length()) {
                return "";
            }
            String string2 = string.substring(this.b.length());
            if (string2.startsWith(this.getSeparator())) {
                return string2.substring(1);
            }
            return string2;
        }
        return "";
    }
}

