/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.obstorage;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.h;
import com.geoway.adf.gis.fs.obstorage.BucketInfo;
import com.geoway.adf.gis.fs.obstorage.BucketPolicyEnum;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import com.obs.services.ObsClient;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.Permission;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBSFileStorage
implements IFileStorage,
IObjectStorage {
    private static final Logger a = LoggerFactory.getLogger(OBSFileStorage.class);
    protected final String endPoint;
    private final String C;
    private final String D;
    protected String bucketName;
    public String pathPrefix;
    private ObsClient T;
    private static Map<String, ObsClient> G = new ConcurrentHashMap<String, ObsClient>();

    public OBSFileStorage(String string, String string2, String string3, String string4) {
        this.C = string3;
        this.D = string4;
        String string5 = string;
        while (string5.endsWith("/")) {
            string5 = string5.substring(0, string5.length() - 1);
        }
        this.endPoint = string5;
        if (string2 != null && !string2.trim().isEmpty()) {
            this.bucketName = string2.trim();
            this.pathPrefix = this.endPoint + "/" + this.bucketName;
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.bucketName == null || this.bucketName.isEmpty()) {
            return this.endPoint;
        }
        return this.endPoint + "/" + this.bucketName;
    }

    @Override
    public String getUserName() {
        return this.C;
    }

    @Override
    public String getPassword() {
        return this.D;
    }

    @Override
    public String getType() {
        return "object storage";
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean connect() {
        if (this.T != null) {
            return true;
        }
        String string = String.format("%s:%s@%s", this.C, this.D, this.endPoint);
        if (G.containsKey(string)) {
            this.T = G.get(string);
        } else {
            boolean bl;
            ObsClient obsClient = new ObsClient(this.C, this.D, this.endPoint);
            if (this.bucketName != null && !this.bucketName.isEmpty() && !(bl = obsClient.headBucket(this.bucketName))) {
                throw new RuntimeException("\u8fde\u63a5\u5931\u8d25\uff0c\u6876[" + this.bucketName + "]\u4e0d\u5b58\u5728");
            }
            G.put(string, obsClient);
            this.T = obsClient;
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.T != null) {
                this.T = null;
            }
        }
        catch (Exception exception) {
            a.error(this.endPoint + "\u5173\u95ed\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public String getEndPoint() {
        return this.endPoint;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public List<String> listBucketNames() {
        List list = this.T.listBuckets(new ListBucketsRequest());
        return list.stream().map(ObsBucket::getBucketName).collect(Collectors.toList());
    }

    @Override
    public BucketInfo getBucketInfo() {
        Object object3;
        ObsBucket obsBucket2;
        Date date = null;
        boolean bl = false;
        List list = this.T.listBuckets(new ListBucketsRequest());
        for (ObsBucket obsBucket2 : list) {
            if (!obsBucket2.getBucketName().equals(this.bucketName)) continue;
            date = Date.from(obsBucket2.getCreationDate().toInstant());
            bl = true;
            break;
        }
        if (!bl) {
            throw new RuntimeException("\u6876[" + this.bucketName + "]\u4e0d\u5b58\u5728");
        }
        Object object2 = BucketPolicyEnum.Private;
        obsBucket2 = this.T.getBucketAcl(this.bucketName);
        for (Object object3 : obsBucket2.getGrants()) {
            if (!object3.getGrantee().getIdentifier().equalsIgnoreCase("Everyone")) continue;
            if (object3.getPermission().equals((Object)Permission.PERMISSION_READ)) {
                object2 = BucketPolicyEnum.PublicRead;
                continue;
            }
            if (!object3.getPermission().equals((Object)Permission.PERMISSION_FULL_CONTROL)) continue;
            object2 = BucketPolicyEnum.PublicReadWrite;
        }
        BucketStorageInfo bucketStorageInfo = this.T.getBucketStorageInfo(this.bucketName);
        object3 = new BucketInfo();
        ((BucketInfo)object3).setBucketName(this.bucketName);
        ((BucketInfo)object3).setBucketPolicy((BucketPolicyEnum)((Object)object2));
        ((BucketInfo)object3).setStorageSize(bucketStorageInfo.getSize());
        ((BucketInfo)object3).setCreationDate(date);
        return object3;
    }

    @Override
    public String generatePresignedGetUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        TemporarySignatureRequest temporarySignatureRequest = new TemporarySignatureRequest(HttpMethodEnum.GET, (long)n);
        temporarySignatureRequest.setBucketName(this.bucketName);
        temporarySignatureRequest.setObjectKey(string2);
        temporarySignatureRequest.setHeaders(map);
        temporarySignatureRequest.setQueryParams(map2);
        TemporarySignatureResponse temporarySignatureResponse = this.T.createTemporarySignature(temporarySignatureRequest);
        return temporarySignatureResponse.getSignedUrl();
    }

    @Override
    public String generatePresignedPutUrl(String string, int n, Map<String, String> map, Map<String, String> map2) {
        String string2 = this.g(string);
        TemporarySignatureRequest temporarySignatureRequest = new TemporarySignatureRequest(HttpMethodEnum.PUT, (long)n);
        temporarySignatureRequest.setBucketName(this.bucketName);
        temporarySignatureRequest.setObjectKey(string2);
        temporarySignatureRequest.setHeaders(map);
        temporarySignatureRequest.setQueryParams(map2);
        TemporarySignatureResponse temporarySignatureResponse = this.T.createTemporarySignature(temporarySignatureRequest);
        return temporarySignatureResponse.getSignedUrl();
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        h h2;
        String string2 = this.g(string);
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
        listObjectsRequest.setPrefix(string2);
        listObjectsRequest.setDelimiter("/");
        ObjectListing objectListing = this.T.listObjects(listObjectsRequest);
        for (String string3 : objectListing.getCommonPrefixes()) {
            h2 = new h(this, string3, true);
            arrayList.add(h2);
        }
        for (String string3 : objectListing.getObjects()) {
            if (string3.getObjectKey().equals(string2)) continue;
            h2 = new h(this, string3.getObjectKey(), this.h(string3.getObjectKey()));
            if (!h2.getIsDirectory()) {
                h2.a(Date.from(string3.getMetadata().getLastModified().toInstant()));
                h2.a(string3.getMetadata().getContentLength());
            }
            arrayList.add(h2);
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        String string2 = this.g(string);
        return this.f(string2);
    }

    @Override
    public IFileset getFile(String string) {
        String string2 = this.g(string);
        if (this.h(string2)) {
            if (this.f(string2)) {
                h h2 = new h(this, string2, true);
                return h2;
            }
            a.error(string + " does not exist.");
            return null;
        }
        if (!this.T.doesObjectExist(this.bucketName, string2)) {
            a.error(string + " does not exist.");
            return null;
        }
        ObsObject obsObject = this.T.getObject(this.bucketName, string2);
        h h3 = new h(this, string2, this.h(string2));
        if (!h3.getIsDirectory()) {
            h3.a(Date.from(obsObject.getMetadata().getLastModified().toInstant()));
            h3.a(obsObject.getMetadata().getContentLength());
        }
        return h3;
    }

    @Override
    public IFileset getParentFile(String string) {
        String string2 = null;
        if (string.endsWith("/")) {
            int n = string.substring(0, string.length() - 1).lastIndexOf("/");
            if (n >= 0) {
                string2 = string.substring(0, n + 1);
            }
        } else {
            int n = string.lastIndexOf("/");
            if (n >= 0 && !this.fileExist(string2 = string.substring(0, n + 1))) {
                string2 = string.substring(0, n);
            }
        }
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.getFile(string2);
    }

    @Override
    public boolean deleteFile(String string) {
        String string2 = this.g(string);
        this.T.deleteObject(this.bucketName, string2);
        return true;
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        String string3 = this.g(string);
        String string4 = string3 + string2 + "/";
        this.e(string4);
        return this.getFile(string4);
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        if (stringArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripEnd((String)string, (String)"/"));
        for (int j = 0; j < stringArray.length - 1; ++j) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.strip((String)stringArray[j], (String)"/"));
        }
        stringBuilder.append("/");
        stringBuilder.append(StringUtils.stripStart((String)stringArray[stringArray.length - 1], (String)"/"));
        return stringBuilder.toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        String string3 = this.g(string2);
        File file = new File(string);
        if (file.isDirectory() && !string3.isEmpty() && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        this.b(file, string3, bl);
        return this.getFile(string3);
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        String string2 = this.g(string);
        this.T.putObject(this.bucketName, string2, inputStream);
        return this.getFile(string2);
    }

    @Override
    public InputStream openFileStream(String string) {
        String string2 = this.g(string);
        ObsObject obsObject = this.T.getObject(this.bucketName, string2);
        return obsObject.getObjectContent();
    }

    private void b(File file, String string, boolean bl) {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u4e0d\u5b58\u5728");
        }
        if (file.isFile()) {
            if (bl || !this.f(string)) {
                PutObjectRequest putObjectRequest = new PutObjectRequest();
                putObjectRequest.setBucketName(this.bucketName);
                putObjectRequest.setObjectKey(string);
                putObjectRequest.setFile(file);
                PutObjectResult putObjectResult = this.T.putObject(putObjectRequest);
            }
            return;
        }
        this.e(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string + file2.getName();
            if (file2.isDirectory()) {
                string2 = string2 + "/";
            }
            this.b(file2, string2, bl);
        }
    }

    private void e(String string) {
        if (!this.f(string)) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, string, (InputStream)byteArrayInputStream);
            this.T.putObject(putObjectRequest);
        }
    }

    private boolean f(String string) {
        if (string.isEmpty() || string.equals("/")) {
            return true;
        }
        if (this.h(string)) {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
            listObjectsRequest.setPrefix(string);
            listObjectsRequest.setDelimiter("/");
            listObjectsRequest.setMaxKeys(1);
            ObjectListing objectListing = this.T.listObjects(listObjectsRequest);
            return !objectListing.getCommonPrefixes().isEmpty() || !objectListing.getObjects().isEmpty();
        }
        return this.T.doesObjectExist(this.bucketName, string);
    }

    private String g(String string) {
        if (this.bucketName == null) {
            throw new RuntimeException("\u672a\u8bbe\u7f6e\u6876\u540d\u79f0");
        }
        if (string == null || string.length() == 0 || string.equals("/")) {
            string = "";
        }
        String string2 = string;
        if (string.startsWith(this.pathPrefix)) {
            string2 = string.substring(this.pathPrefix.length());
        }
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private boolean h(String string) {
        return string.isEmpty() || string.endsWith("/");
    }
}

