/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.fs.ftp;

import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import com.geoway.adf.gis.fs.a.b;
import com.geoway.adf.gis.fs.a.c;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPFileStorage
implements IFileStorage {
    private static final Logger a = LoggerFactory.getLogger(FTPFileStorage.class);
    public final String url;
    private final String c;
    private final String d;
    public String dataFolder;
    private String q = "GBK";
    private GenericObjectPool<FTPClient> r;
    private FTPClient s;

    public FTPFileStorage(String string, String string2, String string3) {
        this.c = string2;
        this.d = string3;
        String string4 = string;
        while (string4.endsWith("/")) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        String string5 = "ftp://";
        if (!string4.startsWith(string5) || string4.equals(string5)) {
            throw new RuntimeException(string + " \u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int n = string4.indexOf("/", string5.length());
        if (n < 0) {
            this.url = string4;
            this.dataFolder = "/";
        } else {
            this.url = string4.substring(0, n);
            this.dataFolder = string4.substring(n);
        }
    }

    @Override
    public String getStorageUrl() {
        if (this.dataFolder == null || this.dataFolder.isEmpty() || this.dataFolder.equals("/")) {
            return this.url;
        }
        return this.url + this.dataFolder;
    }

    @Override
    public String getUserName() {
        return this.c;
    }

    @Override
    public String getPassword() {
        return this.d;
    }

    @Override
    public String getType() {
        return "ftp";
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public boolean connect() {
        if (this.s == null) {
            this.r = b.a(this.url, this.c, this.d);
            this.s = (FTPClient)this.r.borrowObject();
            if (FTPReply.isPositiveCompletion((int)this.s.sendCommand("OPTS UTF8", "ON"))) {
                this.q = "UTF-8";
            }
            this.s.setControlEncoding(this.q);
        }
        return true;
    }

    @Override
    public void close() {
        try {
            if (this.r != null) {
                this.r.returnObject((Object)this.s);
            }
            this.s = null;
        }
        catch (Exception exception) {
            a.error(this.url + "\u5173\u95ed\u5931\u8d25", (Throwable)exception);
        }
    }

    @Override
    public List<IFileset> listFile(String string, boolean bl) {
        String string2 = this.d(string);
        ArrayList<IFileset> arrayList = new ArrayList<IFileset>();
        FTPFile[] fTPFileArray = this.s.listFiles(string2);
        if (fTPFileArray == null || fTPFileArray.length == 0) {
            return arrayList;
        }
        if (fTPFileArray.length == 1 && fTPFileArray[0].isFile()) {
            try {
                IFileset iFileset = this.getFile(this.combinePath(string2, fTPFileArray[0].getName()));
                if (iFileset.getFullPath().equals(this.url + string2)) {
                    return arrayList;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (FTPFile fTPFile : fTPFileArray) {
            c c2 = new c(this, fTPFile, this.combinePath(string2, fTPFile.getName()));
            arrayList.add(c2);
            if (!bl || !fTPFile.isDirectory()) continue;
            arrayList.addAll(this.listFile(fTPFile.getLink(), bl));
        }
        return arrayList;
    }

    @Override
    public boolean fileExist(String string) {
        return this.getFile(string) != null;
    }

    @Override
    public IFileset getFile(String string) {
        Object object;
        String string2 = this.d(string);
        String string3 = new File(string).getName();
        FTPFile fTPFile = null;
        if (string2.equals("/")) {
            fTPFile = new FTPFile();
            fTPFile.setRawListing("");
        } else {
            object = this.getParentPath(string2);
            FTPFile[] fTPFileArray = this.s.listFiles((String)object);
            if (fTPFileArray != null) {
                for (FTPFile fTPFile2 : fTPFileArray) {
                    if (!fTPFile2.getName().equals(string3)) continue;
                    fTPFile = fTPFile2;
                    break;
                }
            }
        }
        if (fTPFile == null) {
            a.error("File " + string2 + " does not exist.");
            return null;
        }
        object = new c(this, fTPFile, string2);
        return object;
    }

    @Override
    public IFileset getParentFile(String string) {
        String string2 = this.getParentPath(string);
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return this.getFile(string2);
    }

    @Override
    public boolean deleteFile(String string) {
        String string2 = this.d(string);
        return this.s.deleteFile(string2);
    }

    @Override
    public IFileset createDirectory(String string, String string2) {
        String string3 = this.d(string);
        string3 = string3 + "/" + string2;
        this.s.mkd(string3);
        return this.getFile(string3);
    }

    @Override
    public String combinePaths(String string, String ... stringArray) {
        if (stringArray == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringUtils.stripEnd((String)string, (String)"/"));
        for (String string2 : stringArray) {
            stringBuilder.append("/");
            stringBuilder.append(StringUtils.strip((String)string2, (String)"/"));
        }
        return stringBuilder.toString();
    }

    @Override
    public IFileset upload(String string, String string2, boolean bl) {
        String string3 = this.d(string2);
        File file = new File(string);
        this.a(file, string3, bl);
        return this.getFile(string3);
    }

    @Override
    public IFileset upload(InputStream inputStream, String string, boolean bl) {
        String string2 = this.d(string);
        String string3 = this.getParentPath(string2);
        if (string3 != null && !this.c(string3)) {
            this.s.mkd(string3);
        }
        if (this.s.storeFile(string2, inputStream)) {
            return this.getFile(string2);
        }
        throw new RuntimeException("\u6570\u636e\u4e0a\u4f20\u5931\u8d25");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream openFileStream(String string) {
        String string2 = this.d(string);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.s.retrieveFile(string2, (OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private void a(File file, String string, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new RuntimeException(file.getAbsolutePath() + "\u4e0d\u5b58\u5728");
        }
        if (file.isFile()) {
            if (bl || !this.c(string)) {
                String string2 = this.getParentPath(string);
                if (string2 != null && !this.c(string2)) {
                    this.s.mkd(string2);
                }
                try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                    this.s.storeFile(string, inputStream);
                }
            }
            return;
        }
        if (!this.c(string) && !this.s.makeDirectory(string)) {
            throw new RuntimeException(string + " \u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string3 = string + "/" + file2.getName();
            this.a(file2, string3, bl);
        }
    }

    private boolean c(String string) {
        try {
            return this.s.listFiles(string).length > 0;
        }
        catch (Exception exception) {
            System.out.println(string);
            System.out.println(exception);
            return false;
        }
    }

    private String d(String string) {
        if (string == null || string.length() == 0) {
            string = this.dataFolder;
        }
        String string2 = string;
        if (string.startsWith(this.url)) {
            string2 = string.substring(this.url.length());
        }
        if (!string2.startsWith(this.dataFolder)) {
            string2 = (this.dataFolder.endsWith("/") ? this.dataFolder.substring(0, this.dataFolder.length() - 1) : this.dataFolder) + "/" + (string2.startsWith("/") ? string2.substring(1) : string2);
        }
        while (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.length() == 0) {
            string2 = "/";
        }
        return string2;
    }

    protected String getParentPath(String string) {
        if (string.equals("") || string.equals("/")) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    protected String combinePath(String string, String string2) {
        if (string.endsWith("/")) {
            return string + string2;
        }
        return string + "/" + string2;
    }
}

