/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb;

import com.geoway.adf.gis.basic.IEnum;
import com.geoway.adf.gis.basic.geometry.GeometryType;

public enum FeatureType implements IEnum
{
    Unknown(-1),
    Point(0),
    Polyline(1),
    Polygon(2),
    Annotation(3),
    Mixed(4);

    private final int value;

    private FeatureType(int n3) {
        this.value = n3;
    }

    public int getValue() {
        return this.value;
    }

    public static FeatureType getByValue(Integer n2) {
        return IEnum.getByValue(FeatureType.class, (Integer)n2).orElse(Unknown);
    }

    public static FeatureType getByGeometryType(GeometryType geometryType) {
        switch (geometryType) {
            case Unknown: {
                return Unknown;
            }
            case Point: 
            case MultiPoint: {
                return Point;
            }
            case LineString: 
            case Polyline: 
            case LinearRing: 
            case CircularString: 
            case Curve: 
            case CompoundCurve: 
            case MultiCurve: {
                return Polyline;
            }
            case Polygon: 
            case MultiPolygon: 
            case Envelope: 
            case CurvePolygon: 
            case MultiCurvePolygon: {
                return Polygon;
            }
        }
        return Unknown;
    }
}

