/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb.a;

import com.geoway.adf.gis.basic.RefObject;
import com.geoway.adf.gis.basic.geometry.GeometryFunc;
import com.geoway.adf.gis.basic.geometry.IEnvelope;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.basic.geometry.ISpatialReferenceSystem;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemFunc;
import com.geoway.adf.gis.basic.geometry.SpatialReferenceSystemType;
import com.geoway.adf.gis.basic.util.XmlUtil;
import com.geoway.adf.gis.fs.obstorage.AmazonS3FileStorage;
import com.geoway.adf.gis.fs.obstorage.IObjectStorage;
import com.geoway.adf.gis.fs.obstorage.MinIOFileStorage;
import com.geoway.adf.gis.fs.obstorage.OBSFileStorage;
import com.geoway.adf.gis.fs.obstorage.OSSFileStorage;
import com.geoway.adf.gis.geodb.GeoDataset;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IGeoDataset;
import com.geoway.adf.gis.geodb.IMosaicDataset;
import com.geoway.adf.gis.geodb.a.am;
import com.geoway.adf.gis.geodb.a.aq;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.field.Field;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import com.geoway.adf.gis.geodb.filter.QueryFilter;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.raster.info.PixelDataType;
import com.geoway.adf.gis.raster.info.RasterInfo;
import com.geoway.adf.gis.raster.info.RasterStatisticInfo;
import com.geoway.adf.gis.raster.info.RasterStorageInfo;
import com.geoway.adf.gis.raster.info.Size;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.gdal.gdal.Dataset;
import org.gdal.ogr.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ak
extends GeoDataset
implements IMosaicDataset {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String bj;
    protected aq bx;
    protected ISpatialReferenceSystem R = null;
    int srid = 0;
    String bw = null;
    protected IEnvelope Q = null;
    protected IFeatureClass bC;
    protected IFeatureClass bD;
    protected RasterInfo bE;

    protected ak(IFeatureWorkspace iFeatureWorkspace, String string, String string2) {
        super(iFeatureWorkspace, string, string2);
        this.bj = string;
        this.type = GeoDatasetType.MosaicDataset;
        this.bx = (aq)iFeatureWorkspace;
    }

    @Override
    public String getFullName() {
        return this.bj;
    }

    protected void f(String string) {
        this.bj = string;
    }

    protected void a(List<IGeoDataset> list) {
        this.subsets = list;
    }

    @Override
    public ISpatialReferenceSystem getSpatialReferenceSystem() {
        if (this.R == null) {
            if (this.srid > 0) {
                this.R = SpatialReferenceSystemFunc.createSpatialReference((int)this.srid);
            } else if (this.bw != null && this.bw.length() > 0) {
                this.R = SpatialReferenceSystemFunc.createSpatialReference((String)this.bw);
            }
        }
        return this.R;
    }

    protected void a(ISpatialReferenceSystem iSpatialReferenceSystem) {
        this.R = iSpatialReferenceSystem;
    }

    @Override
    public IEnvelope getExtent() {
        return this.Q;
    }

    protected void a(IEnvelope iEnvelope) {
        this.Q = iEnvelope;
    }

    @Override
    public IFeatureClass getCatalog() {
        return this.bC;
    }

    protected void a(IFeatureClass iFeatureClass) {
        this.bC = iFeatureClass;
    }

    @Override
    public IFeatureClass getBoundary() {
        return this.bD;
    }

    protected void b(IFeatureClass iFeatureClass) {
        this.bD = iFeatureClass;
    }

    public RasterInfo getRasterInfo() {
        return this.bE;
    }

    public Dataset getRaster() {
        return null;
    }

    protected void a(RasterInfo rasterInfo) {
        this.bE = rasterInfo;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean delete() {
        try {
            this.bx.beginTransaction();
            for (IGeoDataset iGeoDataset : this.getSubsets()) {
                am am2 = (am)iGeoDataset;
                am2.m();
            }
            this.bx.bN.e(this);
            this.bx.commitTransaction();
            this.subsets = new ArrayList();
            return true;
        }
        catch (Exception exception) {
            this.log.error(this.getFullName() + "\u9576\u5d4c\u6570\u636e\u96c6\u5220\u9664\u5931\u8d25", (Throwable)exception);
            this.bx.rollbackTransaction();
            return false;
        }
    }

    @Override
    public boolean alterAliasName(String string) {
        if (this.bx.bN.a((IGeoDataset)this, string)) {
            this.aliasName = string;
            return true;
        }
        return false;
    }

    @Override
    public Long getDataCount() {
        String string = "select count(*) from " + this.bC.getFullName() + " where category=1";
        Object object = this.bx.queryScalar(string, new Object[0]);
        if (object != null) {
            return Long.valueOf(object.toString());
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getDataSize() {
        Object object;
        IFeatureCursor iFeatureCursor = null;
        try {
            if (!this.bC.getFields().contains("datasize")) {
                Object object2;
                Field field = new Field("datasize", "datasize", FieldType.Long);
                this.bC.addField(field);
                long l2 = 0L;
                RasterFileWorkspace rasterFileWorkspace = new RasterFileWorkspace("");
                iFeatureCursor = this.bC.updateFeature(null);
                IFeature iFeature = iFeatureCursor.nextFeature();
                while (iFeature != null) {
                    object2 = iFeature.getValue("urihash").toString();
                    IRasterDataset iRasterDataset = rasterFileWorkspace.openRasterDataset((String)object2);
                    if (iRasterDataset != null) {
                        Long l3 = this.a(iRasterDataset);
                        if (l3 != null) {
                            iFeature.setValue("datasize", (Object)l3);
                            iFeatureCursor.updateFeature(iFeature);
                            l2 += l3.longValue();
                        }
                        iRasterDataset.closeRaster();
                    }
                    iFeature = iFeatureCursor.nextFeature();
                }
                object2 = l2;
                return object2;
            }
            String string = "select sum(datasize) from " + this.bC.getFullName();
            object = this.bx.queryScalar(string, new Object[0]);
            if (object != null) {
                Long l4 = Long.valueOf(object.toString());
                return l4;
            }
            Long l5 = 0L;
            return l5;
        }
        catch (Exception exception) {
            this.log.error(this.bj + "\u8ba1\u7b97\u5f71\u50cf\u5927\u5c0f\u5931\u8d25", (Throwable)exception);
            object = null;
            return object;
        }
        finally {
            if (iFeatureCursor != null) {
                iFeatureCursor.release();
            }
        }
    }

    @Override
    public IEnvelope updateExtent() {
        try {
            IEnvelope iEnvelope = this.bC.updateExtent();
            if (iEnvelope == null) {
                return null;
            }
            this.changeExtent(iEnvelope);
            return iEnvelope;
        }
        catch (Exception exception) {
            this.log.error("\u66f4\u65b0\u9576\u5d4c\u6570\u636e\u96c6\u8303\u56f4\u5931\u8d25", (Throwable)exception);
            return null;
        }
    }

    @Override
    public boolean changeExtent(IEnvelope iEnvelope) {
        try {
            this.bC.changeExtent(iEnvelope);
            String string = this.bx.bN.f(this);
            Document document = XmlUtil.readDocumentFromStr((String)string);
            XmlUtil.findfirstNode((Node)document, (String)"/MosaicDatainfo/Extent/Bottom").setTextContent(String.valueOf(iEnvelope.getYMin()));
            XmlUtil.findfirstNode((Node)document, (String)"/MosaicDatainfo/Extent/Left").setTextContent(String.valueOf(iEnvelope.getXMin()));
            XmlUtil.findfirstNode((Node)document, (String)"/MosaicDatainfo/Extent/Top").setTextContent(String.valueOf(iEnvelope.getYMax()));
            XmlUtil.findfirstNode((Node)document, (String)"/MosaicDatainfo/Extent/Right").setTextContent(String.valueOf(iEnvelope.getXMax()));
            string = XmlUtil.toXmlString((Document)document);
            boolean bl = this.bx.bN.c(this, string);
            if (bl) {
                this.bE.setExtent(iEnvelope);
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.error("\u66f4\u65b0\u9576\u5d4c\u6570\u636e\u96c6\u8303\u56f4\u5931\u8d25", (Throwable)exception);
            return false;
        }
    }

    public boolean defineNoDataValue(Double d2) {
        try {
            String string = this.bx.bN.f(this);
            Document document = XmlUtil.readDocumentFromStr((String)string);
            XmlUtil.findfirstNode((Node)document, (String)"/MosaicDatainfo/NoDataValue").setTextContent(String.valueOf(d2));
            string = XmlUtil.toXmlString((Document)document);
            boolean bl = this.bx.bN.c(this, string);
            if (bl) {
                Object[] objectArray = new Double[this.bE.getBandCount().intValue()];
                Arrays.fill(objectArray, d2);
                this.bE.setInvalidValue((Double[])objectArray);
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.error("\u66f4\u65b0\u9576\u5d4c\u6570\u636e\u96c6\u65e0\u6548\u503c\u5931\u8d25", (Throwable)exception);
            return false;
        }
    }

    public boolean saveAs(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean calculateCellSizeRanges() {
        try {
            boolean bl;
            String string = this.bx.bN.f(this);
            Document document = XmlUtil.readDocumentFromStr((String)string);
            Double d2 = (Double)this.bx.queryScalar(String.format("select min(lowps) from %s where category=1", this.bC.getFullName()), new Object[0]);
            if (d2 != null) {
                XmlUtil.findfirstNode((Node)document, (String)"//CellSize").setTextContent(String.valueOf(d2));
                string = XmlUtil.toXmlString((Document)document);
            }
            if (bl = this.bx.bN.c(this, string)) {
                this.bE.setXResolution(d2);
            }
            return bl;
        }
        catch (Exception exception) {
            this.log.error("\u66f4\u65b0\u9576\u5d4c\u50cf\u5143\u5927\u5c0f\u5931\u8d25", (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean updateRasterStorageInfo(RasterStorageInfo rasterStorageInfo) {
        try {
            RasterStorageInfo rasterStorageInfo2 = this.bE.getStorageInfo();
            if (rasterStorageInfo2 == null && rasterStorageInfo == null) {
                return true;
            }
            if (rasterStorageInfo2 != null && rasterStorageInfo2.equals((Object)rasterStorageInfo)) {
                return true;
            }
            String string = this.bx.bN.f(this);
            Document document = XmlUtil.readDocumentFromStr((String)string);
            Element element = document.getDocumentElement();
            boolean bl = false;
            Node node = XmlUtil.findfirstNode((Node)element, (String)"//StorageInfo");
            if (node != null) {
                element.removeChild(node);
                bl = true;
            }
            if (rasterStorageInfo != null) {
                Element element2 = XmlUtil.appendElement((Element)element, (String)"StorageInfo", null);
                XmlUtil.appendElement((Element)element2, (String)"Type", (Object)rasterStorageInfo.getType());
                XmlUtil.appendElement((Element)element2, (String)"Url", (Object)rasterStorageInfo.getUrl());
                XmlUtil.appendElement((Element)element2, (String)"UserName", (Object)rasterStorageInfo.getUserName());
                XmlUtil.appendElement((Element)element2, (String)"Password", (Object)rasterStorageInfo.getPassword());
                bl = true;
            }
            string = XmlUtil.toXmlString((Document)document);
            if (bl) {
                boolean bl2 = this.bx.bN.c(this, string);
                if (bl2) {
                    this.bE.setStorageInfo(rasterStorageInfo);
                }
                return bl2;
            }
            return true;
        }
        catch (Exception exception) {
            this.log.error("\u66f4\u65b0\u9576\u5d4c\u6570\u636e\u96c6\u5b58\u50a8\u5143\u6570\u636e\u5931\u8d25", (Throwable)exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calculateStatisticInfo(boolean bl) {
        RasterStatisticInfo[] rasterStatisticInfoArray;
        Object object;
        List<Map<String, Object>> list = this.bx.queryList(String.format("select urihash from %s where category=1", this.bC.getFullName()), new Object[0]);
        List list2 = list.stream().map(map -> map.get("urihash").toString()).collect(Collectors.toList());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        RasterFileWorkspace rasterFileWorkspace = new RasterFileWorkspace("");
        for (Object object2 : list2) {
            if (object2 == null || ((String)object2).isEmpty()) continue;
            object = null;
            try {
                object = rasterFileWorkspace.openRasterDataset((String)object2);
                if (object != null) {
                    object.calculateStatisticInfo(bl);
                    rasterStatisticInfoArray = object.getRasterInfo().getStatisticInfos();
                    if (rasterStatisticInfoArray == null) continue;
                    for (int i2 = 0; i2 < rasterStatisticInfoArray.length; ++i2) {
                        if (!linkedHashMap.containsKey(i2 + 1)) {
                            linkedHashMap.put(i2 + 1, new ArrayList());
                        }
                        ((List)linkedHashMap.get(i2 + 1)).add(rasterStatisticInfoArray[i2]);
                    }
                    continue;
                }
                this.log.error((String)object2 + " \u6253\u5f00\u5931\u8d25");
            }
            catch (Exception exception) {
                this.log.error((String)object2 + "\u7edf\u8ba1\u503c\u8ba1\u7b97\u5f02\u5e38", (Throwable)exception);
            }
            finally {
                if (object == null) continue;
                object.closeRaster();
            }
        }
        if (linkedHashMap.size() > 0) {
            Object object2;
            Object object3 = this.bx.bN.f(this);
            object2 = XmlUtil.readDocumentFromStr((String)object3);
            object = XmlUtil.findfirstNode((Node)object2, (String)"//StaticsticInfo");
            rasterStatisticInfoArray = object.getParentNode();
            rasterStatisticInfoArray.removeChild((Node)object);
            object = XmlUtil.appendElement((Element)((Element)rasterStatisticInfoArray), (String)"StaticsticInfo", null);
            ArrayList arrayList = new ArrayList();
            for (Integer n2 : linkedHashMap.keySet()) {
                Object object4;
                List list3 = (List)linkedHashMap.get(n2);
                double d2 = Double.MAX_VALUE;
                double d3 = Double.MIN_VALUE;
                double d4 = 0.0;
                double d5 = 0.0;
                for (RasterStatisticInfo rasterStatisticInfo : list3) {
                    d2 = Math.min(d2, rasterStatisticInfo.getMinValue());
                    d3 = Math.max(d3, rasterStatisticInfo.getMaxValue());
                    d4 += rasterStatisticInfo.getMeanValue();
                    d5 += rasterStatisticInfo.getStdValue();
                }
                if (n2 == 1) {
                    object4 = XmlUtil.appendElement((Element)((Element)object), (String)"Band", null);
                    object4.setAttribute("NO", "0");
                    XmlUtil.appendElement((Element)object4, (String)"MaxValue", (Object)d3);
                    XmlUtil.appendElement((Element)object4, (String)"MinValue", (Object)d2);
                    XmlUtil.appendElement((Element)object4, (String)"Mean", (Object)(d4 / (double)list3.size()));
                    XmlUtil.appendElement((Element)object4, (String)"Deviation", (Object)(d5 / (double)list3.size()));
                }
                object4 = XmlUtil.appendElement((Element)((Element)object), (String)"Band", null);
                object4.setAttribute("NO", String.valueOf(n2));
                XmlUtil.appendElement((Element)object4, (String)"MaxValue", (Object)d3);
                XmlUtil.appendElement((Element)object4, (String)"MinValue", (Object)d2);
                XmlUtil.appendElement((Element)object4, (String)"Mean", (Object)(d4 / (double)list3.size()));
                XmlUtil.appendElement((Element)object4, (String)"Deviation", (Object)(d5 / (double)list3.size()));
            }
            object3 = XmlUtil.toXmlString((Document)object2);
            boolean bl2 = this.bx.bN.c(this, (String)object3);
            if (bl2) {
                this.bE.setStatisticInfos(linkedHashMap.values().toArray(new RasterStatisticInfo[0]));
            }
            return bl2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRaster(String string, boolean bl) {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException(file + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        RasterFileWorkspace rasterFileWorkspace = new RasterFileWorkspace(file.getParent());
        IRasterDataset iRasterDataset = rasterFileWorkspace.openRasterDataset(string);
        if (iRasterDataset == null) {
            throw new RuntimeException(string + " \u6253\u5f00\u5931\u8d25");
        }
        try {
            boolean bl2 = this.addRaster(iRasterDataset, bl);
            return bl2;
        }
        finally {
            iRasterDataset.closeRaster();
        }
    }

    @Override
    public boolean addRaster(IRasterDataset iRasterDataset, boolean bl) {
        return this.addRaster(iRasterDataset, null, bl) > -1;
    }

    @Override
    public int addRaster(IRasterDataset iRasterDataset, IGeometry iGeometry, Boolean bl) {
        return this.addRaster(iRasterDataset, iGeometry, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addRaster(IRasterDataset iRasterDataset, IGeometry iGeometry, Map<String, Object> map, Boolean bl) {
        IFeatureCursor iFeatureCursor = null;
        IFeatureCursor iFeatureCursor2 = null;
        try {
            Object object;
            double d3;
            if (iRasterDataset == null) {
                boolean bl2;
                iFeatureCursor2 = this.bC.insertFeature();
                IFeature iFeature = this.bC.createFeature();
                if (iGeometry != null) {
                    iFeature.setGeometry(iGeometry);
                }
                iFeature.setValue("category", (Object)1);
                iFeature.setValue("tag", (Object)"RasterDataset");
                iFeature.setValue("datasize", (Object)0L);
                if (map != null && map.size() > 0) {
                    for (String string : map.keySet()) {
                        iFeature.setValue(string, map.get(string));
                    }
                }
                if (bl2 = iFeatureCursor2.insertFeature(iFeature)) {
                    int n2 = Integer.parseInt(iFeature.getObjectId().toString());
                    return n2;
                }
                int n3 = -1;
                return n3;
            }
            String string = iRasterDataset.getRasterInfo().getRasterPath();
            RasterInfo rasterInfo = iRasterDataset.getRasterInfo();
            IEnvelope iEnvelope = rasterInfo.getExtent();
            String string2 = String.format("[%s]\u6570\u636e\u8be6\u60c5\uff1a\r\n\u7a7a\u95f4\u53c2\u8003\uff1a%s\r\n\u8303\u56f4\uff1a%s\r\n\u50cf\u7d20\u7c7b\u578b\uff1a%s\r\n\u6ce2\u6bb5\u6570\uff1a%s\r\n\u65e0\u6548\u503c\uff1a%s", string, rasterInfo.getSpatialReferenceSystem() == null ? "null" : rasterInfo.getSpatialReferenceSystem().getWkt(), iEnvelope == null ? "null" : iEnvelope.getXMin() + "," + iEnvelope.getYMin() + "," + iEnvelope.getXMax() + "," + iEnvelope.getYMax(), rasterInfo.getPixelDataType().toString(), rasterInfo.getBandCount(), rasterInfo.getInvalidValue() == null ? "null" : Arrays.stream(rasterInfo.getInvalidValue()).map(d2 -> d2 == null ? "null" : d2.toString()).collect(Collectors.joining(",")));
            this.log.info(string2);
            if (rasterInfo.getExtent() == null) {
                throw new RuntimeException(string + " \u8303\u56f4\u4e3a\u7a7a");
            }
            double d4 = d3 = rasterInfo.getXResolution().doubleValue();
            if (rasterInfo.getHasPyramid().booleanValue()) {
                d4 = d3 * (double)rasterInfo.getWidth().intValue() / (double)((Size)rasterInfo.getPyramidSizes().get((int)(rasterInfo.getPyramidLevel().intValue() - 1))).width;
            }
            double d5 = d4 * 50.0;
            double d6 = iEnvelope.getXMin();
            double d7 = iEnvelope.getYMin();
            double d8 = iEnvelope.getXMax();
            double d9 = iEnvelope.getYMax();
            double[] dArray = iRasterDataset.getRaster().GetGeoTransform();
            int n4 = iRasterDataset.getRaster().GetRasterXSize();
            int n5 = iRasterDataset.getRaster().GetRasterYSize();
            double[] dArray2 = ak.a(dArray, 0, 0);
            double[] dArray3 = ak.a(dArray, n4, 0);
            double[] dArray4 = ak.a(dArray, n4, n5);
            double[] dArray5 = ak.a(dArray, 0, n5);
            Geometry geometry = new Geometry(3);
            Geometry geometry2 = new Geometry(101);
            geometry2.AddPoint_2D(dArray2[0], dArray2[1]);
            geometry2.AddPoint_2D(dArray3[0], dArray3[1]);
            geometry2.AddPoint_2D(dArray4[0], dArray4[1]);
            geometry2.AddPoint_2D(dArray5[0], dArray5[1]);
            geometry2.AddPoint_2D(dArray2[0], dArray2[1]);
            geometry.AddGeometry(geometry2);
            IGeometry iGeometry2 = GeometryFunc.createGeometryByObject((Object)geometry);
            if (this.bC.getSpatialReferenceSystem() != null && rasterInfo.getSpatialReferenceSystem() != null && !this.bC.getSpatialReferenceSystem().equals(rasterInfo.getSpatialReferenceSystem())) {
                if ((iGeometry2 = iGeometry2.projectToCopy(rasterInfo.getSpatialReferenceSystem(), this.bC.getSpatialReferenceSystem())) == null || iGeometry2.isEmpty()) {
                    throw new RuntimeException(string + " \u6295\u5f71\u540e\u8303\u56f4\u4e3a\u7a7a");
                }
                object = iGeometry2.getEnvelope();
                d6 = object.getXMin();
                d7 = object.getYMin();
                d8 = object.getXMax();
                d9 = object.getYMax();
                this.log.info("\u6295\u5f71\u540e\u8303\u56f4\uff1a" + d6 + "," + d7 + "," + d8 + "," + d9);
                if (this.bC.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Projected && rasterInfo.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Geographic) {
                    d3 = 111319.49079327358 * d3;
                    d4 = 111319.49079327358 * d4;
                    d5 = 111319.49079327358 * d5;
                } else if (rasterInfo.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Projected && this.bC.getSpatialReferenceSystem().getType() == SpatialReferenceSystemType.Geographic) {
                    d3 = 8.983152841195214E-6 * d3;
                    d4 = 8.983152841195214E-6 * d4;
                    d5 = 8.983152841195214E-6 * d5;
                }
            }
            if (bl != null) {
                object = new QueryFilter();
                object.setWhereClause(String.format("urihash='%s'", string));
                try {
                    iFeatureCursor = this.bC.searchFeature((IQueryFilter)object);
                    IFeature iFeature = iFeatureCursor.nextFeature();
                    if (bl.booleanValue()) {
                        if (iFeature != null) {
                            this.bC.deleteFeature(iFeature.getObjectId());
                        }
                    } else if (iFeature != null) {
                        throw new RuntimeException(string + " \u5df2\u5b58\u5728");
                    }
                }
                finally {
                    if (iFeatureCursor != null) {
                        iFeatureCursor.release();
                    }
                    iFeatureCursor = null;
                }
            }
            iFeatureCursor2 = this.bC.insertFeature();
            object = this.bC.createFeature();
            if (iGeometry != null) {
                object.setGeometry(iGeometry);
            } else {
                object.setGeometry(iGeometry2);
            }
            object.setValue("raster", (Object)this.b(rasterInfo));
            object.setValue("name", (Object)iRasterDataset.getName());
            object.setValue("minps", (Object)0);
            object.setValue("maxps", (Object)d5);
            object.setValue("lowps", (Object)d3);
            object.setValue("highps", (Object)d4);
            object.setValue("category", (Object)1);
            object.setValue("tag", (Object)"RasterDataset");
            object.setValue("centerx", (Object)((d6 + d8) / 2.0));
            object.setValue("centery", (Object)((d7 + d9) / 2.0));
            object.setValue("urihash", (Object)string);
            if (object.getFields().contains("datasize")) {
                object.setValue("datasize", (Object)this.a(iRasterDataset));
            }
            if (map != null && map.size() > 0) {
                for (String string3 : map.keySet()) {
                    object.setValue(string3, map.get(string3));
                }
            }
            boolean bl3 = iFeatureCursor2.insertFeature((IFeature)object);
            iFeatureCursor2.release();
            iFeatureCursor2 = null;
            if (this.bE.getBandCount() < 1 || this.bE.getPixelDataType() == PixelDataType.Unknown) {
                try {
                    String string3;
                    string3 = this.bx.bN.f(this);
                    Document document = XmlUtil.readDocumentFromStr((String)string3);
                    if (this.bE.getBandCount() < 1) {
                        this.bE.setBandCount(rasterInfo.getBandCount());
                        XmlUtil.findfirstNode((Node)document, (String)"//BandCount").setTextContent(String.valueOf(rasterInfo.getBandCount()));
                    }
                    if (this.bE.getPixelDataType() == PixelDataType.Unknown) {
                        this.bE.setPixelDataType(rasterInfo.getPixelDataType());
                        XmlUtil.findfirstNode((Node)document, (String)"//PixelType").setTextContent(String.valueOf(rasterInfo.getPixelDataType().getValue()));
                    }
                    string3 = XmlUtil.toXmlString((Document)document);
                    boolean bl4 = this.bx.bN.c(this, string3);
                }
                catch (Exception exception) {
                    this.log.error("\u66f4\u65b0\u9576\u5d4c\u6570\u636e\u96c6\u5143\u6570\u636e\u4fe1\u606f\u5f02\u5e38", (Throwable)exception);
                }
            }
            if (bl3) {
                int n6 = Integer.parseInt(object.getObjectId().toString());
                return n6;
            }
            int n7 = -1;
            return n7;
        }
        finally {
            if (iFeatureCursor != null) {
                iFeatureCursor.release();
            }
            if (iFeatureCursor2 != null) {
                iFeatureCursor2.release();
            }
        }
    }

    private static double[] a(double[] dArray, int n2, int n3) {
        double[] dArray2 = new double[]{dArray[0] + (double)n2 * dArray[1] + (double)n3 * dArray[2], dArray[3] + (double)n2 * dArray[4] + (double)n3 * dArray[5]};
        return dArray2;
    }

    private String b(RasterInfo rasterInfo) {
        try {
            Document document = XmlUtil.createDocument();
            Element element = document.createElement("RasterInfo");
            document.appendChild(element);
            XmlUtil.appendElement((Element)element, (String)"DataPath", (Object)rasterInfo.getRasterPath());
            XmlUtil.appendElement((Element)element, (String)"Format", (Object)"");
            XmlUtil.appendElement((Element)element, (String)"Width", (Object)String.valueOf(rasterInfo.getWidth()));
            XmlUtil.appendElement((Element)element, (String)"Height", (Object)String.valueOf(rasterInfo.getHeight()));
            XmlUtil.appendElement((Element)element, (String)"BandCount", (Object)String.valueOf(rasterInfo.getBandCount()));
            XmlUtil.appendElement((Element)element, (String)"PyramidLevel", (Object)String.valueOf(rasterInfo.getPyramidLevel()));
            XmlUtil.appendElement((Element)element, (String)"HasNodata", (Object)String.valueOf(rasterInfo.getHasPyramid() != false ? 1 : 0));
            XmlUtil.appendElement((Element)element, (String)"NodataValue", (Object)String.valueOf(rasterInfo.getInvalidValue()[0]));
            XmlUtil.appendElement((Element)element, (String)"PixelType", (Object)String.valueOf(rasterInfo.getPixelDataType().getValue()));
            XmlUtil.appendElement((Element)element, (String)"CellSize", (Object)String.valueOf(rasterInfo.getXResolution()));
            XmlUtil.appendElement((Element)element, (String)"CellSizeY", (Object)String.valueOf(rasterInfo.getYResolution()));
            XmlUtil.appendElement((Element)element, (String)"Envelope", (Object)String.format("%f,%f,%f,%f", rasterInfo.getExtent().getXMin(), rasterInfo.getExtent().getYMax(), rasterInfo.getExtent().getXMax(), rasterInfo.getExtent().getYMin()));
            XmlUtil.appendElement((Element)element, (String)"SpatialReference", (Object)(rasterInfo.getSpatialReferenceSystem() == null ? "" : rasterInfo.getSpatialReferenceSystem().getWkt()));
            String string = XmlUtil.toXmlString((Document)document);
            return string;
        }
        catch (Exception exception) {
            this.log.error("\u751f\u6210raster xml\u5931\u8d25", (Throwable)exception);
            return null;
        }
    }

    public void closeRaster() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long a(IRasterDataset iRasterDataset) {
        try (MinIOFileStorage minIOFileStorage = null;){
            Object object;
            String string;
            int n2;
            Object object2;
            if (iRasterDataset.getRasterInfo().getStorageInfo() != null) {
                RasterStorageInfo rasterStorageInfo = iRasterDataset.getRasterInfo().getStorageInfo();
                String string2 = rasterStorageInfo.getType();
                object2 = string2;
                n2 = -1;
                switch (((String)object2).hashCode()) {
                    case 74347224: {
                        if (!((String)object2).equals("MinIO")) break;
                        n2 = 0;
                        break;
                    }
                    case 78048: {
                        if (!((String)object2).equals("OBS")) break;
                        n2 = 1;
                        break;
                    }
                    case 78575: {
                        if (!((String)object2).equals("OSS")) break;
                        n2 = 2;
                    }
                }
                switch (n2) {
                    case 0: {
                        string = new RefObject();
                        object = this.a(rasterStorageInfo.getUrl(), (RefObject<String>)string);
                        minIOFileStorage = new MinIOFileStorage((String)object, (String)string.get(), rasterStorageInfo.getUserName(), rasterStorageInfo.getPassword());
                        minIOFileStorage.connect();
                        break;
                    }
                    case 1: {
                        string = new RefObject();
                        object = this.a(rasterStorageInfo.getUrl(), (RefObject<String>)string);
                        minIOFileStorage = new OBSFileStorage((String)object, (String)string.get(), rasterStorageInfo.getUserName(), rasterStorageInfo.getPassword());
                        minIOFileStorage.connect();
                        break;
                    }
                    case 2: {
                        string = new RefObject();
                        object = this.a(rasterStorageInfo.getUrl(), (RefObject<String>)string);
                        minIOFileStorage = new OSSFileStorage((String)object, (String)string.get(), rasterStorageInfo.getUserName(), rasterStorageInfo.getPassword());
                        minIOFileStorage.connect();
                        break;
                    }
                    default: {
                        string = new RefObject();
                        object = this.a(rasterStorageInfo.getUrl(), (RefObject<String>)string);
                        minIOFileStorage = new AmazonS3FileStorage((String)object, (String)string.get(), rasterStorageInfo.getUserName(), rasterStorageInfo.getPassword());
                        minIOFileStorage.connect();
                    }
                }
            }
            long l2 = 0L;
            object2 = iRasterDataset.getRaster().GetFileList();
            for (n2 = 0; n2 < ((Vector)object2).size(); ++n2) {
                string = ((Vector)object2).get(n2).toString();
                if (minIOFileStorage != null) {
                    if (string.startsWith("/vsis3")) {
                        object = (IObjectStorage)minIOFileStorage;
                        string = object.getEndPoint() + string.substring("/vsis3".length());
                    }
                    if ((object = minIOFileStorage.getFile(string)) == null) continue;
                    l2 += object.getSize();
                    continue;
                }
                object = new File(string);
                if (!((File)object).exists()) continue;
                l2 += ((File)object).length();
            }
            Long l3 = l2;
            return l3;
        }
    }

    String a(String string, RefObject<String> refObject) {
        int n2 = string.lastIndexOf("/");
        if (n2 > 0) {
            String string2 = string.substring(0, n2);
            refObject.set((Object)string.substring(n2 + 1));
            return string2;
        }
        throw new IllegalArgumentException("\u5730\u5740\u4e0d\u6b63\u786e\uff1a" + string);
    }

    double a(Double[] doubleArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            d2 += doubleArray[i2].doubleValue();
        }
        return d2;
    }

    double b(Double[] doubleArray) {
        double d2 = 0.0;
        d2 = this.a(doubleArray) / (double)doubleArray.length;
        return d2;
    }

    double c(Double[] doubleArray) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < doubleArray.length; ++i2) {
            d2 += Math.pow(doubleArray[i2] - this.b(doubleArray), 2.0);
        }
        return d2 /= (double)doubleArray.length;
    }

    double d(Double[] doubleArray) {
        double d2 = Math.sqrt(this.c(doubleArray));
        return d2;
    }
}

