/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb;

import com.alibaba.druid.pool.DataSourceNotAvailableException;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.ITable;
import com.geoway.adf.gis.geodb.IWorkspaceFactory;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.filter.IQueryFilter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcWorkspace
implements IFeatureWorkspace {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static Map<String, DruidDataSource> b = new ConcurrentHashMap<String, DruidDataSource>();
    protected int poolMaxActive = 200;
    protected int poolMaxWait = 30000;
    protected int poolInitialSize = 2;
    protected int poolMinIdle = 4;
    protected boolean poolTestOnBorrow = true;
    public String poolValidationQuery = "select 'x'";
    protected IWorkspaceFactory workspaceFactory;
    protected String userName;
    protected String password;
    protected String url;
    protected Map options;
    protected Connection connection;
    protected boolean inTransaction = false;
    protected int queryTimeout = 0;
    public int queryFetchSize = 1000;

    public JdbcWorkspace(IWorkspaceFactory iWorkspaceFactory, String string, String string2, String string3, Map map) {
        this.workspaceFactory = iWorkspaceFactory;
        this.userName = string2;
        this.password = string3;
        this.url = string;
        this.options = map;
    }

    public JdbcWorkspace(IWorkspaceFactory iWorkspaceFactory, Connection connection, String string, String string2, Map map) {
        this.workspaceFactory = iWorkspaceFactory;
        this.userName = string2;
        this.password = null;
        this.url = string;
        this.options = map;
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected Connection createConnection() {
        String string;
        DruidDataSource druidDataSource;
        String string2 = this.getConnectionString();
        if (b.containsKey(string2)) {
            druidDataSource = b.get(string2);
        } else {
            string = this.getJdbcUrl();
            druidDataSource = this.a(string2, this.getDriverClassName(), string, this.userName, this.password);
        }
        string = null;
        DruidPooledConnection druidPooledConnection = null;
        try {
            druidPooledConnection = druidDataSource.getConnection();
        }
        catch (DataSourceNotAvailableException dataSourceNotAvailableException) {
            b.remove(string2);
            try {
                druidDataSource.close();
            }
            catch (Exception exception) {
                this.log.error(this.getJdbcUrl() + "\u6570\u636e\u6e90\u5173\u95ed\u5f02\u5e38", (Throwable)exception);
            }
            druidDataSource = null;
            throw dataSourceNotAvailableException;
        }
        string = druidPooledConnection;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DruidDataSource a(String string, String string2, String string3, String string4, String string5) {
        Class<JdbcWorkspace> clazz = JdbcWorkspace.class;
        synchronized (JdbcWorkspace.class) {
            DruidDataSource druidDataSource;
            if (b.containsKey(string)) {
                druidDataSource = b.get(string);
            } else {
                System.out.println("\u521d\u59cb\u5316\u8fde\u63a5" + string3);
                druidDataSource = new DruidDataSource();
                druidDataSource.setDriverClassName(string2);
                druidDataSource.setUrl(string3);
                druidDataSource.setUsername(string4);
                druidDataSource.setPassword(string5);
                druidDataSource.setAsyncInit(true);
                druidDataSource.setInitialSize(this.poolInitialSize);
                druidDataSource.setMinIdle(this.poolMinIdle);
                druidDataSource.setMaxActive(this.poolMaxActive);
                druidDataSource.setPoolPreparedStatements(true);
                druidDataSource.setMaxOpenPreparedStatements(100);
                druidDataSource.setMaxWait((long)this.poolMaxWait);
                druidDataSource.setKeepAlive(true);
                druidDataSource.setValidationQuery(this.poolValidationQuery);
                druidDataSource.setTimeBetweenEvictionRunsMillis(90000L);
                druidDataSource.setTestOnReturn(false);
                druidDataSource.setTestOnBorrow(this.poolTestOnBorrow);
                druidDataSource.setTestWhileIdle(true);
                druidDataSource.setFailFast(true);
                druidDataSource.setBreakAfterAcquireFailure(true);
                druidDataSource.setNotFullTimeoutRetryCount(-1);
                druidDataSource.setConnectionErrorRetryAttempts(0);
                druidDataSource.setFilters("stat");
                b.put(string, druidDataSource);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return druidDataSource;
        }
    }

    public abstract String getDriverClassName();

    public abstract String getJdbcUrl();

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    protected String getConnectOptionsStr() {
        if (this.options != null && this.options.size() > 0) {
            ArrayList arrayList = new ArrayList();
            this.options.keySet().forEach(object -> arrayList.add(object + "=" + this.options.get(object)));
            return String.join((CharSequence)"&", arrayList);
        }
        return "";
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n2) {
        this.queryTimeout = n2;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setQueryFetchSize(int n2) {
        this.queryFetchSize = n2;
    }

    void setPoolMaxActive(Integer n2) {
        if (n2 != null) {
            this.poolMaxActive = n2;
        }
    }

    void setPoolInitialSize(Integer n2) {
        if (n2 != null) {
            this.poolInitialSize = n2;
        }
    }

    void setPoolMinIdle(Integer n2) {
        if (n2 != null) {
            this.poolMinIdle = n2;
        }
    }

    void setPoolMaxWait(Integer n2) {
        if (n2 != null) {
            this.poolMaxWait = n2;
        }
    }

    void setPoolTestOnBorrow(Boolean bl) {
        if (bl != null) {
            this.poolTestOnBorrow = bl;
        }
    }

    @Override
    public String getConnectionString() {
        String string = String.format("%s://%s:%s@%s", this.workspaceFactory.getName(), this.userName, this.password, this.url);
        if (this.options != null && this.options.size() > 0) {
            string = string.contains("?") ? string + "&" : string + "?";
            string = string + this.getConnectOptionsStr();
        }
        return string;
    }

    @Override
    public IWorkspaceFactory getWorkspaceFactory() {
        return this.workspaceFactory;
    }

    @Override
    public boolean getOpened() {
        if (this.connection == null) {
            return false;
        }
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException sQLException) {
            this.log.error("\u67e5\u770b\u6570\u636e\u5e93\u8fde\u63a5\u5f02\u5e38", (Throwable)sQLException);
            return false;
        }
    }

    @Override
    public boolean open() {
        boolean bl;
        block6: {
            bl = false;
            if (this.connection != null) {
                try {
                    if (!this.connection.isClosed()) {
                        bl = true;
                        break block6;
                    }
                    this.connection = this.createConnection();
                    bl = this.connection != null;
                }
                catch (SQLException sQLException) {
                    this.log.error("\u6570\u636e\u5e93\u91cd\u65b0\u8fde\u63a5\u5f02\u5e38", (Throwable)sQLException);
                    this.connection = this.createConnection();
                    bl = this.connection != null;
                }
            } else {
                this.connection = this.createConnection();
                boolean bl2 = bl = this.connection != null;
            }
        }
        if (bl) {
            this.afterConnected();
        }
        return bl;
    }

    protected void afterConnected() {
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            this.connection = null;
        }
    }

    @Override
    public IFeatureWorkspace clone() {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean getInTransaction() {
        try {
            if (this.connection != null) {
                return this.inTransaction && !this.connection.getAutoCommit();
            }
        }
        catch (SQLException sQLException) {
            this.log.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return false;
    }

    @Override
    public void beginTransaction() {
        if (this.connection != null) {
            if (this.getInTransaction()) {
                throw new RuntimeException("\u4e0d\u80fd\u5d4c\u5957\u4e8b\u52a1\uff01");
            }
            this.connection.setAutoCommit(false);
            this.inTransaction = true;
        }
    }

    @Override
    public void commitTransaction() {
        if (this.connection == null) {
            throw new RuntimeException("\u4e8b\u52a1\u672a\u5f00\u542f");
        }
        this.connection.commit();
        this.connection.setAutoCommit(true);
        this.inTransaction = false;
    }

    @Override
    public void rollbackTransaction() {
        if (!this.getInTransaction()) {
            throw new RuntimeException("\u4e8b\u52a1\u672a\u5f00\u542f");
        }
        this.connection.rollback();
        this.connection.setAutoCommit(true);
        this.inTransaction = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int excuteSql(String string) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(string);
            int n2 = preparedStatement.executeUpdate();
            return n2;
        }
        catch (SQLException sQLException) {
            this.log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", string));
            throw sQLException;
        }
        finally {
            this.closeObject(preparedStatement);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int excuteSql(String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        try {
            int n2;
            preparedStatement = this.connection.prepareStatement(string);
            if (objectArray != null) {
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    if (objectArray[n2] == null) {
                        preparedStatement.setNull(n2 + 1, 0);
                        continue;
                    }
                    preparedStatement.setObject(n2 + 1, objectArray[n2]);
                }
            }
            n2 = preparedStatement.executeUpdate();
            return n2;
        }
        catch (SQLException sQLException) {
            this.log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", string));
            throw sQLException;
        }
        finally {
            this.closeObject(preparedStatement);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object queryScalar(String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.a(string, objectArray);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Object object = resultSet.getObject(1);
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                return object;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", string));
                throw sQLException;
            }
            catch (Throwable throwable) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                throw throwable;
            }
        }
        {
            Object var5_7 = null;
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            return var5_7;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> queryOne(String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.a(string, objectArray);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                int i2 = 1;
                while (true) {
                    if (i2 > n2) {
                        HashMap<String, Object> hashMap2 = hashMap;
                        this.closeObject(resultSet);
                        this.closeObject(preparedStatement);
                        return hashMap2;
                    }
                    hashMap.put(resultSetMetaData.getColumnName(i2), resultSet.getObject(i2));
                    ++i2;
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", string));
                throw sQLException;
            }
            catch (Throwable throwable) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                throw throwable;
            }
        }
        {
            Map<String, Object> map = null;
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            return map;
        }
    }

    @Override
    public List<Map<String, Object>> queryList(String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<Map<String, Object>> arrayList;
            ArrayList<ArrayList<Map<String, Object>>> arrayList2 = new ArrayList<ArrayList<Map<String, Object>>>();
            preparedStatement = this.a(string, objectArray);
            resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                arrayList = new HashMap();
                for (int i2 = 1; i2 <= n2; ++i2) {
                    arrayList.put(resultSetMetaData.getColumnName(i2), resultSet.getObject(i2));
                }
                arrayList2.add(arrayList);
            }
            arrayList = arrayList2;
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            return arrayList;
        }
        catch (SQLException sQLException) {
            try {
                this.log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", string));
                throw sQLException;
            }
            catch (Throwable throwable) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dataExist(String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.a(string, objectArray);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = true;
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                return bl;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.log.error(String.format("\u6267\u884csql\u5f02\u5e38\uff1a%s", string));
                throw sQLException;
            }
            catch (Throwable throwable) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                throw throwable;
            }
        }
        {
            boolean bl = false;
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getServerDate() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block5: {
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.a("SELECT CURRENT_TIMESTAMP", new Object[0]);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            Timestamp timestamp = resultSet.getTimestamp(1);
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            return timestamp;
        }
        try {
            Timestamp timestamp = null;
            this.closeObject(resultSet);
            this.closeObject(preparedStatement);
            return timestamp;
        }
        catch (SQLException sQLException) {
            try {
                this.log.error("\u67e5\u8be2\u6570\u636e\u5e93\u65f6\u95f4\u5f02\u5e38", (Throwable)sQLException);
                Timestamp timestamp = null;
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                return timestamp;
            }
            catch (Throwable throwable) {
                this.closeObject(resultSet);
                this.closeObject(preparedStatement);
                throw throwable;
            }
        }
    }

    private PreparedStatement a(String string, Object ... objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement(string, 1003, 1007);
        if (this.queryTimeout > 0) {
            preparedStatement.setQueryTimeout(this.queryTimeout);
        }
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null) {
                    preparedStatement.setNull(i2 + 1, 0);
                    continue;
                }
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
            }
        }
        return preparedStatement;
    }

    public void closeObject(AutoCloseable autoCloseable) {
        try {
            if (autoCloseable != null) {
                autoCloseable.close();
            }
        }
        catch (Exception exception) {
            this.log.error(exception.getMessage(), (Throwable)exception);
        }
    }

    public FieldType convertFieldType(int n2) {
        FieldType fieldType;
        switch (n2) {
            case -7: 
            case 16: {
                fieldType = FieldType.Boolean;
                break;
            }
            case -6: {
                fieldType = FieldType.Byte;
                break;
            }
            case 5: {
                fieldType = FieldType.Short;
                break;
            }
            case 4: {
                fieldType = FieldType.Int;
                break;
            }
            case -5: {
                fieldType = FieldType.Long;
                break;
            }
            case 7: {
                fieldType = FieldType.Float;
                break;
            }
            case 6: 
            case 8: {
                fieldType = FieldType.Double;
                break;
            }
            case 2: 
            case 3: {
                fieldType = FieldType.Decimal;
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                fieldType = FieldType.DateTime;
                break;
            }
            case 2004: {
                fieldType = FieldType.Blob;
                break;
            }
            case 2005: {
                fieldType = FieldType.Text;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                fieldType = FieldType.String;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                fieldType = FieldType.Blob;
                break;
            }
            default: {
                fieldType = FieldType.Unknown;
            }
        }
        return fieldType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] blobToBytes(Blob blob) throws SQLException, IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
            byte[] byArray = new byte[(int)blob.length()];
            int n2 = byArray.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2 && (n3 = bufferedInputStream.read(byArray, i2, n2 - i2)) >= 0; i2 += n3) {
            }
            byte[] byArray2 = byArray;
            this.closeObject(bufferedInputStream);
            return byArray2;
        }
        catch (Throwable throwable) {
            this.closeObject(bufferedInputStream);
            throw throwable;
        }
    }

    public abstract String getWhereClause(ITable var1, IQueryFilter var2);
}

