/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.geodb.ogr;

import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.IWorkspaceFactory;
import com.geoway.adf.gis.geodb.a.r;
import com.geoway.adf.gis.geodb.a.t;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.gdal.ogr.Driver;
import org.gdal.ogr.ogr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrWorkspaceFactory
implements IWorkspaceFactory {
    private static final Logger log = LoggerFactory.getLogger(OgrWorkspaceFactory.class);
    public static final String DRIVER_SHPFILE = "ESRI Shapefile";
    public static final String DRIVER_FileGDB_ESRI = "FileGDB";
    public static final String DRIVER_FileGDB = "OpenFileGDB";
    public static final String DRIVER_MDB = "PGeo";
    public static final String DRIVER_GEOPACKAGE = "GPKG";
    public static final String DRIVER_POSTGRESQL = "PostgreSQL";
    public static final String DRIVER_GeoJSON = "GeoJSON";
    public static final String DRIVER_GML = "GML";
    public static final String DRIVER_KML = "KML";
    public static final String DRIVER_XLSX = "XLSX";
    public static final String DRIVER_CSV = "CSV";
    public static final String DRIVER_MapInfo = "MapInfo File";
    private String bc;

    public String getDriverName() {
        return this.bc;
    }

    @Override
    public String getName() {
        return "ogr";
    }

    public OgrWorkspaceFactory() {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
    }

    @Override
    public IFeatureWorkspace openWorkspace(String string, String string2, String string3, Map map) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("\u8fde\u63a5\u53c2\u6570\u9519\u8bef\uff01");
        }
        t t2 = string.endsWith(".000") ? new r((IWorkspaceFactory)this, string, map) : new t((IWorkspaceFactory)this, string, map);
        if (t2.open()) {
            this.bc = t2.bc;
            return t2;
        }
        return null;
    }

    @Override
    public IFeatureWorkspace createWorkspace(String string, String string2, String string3, Map map) {
        Object object2;
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("\u8fde\u63a5\u53c2\u6570\u9519\u8bef:" + string);
        }
        Vector<String> vector = new Vector<String>();
        String string4 = null;
        String string5 = "UTF-8";
        if (map != null) {
            for (Object object2 : map.keySet()) {
                if (object2.equals("DRIVER")) {
                    string4 = map.get(object2).toString();
                    continue;
                }
                if (object2.equals("ENCODING")) {
                    string5 = map.get(object2).toString();
                    continue;
                }
                vector.add(object2 + "=" + map.get(object2).toString());
            }
        }
        vector.add("ENCODING=" + string5);
        if (string4 == null) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6edriver");
        }
        Driver driver = ogr.GetDriverByName(string4);
        if (driver == null) {
            throw new RuntimeException(string4 + " \u9a71\u52a8\u4e0d\u53ef\u7528\uff01");
        }
        if (!driver.TestCapability("CreateDataSource")) {
            throw new RuntimeException(string4 + " \u9a71\u52a8\u4e0d\u652f\u6301\u521b\u5efa\u6570\u636e\u6e90\uff01");
        }
        object2 = driver.CreateDataSource(string, vector);
        if (object2 == null) {
            throw new RuntimeException(string + " \u521b\u5efa\u5931\u8d25\uff01");
        }
        this.bc = string4;
        t t2 = new t((IWorkspaceFactory)this, string4, string);
        t2.be = object2;
        return t2;
    }

    public IFeatureWorkspace openLocalFileWorkspace(String string) {
        IFeatureWorkspace iFeatureWorkspace = this.openWorkspace(string, null, null, null);
        return iFeatureWorkspace;
    }

    public IFeatureWorkspace createLocalWorkspace(String string) {
        String string2;
        File file = new File(string);
        if (file.exists()) {
            throw new RuntimeException(string + "\u5df2\u5b58\u5728");
        }
        String string3 = "";
        int n2 = file.getName().lastIndexOf(".");
        if (n2 >= 0) {
            string3 = file.getName().substring(n2).toLowerCase();
        }
        switch (string3) {
            case "": 
            case ".shp": 
            case ".dbf": {
                string2 = DRIVER_SHPFILE;
                break;
            }
            case ".gpkg": {
                string2 = DRIVER_GEOPACKAGE;
                break;
            }
            case ".gdb": {
                string2 = DRIVER_FileGDB;
                break;
            }
            case ".geojson": {
                string2 = DRIVER_GeoJSON;
                break;
            }
            case ".kml": {
                string2 = DRIVER_KML;
                break;
            }
            case ".gml": {
                string2 = DRIVER_GML;
                break;
            }
            case ".csv": {
                string2 = DRIVER_CSV;
                break;
            }
            case ".xlsx": {
                string2 = DRIVER_XLSX;
                break;
            }
            default: {
                throw new RuntimeException(string + "\u4e0d\u652f\u6301\u521b\u5efa\u6570\u636e\u6e90\uff01");
            }
        }
        Object object = new HashMap(){
            {
                this.put("DRIVER", string2);
            }
        };
        return this.createWorkspace(string, null, null, (Map)object);
    }

    public IFeatureWorkspace createShpfileWorkspace(String string) {
        HashMap hashMap = new HashMap(){
            {
                this.put("DRIVER", OgrWorkspaceFactory.DRIVER_SHPFILE);
            }
        };
        return this.createWorkspace(string, null, null, hashMap);
    }

    public IFeatureWorkspace createGeoPackageWorkspace(String string) {
        HashMap hashMap = new HashMap(){
            {
                this.put("DRIVER", OgrWorkspaceFactory.DRIVER_GEOPACKAGE);
            }
        };
        return this.createWorkspace(string, null, null, hashMap);
    }

    public IFeatureWorkspace createFileGDBWorkspace(String string) {
        HashMap hashMap = new HashMap(){
            {
                this.put("DRIVER", OgrWorkspaceFactory.DRIVER_FileGDB);
            }
        };
        return this.createWorkspace(string, null, null, hashMap);
    }
}

