/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.raster;

import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.basic.geometry.GeometryType;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.raster.RasterProgressCallback;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.ProgressCallback;
import org.gdal.gdal.WarpOptions;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Driver;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FeatureDefn;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;

public class RasterProcessFunc {
    public static boolean clipRasterFile(List<String> list, String string, IGeometry iGeometry, int n, Double d) {
        return RasterProcessFunc.clipRasterFile(list, string, iGeometry, n, -1.0, d);
    }

    public static boolean clipRasterFile(List<String> list, String string, IGeometry iGeometry, int n, double d, Double d2) {
        return RasterProcessFunc.clipRasterFile(list, string, iGeometry, n, d, d2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clipRasterFile(List<String> list, String string, IGeometry iGeometry, int n, double d, Double d2, RasterProgressCallback rasterProgressCallback) {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        try {
            Dataset dataset;
            for (String object2 : list) {
                dataset = gdal.Open((String)object2, (int)gdalconstConstants.GA_ReadOnly);
                if (dataset == null) {
                    throw new RuntimeException(object2 + " \u6805\u683c\u6570\u636e\u8bfb\u53d6\u5931\u8d25\uff01");
                }
                arrayList.add(dataset);
            }
            String string2 = Paths.get(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()).toString();
            RasterProcessFunc.a(string2, "temp", n, iGeometry);
            Vector<Object> vector = new Vector<Object>();
            vector.add("-cutline");
            vector.add(string2);
            vector.add("-cl");
            vector.add("temp");
            vector.add("-crop_to_cutline");
            vector.add("-t_srs");
            vector.add("EPSG:" + n);
            if (d2 != null) {
                vector.add("-dstnodata");
                vector.add(d2.toString());
            }
            vector.add("-r");
            vector.add("bilinear");
            if (d > 0.0) {
                vector.add("-tr");
                vector.add(d + "");
                vector.add(d + "");
            }
            dataset = new WarpOptions(vector);
            Dataset dataset2 = gdal.Warp((String)string, (Dataset[])arrayList.toArray(new Dataset[0]), (WarpOptions)dataset, (ProgressCallback)(rasterProgressCallback == null ? null : rasterProgressCallback.getCallback()));
            if (dataset2 != null) {
                dataset2.delete();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            for (Dataset dataset : arrayList) {
                dataset.delete();
            }
        }
    }

    private static void a(String string, String string2, int n, IGeometry iGeometry) {
        int n2;
        ogr.RegisterAll();
        String string3 = "ESRI Shapefile";
        Driver driver = ogr.GetDriverByName((String)string3);
        if (driver == null) {
            throw new RuntimeException(string3 + " \u9a71\u52a8\u4e0d\u53ef\u7528");
        }
        DataSource dataSource = driver.CreateDataSource(string, null);
        if (dataSource == null) {
            throw new RuntimeException("\u521b\u5efashp\u5931\u8d25\uff01");
        }
        SpatialReference spatialReference = new SpatialReference();
        if (spatialReference.ImportFromEPSG(n) != 0) {
            throw new RuntimeException(n + "\u7a7a\u95f4\u53c2\u8003\u521b\u5efa\u5931\u8d25\uff01");
        }
        if (iGeometry.getType() == GeometryType.Polygon) {
            n2 = 3;
        } else if (iGeometry.getType() == GeometryType.MultiPolygon) {
            n2 = 6;
        } else {
            throw new RuntimeException(iGeometry.getType() + "\u4e0d\u652f\u6301\u7684\u88c1\u5207\u51e0\u4f55\u7c7b\u578b\uff01");
        }
        Layer layer = dataSource.CreateLayer(string2, spatialReference, n2, null);
        if (layer == null) {
            System.out.println(gdal.GetLastErrorMsg());
            throw new RuntimeException("\u521b\u5efashp\u5931\u8d25\uff01");
        }
        FeatureDefn featureDefn = layer.GetLayerDefn();
        Feature feature = new Feature(featureDefn);
        Geometry geometry = Geometry.CreateFromWkt((String)iGeometry.toWkt());
        feature.SetGeometry(geometry);
        layer.CreateFeature(feature);
        dataSource.SyncToDisk();
        layer.delete();
        dataSource.delete();
    }
}

