/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.raster;

import com.geoway.adf.gis.basic.LicChecker;
import com.geoway.adf.gis.basic.gdalFunc;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.IRasterWorkspace;
import com.geoway.adf.gis.raster.a.a;
import com.geoway.adf.gis.raster.info.RasterInfo;
import com.geoway.atlas.license.authorize.LicenseCheck;
import java.io.File;
import java.util.Map;
import java.util.Vector;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconstConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterFileWorkspace
implements IRasterWorkspace {
    private static final Logger f = LoggerFactory.getLogger(RasterFileWorkspace.class);
    private String g;
    private Map h;

    public RasterFileWorkspace(String string) {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
        this.g = string;
    }

    public RasterFileWorkspace(String string, String string2, String string3, Map<String, String> map) {
        if (!gdalFunc.isAvailable()) {
            throw new UnsatisfiedLinkError("Native library load failed.");
        }
        this.g = string;
        this.h = map;
    }

    @Override
    public String getPath() {
        return this.g;
    }

    @Override
    public IRasterDataset openRasterDataset(String string) {
        Object object;
        Dataset dataset;
        Vector<String> vector = null;
        if (this.h != null) {
            vector = new Vector<String>();
            dataset = this.h.keySet().iterator();
            while (dataset.hasNext()) {
                object = dataset.next();
                vector.add(object + "=" + this.h.get(object));
            }
        }
        if ((dataset = gdal.OpenEx((String)string, (long)(gdalconstConstants.OF_RASTER | gdalconstConstants.OF_READONLY), null, vector)) != null) {
            object = new File(string);
            String string2 = ((File)object).getName();
            if (string2.equalsIgnoreCase("hdr.adf")) {
                string2 = ((File)object).getParentFile().getName();
            }
            return new a(this, string2, string, dataset);
        }
        return null;
    }

    @Override
    public IRasterDataset createRasterDataset(RasterInfo rasterInfo) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u521b\u5efa\u6805\u683c\u6570\u636e");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<LicenseCheck> clazz = LicenseCheck.class;
        synchronized (LicenseCheck.class) {
            LicenseCheck.isValid((int)LicChecker.EnumModule.modGIS.value);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

