/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.a;

import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.meta.LODInfo;
import com.geoway.adf.gis.tile.meta.TileSchema;
import com.geoway.adf.gis.tile.wmts.HttpUtil;
import com.geoway.adf.gis.tile.wmts.WMTSTileDataSource;
import com.geoway.adf.gis.tile.wmts.WMTSTileMeta;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class m
implements ITileDataset {
    private static final Logger a = LoggerFactory.getLogger(m.class);
    private String name;
    private TileType aY;
    private WMTSTileMeta bk;
    private WMTSTileDataSource bl;
    private String bj;

    public m(WMTSTileDataSource wMTSTileDataSource, WMTSTileMeta wMTSTileMeta) {
        this.bl = wMTSTileDataSource;
        this.bk = wMTSTileMeta;
        this.name = wMTSTileMeta.getName();
        this.aY = wMTSTileMeta.getTileType();
        String string = wMTSTileDataSource.getDefaultTileMatrixSet(wMTSTileMeta.getTileMatrixSets());
        this.bj = wMTSTileDataSource.getConnectionString();
        if (!this.bj.endsWith("?")) {
            this.bj = this.bj + "&";
        }
        this.bj = this.bj + String.format("service=WMTS&request=GetTile&layer=%s&style=%s&tilematrixSet=%s&format=%s", this.name, wMTSTileMeta.getStyle(), string, wMTSTileMeta.getDataFormat());
        this.bj = this.bj + "&tilematrix=%s&tilerow=%s&tilecol=%s";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAliasName() {
        return this.name;
    }

    @Override
    public TileType getType() {
        return this.aY;
    }

    @Override
    public ITileDataSource getDataSource() {
        return this.bl;
    }

    @Override
    public TileMeta getTileMeta() {
        return this.bk;
    }

    @Override
    public boolean updateTileMeta(TileMeta tileMeta) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u66f4\u65b0\u5143\u6570\u636e");
    }

    @Override
    public List<Integer> getAllLevels() {
        String string = this.bl.getDefaultTileMatrixSet(this.bk.getTileMatrixSets());
        TileSchema tileSchema = this.bk.getTileMatrixSets().get(string);
        return tileSchema.getLodInfos().stream().map(LODInfo::getLevelID).collect(Collectors.toList());
    }

    @Override
    public Long getDataCount() {
        return null;
    }

    @Override
    public Long getDataSize() {
        return null;
    }

    @Override
    public boolean existTile(int n, int n2, int n3) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TileData getTile(int n, int n2, int n3) {
        RequestConfig requestConfig;
        String string = String.format(this.bj, n, n2, n3);
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            httpGet.setConfig(requestConfig);
            closeableHttpResponse = HttpUtil.httpclient.execute((HttpUriRequest)httpGet);
            int n4 = closeableHttpResponse.getStatusLine().getStatusCode();
            if (200 != n4) {
                a.error(String.format("%s\u83b7\u53d6\u74e6\u7247\u65f6\u51fa\u9519,\u72b6\u6001\u7801\u4e3a%d", this.bj, n4));
                TileData tileData = null;
                HttpUtil.closeResponse(closeableHttpResponse);
                return tileData;
            }
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            if (httpEntity == null) {
                TileData tileData = null;
                HttpUtil.closeResponse(closeableHttpResponse);
                return tileData;
            }
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)httpEntity);
            if (byArray == null) {
                TileData tileData = null;
                HttpUtil.closeResponse(closeableHttpResponse);
                return tileData;
            }
            TileData tileData = new TileData();
            tileData.setKey(n2 + "_" + n3 + "_" + n);
            tileData.setLevel(n);
            tileData.setLevel(n);
            tileData.setCol(n3);
            tileData.setRow(n2);
            tileData.setFormat(this.a(byArray));
            tileData.setData(byArray);
            TileData tileData2 = tileData;
            HttpUtil.closeResponse(closeableHttpResponse);
            return tileData2;
        }
        catch (Exception exception) {
            a.error(String.format("%s\u83b7\u53d6\u74e6\u7247\u5931\u8d25", this.bj), (Throwable)exception);
            requestConfig = null;
            return requestConfig;
        }
        finally {
            HttpUtil.closeResponse(closeableHttpResponse);
        }
    }

    @Override
    public TileData getTile(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("key\u503c\u4e0d\u6b63\u786e");
        }
        return this.getTile(Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    @Override
    public boolean deleteTile(int n, int n2, int n3) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5220\u9664\u74e6\u7247");
    }

    @Override
    public boolean writeTile(TileData tileData, boolean bl) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5199\u74e6\u7247");
    }

    @Override
    public void startWrite() {
    }

    @Override
    public void commitWrite(boolean bl) {
    }

    private String a(byte[] byArray) {
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -40) {
            return "jpg";
        }
        if (byArray.length >= 8 && byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70) {
            return "webp";
        }
        return "png";
    }
}

