/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.a;

import com.geoway.adf.gis.tile.ITileDataSource;
import com.geoway.adf.gis.tile.ITileDataset;
import com.geoway.adf.gis.tile.TileData;
import com.geoway.adf.gis.tile.TileMeta;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileDataSource;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileMeta;
import com.geoway.adf.gis.tile.arcgis.ArcGISTileStorageFormat;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;

public class c
implements ITileDataset {
    private ArcGISTileDataSource b;
    private ArcGISTileMeta c;

    public c(ArcGISTileDataSource arcGISTileDataSource, ArcGISTileMeta arcGISTileMeta) {
        this.b = arcGISTileDataSource;
        this.c = arcGISTileMeta;
    }

    @Override
    public String getName() {
        return this.c.getName();
    }

    @Override
    public String getAliasName() {
        return this.c.getAliasName();
    }

    @Override
    public TileType getType() {
        return this.c.getTileType();
    }

    @Override
    public ITileDataSource getDataSource() {
        return this.b;
    }

    @Override
    public TileMeta getTileMeta() {
        return this.c;
    }

    @Override
    public void startWrite() {
    }

    @Override
    public void commitWrite(boolean bl) {
    }

    @Override
    public boolean updateTileMeta(TileMeta tileMeta) {
        ArcGISTileMeta arcGISTileMeta = new ArcGISTileMeta();
        arcGISTileMeta.copyFrom(tileMeta);
        arcGISTileMeta.setUpdateTime(new Date());
        arcGISTileMeta.setStorageFormat(ArcGISTileStorageFormat.Exploded);
        if (this.b.updateTileMeta(arcGISTileMeta)) {
            this.c = arcGISTileMeta;
            return true;
        }
        return false;
    }

    @Override
    public List<Integer> getAllLevels() {
        return this.c.getLevels();
    }

    @Override
    public Long getDataCount() {
        return null;
    }

    @Override
    public Long getDataSize() {
        return null;
    }

    @Override
    public boolean existTile(int n, int n2, int n3) {
        File file = this.b(n, n2, n3, "jpg").toFile();
        if (file.isFile() && file.exists()) {
            return true;
        }
        file = this.b(n, n2, n3, "png").toFile();
        return file.isFile() && file.exists();
    }

    @Override
    public TileData getTile(int n, int n2, int n3) {
        String string = "jpg";
        File file = this.b(n, n2, n3, "jpg").toFile();
        if (!file.isFile() || !file.exists()) {
            file = this.b(n, n2, n3, "png").toFile();
            if (!file.isFile() || !file.exists()) {
                return null;
            }
            string = "png";
        }
        TileData tileData = new TileData();
        tileData.setKey(n2 + "_" + n3 + "_" + n);
        tileData.setLevel(n);
        tileData.setRow(n2);
        tileData.setCol(n3);
        tileData.setFormat(string);
        tileData.setData(Files.readAllBytes(file.toPath()));
        return tileData;
    }

    @Override
    public TileData getTile(String string) {
        String[] stringArray = string.split("_");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("key\u503c\u4e0d\u6b63\u786e");
        }
        return this.getTile(Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
    }

    @Override
    public boolean deleteTile(int n, int n2, int n3) {
        File file = this.b(n, n2, n3, "jpg").toFile();
        if (file.exists()) {
            return file.delete();
        }
        file = this.b(n, n2, n3, "png").toFile();
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    @Override
    public boolean writeTile(TileData tileData, boolean bl) {
        Path path;
        File file;
        this.deleteTile(tileData.getLevel(), tileData.getRow(), tileData.getCol());
        String string = tileData.getFormat().toLowerCase();
        if (!string.equalsIgnoreCase("jpg") && !string.equalsIgnoreCase("png")) {
            string = "png";
        }
        if (!(file = (path = this.b(tileData.getLevel(), tileData.getRow(), tileData.getCol(), string)).getParent().toFile()).exists()) {
            this.b.mkdirs(file);
        }
        Files.write(path, tileData.getData(), new OpenOption[0]);
        return true;
    }

    private Path b(int n, int n2, int n3, String string) {
        return Paths.get(this.b.getConnectionString(), "_alllayers", String.format("L%02d", n), String.format("R%08x", n2), String.format("C%08x.", n3) + string);
    }
}

