/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.gis.tile.wmts;

import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger a = LoggerFactory.getLogger(HttpUtil.class);
    private static final int be = 200;
    public static final CloseableHttpClient httpclient;
    public static int maxTotal;
    public static int maxPerRoute;
    public static int connectRequestTimeout;

    public static String doGet(String string, int n) {
        CloseableHttpResponse closeableHttpResponse = null;
        String string2 = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).build();
            httpGet.setConfig(requestConfig);
            closeableHttpResponse = httpclient.execute((HttpUriRequest)httpGet);
            int n2 = closeableHttpResponse.getStatusLine().getStatusCode();
            string2 = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"utf-8");
            if (200 != n2) {
                throw new RuntimeException(string2);
            }
        }
        catch (Exception exception) {
            try {
                a.error(string);
                throw exception;
            }
            catch (Throwable throwable) {
                HttpUtil.closeResponse(closeableHttpResponse);
                throw throwable;
            }
        }
        HttpUtil.closeResponse(closeableHttpResponse);
        return string2;
    }

    public static byte[] doGetBytes(String string, int n) {
        byte[] byArray;
        CloseableHttpResponse closeableHttpResponse = null;
        byte[] byArray2 = null;
        try {
            HttpGet httpGet = new HttpGet(string);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(n).setConnectionRequestTimeout(n).build();
            httpGet.setConfig(requestConfig);
            closeableHttpResponse = httpclient.execute((HttpUriRequest)httpGet);
            int n2 = closeableHttpResponse.getStatusLine().getStatusCode();
            byArray2 = EntityUtils.toByteArray((HttpEntity)closeableHttpResponse.getEntity());
            if (200 != n2) {
                throw new RuntimeException(new String(byArray2, "utf-8"));
            }
            byArray = byArray2;
        }
        catch (Exception exception) {
            try {
                a.error(string);
                throw exception;
            }
            catch (Throwable throwable) {
                HttpUtil.closeResponse(closeableHttpResponse);
                throw throwable;
            }
        }
        HttpUtil.closeResponse(closeableHttpResponse);
        return byArray;
    }

    public static void closeResponse(CloseableHttpResponse closeableHttpResponse) {
        try {
            if (closeableHttpResponse != null) {
                closeableHttpResponse.close();
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
    }

    static {
        maxTotal = 1000;
        maxPerRoute = 200;
        connectRequestTimeout = 10000;
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
        poolingHttpClientConnectionManager.setMaxTotal(maxTotal);
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(connectRequestTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpclient = httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setConnectionManagerShared(true).setDefaultRequestConfig(requestConfig).build();
    }
}

